/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.struct;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import rasmus.interpreter.Commitable;
import rasmus.interpreter.NameSpace;
import rasmus.interpreter.Variable;
import rasmus.interpreter.VariablePartAdapter;
import rasmus.interpreter.namespace.CommitSystem;

public class Struct
extends VariablePartAdapter
implements NameSpace {
    HashMap<String, Variable> overrides = null;
    private Map<String, Integer> varPrivateCounter = null;
    private TreeSet<String> privateVars = null;
    private Map<String, Variable> vars = null;
    private ArrayList<Struct> childstructs = new ArrayList();
    private CommitSystem cosys = null;
    static /* synthetic */ Class class$0;

    public static Variable get(Variable variable, String name) {
        return Struct.getInstance(variable).get(name);
    }

    public static Struct getInstance(Variable variable) {
        return (Struct)variable.get(Struct.class);
    }

    public void overrideVariable(String name, Variable var) {
        if (this.overrides == null) {
            this.overrides = new HashMap();
        }
        this.overrides.put(name.toLowerCase(), var);
    }

    public Variable get(String name) {
        Variable var;
        if (name.equalsIgnoreCase("this")) {
            return this.getVariable();
        }
        if (this.vars == null) {
            this.vars = new Hashtable<String, Variable>();
        }
        String lname = name.toLowerCase();
        if (this.overrides != null && (var = this.overrides.get(lname)) != null) {
            return var;
        }
        var = this.vars.get(lname);
        if (var == null) {
            var = new Variable();
            if (!this.isPrivate(name)) {
                Iterator<Struct> iterator = this.childstructs.iterator();
                while (iterator.hasNext()) {
                    var.add(iterator.next().get(lname));
                }
            }
            this.vars.put(lname, var);
        }
        return var;
    }

    public void getAllNames(Set set) {
        Iterator<Struct> iterator = this.childstructs.iterator();
        while (iterator.hasNext()) {
            iterator.next().getAllNames(set);
        }
        set.addAll((Collection)this.vars.keySet());
    }

    public void registerAsPrivate(String name) {
        Integer value;
        if (this.varPrivateCounter == null) {
            this.varPrivateCounter = new HashMap<String, Integer>();
        }
        if (this.privateVars == null) {
            this.privateVars = new TreeSet();
        }
        value = (value = this.varPrivateCounter.get(name = name.toLowerCase())) == null ? Integer.valueOf(1) : Integer.valueOf(value + 1);
        this.varPrivateCounter.put(name, value);
        if (value == 1) {
            Variable var;
            this.privateVars.add(name);
            if (this.vars != null && (var = this.vars.get(name.toLowerCase())) != null) {
                Iterator<Struct> iterator = this.childstructs.iterator();
                while (iterator.hasNext()) {
                    var.remove(iterator.next().get(name));
                }
            }
        }
    }

    public void unRegisterAsPrivate(String name) {
        if (this.varPrivateCounter == null) {
            return;
        }
        if (this.privateVars == null) {
            return;
        }
        Integer value = this.varPrivateCounter.get(name = name.toLowerCase());
        value = value == null ? Integer.valueOf(-1) : Integer.valueOf(value - 1);
        this.varPrivateCounter.put(name, value);
        if (value == 0) {
            Variable var;
            this.privateVars.remove(name);
            if (this.vars != null && (var = this.vars.get(name)) != null) {
                Iterator<Struct> iterator = this.childstructs.iterator();
                while (iterator.hasNext()) {
                    var.add(iterator.next().get(name));
                }
            }
        }
    }

    public void put(String name, Variable var) {
        this.registerAsPrivate(name);
        if (this.vars == null) {
            this.vars = new Hashtable<String, Variable>();
        }
        this.vars.put(name.toLowerCase(), var);
    }

    public boolean isPrivate(String name) {
        if (this.varPrivateCounter == null) {
            return false;
        }
        if (this.privateVars == null) {
            return false;
        }
        name = name.toLowerCase();
        return this.privateVars.contains(name);
    }

    public Struct clone() {
        if (this.varPrivateCounter == null) {
            this.varPrivateCounter = new HashMap<String, Integer>();
        }
        if (this.privateVars == null) {
            this.privateVars = new TreeSet();
        }
        if (this.vars == null) {
            this.vars = new Hashtable<String, Variable>();
        }
        if (this.overrides == null) {
            this.overrides = new HashMap();
        }
        Struct struct = new Struct();
        struct.cosys = this.cosys;
        struct.childstructs = this.childstructs;
        struct.overrides = this.overrides;
        struct.varPrivateCounter = this.varPrivateCounter;
        struct.privateVars = this.privateVars;
        struct.vars = this.vars;
        struct.childstructs = this.childstructs;
        return struct;
    }

    public void clear() {
        if (this.vars != null) {
            this.vars.clear();
        }
    }

    public void add(Variable variable) {
        Struct struct = Struct.getInstance(variable);
        this.childstructs.add(struct);
        if (this.vars != null) {
            for (Map.Entry<String, Variable> entry : this.vars.entrySet()) {
                if (this.isPrivate(entry.getKey())) continue;
                entry.getValue().add(struct.get(entry.getKey()));
            }
        }
    }

    public void remove(Variable variable) {
        Struct struct = Struct.getInstance(variable);
        this.childstructs.remove(struct);
        if (this.vars != null) {
            for (Map.Entry<String, Variable> entry : this.vars.entrySet()) {
                if (this.isPrivate(entry.getKey())) continue;
                entry.getValue().remove(struct.get(entry.getKey()));
            }
        }
    }

    public void commit() {
        this.cosys.commit();
    }

    public CommitSystem getCommitSystem() {
        return this.cosys;
    }

    public void setCommitSystem(CommitSystem cosys) {
        this.cosys = cosys;
    }

    public void addToCommitStack(Commitable commitable) {
        this.cosys.add(commitable);
    }
}

