/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.strings;

import java.util.ArrayList;
import rasmus.interpreter.Variable;
import rasmus.interpreter.list.ObjectsPart;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class ConcatInstance
extends UnitInstanceAdapter {
    ArrayList elements = new ArrayList();
    Variable output;
    Variable answer = null;

    public ConcatInstance(Parameters parameters) {
        this.output = parameters.getParameterWithDefault("output");
        int i = 1;
        Variable val = parameters.getParameter(i);
        while (val != null) {
            this.elements.add(val);
            val = parameters.getParameter(++i);
        }
        for (Variable var : this.elements) {
            ObjectsPart.getInstance(var).addListener(this);
            DoublePart.getInstance(var).addListener(this);
        }
        this.calc();
    }

    public void close() {
        this.clear();
        for (Variable var : this.elements) {
            ObjectsPart.getInstance(var).removeListener(this);
            DoublePart.getInstance(var).removeListener(this);
        }
        this.elements.clear();
    }

    public void clear() {
        if (this.answer != null) {
            this.output.remove(this.answer);
            this.answer = null;
        }
    }

    public void calc() {
        this.clear();
        StringBuffer catter = new StringBuffer();
        for (Variable var : this.elements) {
            double num;
            String str = ObjectsPart.getInstance(var).getObjects().size() == 0 ? (Math.abs((double)Math.round(num = DoublePart.asDouble(var)) - num) < 1.0E-10 ? Long.toString((long)num) : Double.toString(num)) : ObjectsPart.toString(var);
            catter.append(str);
        }
        this.answer = ObjectsPart.asVariable(catter.toString());
        this.output.add(this.answer);
    }
}

