/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sf2;

import java.io.File;
import java.io.IOException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import rasmus.interpreter.Commitable;
import rasmus.interpreter.Interpreter;
import rasmus.interpreter.NameSpace;
import rasmus.interpreter.Variable;
import rasmus.interpreter.io.Resource;
import rasmus.interpreter.io.ResourceManager;
import rasmus.interpreter.list.ObjectsPart;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.parser.ScriptParserException;
import rasmus.interpreter.sf2.SF2SoundFont;
import rasmus.interpreter.sf2.SF2SoundFontManager;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class SF2SoundbankInstance
extends UnitInstanceAdapter
implements Commitable {
    Variable output;
    Variable filename;
    Variable bank;
    Variable answer = null;
    NameSpace namespace;
    Variable wrkdir;
    Variable streammode;
    ResourceManager manager;
    Interpreter soundbankinterpreter = null;
    Resource resource = null;

    public SF2SoundbankInstance(Parameters parameters) {
        this.namespace = parameters.getNameSpace();
        this.manager = ResourceManager.getInstance(this.namespace);
        this.output = parameters.getParameterWithDefault("output");
        this.filename = parameters.getParameterWithDefault(1, "filename");
        this.bank = parameters.getParameterWithDefault(2, "bank");
        this.streammode = parameters.getParameter(3, "streammode");
        if (this.streammode == null) {
            this.streammode = DoublePart.asVariable(1.0);
        }
        this.wrkdir = parameters.get("wrkdir");
        DoublePart.getInstance(this.bank).addListener(this);
        ObjectsPart.getInstance(this.filename).addListener(this);
        ObjectsPart.getInstance(this.wrkdir).addListener(this);
        this.calc();
    }

    public void calc() {
        this.namespace.addToCommitStack(this);
    }

    public void close() {
        this.clear();
        if (this.resource != null) {
            this.resource.close();
            this.resource = null;
        }
        DoublePart.getInstance(this.bank).removeListener(this);
        ObjectsPart.getInstance(this.filename).removeListener(this);
        ObjectsPart.getInstance(this.wrkdir).removeListener(this);
    }

    public void clear() {
        if (this.answer != null) {
            this.output.remove(this.answer);
            this.answer = null;
            if (this.soundbankinterpreter != null) {
                this.soundbankinterpreter.close();
                this.soundbankinterpreter = null;
            }
        }
    }

    public String expandPath(String path) {
        if ((path = path.trim()).length() == 0) {
            return path;
        }
        if (path.startsWith(File.separator)) {
            return path;
        }
        if (path.length() > 2 && Character.isLetter(path.charAt(0)) && path.charAt(1) == ':' && path.charAt(2) == File.separatorChar) {
            return path;
        }
        String wrkdir = ObjectsPart.toString(this.wrkdir);
        if (wrkdir.trim().length() == 0) {
            return path;
        }
        if (wrkdir.endsWith(File.separator)) {
            return String.valueOf(wrkdir) + path;
        }
        return String.valueOf(wrkdir) + File.separator + path;
    }

    public int getRunLevel() {
        return 0;
    }

    public void commit() {
        this.clear();
        String filename = this.expandPath(ObjectsPart.toString(this.filename));
        if (this.resource != null) {
            this.resource.close();
        }
        this.resource = this.manager.getResource(filename);
        if (this.resource == null) {
            return;
        }
        File file = this.resource.getFile();
        SF2SoundFont sf2soundfont = SF2SoundFontManager.getSF2SoundFont(file.getPath());
        int bankshift = (int)DoublePart.asDouble(this.bank);
        this.soundbankinterpreter = new Interpreter();
        this.soundbankinterpreter.add("streammode", this.streammode);
        this.soundbankinterpreter.setAutoCommit(false);
        StringBuffer code = new StringBuffer();
        Element root = sf2soundfont.getDocument().getDocumentElement();
        NodeList presetlist = root.getElementsByTagName("preset");
        int i = 0;
        while (i < presetlist.getLength()) {
            Element preset = (Element)presetlist.item(i);
            int attr_bank = Integer.parseInt(preset.getAttribute("bank"));
            int attr_preset = Integer.parseInt(preset.getAttribute("preset"));
            this.soundbankinterpreter.add("sfdescription" + i, (Object)preset.getAttribute("name"));
            if (attr_bank < 128) {
                String ident = String.valueOf(attr_preset) + "," + (attr_bank + bankshift);
                code.append("<- instrument(" + ident + ",sfdescription" + i + ",ch10=0) <- soundbankpreset(filename, " + attr_preset + "," + attr_bank + ",streammode=streammode);");
            } else {
                String ident2 = String.valueOf(attr_preset) + "," + (attr_bank - 128 + bankshift);
                code.append("<- instrument(" + ident2 + ",sfdescription" + i + ",ch10=1) <- soundbankpreset(filename, " + attr_preset + "," + attr_bank + ",streammode=streammode);");
            }
            ++i;
        }
        try {
            this.soundbankinterpreter.add("filename", (Object)file.getCanonicalPath());
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            this.soundbankinterpreter.eval(code.toString());
        }
        catch (ScriptParserException e) {
            e.printStackTrace();
        }
        this.answer = this.soundbankinterpreter.get("output");
        this.output.add(this.answer);
    }
}

