/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sf2;

import java.io.File;
import java.util.WeakHashMap;
import rasmus.interpreter.sf2.SF2SoundFont;

public class SF2SoundFontManager {
    private static WeakHashMap<String, MapEntry> cachetable = new WeakHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SF2SoundFont getSF2SoundFont(String filename) {
        WeakHashMap<String, MapEntry> weakHashMap = cachetable;
        synchronized (weakHashMap) {
            MapEntry entry = cachetable.get(filename);
            long file_lastmod = new File(filename).lastModified();
            if (entry == null) {
                entry = new MapEntry();
                entry.soundfont = new SF2SoundFont(filename);
                entry.lastmod = file_lastmod;
                cachetable.put(filename, entry);
            } else if (entry.lastmod != file_lastmod) {
                entry.soundfont = new SF2SoundFont(filename);
            }
            return entry.soundfont;
        }
    }

    private static class MapEntry {
        SF2SoundFont soundfont;
        long lastmod;

        MapEntry() {
        }
    }
}

