/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sf2;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import rasmus.interpreter.sf2.SF2SoundFontManager;
import rasmus.util.riff.sf2.SoundFont;

public class SF2SoundFont {
    private SoundFont soundfont;
    private Document sfdoc;
    private Hashtable sampleinfotable = new Hashtable();
    private Hashtable presetinfotable = new Hashtable();
    private Hashtable instrumentinfotable = new Hashtable();

    public Document getDocument() {
        return this.sfdoc;
    }

    public SoundFont getSoundFont() {
        return this.soundfont;
    }

    public Element getSample(int id) {
        return (Element)this.sampleinfotable.get(Integer.toString(id));
    }

    public Element getPreset(int id) {
        return this.getPreset(id, 0);
    }

    public Element getPreset(int id, int bank) {
        return (Element)this.presetinfotable.get(String.valueOf(Integer.toString(id)) + "." + Integer.toString(bank));
    }

    public Element getInstrument(int id) {
        return (Element)this.instrumentinfotable.get(Integer.toString(id));
    }

    public static void main(String[] args) {
        String filename = "C:\\Documents and Settings\\kalli\\My Documents\\broken_bassdrum.sf2";
        SF2SoundFont sf2 = SF2SoundFontManager.getSF2SoundFont(filename);
        Document document = sf2.getDocument();
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = null;
        try {
            transformer = tFactory.newTransformer();
            FileOutputStream fo = new FileOutputStream("C:\\broken_bassdrum.xml");
            transformer.transform(new DOMSource(document), new StreamResult(fo));
            fo.close();
        }
        catch (Exception fo) {
            // empty catch block
        }
        System.out.println("sf2preset  <- function(note, velocity, active) ");
        System.out.println("{ ");
        int gen_no = 0;
        ArrayList<String> sample_used = new ArrayList<String>();
        Element preset_element = sf2.getPreset(0);
        NodeList instruments = preset_element.getElementsByTagName("generator");
        int i = 0;
        while (i < instruments.getLength()) {
            Element preset_generator = (Element)instruments.item(i);
            String instrumentid = preset_generator.getAttribute("instrument");
            if (instrumentid.length() != 0) {
                Element instrument_element = sf2.getInstrument(Integer.parseInt(instrumentid));
                NodeList samples = instrument_element.getElementsByTagName("generator");
                int j = 0;
                while (j < samples.getLength()) {
                    Element instrument_generator = (Element)samples.item(j);
                    String sampleid = instrument_generator.getAttribute("sampleID");
                    if (sampleid.length() != 0) {
                        int b;
                        int a;
                        StringTokenizer st;
                        Element sample_element = sf2.getSample(Integer.parseInt(sampleid));
                        if (!sample_used.contains(sampleid)) {
                            sample_used.add(sampleid);
                        }
                        int keyRange_from = 0;
                        int keyRange_to = 127;
                        int velRange_from = 0;
                        int velRange_to = 127;
                        int overridingRootKey = 60;
                        if (sample_element.getAttribute("originalkey").length() != 0) {
                            overridingRootKey = Integer.parseInt(sample_element.getAttribute("originalkey"));
                        }
                        if (instrument_generator.getAttribute("overridingRootKey").length() != 0) {
                            overridingRootKey = Integer.parseInt(instrument_generator.getAttribute("overridingRootKey"));
                        }
                        if (preset_generator.getAttribute("overridingRootKey").length() != 0) {
                            overridingRootKey = Integer.parseInt(preset_generator.getAttribute("overridingRootKey"));
                        }
                        if (instrument_generator.getAttribute("keyRange").length() != 0) {
                            st = new StringTokenizer(instrument_generator.getAttribute("keyRange"), "-");
                            keyRange_from = Integer.parseInt(st.nextToken().trim());
                            keyRange_to = Integer.parseInt(st.nextToken().trim());
                        }
                        if (instrument_generator.getAttribute("velRange").length() != 0) {
                            st = new StringTokenizer(instrument_generator.getAttribute("velRange"), "-");
                            velRange_from = Integer.parseInt(st.nextToken().trim());
                            velRange_to = Integer.parseInt(st.nextToken().trim());
                        }
                        if (preset_generator.getAttribute("keyRange").length() != 0) {
                            st = new StringTokenizer(preset_generator.getAttribute("keyRange"), "-");
                            a = Integer.parseInt(st.nextToken().trim());
                            b = Integer.parseInt(st.nextToken().trim());
                            if (a > keyRange_from) {
                                keyRange_from = a;
                            }
                            if (b > keyRange_to) {
                                keyRange_to = b;
                            }
                        }
                        if (preset_generator.getAttribute("velRange").length() != 0) {
                            st = new StringTokenizer(preset_generator.getAttribute("velRange"), "-");
                            a = Integer.parseInt(st.nextToken().trim());
                            b = Integer.parseInt(st.nextToken().trim());
                            if (a > velRange_from) {
                                velRange_from = a;
                            }
                            if (b > velRange_to) {
                                velRange_to = b;
                            }
                        }
                        String samplerate = sample_element.getAttribute("samplerate");
                        System.out.println("  // " + sample_element.getAttribute("name"));
                        System.out.println("  generator_" + gen_no + " <- resamplei((" + samplerate + "/48000)*pow(2, (note-" + overridingRootKey + ") / 12)) <- sample_" + sampleid + ";");
                        System.out.println("  vgenerator_" + gen_no + " <- xadsr(active,0.01, 1, 1, 0.1,0.01) * generator_" + gen_no);
                        System.out.println("  out <- if(((note >= " + keyRange_from + ") * (note <= " + keyRange_to + ") * (velocity >= " + velRange_from + ") * (velocity <= " + velRange_to + ")), vgenerator_" + gen_no + ");");
                        System.out.println("  ");
                        ++gen_no;
                    }
                    ++j;
                }
            }
            ++i;
        }
        System.out.println("  output <- channelmux(out, out)*velocity;");
        System.out.println("}; ");
        int j = 0;
        while (j < sample_used.size()) {
            int sampleid = Integer.parseInt((String)sample_used.get(j));
            System.out.println("sample_" + sampleid + " <- SF2Sample(\"" + filename + "\", " + sampleid + ");");
            ++j;
        }
    }

    protected SF2SoundFont(String filename) {
        FileInputStream fi;
        try {
            fi = new FileInputStream(filename);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return;
        }
        SoundFont soundfont = new SoundFont();
        try {
            try {
                soundfont.read(fi);
                this.sfdoc = soundfont.toDocument();
                NodeList samplelist = this.sfdoc.getElementsByTagName("sample");
                int i = 0;
                while (i < samplelist.getLength()) {
                    Element sample = (Element)samplelist.item(i);
                    this.sampleinfotable.put(sample.getAttribute("id"), sample);
                    ++i;
                }
                NodeList presetlist = this.sfdoc.getElementsByTagName("preset");
                int i2 = 0;
                while (i2 < presetlist.getLength()) {
                    Element preset = (Element)presetlist.item(i2);
                    this.presetinfotable.put(String.valueOf(preset.getAttribute("preset")) + "." + preset.getAttribute("bank"), preset);
                    ++i2;
                }
                NodeList instrumentlist = this.sfdoc.getElementsByTagName("instrument");
                int i3 = 0;
                while (i3 < instrumentlist.getLength()) {
                    Element instrument = (Element)instrumentlist.item(i3);
                    this.instrumentinfotable.put(instrument.getAttribute("id"), instrument);
                    ++i3;
                }
            }
            finally {
                ((InputStream)fi).close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

