/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sf2;

import java.io.File;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.WeakHashMap;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import rasmus.interpreter.Commitable;
import rasmus.interpreter.Interpreter;
import rasmus.interpreter.NameSpace;
import rasmus.interpreter.Variable;
import rasmus.interpreter.io.Resource;
import rasmus.interpreter.io.ResourceManager;
import rasmus.interpreter.list.ObjectsPart;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.namespace.GlobalNameSpace;
import rasmus.interpreter.parser.ScriptParserException;
import rasmus.interpreter.sampled.io.AudioFile;
import rasmus.interpreter.sampled.midi.AudioRegisterVoice;
import rasmus.interpreter.sampled.midi.AudioVoiceFactory;
import rasmus.interpreter.sf2.SF2SoundFont;
import rasmus.interpreter.sf2.SF2SoundFontManager;
import rasmus.interpreter.status.GlobalStatus;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;
import rasmus.interpreter.unit.UnitInstancePart;

class SF2PresetInstance
extends UnitInstanceAdapter
implements Commitable {
    static double ATTEN_EMU8K_DBFIX = 0.376287;
    Variable preset;
    Variable bank;
    Variable filename;
    Variable output;
    Variable streammode;
    PresetEntry answer = null;
    static boolean garbagerunned = true;
    static Commitable garbagerunner = new Commitable(){

        public int getRunLevel() {
            return 100;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commit() {
            Commitable commitable = garbagerunner;
            synchronized (commitable) {
                Object entry;
                garbagerunned = true;
                for (String ident : preset_garbage) {
                    entry = (PresetEntry)presettable.get(ident);
                    ((PresetEntry)entry).close();
                }
                preset_garbage.clear();
                for (String ident : sample_garbage) {
                    entry = (SampleEntry)sampletable.get(ident);
                    ((SampleEntry)entry).close();
                }
                sample_garbage.clear();
            }
        }
    };
    private static HashSet sample_garbage = new HashSet();
    private static Map<String, SampleEntry> sampletable = new WeakHashMap<String, SampleEntry>();
    private static HashSet preset_garbage = new HashSet();
    private static Map<String, PresetEntry> presettable = new WeakHashMap<String, PresetEntry>();
    Resource resource = null;
    Map addparameters = new HashMap();
    NameSpace namespace;
    Variable wrkdir;
    ResourceManager manager;

    public void clear() {
        if (this.answer != null) {
            this.answer.deuse();
            this.output.remove(this.answer.variable);
            this.answer = null;
        }
    }

    private void initPresetGarbageCollector() {
        if (garbagerunned) {
            garbagerunned = false;
            this.namespace.addToCommitStack(garbagerunner);
        }
    }

    private static SampleEntry loadSample(String filename, long offset, long length, long loopstart, long loopend, int streammode) {
        NameSpace namespace = GlobalNameSpace.getNameSpace();
        String ident = String.valueOf(filename) + ":" + offset + ":" + length + ":" + loopstart + ":" + loopend + ":stream=" + streammode;
        SampleEntry samplevar = sampletable.get(ident);
        if (samplevar != null) {
            return samplevar;
        }
        samplevar = new SampleEntry(ident);
        samplevar.variable = new Variable();
        Parameters uparams = new Parameters(namespace);
        uparams.setParameter(1, ObjectsPart.asVariable(filename));
        uparams.setParameter(2, DoublePart.asVariable(offset));
        uparams.setParameter(3, DoublePart.asVariable(length));
        if (loopstart != 0L || loopend != 0L) {
            uparams.setParameter("loopstart", DoublePart.asVariable(loopstart));
            uparams.setParameter("loopend", DoublePart.asVariable(loopend));
        }
        uparams.setParameter("output", samplevar.variable);
        uparams.setParameter("streammode", (double)streammode);
        samplevar.instance = new AudioFile(true).newInstance(uparams);
        sampletable.put(ident, samplevar);
        return samplevar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PresetEntry loadPreset(String filename, int presetid, int bankid, Map addparameters, NameSpace namespace, int streammode) {
        Commitable commitable = garbagerunner;
        synchronized (commitable) {
            PresetEntry answer;
            String presetcacheid = String.valueOf(filename) + " : " + presetid + "." + bankid + ":stream=" + streammode;
            if (addparameters.size() != 0) {
                TreeSet<String> treeset = new TreeSet<String>();
                for (Map.Entry entry : addparameters.entrySet()) {
                    treeset.add(entry.getKey() + "=" + DoublePart.asDouble((Variable)entry.getValue()) + ";");
                }
                StringBuilder builder = new StringBuilder();
                for (String entry : treeset) {
                    builder.append(entry);
                }
                presetcacheid = String.valueOf(presetcacheid) + ":" + builder.toString();
            }
            if ((answer = presettable.get(presetcacheid)) != null) {
                return answer;
            }
            GlobalStatus.setStatus("loading " + filename + " : " + presetid + "." + bankid);
            AudioVoiceFactory AudioVoiceFactory2 = new AudioVoiceFactory();
            AudioRegisterVoice RegisterVoice = new AudioRegisterVoice();
            Variable voices = new Variable();
            int gen_no = 0;
            GlobalStatus.setStatus("parsing " + filename + " : " + presetid + "." + bankid);
            Interpreter interpreter = null;
            SF2SoundFont sf2 = SF2SoundFontManager.getSF2SoundFont(filename);
            GlobalStatus.setStatus("processing " + filename + " : " + presetid + "." + bankid);
            Element preset_element = sf2.getPreset(presetid, bankid);
            if (preset_element != null) {
                ArrayList<SampleEntry> sampleslist = new ArrayList<SampleEntry>();
                NodeList instruments = preset_element.getElementsByTagName("generator");
                Element global_preset_generator = null;
                int i = 0;
                while (i < instruments.getLength()) {
                    Element preset_generator = (Element)instruments.item(i);
                    String instrumentid = preset_generator.getAttribute("instrument");
                    if (instrumentid.length() == 0) {
                        global_preset_generator = preset_generator;
                    } else {
                        Element global_instrument_generator = null;
                        Element instrument_element = sf2.getInstrument(SF2PresetInstance.parseInt(instrumentid));
                        NodeList samples = instrument_element.getElementsByTagName("generator");
                        int j = 0;
                        while (j < samples.getLength()) {
                            Element instrument_generator = (Element)samples.item(j);
                            String sampleid = instrument_generator.getAttribute("sampleID");
                            if (sampleid.length() == 0) {
                                global_instrument_generator = instrument_generator;
                            } else {
                                double d_releaseModEnv;
                                int b;
                                int a;
                                StringTokenizer st;
                                Element sample_element = sf2.getSample(SF2PresetInstance.parseInt(sampleid));
                                int startAddrsOffset = 0;
                                int endAddrsOffset = 0;
                                int startloopAddrsOffset = 0;
                                int endloopAddrsOffset = 0;
                                int startAddrsCoarseOffset = 0;
                                int endAddrsCoarseOffset = 0;
                                int startloopAddrsCoarseOffset = 0;
                                int endloopAddrsCoarseOffset = 0;
                                int keyRange_from = 0;
                                int keyRange_to = 127;
                                int velRange_from = 0;
                                int velRange_to = 127;
                                int overridingRootKey = 60;
                                int delayVolEnv = -12000;
                                int attackVolEnv = -12000;
                                int holdVolEnv = -12000;
                                int decayVolEnv = -12000;
                                int sustainVolEnv = 0;
                                int releaseVolEnv = -12000;
                                int delayModEnv = -12000;
                                int attackModEnv = -12000;
                                int holdModEnv = -12000;
                                int decayModEnv = -12000;
                                int sustainModEnv = 0;
                                int releaseModEnv = -12000;
                                int scaleTuning = 100;
                                int coarseTune = 0;
                                int fineTune = 0;
                                int samplemode = 0;
                                int initialAttenuation = 0;
                                int velocity = -1;
                                int keynum = -1;
                                int modEnvToPitch = 0;
                                int modEnvToFilterFc = 0;
                                int initialFilterFc = 13500;
                                int initialFilterQ = 0;
                                int pan = 0;
                                int chorusEffectsSend = 0;
                                int reverbEffectsSend = 0;
                                int delayModLFO = -12000;
                                int freqModLFO = 0;
                                int modLfoToPitch = 0;
                                int modLfoToFilterFc = 0;
                                int modLfoToVolume = 0;
                                int delayVibLFO = -12000;
                                int freqVibLFO = 0;
                                int vibLfoToPitch = 0;
                                int keynumToModEnvHold = 0;
                                int keynumToModEnvDecay = 0;
                                int keynumToVolEnvHold = 0;
                                int keynumToVolEnvDecay = 0;
                                int exclusiveClass = -1;
                                if (SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "initialAttenuation").length() != 0) {
                                    initialAttenuation = SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "initialAttenuation"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "delayVolEnv").length() != 0) {
                                    delayVolEnv = SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "delayVolEnv"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "attackVolEnv").length() != 0) {
                                    attackVolEnv = SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "attackVolEnv"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "holdVolEnv").length() != 0) {
                                    holdVolEnv = SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "holdVolEnv"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "decayVolEnv").length() != 0) {
                                    decayVolEnv = SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "decayVolEnv"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "sustainVolEnv").length() != 0) {
                                    sustainVolEnv = SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "sustainVolEnv"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "releaseVolEnv").length() != 0) {
                                    releaseVolEnv = SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "releaseVolEnv"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "attackModEnv").length() != 0) {
                                    attackModEnv = SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "attackModEnv"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "holdModEnv").length() != 0) {
                                    holdModEnv = SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "holdModEnv"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "decayModEnv").length() != 0) {
                                    decayModEnv = SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "decayModEnv"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "sustainModEnv").length() != 0) {
                                    sustainModEnv = SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "sustainModEnv"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "releaseModEnv").length() != 0) {
                                    releaseModEnv = SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "releaseModEnv"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "modEnvToPitch").length() != 0) {
                                    modEnvToPitch = SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "modEnvToPitch"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "modEnvToFilterFc").length() != 0) {
                                    modEnvToFilterFc = SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "modEnvToFilterFc"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "initialFilterFc").length() != 0) {
                                    initialFilterFc = SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "initialFilterFc"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "initialFilterQ").length() != 0) {
                                    initialFilterQ = SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "initialFilterQ"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "pan").length() != 0) {
                                    pan = SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "pan"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "chorusEffectsSend").length() != 0) {
                                    chorusEffectsSend = SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "chorusEffectsSend"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "reverbEffectsSend").length() != 0) {
                                    reverbEffectsSend = SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "reverbEffectsSend"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "scaleTuning").length() != 0) {
                                    scaleTuning = SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "scaleTuning"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "coarseTune").length() != 0) {
                                    coarseTune = SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "coarseTune"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "fineTune").length() != 0) {
                                    fineTune = SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "fineTune"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "sampleModes").length() != 0) {
                                    samplemode = SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "sampleModes"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "velocity").length() != 0) {
                                    velocity = SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "velocity"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "keynum").length() != 0) {
                                    keynum = SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "keynum"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "startAddrsOffset").length() != 0) {
                                    startAddrsOffset = SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "startAddrsOffset"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "endAddrsOffset").length() != 0) {
                                    endAddrsOffset = SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "endAddrsOffset"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "startloopAddrsOffset").length() != 0) {
                                    startloopAddrsOffset = SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "startloopAddrsOffset"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "endloopAddrsOffset").length() != 0) {
                                    endloopAddrsOffset = SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "endloopAddrsOffset"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "startAddrsCoarseOffset").length() != 0) {
                                    startAddrsCoarseOffset = SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "startAddrsCoarseOffset"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "endAddrsCoarseOffset").length() != 0) {
                                    endAddrsCoarseOffset = SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "endAddrsCoarseOffset"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "startloopAddrsCoarseOffset").length() != 0) {
                                    startloopAddrsCoarseOffset = SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "startloopAddrsCoarseOffset"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "endloopAddrsCoarseOffset").length() != 0) {
                                    endloopAddrsCoarseOffset = SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "endloopAddrsCoarseOffset"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "delayModLFO").length() != 0) {
                                    delayModLFO = SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "delayModLFO"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "freqModLFO").length() != 0) {
                                    freqModLFO = SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "freqModLFO"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "modLfoToPitch").length() != 0) {
                                    modLfoToPitch = SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "modLfoToPitch"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "modLfoToFilterFc").length() != 0) {
                                    modLfoToFilterFc = SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "modLfoToFilterFc"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "modLfoToVolume").length() != 0) {
                                    modLfoToVolume = SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "modLfoToVolume"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "keynumToModEnvHold").length() != 0) {
                                    keynumToModEnvHold = SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "keynumToModEnvHold"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "keynumToModEnvDecay").length() != 0) {
                                    keynumToModEnvDecay = SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "keynumToModEnvDecay"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "keynumToVolEnvHold").length() != 0) {
                                    keynumToVolEnvHold = SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "keynumToVolEnvHold"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "keynumToVolEnvDecay").length() != 0) {
                                    keynumToVolEnvDecay = SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "keynumToVolEnvDecay"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "exclusiveClass").length() != 0) {
                                    exclusiveClass = SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "exclusiveClass"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "delayVibLFO").length() != 0) {
                                    delayVibLFO = SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "delayVibLFO"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "freqVibLFO").length() != 0) {
                                    freqVibLFO = SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "freqVibLFO"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "vibLfoToPitch").length() != 0) {
                                    vibLfoToPitch = SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_instrument_generator, instrument_generator, "vibLfoToPitch"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "initialAttenuation").length() != 0) {
                                    initialAttenuation += SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "initialAttenuation"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "delayVolEnv").length() != 0) {
                                    delayVolEnv += SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "delayVolEnv"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "attackVolEnv").length() != 0) {
                                    attackVolEnv += SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "attackVolEnv"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "holdVolEnv").length() != 0) {
                                    holdVolEnv += SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "holdVolEnv"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "decayVolEnv").length() != 0) {
                                    decayVolEnv += SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "decayVolEnv"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "sustainVolEnv").length() != 0) {
                                    sustainVolEnv += SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "sustainVolEnv"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "releaseVolEnv").length() != 0) {
                                    releaseVolEnv += SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "releaseVolEnv"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "attackModEnv").length() != 0) {
                                    attackModEnv += SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "attackModEnv"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "holdModEnv").length() != 0) {
                                    holdModEnv += SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "holdModEnv"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "decayModEnv").length() != 0) {
                                    decayModEnv += SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "decayModEnv"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "sustainModEnv").length() != 0) {
                                    sustainModEnv += SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "sustainModEnv"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "releaseModEnv").length() != 0) {
                                    releaseModEnv += SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "releaseModEnv"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "modEnvToPitch").length() != 0) {
                                    modEnvToPitch += SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "modEnvToPitch"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "modEnvToFilterFc").length() != 0) {
                                    modEnvToFilterFc += SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "modEnvToFilterFc"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "initialFilterFc").length() != 0) {
                                    initialFilterFc += SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "initialFilterFc"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "initialFilterQ").length() != 0) {
                                    initialFilterQ += SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "initialFilterQ"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "pan").length() != 0) {
                                    pan += SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "pan"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "chorusEffectsSend").length() != 0) {
                                    chorusEffectsSend += SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "chorusEffectsSend"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "reverbEffectsSend").length() != 0) {
                                    reverbEffectsSend += SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "reverbEffectsSend"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "scaleTuning").length() != 0) {
                                    scaleTuning += SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "scaleTuning"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "coarseTune").length() != 0) {
                                    coarseTune += SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "coarseTune"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "fineTune").length() != 0) {
                                    fineTune += SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "fineTune"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "sampleModes").length() != 0) {
                                    samplemode = SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "sampleModes"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "velocity").length() != 0) {
                                    velocity = SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "velocity"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "keynum").length() != 0) {
                                    keynum = SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "keynum"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "startAddrsOffset").length() != 0) {
                                    startAddrsOffset += SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "startAddrsOffset"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "endAddrsOffset").length() != 0) {
                                    endAddrsOffset += SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "endAddrsOffset"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "startloopAddrsOffset").length() != 0) {
                                    startloopAddrsOffset += SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "startloopAddrsOffset"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "endloopAddrsOffset").length() != 0) {
                                    endloopAddrsOffset += SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "endloopAddrsOffset"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "startAddrsCoarseOffset").length() != 0) {
                                    startAddrsCoarseOffset += SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "startAddrsCoarseOffset"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "endAddrsCoarseOffset").length() != 0) {
                                    endAddrsCoarseOffset += SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "endAddrsCoarseOffset"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "startloopAddrsCoarseOffset").length() != 0) {
                                    startloopAddrsCoarseOffset += SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "startloopAddrsCoarseOffset"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "endloopAddrsCoarseOffset").length() != 0) {
                                    endloopAddrsCoarseOffset += SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "endloopAddrsCoarseOffset"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "delayModLFO").length() != 0) {
                                    delayModLFO += SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "delayModLFO"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "freqModLFO").length() != 0) {
                                    freqModLFO += SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "freqModLFO"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "modLfoToPitch").length() != 0) {
                                    modLfoToPitch += SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "modLfoToPitch"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "modLfoToFilterFc").length() != 0) {
                                    modLfoToFilterFc += SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "modLfoToFilterFc"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "modLfoToVolume").length() != 0) {
                                    modLfoToVolume += SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "modLfoToVolume"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "keynumToModEnvHold").length() != 0) {
                                    keynumToModEnvHold += SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "keynumToModEnvHold"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "keynumToModEnvDecay").length() != 0) {
                                    keynumToModEnvDecay += SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "keynumToModEnvDecay"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "keynumToVolEnvHold").length() != 0) {
                                    keynumToVolEnvHold += SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "keynumToVolEnvHold"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "keynumToVolEnvDecay").length() != 0) {
                                    keynumToVolEnvDecay += Integer.parseInt(SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "keynumToVolEnvDecay"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "exclusiveClass").length() != 0) {
                                    exclusiveClass += SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "exclusiveClass"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "delayVibLFO").length() != 0) {
                                    delayVibLFO += SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "delayVibLFO"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "freqVibLFO").length() != 0) {
                                    freqVibLFO += SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "freqVibLFO"));
                                }
                                if (SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "vibLfoToPitch").length() != 0) {
                                    vibLfoToPitch += SF2PresetInstance.parseInt(SF2PresetInstance.globalSecondAttribute(global_preset_generator, preset_generator, "vibLfoToPitch"));
                                }
                                startAddrsOffset += startAddrsCoarseOffset * 32768;
                                endAddrsOffset += endAddrsCoarseOffset * 32768;
                                startloopAddrsOffset += startloopAddrsCoarseOffset * 32768;
                                endloopAddrsOffset += endloopAddrsCoarseOffset * 32768;
                                if (sample_element.getAttribute("pitchcorrection").length() != 0) {
                                    fineTune += SF2PresetInstance.parseInt(sample_element.getAttribute("pitchcorrection"));
                                }
                                if (sample_element.getAttribute("originalkey").length() != 0) {
                                    overridingRootKey = SF2PresetInstance.parseInt(sample_element.getAttribute("originalkey"));
                                }
                                if (instrument_generator.getAttribute("overridingRootKey").length() != 0) {
                                    overridingRootKey = SF2PresetInstance.parseInt(instrument_generator.getAttribute("overridingRootKey"));
                                }
                                if (global_instrument_generator != null && global_instrument_generator.getAttribute("overridingRootKey").length() != 0) {
                                    overridingRootKey = SF2PresetInstance.parseInt(global_instrument_generator.getAttribute("overridingRootKey"));
                                }
                                if (preset_generator.getAttribute("overridingRootKey").length() != 0) {
                                    overridingRootKey = SF2PresetInstance.parseInt(preset_generator.getAttribute("overridingRootKey"));
                                }
                                if (global_preset_generator != null && global_preset_generator.getAttribute("overridingRootKey").length() != 0) {
                                    overridingRootKey = SF2PresetInstance.parseInt(global_preset_generator.getAttribute("overridingRootKey"));
                                }
                                if (instrument_generator.getAttribute("keyRange").length() != 0) {
                                    st = new StringTokenizer(instrument_generator.getAttribute("keyRange"), "-");
                                    keyRange_from = SF2PresetInstance.parseInt(st.nextToken().trim());
                                    keyRange_to = SF2PresetInstance.parseInt(st.nextToken().trim());
                                }
                                if (instrument_generator.getAttribute("velRange").length() != 0) {
                                    st = new StringTokenizer(instrument_generator.getAttribute("velRange"), "-");
                                    velRange_from = SF2PresetInstance.parseInt(st.nextToken().trim());
                                    velRange_to = SF2PresetInstance.parseInt(st.nextToken().trim());
                                }
                                if (preset_generator.getAttribute("keyRange").length() != 0) {
                                    st = new StringTokenizer(preset_generator.getAttribute("keyRange"), "-");
                                    a = SF2PresetInstance.parseInt(st.nextToken().trim());
                                    b = SF2PresetInstance.parseInt(st.nextToken().trim());
                                    if (a > keyRange_from) {
                                        keyRange_from = a;
                                    }
                                    if (b < keyRange_to) {
                                        keyRange_to = b;
                                    }
                                }
                                if (preset_generator.getAttribute("velRange").length() != 0) {
                                    st = new StringTokenizer(preset_generator.getAttribute("velRange"), "-");
                                    a = SF2PresetInstance.parseInt(st.nextToken().trim());
                                    b = SF2PresetInstance.parseInt(st.nextToken().trim());
                                    if (a > velRange_from) {
                                        velRange_from = a;
                                    }
                                    if (b < velRange_to) {
                                        velRange_to = b;
                                    }
                                }
                                String samplerate = sample_element.getAttribute("samplerate");
                                double d_delayVolEnv = Math.pow(2.0, (double)delayVolEnv / 1200.0);
                                if (delayVolEnv <= -12000) {
                                    d_delayVolEnv = 0.0;
                                }
                                double d_attackVolEnv = Math.pow(2.0, (double)attackVolEnv / 1200.0);
                                if (attackVolEnv <= -12000) {
                                    d_attackVolEnv = 0.0;
                                }
                                double d_holdVolEnv = Math.pow(2.0, (double)holdVolEnv / 1200.0);
                                double d_decayVolEnv = Math.pow(2.0, (double)decayVolEnv / 1200.0);
                                double d_sustainVolEnv = Math.pow(10.0, (double)(-(sustainVolEnv / 10)) / 20.0);
                                double d_releaseVolEnv = Math.pow(2.0, (double)releaseVolEnv / 1200.0);
                                if (d_releaseVolEnv < 0.05) {
                                    d_releaseVolEnv = 0.05;
                                }
                                double d_delayModEnv = Math.pow(2.0, (double)delayModEnv / 1200.0);
                                double d_attackModEnv = Math.pow(2.0, (double)attackModEnv / 1200.0);
                                double d_holdModEnv = Math.pow(2.0, (double)holdModEnv / 1200.0);
                                double d_decayModEnv = Math.pow(2.0, (double)decayModEnv / 1200.0);
                                double d_sustainModEnv = 1.0 - (double)sustainModEnv / 1000.0;
                                if (d_sustainModEnv < 0.0) {
                                    d_sustainModEnv = 0.0;
                                }
                                if (d_sustainModEnv > 1.0) {
                                    d_sustainModEnv = 1.0;
                                }
                                if ((d_releaseModEnv = Math.pow(2.0, (double)releaseModEnv / 1200.0)) < 0.05) {
                                    d_releaseModEnv = 0.05;
                                }
                                DecimalFormat d = new DecimalFormat("0.########", new DecimalFormatSymbols(Locale.ENGLISH));
                                double notetune = -((double)overridingRootKey) + (double)coarseTune + (double)fineTune / 100.0;
                                double scaletune = (double)scaleTuning / 50.0;
                                if (initialAttenuation < 0) {
                                    initialAttenuation = 0;
                                }
                                double d_initialAttenuation = Math.pow(10.0, -ATTEN_EMU8K_DBFIX * (double)(initialAttenuation / 10) / 20.0);
                                boolean looped = false;
                                if (samplemode == 1 || samplemode == 3) {
                                    looped = true;
                                }
                                Variable samplevar = null;
                                Element sampleinfo = sf2.getSample(SF2PresetInstance.parseInt(sampleid));
                                if (sampleinfo != null) {
                                    long offset = Long.parseLong(sampleinfo.getAttribute("offset"));
                                    long start = Long.parseLong(sampleinfo.getAttribute("start"));
                                    long length = Long.parseLong(sampleinfo.getAttribute("datalength"));
                                    start += (long)startAddrsOffset;
                                    offset += (long)(startAddrsOffset * 2);
                                    length += (long)(endAddrsOffset * 2);
                                    long loopstart = Long.parseLong(sampleinfo.getAttribute("loopstart"));
                                    long loopend = Long.parseLong(sampleinfo.getAttribute("loopend"));
                                    if (loopstart < 0L) {
                                        loopstart = 0L;
                                    }
                                    if (loopend < 0L) {
                                        loopend = 0L;
                                    }
                                    if (loopstart != 0L) {
                                        loopstart = (loopstart - start) * 2L;
                                    }
                                    if (loopend != 0L) {
                                        loopend = (loopend - start) * 2L;
                                    }
                                    if ((loopend += (long)(endloopAddrsOffset * 2)) - (loopstart += (long)(startloopAddrsOffset * 2)) < 0L) {
                                        System.out.println("loop error");
                                        looped = false;
                                    }
                                    if (!looped) {
                                        loopstart = 0L;
                                        loopend = 0L;
                                    }
                                    SampleEntry sampleentry = SF2PresetInstance.loadSample(filename, offset, length, loopstart, loopend, streammode);
                                    samplevar = sampleentry.variable;
                                    sampleslist.add(sampleentry);
                                }
                                if (samplevar != null) {
                                    Parameters uparams = new Parameters(namespace);
                                    HashMap<String, String> audiofactoryparams = new HashMap<String, String>();
                                    if (pan > 500) {
                                        pan = 500;
                                    }
                                    if (pan < -500) {
                                        pan = -500;
                                    }
                                    audiofactoryparams.put("velocity", Integer.toString(velocity));
                                    audiofactoryparams.put("keynum", Integer.toString(keynum));
                                    audiofactoryparams.put("pan", d.format((double)pan / 1000.0));
                                    audiofactoryparams.put("ch1Vol", d.format(Math.cos((0.5 + (double)pan / 500.0) * Math.PI * 0.5)));
                                    audiofactoryparams.put("ch2Vol", d.format(Math.sin((0.5 + (double)pan / 500.0) * Math.PI * 0.5)));
                                    audiofactoryparams.put("ch3Vol", d.format((double)reverbEffectsSend / 1000.0));
                                    audiofactoryparams.put("ch4Vol", d.format((double)chorusEffectsSend / 1000.0));
                                    audiofactoryparams.put("initialAttenuation", d.format(d_initialAttenuation));
                                    audiofactoryparams.put("delayVolEnv", d.format(d_delayVolEnv));
                                    audiofactoryparams.put("attackVolEnv", d.format(d_attackVolEnv));
                                    audiofactoryparams.put("holdVolEnv", d.format(d_holdVolEnv));
                                    audiofactoryparams.put("decayVolEnv", d.format(d_decayVolEnv));
                                    audiofactoryparams.put("sustainVolEnv", d.format(d_sustainVolEnv));
                                    audiofactoryparams.put("releaseVolEnv", d.format(d_releaseVolEnv));
                                    audiofactoryparams.put("delayModEnv", d.format(d_delayModEnv));
                                    audiofactoryparams.put("attackModEnv", d.format(d_attackModEnv));
                                    audiofactoryparams.put("holdModEnv", d.format(d_holdModEnv));
                                    audiofactoryparams.put("decayModEnv", d.format(d_decayModEnv));
                                    audiofactoryparams.put("sustainModEnv", d.format(d_sustainModEnv));
                                    audiofactoryparams.put("releaseModEnv", d.format(d_releaseModEnv));
                                    audiofactoryparams.put("modEnvToPitch", d.format((double)modEnvToPitch / 1200.0));
                                    audiofactoryparams.put("modEnvToFilterFc", d.format((double)modEnvToFilterFc / 1200.0));
                                    uparams.setParameter("sample", samplevar);
                                    audiofactoryparams.put("sampleRate", samplerate);
                                    audiofactoryparams.put("scaleTune", d.format(scaletune));
                                    audiofactoryparams.put("coarseTune", d.format(notetune));
                                    audiofactoryparams.put("initialFilterFc", d.format(8.177 * Math.pow(2.0, (double)initialFilterFc / 1200.0)));
                                    audiofactoryparams.put("initialFilterQ", d.format((double)initialFilterQ / 10.0));
                                    audiofactoryparams.put("delayModLFO", d.format(delayModLFO == Short.MIN_VALUE ? 0.0 : Math.pow(2.0, (double)delayModLFO / 1200.0)));
                                    audiofactoryparams.put("freqModLFO", d.format(8.177 * Math.pow(2.0, (double)freqModLFO / 1200.0)));
                                    audiofactoryparams.put("modLfoToPitch", d.format((double)modLfoToPitch / 1200.0));
                                    audiofactoryparams.put("modLfoToFilterFc", d.format((double)modLfoToFilterFc / 1200.0));
                                    audiofactoryparams.put("modLfoToVolume", d.format(Math.pow(10.0, (double)(-(modLfoToVolume / 10)) / 20.0)));
                                    audiofactoryparams.put("delayVibLFO", d.format(delayModLFO == Short.MIN_VALUE ? 0.0 : Math.pow(2.0, (double)delayVibLFO / 1200.0)));
                                    audiofactoryparams.put("freqVibLFO", d.format(8.177 * Math.pow(2.0, freqVibLFO / 1200)));
                                    audiofactoryparams.put("vibLfoToPitch", d.format((double)vibLfoToPitch / 1200.0));
                                    audiofactoryparams.put("keynumToModEnvHold", d.format((double)keynumToModEnvHold / 100.0));
                                    audiofactoryparams.put("keynumToModEnvDecay", d.format((double)keynumToModEnvDecay / 100.0));
                                    audiofactoryparams.put("keynumToVolEnvHold", d.format((double)keynumToVolEnvHold / 100.0));
                                    audiofactoryparams.put("keynumToVolEnvDecay", d.format((double)keynumToVolEnvDecay / 100.0));
                                    if (addparameters.size() != 0) {
                                        for (Map.Entry entry : addparameters.entrySet()) {
                                            String keyname;
                                            String extvar = "external_" + (String)entry.getKey();
                                            if (((String)entry.getKey()).startsWith("add_")) {
                                                keyname = ((String)entry.getKey()).substring(4);
                                                String value = (String)audiofactoryparams.get(keyname);
                                                value = value == null ? extvar : "(" + value + ") + " + extvar;
                                                audiofactoryparams.put(keyname, value);
                                                continue;
                                            }
                                            if (((String)entry.getKey()).startsWith("mul_")) {
                                                keyname = ((String)entry.getKey()).substring(4);
                                                String value = (String)audiofactoryparams.get(keyname);
                                                if (value == null) continue;
                                                value = "(" + value + ") * " + extvar;
                                                audiofactoryparams.put(keyname, value);
                                                continue;
                                            }
                                            audiofactoryparams.put((String)entry.getKey(), extvar);
                                        }
                                    }
                                    for (Map.Entry entry : audiofactoryparams.entrySet()) {
                                        String val = (String)entry.getValue();
                                        String name = (String)entry.getKey();
                                        if (val.length() == 0) continue;
                                        if (val.startsWith("(")) {
                                            if (interpreter == null) {
                                                interpreter = new Interpreter();
                                                interpreter.setAutoCommit(false);
                                            }
                                            try {
                                                uparams.setParameter(name, interpreter.eval(val));
                                            }
                                            catch (ScriptParserException e) {
                                                e.printStackTrace();
                                            }
                                            continue;
                                        }
                                        try {
                                            uparams.setParameter(name, (double)new Double(Double.parseDouble(val)));
                                        }
                                        catch (Exception e) {
                                            if (interpreter == null) {
                                                interpreter = new Interpreter();
                                                interpreter.setAutoCommit(false);
                                            }
                                            try {
                                                uparams.setParameter(name, interpreter.eval(val));
                                            }
                                            catch (ScriptParserException e1) {
                                                e1.printStackTrace();
                                            }
                                        }
                                    }
                                    Variable sf2preset = new Variable();
                                    uparams.setParameter("output", sf2preset);
                                    AudioVoiceFactory2.newInstance(uparams);
                                    uparams = new Parameters(namespace);
                                    if (exclusiveClass != -1) {
                                        uparams.setParameter("exclusiveClass", (double)new Double(exclusiveClass));
                                    }
                                    uparams.setParameter("output", voices);
                                    uparams.setParameter("input", sf2preset);
                                    uparams.setParameter("keyfrom", (double)new Double(keyRange_from));
                                    uparams.setParameter("keyto", (double)new Double(keyRange_to));
                                    uparams.setParameter("velfrom", (double)new Double(velRange_from));
                                    uparams.setParameter("velto", (double)new Double(velRange_to));
                                    uparams.setParameter("name", ObjectsPart.asVariable(sampleinfo.getAttribute("name")));
                                    RegisterVoice.newInstance(uparams);
                                    ++gen_no;
                                }
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                if (interpreter != null && addparameters.size() != 0) {
                    for (Map.Entry entry : addparameters.entrySet()) {
                        interpreter.add("external_" + (String)entry.getKey(), DoublePart.asVariable(DoublePart.asDouble((Variable)entry.getValue())));
                    }
                }
                SampleEntry[] samples_entries = new SampleEntry[sampleslist.size()];
                sampleslist.toArray(samples_entries);
                PresetEntry answer2 = new PresetEntry(presetcacheid, samples_entries);
                answer2.variable = voices;
                presettable.put(presetcacheid, answer2);
                GlobalStatus.setStatus("");
                return answer2;
            }
            return null;
        }
    }

    public static int parseInt(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (Throwable e) {
            return 0;
        }
    }

    public static String globalSecondAttribute(Element global, Element primary, String attribute) {
        if (primary != null && primary.getAttribute(attribute).length() != 0) {
            return primary.getAttribute(attribute);
        }
        if (global != null && global.getAttribute(attribute).length() != 0) {
            return global.getAttribute(attribute);
        }
        return "";
    }

    public String expandPath(String path) {
        if ((path = path.trim()).length() == 0) {
            return path;
        }
        if (path.startsWith(File.separator)) {
            return path;
        }
        if (path.length() > 2 && Character.isLetter(path.charAt(0)) && path.charAt(1) == ':' && path.charAt(2) == File.separatorChar) {
            return path;
        }
        String wrkdir = ObjectsPart.toString(this.wrkdir);
        if (wrkdir.trim().length() == 0) {
            return path;
        }
        if (wrkdir.endsWith(File.separator)) {
            return String.valueOf(wrkdir) + path;
        }
        return String.valueOf(wrkdir) + File.separator + path;
    }

    public void calc() {
        this.namespace.addToCommitStack(this);
    }

    public int getRunLevel() {
        return 0;
    }

    public void commit() {
        this.clear();
        this.initPresetGarbageCollector();
        String filename = this.expandPath(ObjectsPart.toString(this.filename));
        int presetid = (int)DoublePart.asDouble(this.preset);
        int bankid = (int)DoublePart.asDouble(this.bank);
        if (this.resource != null) {
            this.resource.close();
        }
        this.resource = this.manager.getResource(filename);
        if (this.resource == null) {
            return;
        }
        File file = this.resource.getFile();
        filename = file.getPath();
        int i_streammode = (int)DoublePart.asDouble(this.streammode);
        this.answer = SF2PresetInstance.loadPreset(filename, presetid, bankid, this.addparameters, this.namespace, i_streammode);
        if (this.answer != null) {
            this.answer.use();
            this.output.add(this.answer.variable);
            return;
        }
    }

    public SF2PresetInstance(Parameters parameters) {
        this.namespace = parameters.getNameSpace();
        this.manager = ResourceManager.getInstance(this.namespace);
        this.output = parameters.getParameterWithDefault("output");
        this.filename = parameters.getParameterWithDefault(1, "filename");
        this.preset = parameters.getParameterWithDefault(2, "preset");
        this.bank = parameters.getParameterWithDefault(3, "bank");
        this.streammode = parameters.getParameterWithDefault(4, "streammode");
        this.wrkdir = parameters.get("wrkdir");
        this.addparameters.putAll(parameters.getParameters());
        this.addparameters.remove("output");
        this.addparameters.remove("filename");
        this.addparameters.remove("preset");
        this.addparameters.remove("bank");
        this.addparameters.remove("0");
        this.addparameters.remove("1");
        this.addparameters.remove("2");
        this.addparameters.remove("3");
        this.addparameters.remove("4");
        this.addparameters.remove("5");
        for (Map.Entry entry : this.addparameters.entrySet()) {
            DoublePart.getInstance((Variable)entry.getValue()).addListener(this);
        }
        DoublePart.getInstance(this.preset).addListener(this);
        DoublePart.getInstance(this.bank).addListener(this);
        DoublePart.getInstance(this.streammode).addListener(this);
        ObjectsPart.getInstance(this.filename).addListener(this);
        ObjectsPart.getInstance(this.wrkdir).addListener(this);
        this.calc();
    }

    public void close() {
        this.clear();
        if (this.resource != null) {
            this.resource.close();
            this.resource = null;
        }
        for (Map.Entry entry : this.addparameters.entrySet()) {
            DoublePart.getInstance((Variable)entry.getValue()).removeListener(this);
        }
        DoublePart.getInstance(this.preset).removeListener(this);
        DoublePart.getInstance(this.bank).removeListener(this);
        DoublePart.getInstance(this.streammode).removeListener(this);
        ObjectsPart.getInstance(this.filename).removeListener(this);
        ObjectsPart.getInstance(this.wrkdir).removeListener(this);
    }

    private static class SampleEntry {
        int usages = 0;
        Variable variable;
        String ident;
        UnitInstancePart instance;

        public SampleEntry(String ident) {
            this.ident = ident;
            sample_garbage.add(ident);
        }

        public void use() {
            if (this.usages == 0) {
                sample_garbage.remove(this.ident);
            }
            ++this.usages;
        }

        public void deuse() {
            --this.usages;
            if (this.usages == 0) {
                sample_garbage.add(this.ident);
            }
        }

        public void close() {
            sampletable.remove(this.ident);
            this.instance.close();
        }
    }

    private static class PresetEntry {
        int usages = 0;
        Variable variable;
        String ident;
        SampleEntry[] samples;

        public PresetEntry(String ident, SampleEntry[] samples) {
            this.ident = ident;
            this.samples = samples;
            preset_garbage.add(ident);
        }

        public void use() {
            if (this.usages == 0) {
                preset_garbage.remove(this.ident);
            }
            ++this.usages;
            int i = 0;
            while (i < this.samples.length) {
                this.samples[i].use();
                ++i;
            }
        }

        public void deuse() {
            --this.usages;
            if (this.usages == 0) {
                preset_garbage.add(this.ident);
            }
            int i = 0;
            while (i < this.samples.length) {
                this.samples[i].deuse();
                ++i;
            }
        }

        public void close() {
            presettable.remove(this.ident);
            this.samples = null;
        }
    }
}

