/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.util;

import java.util.Arrays;
import rasmus.interpreter.sampled.AudioStream;

public class WaveUtils {
    public static byte[] get16BitBytes(float[] sample) {
        byte[] bytesample = new byte[sample.length * 2];
        int i = 0;
        while (i < sample.length) {
            int l = i * 2;
            int value = (int)sample[i];
            bytesample[l] = (byte)value;
            bytesample[l + 1] = (byte)(value >>> 8);
            ++i;
        }
        return bytesample;
    }

    public static final float interpolate(float[] wavetable, double location) {
        float p5;
        float p4;
        float p3;
        float p1;
        float p0;
        int nearest_sample = (int)location;
        double x = location - (double)nearest_sample;
        float p2 = wavetable[nearest_sample];
        if (nearest_sample > 1) {
            p0 = wavetable[nearest_sample - 2];
            p1 = wavetable[nearest_sample - 1];
        } else {
            p0 = p2;
            p1 = nearest_sample > 0 ? wavetable[nearest_sample - 1] : p2;
        }
        int size = wavetable.length;
        if (nearest_sample < size - 3) {
            p3 = wavetable[nearest_sample + 1];
            p4 = wavetable[nearest_sample + 2];
            p5 = wavetable[nearest_sample + 3];
        } else {
            p5 = wavetable[size - 1];
            if (nearest_sample < size - 2) {
                p3 = wavetable[nearest_sample + 1];
                p4 = wavetable[nearest_sample + 2];
            } else {
                p4 = p5;
                p3 = nearest_sample < size - 1 ? wavetable[nearest_sample + 1] : p4;
            }
        }
        return (float)((double)p2 + 0.04166666666 * x * ((double)(p3 - p1) * 16.0 + (double)(p0 - p4) * 2.0 + x * ((double)(p3 + p1) * 16.0 - (double)p0 - (double)p2 * 30.0 - (double)p4 + x * ((double)p3 * 66.0 - (double)p2 * 70.0 - (double)p4 * 33.0 + (double)p1 * 39.0 + (double)p5 * 7.0 - (double)p0 * 9.0 + x * ((double)p2 * 126.0 - (double)p3 * 124.0 + (double)p4 * 61.0 - (double)p1 * 64.0 - (double)p5 * 12.0 + (double)p0 * 13.0 + x * ((double)(p3 - p2) * 50.0 + (double)(p1 - p4) * 25.0 + (double)(p5 - p0) * 5.0))))));
    }

    public static class ResampleStream
    implements AudioStream {
        double f_amount;
        AudioStream inputstream;
        int channels;
        double[] lastvalues;
        double ix = 0.0;
        double[] stockbuffer = null;

        public ResampleStream(AudioStream input, double amount, int channels) {
            this.channels = channels;
            this.lastvalues = new double[channels];
            this.inputstream = input;
            this.f_amount = amount;
        }

        public int mix(double[] buffer, int start, int end) {
            int skorun = 2;
            int sbuffsize = 2048;
            int xloopbuffsize = sbuffsize - skorun;
            int loopbuffsize = xloopbuffsize * this.channels;
            int ret = 0;
            if (this.stockbuffer == null) {
                this.stockbuffer = new double[sbuffsize * this.channels];
                ret = this.inputstream.replace(this.stockbuffer, 0, sbuffsize * this.channels);
                if (ret == -1) {
                    Arrays.fill(this.stockbuffer, this.channels, sbuffsize * this.channels, 0.0);
                } else {
                    Arrays.fill(this.stockbuffer, ret, sbuffsize * this.channels, 0.0);
                }
            }
            int ixx = 0;
            int i = start;
            while (i < end) {
                int j = (int)this.ix * this.channels;
                double interp = this.ix % 1.0;
                int c = 0;
                while (c < this.channels) {
                    int n = i + c;
                    buffer[n] = buffer[n] + (this.stockbuffer[j] * (1.0 - interp) + this.stockbuffer[j + this.channels] * interp);
                    ++j;
                    ++c;
                }
                this.ix += this.f_amount;
                ++ixx;
                if (this.ix > (double)xloopbuffsize) {
                    this.ix -= (double)xloopbuffsize;
                    c = 0;
                    while (c < skorun * this.channels) {
                        this.stockbuffer[c] = this.stockbuffer[loopbuffsize + c];
                        ++c;
                    }
                    ret = this.inputstream.replace(this.stockbuffer, this.channels * skorun, sbuffsize * this.channels);
                    if (ret == -1) {
                        Arrays.fill(this.stockbuffer, this.channels * skorun, 2048 * this.channels, 0.0);
                    } else {
                        Arrays.fill(this.stockbuffer, this.channels * skorun + ret, 2048 * this.channels, 0.0);
                    }
                }
                i += this.channels;
            }
            if (ret == -1) {
                return -1;
            }
            return end - start;
        }

        public int replace(double[] buffer, int start, int end) {
            Arrays.fill(buffer, start, end, 0.0);
            return this.mix(buffer, start, end);
        }

        public int skip(int len) {
            double[] buffer = new double[len];
            return this.mix(buffer, 0, len);
        }

        public int isStatic(double[] buffer, int len) {
            return -1;
        }

        public void close() {
            this.inputstream.close();
        }
    }
}

