/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.util;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import javax.sound.sampled.AudioFormat;
import rasmus.util.ByteConversion;

public class WAVEAudioOutputWriter
extends OutputStream {
    RandomAccessFile ra;
    AudioFormat format;

    public WAVEAudioOutputWriter(File file, AudioFormat format) throws IOException {
        this.ra = new RandomAccessFile(file, "rw");
        this.ra.setLength(44L);
        this.format = format;
        this.writeHeader();
    }

    public void writeHeader() throws IOException {
        this.ra.seek(0L);
        this.ra.write("RIFF".getBytes("latin1"));
        long totallen = this.ra.length() - 8L;
        if (totallen < 0L) {
            totallen = 0L;
        }
        this.ra.write(ByteConversion.longToDWord(totallen));
        this.ra.write("WAVE".getBytes("latin1"));
        this.ra.write("fmt ".getBytes("latin1"));
        this.ra.write(ByteConversion.longToDWord(16L));
        this.ra.write(ByteConversion.intToShort(1));
        this.ra.write(ByteConversion.intToShort(this.format.getChannels()));
        long srate = (long)this.format.getSampleRate();
        this.ra.write(ByteConversion.longToDWord(srate));
        this.ra.write(ByteConversion.longToDWord(srate * (long)this.format.getChannels() * (long)this.format.getSampleSizeInBits() / 8L));
        this.ra.write(ByteConversion.intToShort(this.format.getChannels() * this.format.getSampleSizeInBits() / 8));
        this.ra.write(ByteConversion.intToShort(this.format.getSampleSizeInBits()));
        this.ra.write("data".getBytes("latin1"));
        totallen = this.ra.length() - 44L;
        if (totallen < 0L) {
            totallen = 0L;
        }
        this.ra.write(ByteConversion.longToDWord(totallen));
    }

    public void close() throws IOException {
        this.writeHeader();
        this.ra.close();
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.ra.write(b, off, len);
    }

    public void write(int data) throws IOException {
        this.ra.write(data);
    }

    public void write(byte[] b) throws IOException {
        this.ra.write(b);
    }
}

