/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.util;

import java.util.Arrays;
import rasmus.interpreter.sampled.util.FFT;

public class Vocoder {
    private FFT fft;
    private int fftFrameSize;
    private int fftFrameSize2;
    private int osamp;
    private int stepSize;
    private double freqPerBin;
    private double[] window_table;
    private double[] gFFTworksp;
    private double[] gFFTworksp2;
    private double[] gOutputAccum;
    private double[] gInFIFO;
    private double[] gInFIFO2;
    private double[] gOutFIFO;
    private int gRover = -1;
    private int inFifoLatency;
    private int binsperformants;
    private double[] magnmap1;
    private double[] magnmap2;
    private double[] amagnmap1;
    private double[] amagnmap2;
    private int first100HZ;
    private double[] runningsum = null;

    public Vocoder(int fftFrameSize, int osamp, double sampleRate, int vocoderSize) {
        this.fft = new FFT(fftFrameSize);
        this.fftFrameSize = fftFrameSize;
        this.stepSize = fftFrameSize / osamp;
        this.freqPerBin = sampleRate / (double)fftFrameSize;
        this.osamp = osamp;
        this.window_table = this.fft.wHanning();
        this.inFifoLatency = fftFrameSize - this.stepSize;
        this.fftFrameSize2 = fftFrameSize / 2;
        this.gFFTworksp = new double[fftFrameSize];
        this.gFFTworksp2 = new double[fftFrameSize];
        this.gOutputAccum = new double[2 * fftFrameSize];
        this.gInFIFO = new double[fftFrameSize];
        this.gInFIFO2 = new double[fftFrameSize];
        this.gOutFIFO = new double[fftFrameSize];
        Arrays.fill(this.gInFIFO, 0.0);
        Arrays.fill(this.gInFIFO2, 0.0);
        Arrays.fill(this.gOutFIFO, 0.0);
        Arrays.fill(this.gOutputAccum, 0.0);
        this.binsperformants = (int)((double)vocoderSize / this.freqPerBin);
        this.magnmap1 = new double[this.fftFrameSize2];
        this.magnmap2 = new double[this.fftFrameSize2];
        this.amagnmap1 = new double[this.fftFrameSize2];
        this.amagnmap2 = new double[this.fftFrameSize2];
        this.first100HZ = (int)(100.0 / sampleRate * (double)this.fftFrameSize2);
    }

    public void processFormatScan(double[] magnmap, double[] outdata) {
        int runner_len = this.binsperformants;
        if (this.runningsum == null) {
            this.runningsum = new double[runner_len];
        }
        double[] runningsum = this.runningsum;
        Arrays.fill(runningsum, 0.0);
        int runner = 0;
        double totalsum = 0.0;
        int i = 0;
        while (i < this.fftFrameSize2) {
            double m = magnmap[i];
            totalsum -= runningsum[runner];
            runningsum[runner] = m;
            ++runner;
            runner %= runner_len;
            outdata[i] = (totalsum += m) / (double)runner_len;
            ++i;
        }
    }

    public void processFFT(double[] fftdata, double[] fftmod) {
        int i = 0;
        while (i < this.fftFrameSize2) {
            double real = fftdata[2 * i];
            double imag = fftdata[2 * i + 1];
            double real2 = fftmod[2 * i];
            double imag2 = fftmod[2 * i + 1];
            this.magnmap1[i] = real * real + imag * imag;
            this.magnmap2[i] = real2 * real2 + imag2 * imag2;
            ++i;
        }
        this.processFormatScan(this.magnmap1, this.amagnmap1);
        this.processFormatScan(this.magnmap2, this.amagnmap2);
        i = 0;
        while (i < this.fftFrameSize2) {
            double amp = this.amagnmap1[i] < 1.0E-6 ? 0.0 : Math.sqrt(this.amagnmap2[i] / this.amagnmap1[i]);
            if (i < this.first100HZ) {
                amp = 0.0;
            }
            fftdata[2 * i] = fftdata[2 * i] * amp;
            fftdata[2 * i + 1] = fftdata[2 * i + 1] * amp;
            ++i;
        }
    }

    public void process(int start, int end, int interlace, double[] indata, double[] modulator, double[] outdata) {
        if (this.gRover == -1) {
            this.gRover = this.inFifoLatency;
        }
        double[] gInFIFO = this.gInFIFO;
        double[] gOutFIFO = this.gOutFIFO;
        double[] gOutputAccum = this.gOutputAccum;
        double[] window_table = this.window_table;
        double[] gFFTworksp = this.gFFTworksp;
        double[] gFFTworksp2 = this.gFFTworksp2;
        int i = start;
        while (i < end) {
            gInFIFO[this.gRover] = indata[i];
            this.gInFIFO2[this.gRover] = modulator[i];
            outdata[i] = gOutFIFO[this.gRover - this.inFifoLatency];
            ++this.gRover;
            if (this.gRover >= this.fftFrameSize) {
                double window;
                this.gRover = this.inFifoLatency;
                int k = 0;
                while (k < this.fftFrameSize) {
                    window = window_table[k];
                    gFFTworksp[k] = gInFIFO[k] * window;
                    gFFTworksp2[k] = this.gInFIFO2[k] * window;
                    ++k;
                }
                this.fft.calcReal(gFFTworksp, -1);
                this.fft.calcReal(gFFTworksp2, -1);
                this.processFFT(gFFTworksp, gFFTworksp2);
                this.fft.calcReal(gFFTworksp, 1);
                k = 0;
                while (k < this.fftFrameSize) {
                    window = window_table[k];
                    int n = k;
                    gOutputAccum[n] = gOutputAccum[n] + 2.0 * window * gFFTworksp[k] / (double)(this.fftFrameSize2 * this.osamp);
                    ++k;
                }
                k = 0;
                while (k < this.stepSize) {
                    gOutFIFO[k] = gOutputAccum[k];
                    ++k;
                }
                int shift_len = gOutputAccum.length / 2;
                int j = 0;
                while (j < shift_len) {
                    gOutputAccum[j] = gOutputAccum[j + this.stepSize];
                    ++j;
                }
                k = 0;
                while (k < this.inFifoLatency) {
                    gInFIFO[k] = gInFIFO[k + this.stepSize];
                    ++k;
                }
                k = 0;
                while (k < this.inFifoLatency) {
                    this.gInFIFO2[k] = this.gInFIFO2[k + this.stepSize];
                    ++k;
                }
            }
            i += interlace;
        }
    }
}

