/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class RandomFileInputStream
extends InputStream {
    RandomAccessFile randomfile = null;
    long markpos = 0L;

    public RandomFileInputStream(File file) throws IOException {
        this.randomfile = new RandomAccessFile(file, "r");
    }

    public void close() throws IOException {
        this.randomfile.close();
    }

    public int read() throws IOException {
        return this.randomfile.read();
    }

    public int available() throws IOException {
        return (int)(this.randomfile.length() - this.randomfile.getFilePointer());
    }

    public synchronized void mark(int arg0) {
        try {
            this.markpos = this.randomfile.getFilePointer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean markSupported() {
        return true;
    }

    public int read(byte[] arg0) throws IOException {
        return this.read(arg0, 0, arg0.length);
    }

    public int read(byte[] arg0, int arg1, int arg2) throws IOException {
        return this.randomfile.read(arg0, arg1, arg2);
    }

    public synchronized void reset() throws IOException {
        this.randomfile.seek(this.markpos);
    }

    public long skip(long arg0) throws IOException {
        return this.randomfile.skipBytes((int)arg0);
    }
}

