/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.util;

import java.util.Arrays;
import rasmus.interpreter.sampled.util.FFT;

public class PitchShift {
    public static final double M_PI = Math.PI;
    public static final int MAX_FRAME_LENGTH = 8192;
    private double[] gInFIFO = new double[8192];
    private double[] gOutFIFO = new double[8192];
    private double[] gFFTworksp = new double[8192];
    private double[] gOutputAccum = new double[8192];
    private int gRover = -1;
    private int fftFrameSize;
    int osamp;
    double sampleRate;
    private int fftFrameSize2;
    private double[] window_table;
    private FFT fft;
    private int binsperformants;
    private double[] magnmap1;
    private double[] magnmap2;
    private double[] amagnmap1;
    private double[] amagnmap2;
    private double[] last_amagnmap2;
    private double[] runningsum = null;
    float f_freqPerBin;
    float f_expct;
    double freqPerBin;
    double expct;
    int inFifoLatency;
    int stepSize;
    private double[] gLastPhase = new double[4097];
    private double[] gSumPhase = new double[4097];
    private double[] gAnaFreq = new double[8192];
    private double[] gAnaMagn = new double[8192];
    private double[] gSynFreq = new double[8192];
    private double[] gSynMagn = new double[8192];

    public PitchShift(int fftFrameSize, int osamp, double sampleRate) {
        this.fft = new FFT(fftFrameSize);
        Arrays.fill(this.gInFIFO, 0.0);
        Arrays.fill(this.gOutFIFO, 0.0);
        Arrays.fill(this.gFFTworksp, 0.0);
        Arrays.fill(this.gLastPhase, 0.0);
        Arrays.fill(this.gSumPhase, 0.0);
        Arrays.fill(this.gOutputAccum, 0.0);
        Arrays.fill(this.gAnaFreq, 0.0);
        Arrays.fill(this.gAnaMagn, 0.0);
        this.fftFrameSize = fftFrameSize;
        this.osamp = osamp;
        this.sampleRate = sampleRate;
        this.fftFrameSize2 = fftFrameSize / 2;
        this.stepSize = fftFrameSize / osamp;
        this.freqPerBin = sampleRate / (double)fftFrameSize;
        this.expct = Math.PI * 2 * (double)this.stepSize / (double)fftFrameSize;
        this.inFifoLatency = fftFrameSize - this.stepSize;
        this.window_table = this.fft.wHanning();
        this.binsperformants = (int)(250.0 / this.freqPerBin);
        this.f_freqPerBin = (float)this.freqPerBin;
        this.f_expct = (float)this.expct;
        this.magnmap1 = new double[this.fftFrameSize2];
        this.magnmap2 = new double[this.fftFrameSize2];
        this.amagnmap1 = new double[this.fftFrameSize2];
        this.amagnmap2 = new double[this.fftFrameSize2];
        this.last_amagnmap2 = new double[this.fftFrameSize2];
        Arrays.fill(this.last_amagnmap2, 1.0);
    }

    public void processFormatScan(double[] magnmap, double[] outdata) {
        int runner_len = this.binsperformants;
        if (this.runningsum == null) {
            this.runningsum = new double[runner_len];
        }
        double[] runningsum = this.runningsum;
        Arrays.fill(runningsum, 0.0);
        int runner = 0;
        double totalsum = 0.0;
        int i = 0;
        while (i < this.fftFrameSize2) {
            double m = magnmap[i];
            totalsum -= runningsum[runner];
            runningsum[runner] = m;
            ++runner;
            runner %= runner_len;
            outdata[i] = (totalsum += m) / (double)runner_len;
            ++i;
        }
    }

    public void smbPitchShift(double formatpitchShift, double[] formatpitchtable, double pitchShift, double[] pitchtable, int p_start, int start, int end, int interlace, double[] indata, double[] outdata) {
        if (this.gRover == -1) {
            this.gRover = this.inFifoLatency;
        }
        int pi = p_start;
        double[] gInFIFO = this.gInFIFO;
        double[] gOutFIFO = this.gOutFIFO;
        double[] gOutputAccum = this.gOutputAccum;
        double[] window_table = this.window_table;
        double[] gFFTworksp = this.gFFTworksp;
        int i = start;
        while (i < end) {
            gInFIFO[this.gRover] = indata[i];
            outdata[i] = gOutFIFO[this.gRover - this.inFifoLatency];
            ++this.gRover;
            if (this.gRover >= this.fftFrameSize) {
                double imag;
                double real;
                int ii;
                double window;
                this.gRover = this.inFifoLatency;
                if (pitchtable != null) {
                    pitchShift = pitchtable[pi];
                }
                if (formatpitchtable != null) {
                    formatpitchShift = formatpitchtable[pi];
                }
                int k = 0;
                while (k < this.fftFrameSize) {
                    window = window_table[k];
                    gFFTworksp[k] = gInFIFO[k] * window;
                    ++k;
                }
                this.fft.calcReal(gFFTworksp, -1);
                boolean doformatpitch = false;
                if (Math.abs(formatpitchShift - pitchShift) > 0.001) {
                    doformatpitch = true;
                }
                if (doformatpitch) {
                    ii = 0;
                    while (ii < this.fftFrameSize2) {
                        real = gFFTworksp[2 * ii];
                        imag = gFFTworksp[2 * ii + 1];
                        this.magnmap1[ii] = real * real + imag * imag;
                        ++ii;
                    }
                }
                if (Math.abs(pitchShift - 1.0) > 0.001) {
                    this.processFFT(pitchShift, gFFTworksp);
                }
                if (doformatpitch) {
                    ii = 0;
                    while (ii < this.fftFrameSize2) {
                        real = gFFTworksp[2 * ii];
                        imag = gFFTworksp[2 * ii + 1];
                        this.magnmap2[ii] = real * real + imag * imag;
                        ++ii;
                    }
                    this.processFormatScan(this.magnmap1, this.amagnmap1);
                    this.processFormatScan(this.magnmap2, this.amagnmap2);
                    double[] magn_shift1 = this.amagnmap1;
                    if (Math.abs(formatpitchShift - 1.0) > 0.001) {
                        magn_shift1 = this.magnmap1;
                        int fftFrameSize2_1 = this.fftFrameSize2 - 1;
                        int j = 0;
                        while (j < this.fftFrameSize2) {
                            int index = (int)((double)j / formatpitchShift);
                            double scale = (double)j / formatpitchShift - (double)index;
                            magn_shift1[j] = index < fftFrameSize2_1 ? this.amagnmap1[index] * (1.0 - scale) + this.amagnmap1[index + 1] * scale : 0.0;
                            ++j;
                        }
                    }
                    int ii2 = 0;
                    while (ii2 < this.fftFrameSize2) {
                        double amp = this.amagnmap2[ii2] == 0.0 ? 0.0 : Math.sqrt(magn_shift1[ii2] / this.amagnmap2[ii2]);
                        gFFTworksp[2 * ii2] = gFFTworksp[2 * ii2] * amp;
                        gFFTworksp[2 * ii2 + 1] = gFFTworksp[2 * ii2 + 1] * amp;
                        ++ii2;
                    }
                }
                this.fft.calcReal(gFFTworksp, 1);
                k = 0;
                while (k < this.fftFrameSize) {
                    window = window_table[k];
                    int n = k;
                    gOutputAccum[n] = gOutputAccum[n] + 2.0 * window * gFFTworksp[k] / (double)(this.fftFrameSize2 * this.osamp);
                    ++k;
                }
                k = 0;
                while (k < this.stepSize) {
                    gOutFIFO[k] = gOutputAccum[k];
                    ++k;
                }
                int shift_len = gOutputAccum.length / 2;
                int j = 0;
                while (j < shift_len) {
                    gOutputAccum[j] = gOutputAccum[j + this.stepSize];
                    ++j;
                }
                k = 0;
                while (k < this.inFifoLatency) {
                    gInFIFO[k] = gInFIFO[k + this.stepSize];
                    ++k;
                }
            }
            i += interlace;
            ++pi;
        }
    }

    public final void processFFT(double pitchShift, double[] gFFTworksp) {
        double tmp;
        double phase;
        double magn;
        double[] gAnaMagn = this.gAnaMagn;
        double[] gAnaFreq = this.gAnaFreq;
        double[] gSynMagn = this.gSynMagn;
        double[] gSynFreq = this.gSynFreq;
        int k = 0;
        while (k <= this.fftFrameSize2) {
            double real = gFFTworksp[2 * k];
            double imag = gFFTworksp[2 * k + 1];
            magn = 2.0 * Math.sqrt(real * real + imag * imag);
            phase = Math.atan2(imag, real);
            tmp = phase - this.gLastPhase[k];
            this.gLastPhase[k] = phase;
            int qpd = (int)((tmp -= (double)k * this.expct) / Math.PI);
            qpd = qpd >= 0 ? (qpd += qpd & 1) : (qpd -= qpd & 1);
            tmp -= Math.PI * (double)qpd;
            tmp = (double)this.osamp * tmp / (Math.PI * 2);
            tmp = (double)k * this.freqPerBin + tmp * this.freqPerBin;
            gAnaMagn[k] = magn;
            gAnaFreq[k] = tmp;
            ++k;
        }
        Arrays.fill(gSynMagn, 0.0);
        Arrays.fill(gSynFreq, 0.0);
        k = 0;
        while (k <= this.fftFrameSize2) {
            int index = (int)((double)k / pitchShift);
            if (index <= this.fftFrameSize2) {
                int n = k;
                gSynMagn[n] = gSynMagn[n] + gAnaMagn[index];
                gSynFreq[k] = gAnaFreq[index] * pitchShift;
            }
            ++k;
        }
        k = 0;
        while (k <= this.fftFrameSize2) {
            magn = gSynMagn[k];
            tmp = gSynFreq[k];
            tmp -= (double)k * this.freqPerBin;
            tmp /= this.freqPerBin;
            tmp = Math.PI * 2 * tmp / (double)this.osamp;
            int n = k;
            this.gSumPhase[n] = this.gSumPhase[n] + (tmp += (double)k * this.expct);
            phase = this.gSumPhase[k];
            gFFTworksp[2 * k] = magn * Math.cos(phase);
            gFFTworksp[2 * k + 1] = magn * Math.sin(phase);
            ++k;
        }
    }
}

