/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.util;

public class IIRFilter {
    double samplerate;
    double a1;
    double a2;
    double a3;
    double b1;
    double b2;
    double o1;
    double o2;
    double i1;
    double i2;

    public IIRFilter(double samplerate) {
        this.samplerate = samplerate;
    }

    public void lowpass(double cutoff, double rez) {
        if (cutoff < 10.0) {
            cutoff = 10.0;
        }
        if (cutoff * 2.0 > this.samplerate) {
            cutoff = this.samplerate / 2.0;
        }
        if (rez < (double)0.1f) {
            rez = 0.1f;
        }
        if (rez > (double)1.414f) {
            rez = 1.414f;
        }
        double c = 1.0 / Math.tan(Math.PI * cutoff / this.samplerate);
        double r = rez;
        this.a1 = 1.0 / (1.0 + r * c + c * c);
        this.a2 = 2.0 * this.a1;
        this.a3 = this.a1;
        this.b1 = 2.0 * (1.0 - c * c) * this.a1;
        this.b2 = (1.0 - r * c + c * c) * this.a1;
    }

    public void hipass(double cutoff, double rez) {
        if (cutoff < 10.0) {
            cutoff = 10.0;
        }
        if (cutoff * 2.0 > this.samplerate) {
            cutoff = this.samplerate / 2.0;
        }
        if (rez < (double)0.1f) {
            rez = 0.1f;
        }
        if (rez > (double)1.414f) {
            rez = 1.414f;
        }
        double c = Math.tan(Math.PI * cutoff / this.samplerate);
        double r = rez;
        this.a1 = 1.0 / (1.0 + r * c + c * c);
        this.a2 = -2.0 * this.a1;
        this.a3 = this.a1;
        this.b1 = 2.0 * (c * c - 1.0) * this.a1;
        this.b2 = (1.0 - r * c + c * c) * this.a1;
    }

    public void processReplace(double[] inputs, double[] outputs, int from, int to, int channels) {
        double o1 = this.o1;
        double o2 = this.o2;
        double i1 = this.i1;
        double i2 = this.i2;
        int i = from;
        while (i < to) {
            double o_value;
            double i_value = inputs[i];
            outputs[i] = o_value = this.a1 * i_value + this.a2 * i1 + this.a3 * i2 - this.b1 * o1 - this.b2 * o2;
            i2 = i1;
            i1 = i_value;
            o2 = o1;
            o1 = o_value;
            i += channels;
        }
        this.o1 = o1;
        this.o2 = o2;
        this.i1 = i1;
        this.i2 = i2;
    }

    public void processMix(double[] inputs, double[] outputs, int from, int to, int channels) {
        double o1 = this.o1;
        double o2 = this.o2;
        double i1 = this.i1;
        double i2 = this.i2;
        int i = from;
        while (i < to) {
            double i_value = inputs[i];
            double o_value = this.a1 * i_value + this.a2 * i1 + this.a3 * i2 - this.b1 * o1 - this.b2 * o2;
            int n = i;
            outputs[n] = outputs[n] + o_value;
            i2 = i1;
            i1 = i_value;
            o2 = o1;
            o1 = o_value;
            i += channels;
        }
        this.o1 = o1;
        this.o2 = o2;
        this.i1 = i1;
        this.i2 = i2;
    }
}

