/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.util;

import rasmus.interpreter.sampled.util.FFT;
import rasmus.interpreter.sampled.util.FFTWorker;

public class HarmonicsBooster
extends FFTWorker {
    FFT fft_magn;
    double[] fft_magn_buffer;

    public HarmonicsBooster(int fftFrameSize, int osamp, double sampleRate) {
        super(fftFrameSize, osamp, sampleRate);
        this.fft_magn_buffer = new double[fftFrameSize * 2];
        this.fft_magn = new FFT(fftFrameSize);
    }

    public void processFFT(int index, double[] fftdata) {
        double imag;
        double real;
        int i = 0;
        while (i < this.fftFrameSize) {
            real = fftdata[2 * i];
            imag = fftdata[2 * i + 1];
            this.fft_magn_buffer[2 * i] = Math.sqrt(real * real + imag * imag);
            this.fft_magn_buffer[2 * i + 1] = 0.0;
            ++i;
        }
        this.fft_magn.calc(this.fft_magn_buffer, -1);
        i = 64;
        while (i < 256) {
            this.fft_magn_buffer[2 * i] = this.fft_magn_buffer[2 * i] * 1.5;
            this.fft_magn_buffer[2 * i + 1] = this.fft_magn_buffer[2 * i + 1] * 1.5;
            ++i;
        }
        i = this.fftFrameSize - 256;
        while (i < this.fftFrameSize - 64) {
            this.fft_magn_buffer[2 * i] = this.fft_magn_buffer[2 * i] * 1.5;
            this.fft_magn_buffer[2 * i + 1] = this.fft_magn_buffer[2 * i + 1] * 1.5;
            ++i;
        }
        this.fft_magn.calc(this.fft_magn_buffer, 1);
        i = 0;
        while (i < this.fftFrameSize - 0) {
            real = fftdata[2 * i];
            imag = fftdata[2 * i + 1];
            double magn = Math.sqrt(real * real + imag * imag);
            double target_magn = this.fft_magn_buffer[2 * i] / (double)this.fftFrameSize;
            double diff = target_magn / magn;
            fftdata[2 * i] = real * diff;
            fftdata[2 * i + 1] = imag * diff;
            ++i;
        }
    }
}

