/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.util;

import java.util.Arrays;
import rasmus.interpreter.sampled.util.Allpass;
import rasmus.interpreter.sampled.util.Comb;

public class Freeverb {
    static final float muted = 0.0f;
    static final float fixedgain = 0.03f;
    static final float scalewet = 3.0f;
    static final float scaledry = 2.0f;
    static final float scaledamp = 0.4f;
    static final float scaleroom = 0.28f;
    static final float offsetroom = 0.7f;
    static final float initialroom = 0.5f;
    static final float initialdamp = 0.5f;
    static final float initialwet = 0.33333334f;
    static final float initialdry = 1.0f;
    static final float initialwidth = 1.0f;
    static final float initialmode = 0.0f;
    static final float freezemode = 0.5f;
    float gain;
    float roomsize;
    float roomsize1;
    float damp;
    float damp1;
    float wet;
    float wet1;
    float wet2;
    float dry;
    float width;
    float mode;
    int numcombs;
    Comb[] combL;
    Comb[] combR;
    int numallpasses;
    Allpass[] allpassL;
    Allpass[] allpassR;
    boolean r_isSilent = true;
    double[] input = null;
    double[] outL = null;
    double[] outR = null;

    public boolean isSilent() {
        if (this.r_isSilent) {
            return true;
        }
        int i = 0;
        while (i < this.numcombs) {
            if (!this.combL[i].isSilent()) {
                return false;
            }
            if (!this.combR[i].isSilent()) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.numallpasses) {
            if (!this.allpassL[i].isSilent()) {
                return false;
            }
            if (!this.allpassR[i].isSilent()) {
                return false;
            }
            ++i;
        }
        this.r_isSilent = true;
        return true;
    }

    public Freeverb(double samplerate, double scale) {
        double freqscale = scale * samplerate / 44100.0;
        int stereospread = 23;
        int combtuningL1 = (int)(freqscale * 1116.0);
        int combtuningR1 = (int)(freqscale * (double)(1116 + stereospread));
        int combtuningL2 = (int)(freqscale * 1188.0);
        int combtuningR2 = (int)(freqscale * (double)(1188 + stereospread));
        int combtuningL3 = (int)(freqscale * 1277.0);
        int combtuningR3 = (int)(freqscale * (double)(1277 + stereospread));
        int combtuningL4 = (int)(freqscale * 1356.0);
        int combtuningR4 = (int)(freqscale * (double)(1356 + stereospread));
        int combtuningL5 = (int)(freqscale * 1422.0);
        int combtuningR5 = (int)(freqscale * (double)(1422 + stereospread));
        int combtuningL6 = (int)(freqscale * 1491.0);
        int combtuningR6 = (int)(freqscale * (double)(1491 + stereospread));
        int combtuningL7 = (int)(freqscale * 1557.0);
        int combtuningR7 = (int)(freqscale * (double)(1557 + stereospread));
        int combtuningL8 = (int)(freqscale * 1617.0);
        int combtuningR8 = (int)(freqscale * (double)(1617 + stereospread));
        this.numcombs = 8;
        this.combL = new Comb[this.numcombs];
        this.combR = new Comb[this.numcombs];
        this.combL[0] = new Comb(combtuningL1);
        this.combR[0] = new Comb(combtuningR1);
        this.combL[1] = new Comb(combtuningL2);
        this.combR[1] = new Comb(combtuningR2);
        this.combL[2] = new Comb(combtuningL3);
        this.combR[2] = new Comb(combtuningR3);
        this.combL[3] = new Comb(combtuningL4);
        this.combR[3] = new Comb(combtuningR4);
        this.combL[4] = new Comb(combtuningL5);
        this.combR[4] = new Comb(combtuningR5);
        this.combL[5] = new Comb(combtuningL6);
        this.combR[5] = new Comb(combtuningR6);
        this.combL[6] = new Comb(combtuningL7);
        this.combR[6] = new Comb(combtuningR7);
        this.combL[7] = new Comb(combtuningL8);
        this.combR[7] = new Comb(combtuningR8);
        int allpasstuningL1 = (int)(freqscale * 556.0);
        int allpasstuningR1 = (int)(freqscale * (double)(556 + stereospread));
        int allpasstuningL2 = (int)(freqscale * 441.0);
        int allpasstuningR2 = (int)(freqscale * (double)(441 + stereospread));
        int allpasstuningL3 = (int)(freqscale * 341.0);
        int allpasstuningR3 = (int)(freqscale * (double)(341 + stereospread));
        int allpasstuningL4 = (int)(freqscale * 225.0);
        int allpasstuningR4 = (int)(freqscale * (double)(225 + stereospread));
        this.numallpasses = 4;
        this.allpassL = new Allpass[this.numallpasses];
        this.allpassR = new Allpass[this.numallpasses];
        this.allpassL[0] = new Allpass(allpasstuningL1);
        this.allpassR[0] = new Allpass(allpasstuningR1);
        this.allpassL[1] = new Allpass(allpasstuningL2);
        this.allpassR[1] = new Allpass(allpasstuningR2);
        this.allpassL[2] = new Allpass(allpasstuningL3);
        this.allpassR[2] = new Allpass(allpasstuningR3);
        this.allpassL[3] = new Allpass(allpasstuningL4);
        this.allpassR[3] = new Allpass(allpasstuningR4);
        int i = 0;
        while (i < this.numallpasses) {
            this.allpassL[i].setfeedback(0.5f);
            this.allpassR[i].setfeedback(0.5f);
            ++i;
        }
        this.setwet(0.33333334f);
        this.setroomsize(0.5f);
        this.setdry(1.0f);
        this.setdamp(0.5f);
        this.setwidth(1.0f);
        this.setmode(0.0f);
        this.mute();
    }

    public void processReplace(double[] inputA, double[] output, int from, int to, int channels) {
        block15: {
            int i;
            int ix;
            block14: {
                this.r_isSilent = false;
                int numsamples = (to - from) / channels;
                if (this.input == null || this.input.length < numsamples) {
                    this.input = new double[numsamples];
                    this.outL = new double[numsamples];
                    this.outR = new double[numsamples];
                }
                double again = this.gain / (float)channels;
                ix = 0;
                i = from;
                while (i < to) {
                    this.input[ix] = inputA[i] * again;
                    ++ix;
                    i += channels;
                }
                int c = 1;
                while (c < channels) {
                    ix = 0;
                    int i2 = from + c;
                    while (i2 < to) {
                        int n = ix++;
                        this.input[n] = this.input[n] + inputA[i2] * again;
                        i2 += channels;
                    }
                    ++c;
                }
                Arrays.fill(this.outL, 0.0);
                Arrays.fill(this.outR, 0.0);
                i = 0;
                while (i < this.numcombs) {
                    this.combL[i].processMix(this.input, this.outL, 0, numsamples, 1);
                    this.combR[i].processMix(this.input, this.outR, 0, numsamples, 1);
                    ++i;
                }
                i = 0;
                while (i < this.numallpasses) {
                    this.allpassL[i].processReplace(this.outL, this.outL, 0, numsamples, 1);
                    this.allpassR[i].processReplace(this.outR, this.outR, 0, numsamples, 1);
                    ++i;
                }
                if (channels != 2) break block14;
                ix = 0;
                if (this.dry == 0.0f) {
                    i = from;
                    while (i < to) {
                        output[i] = this.outL[ix] * (double)this.wet1 + this.outR[ix] * (double)this.wet2;
                        output[i + 1] = this.outR[ix] * (double)this.wet1 + this.outL[ix] * (double)this.wet2;
                        ++ix;
                        i += channels;
                    }
                } else {
                    i = from;
                    while (i < to) {
                        output[i] = this.outL[ix] * (double)this.wet1 + this.outR[ix] * (double)this.wet2 + inputA[i] * (double)this.dry;
                        output[i + 1] = this.outR[ix] * (double)this.wet1 + this.outL[ix] * (double)this.wet2 + inputA[i + 1] * (double)this.dry;
                        ++ix;
                        i += channels;
                    }
                }
                break block15;
            }
            if (channels != 1) break block15;
            if (this.dry == 0.0f) {
                ix = 0;
                i = from;
                while (i < to) {
                    output[i] = this.outL[ix] * (double)this.wet1 + this.outR[ix] * (double)this.wet2;
                    ++ix;
                    ++i;
                }
            } else {
                ix = 0;
                i = from;
                while (i < to) {
                    output[i] = this.outL[ix] * (double)this.wet1 + this.outR[ix] * (double)this.wet2 + inputA[ix] * (double)this.dry;
                    ++ix;
                    ++i;
                }
            }
        }
    }

    public void mute() {
        if (this.getmode() >= 0.5f) {
            return;
        }
        int i = 0;
        while (i < this.numcombs) {
            this.combL[i].mute();
            this.combR[i].mute();
            ++i;
        }
        i = 0;
        while (i < this.numallpasses) {
            this.allpassL[i].mute();
            this.allpassR[i].mute();
            ++i;
        }
    }

    private void update() {
        this.wet1 = this.wet * (this.width / 2.0f + 0.5f);
        this.wet2 = this.wet * ((1.0f - this.width) / 2.0f);
        if (this.mode >= 0.5f) {
            this.roomsize1 = 1.0f;
            this.damp1 = 0.0f;
            this.gain = 0.0f;
        } else {
            this.roomsize1 = this.roomsize;
            this.damp1 = this.damp;
            this.gain = 0.03f;
        }
        int i = 0;
        while (i < this.numcombs) {
            this.combL[i].setfeedback(this.roomsize1);
            this.combR[i].setfeedback(this.roomsize1);
            ++i;
        }
        i = 0;
        while (i < this.numcombs) {
            this.combL[i].setdamp(this.damp1);
            this.combR[i].setdamp(this.damp1);
            ++i;
        }
    }

    public void setroomsize(float value) {
        this.roomsize = value * 0.28f + 0.7f;
        this.update();
    }

    public float getroomsize() {
        return (this.roomsize - 0.7f) / 0.28f;
    }

    public void setdamp(float value) {
        this.damp = value * 0.4f;
        this.update();
    }

    public float getdamp() {
        return this.damp / 0.4f;
    }

    public void setwet(float value) {
        this.wet = value * 3.0f;
        this.update();
    }

    public float getwet() {
        return this.wet / 3.0f;
    }

    public void setdry(float value) {
        this.dry = value * 2.0f;
    }

    public float getdry() {
        return this.dry / 2.0f;
    }

    public void setwidth(float value) {
        this.width = value;
        this.update();
    }

    public float getwidth() {
        return this.width;
    }

    public void setmode(float value) {
        this.mode = value;
        this.update();
    }

    public float getmode() {
        if (this.mode >= 0.5f) {
            return 1.0f;
        }
        return 0.0f;
    }
}

