/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.util;

import java.util.Arrays;
import rasmus.interpreter.sampled.util.FFTWorker;

public class FormatMapping
extends FFTWorker {
    int binsperformants = (int)(250.0 / this.freqPerBin);
    double[] formatbuffer = null;
    double[] magnmap = null;

    public FormatMapping(int fftFrameSize, int osamp, double sampleRate) {
        super(fftFrameSize, osamp, sampleRate);
        if (this.binsperformants <= 0) {
            this.binsperformants = 1;
        }
        this.magnmap = new double[this.fftFrameSize2];
    }

    public void processFormatScan(double[] magnmap, double[] outdata) {
        int runner_len = this.binsperformants;
        if (this.formatbuffer == null) {
            this.formatbuffer = new double[runner_len];
        }
        double[] formatbuffer = this.formatbuffer;
        Arrays.fill(formatbuffer, 0.0);
        int runner = 0;
        double totalsum = 0.0;
        int i = 0;
        while (i < this.fftFrameSize2) {
            double m = magnmap[i];
            totalsum -= formatbuffer[runner];
            formatbuffer[runner] = m;
            ++runner;
            runner %= runner_len;
            outdata[i] = (totalsum += m) / (double)runner_len;
            ++i;
        }
    }

    public void processFFT(int index, double[] fftdata) {
        Arrays.fill(fftdata, this.fftFrameSize, 2 * this.fftFrameSize, 0.0);
        int ii = 0;
        while (ii < this.fftFrameSize2) {
            double real = fftdata[2 * ii];
            double imag = fftdata[2 * ii + 1];
            this.magnmap[ii] = Math.sqrt(real * real + imag * imag);
            ++ii;
        }
        this.processFormatScan(this.magnmap, this.magnmap);
        int fftFrameSize2_1 = this.fftFrameSize2 - 1;
        int x = 0;
        while (x < this.fftFrameSize2) {
            double xn = (double)x / (double)this.fftFrameSize2;
            double yn = xn / 2.0;
            double y = yn * (double)this.fftFrameSize2;
            int yi = (int)y;
            double magn1 = this.magnmap[x];
            if (magn1 > 0.0) {
                if (yi < fftFrameSize2_1 && yi >= 0) {
                    double yj = y - (double)yi;
                    double magn2 = this.magnmap[yi] * (1.0 - yj) + this.magnmap[yi + 1] * yj;
                    magn1 = magn2 / magn1;
                    fftdata[2 * x] = fftdata[2 * x] * magn1;
                    fftdata[2 * x + 1] = fftdata[2 * x + 1] * magn1;
                } else {
                    fftdata[2 * x] = 0.0;
                    fftdata[2 * x + 1] = 0.0;
                }
            }
            ++x;
        }
    }
}

