/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.util;

import java.util.Arrays;
import rasmus.interpreter.sampled.util.FFT;

public class FFTWorker {
    FFT fft;
    int fftFrameSize;
    int fftFrameSize2;
    int osamp;
    int stepSize;
    double sampleRate;
    double freqPerBin;
    double[] window_table;
    double[] gFFTworksp;
    double[] gOutputAccum;
    double[] gInFIFO;
    double[] gOutFIFO;
    int gRover = -1;
    int inFifoLatency;

    public FFTWorker(int fftFrameSize, int osamp, double sampleRate) {
        this.fft = new FFT(fftFrameSize);
        this.fftFrameSize = fftFrameSize;
        this.stepSize = fftFrameSize / osamp;
        this.sampleRate = sampleRate;
        this.freqPerBin = sampleRate / (double)fftFrameSize;
        this.osamp = osamp;
        this.window_table = this.fft.wHanning();
        this.inFifoLatency = fftFrameSize - this.stepSize;
        this.fftFrameSize2 = fftFrameSize / 2;
        this.gFFTworksp = new double[fftFrameSize];
        this.gOutputAccum = new double[fftFrameSize * 2];
        this.gInFIFO = new double[fftFrameSize];
        this.gOutFIFO = new double[fftFrameSize];
        Arrays.fill(this.gInFIFO, 0.0);
        Arrays.fill(this.gOutFIFO, 0.0);
        Arrays.fill(this.gOutputAccum, 0.0);
    }

    public void processFFT(int index, double[] fftdata) {
    }

    public void process(int start, int end, int interlace, double[] indata, double[] outdata) {
        if (this.gRover == -1) {
            this.gRover = this.inFifoLatency;
        }
        double[] gInFIFO = this.gInFIFO;
        double[] gOutFIFO = this.gOutFIFO;
        double[] gOutputAccum = this.gOutputAccum;
        double[] window_table = this.window_table;
        double[] gFFTworksp = this.gFFTworksp;
        int i = start;
        while (i < end) {
            gInFIFO[this.gRover] = indata[i];
            outdata[i] = gOutFIFO[this.gRover - this.inFifoLatency];
            ++this.gRover;
            if (this.gRover >= this.fftFrameSize) {
                double window;
                this.gRover = this.inFifoLatency;
                int k = 0;
                while (k < this.fftFrameSize) {
                    window = window_table[k];
                    gFFTworksp[k] = gInFIFO[k] * window;
                    ++k;
                }
                this.fft.calcReal(gFFTworksp, -1);
                this.processFFT(i, gFFTworksp);
                this.fft.calcReal(gFFTworksp, 1);
                k = 0;
                while (k < this.fftFrameSize) {
                    window = window_table[k];
                    int n = k;
                    gOutputAccum[n] = gOutputAccum[n] + 2.0 * window * gFFTworksp[k] / (double)(this.fftFrameSize2 * this.osamp);
                    ++k;
                }
                k = 0;
                while (k < this.stepSize) {
                    gOutFIFO[k] = gOutputAccum[k];
                    ++k;
                }
                int shift_len = gOutputAccum.length / 2;
                int j = 0;
                while (j < shift_len) {
                    gOutputAccum[j] = gOutputAccum[j + this.stepSize];
                    ++j;
                }
                k = 0;
                while (k < this.inFifoLatency) {
                    gInFIFO[k] = gInFIFO[k + this.stepSize];
                    ++k;
                }
            }
            i += interlace;
        }
    }
}

