/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.util;

import rasmus.fft.FFTTransformer;

public final class FFT {
    final int fftFrameSize;
    FFTTransformer fft_forward = null;
    FFTTransformer fft_backward = null;
    FFTTransformer fft_realtocomplex = null;
    FFTTransformer fft_complextoreal = null;

    public double[] wHanning() {
        return rasmus.fft.FFT.wHanning(this.fftFrameSize);
    }

    public FFT(int fftFrameSize) {
        this.fftFrameSize = fftFrameSize;
    }

    public final void calc(double[] data, int sign) {
        if (sign == -1) {
            if (this.fft_forward == null) {
                this.fft_forward = rasmus.fft.FFT.getTransformer(this.fftFrameSize, -1, true);
            }
            this.fft_forward.transform(data);
        } else {
            if (this.fft_backward == null) {
                this.fft_backward = rasmus.fft.FFT.getTransformer(this.fftFrameSize, 1, true);
            }
            this.fft_backward.transform(data);
        }
    }

    public final void calcReal(double[] data, int sign) {
        if (sign == -1) {
            if (this.fft_realtocomplex == null) {
                this.fft_realtocomplex = rasmus.fft.FFT.getTransformer(this.fftFrameSize, -2, true);
            }
            this.fft_realtocomplex.transform(data);
        } else {
            if (this.fft_complextoreal == null) {
                this.fft_complextoreal = rasmus.fft.FFT.getTransformer(this.fftFrameSize, 2, true);
            }
            this.fft_complextoreal.transform(data);
        }
    }
}

