/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import rasmus.interpreter.sampled.AudioStream;

public class DoubleByteStream
extends InputStream {
    AudioStream stream;
    ByteOrder order;
    double[] buffer = null;
    DoubleBuffer dbuffer = null;
    ByteBuffer bbuffer = null;

    public DoubleByteStream(AudioStream stream, ByteOrder order) {
        this.stream = stream;
        this.order = order;
    }

    public void close() throws IOException {
        this.stream.close();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int ret;
        int dlen = len / 8;
        if (this.buffer == null || this.buffer.length < len) {
            this.buffer = new double[dlen];
            this.bbuffer = ByteBuffer.allocate(len).order(this.order);
            this.dbuffer = this.bbuffer.asDoubleBuffer();
        }
        if ((ret = this.stream.replace(this.buffer, 0, dlen)) == -1) {
            return -1;
        }
        this.dbuffer.position(0);
        this.dbuffer.put(this.buffer);
        this.bbuffer.position(0);
        this.bbuffer.get(b, off, len);
        return ret * 8;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public long skip(long n) throws IOException {
        long ret = this.stream.skip((int)(n / 4L));
        if (ret == -1L) {
            return -1L;
        }
        return ret * 4L;
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        int ret = this.read(b);
        if (ret == -1) {
            return -1;
        }
        return b[0];
    }
}

