/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.util;

import rasmus.interpreter.sampled.util.FFTWorker;

public class DeReverb
extends FFTWorker {
    double[] lastmagn_table;
    double[] lastmagn_table_diff;
    int runner = 0;
    double[][] lastmagn_table_runsum;
    double[] lastmagn_table_runsum_total;
    public double attack = 0.1;
    public double release = 0.8;
    public double feedback = 0.9;
    public double amount = 1.0;
    public double thresold = 1.5;

    public DeReverb(int fftFrameSize, int osamp, double sampleRate, int sumsmooth) {
        super(fftFrameSize, osamp, sampleRate);
        this.lastmagn_table_runsum = new double[this.fftFrameSize2][sumsmooth];
        this.lastmagn_table_runsum_total = new double[this.fftFrameSize2];
        this.lastmagn_table = new double[this.fftFrameSize2];
        this.lastmagn_table_diff = new double[this.fftFrameSize2];
    }

    public void processFFT(int index, double[] fftdata) {
        double attack = this.attack;
        double release = this.release;
        double feedback = this.feedback;
        double amount = this.amount;
        amount *= 1.0 - feedback;
        double thresold = this.thresold;
        int runnerlen = this.lastmagn_table_runsum[0].length;
        if (runnerlen > 1) {
            ++this.runner;
            if (this.runner == runnerlen) {
                this.runner = 0;
            }
            int j = 0;
            int i = 0;
            while (i < this.fftFrameSize2) {
                int a = j++;
                int b = j++;
                double real = fftdata[a];
                double imag = fftdata[b];
                double magn = real * real + imag * imag;
                double total = this.lastmagn_table_runsum_total[i];
                double lastmagn = this.lastmagn_table_runsum[i][this.runner];
                this.lastmagn_table_runsum[i][this.runner] = magn;
                this.lastmagn_table_runsum_total[i] = total += magn - lastmagn;
                magn = Math.sqrt(total / (double)runnerlen);
                double l_magn = this.lastmagn_table[i];
                if (l_magn < 1.0E-8) {
                    l_magn = 0.0;
                }
                this.lastmagn_table[i] = magn + l_magn * feedback;
                double newmagn = magn - l_magn * amount;
                if (newmagn < 0.0) {
                    newmagn = 0.0;
                }
                if (magn != 0.0) {
                    double diff = 2.0 * newmagn / magn;
                    double ldiff = this.lastmagn_table_diff[i];
                    double smooth = diff - ldiff > thresold ? attack : release;
                    this.lastmagn_table_diff[i] = diff = diff * (1.0 - smooth) + smooth * ldiff;
                    fftdata[a] = real * diff;
                    fftdata[b] = imag * diff;
                }
                ++i;
            }
        } else {
            int j = 0;
            int i = 0;
            while (i < this.fftFrameSize2) {
                int a = j++;
                int b = j++;
                double real = fftdata[a];
                double imag = fftdata[b];
                double magn = Math.sqrt(real * real + imag * imag);
                double l_magn = this.lastmagn_table[i];
                if (l_magn < 1.0E-8) {
                    l_magn = 0.0;
                }
                this.lastmagn_table[i] = magn + l_magn * feedback;
                double newmagn = magn - l_magn * amount;
                if (newmagn < 0.0) {
                    newmagn = 0.0;
                }
                if (magn != 0.0) {
                    double diff = 2.0 * newmagn / magn;
                    double ldiff = this.lastmagn_table_diff[i];
                    double smooth = diff - ldiff > thresold ? attack : release;
                    this.lastmagn_table_diff[i] = diff = diff * (1.0 - smooth) + smooth * ldiff;
                    fftdata[a] = real * diff;
                    fftdata[b] = imag * diff;
                }
                ++i;
            }
        }
    }
}

