/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.util;

import rasmus.interpreter.sampled.util.FFTWorker;

public class DeHiss
extends FFTWorker {
    double[] lastmagn_table;
    double[] lastmagn_table_diff;
    int runner = 0;
    int runner_len = 0;
    double[][] lastmagn_table_runsum;
    double[] lastmagn_table_runsum_total;
    double[][] lastmagn_table_runsum2;
    double[] lastmagn_table_runsum2_total;
    public double floor = 0.1;
    public double width = 1.001;
    public double reduce = 0.001;

    public DeHiss(int fftFrameSize, int osamp, double sampleRate, int sumsmooth) {
        super(fftFrameSize, osamp, sampleRate);
        this.runner_len = sumsmooth;
        this.lastmagn_table_runsum = new double[sumsmooth][this.fftFrameSize2];
        this.lastmagn_table_runsum_total = new double[this.fftFrameSize2];
        this.lastmagn_table_runsum2 = new double[sumsmooth][this.fftFrameSize2];
        this.lastmagn_table_runsum2_total = new double[this.fftFrameSize2];
        this.lastmagn_table = new double[this.fftFrameSize2];
        this.lastmagn_table_diff = new double[this.fftFrameSize2];
    }

    public void processFFT(int index, double[] fftdata) {
        double floor = this.floor;
        double floorb = this.width == 0.0 ? floor : this.floor / this.width;
        double floorw = floor - floorb;
        double reduce = this.reduce;
        int runner = this.runner;
        int runner_len = this.runner_len;
        double[] lastmagn_table_runsum = this.lastmagn_table_runsum[runner];
        double[] lastmagn_table_runsum_total = this.lastmagn_table_runsum_total;
        double[] lastmagn_table_runsum2 = this.lastmagn_table_runsum2[runner];
        double[] lastmagn_table_runsum2_total = this.lastmagn_table_runsum2_total;
        int j = 0;
        int i = 0;
        while (i < this.fftFrameSize2) {
            double targetgain;
            int a = j++;
            int b = j++;
            double real = fftdata[a];
            double imag = fftdata[b];
            double magn = real * real + imag * imag;
            double n = lastmagn_table_runsum[i];
            int n2 = i;
            lastmagn_table_runsum_total[n2] = lastmagn_table_runsum_total[n2] - n;
            int n3 = i;
            lastmagn_table_runsum_total[n3] = lastmagn_table_runsum_total[n3] + magn;
            lastmagn_table_runsum[i] = magn;
            double avgmagn = Math.sqrt(lastmagn_table_runsum_total[i] / (double)runner_len);
            if (avgmagn < floor) {
                if (avgmagn > floorb) {
                    double d = (avgmagn - floorb) / floorw;
                    targetgain = reduce * (1.0 - d) + d;
                } else {
                    targetgain = reduce;
                }
            } else {
                targetgain = 1.0;
            }
            n = lastmagn_table_runsum2[i];
            int n4 = i;
            lastmagn_table_runsum2_total[n4] = lastmagn_table_runsum2_total[n4] - n;
            int n5 = i;
            lastmagn_table_runsum2_total[n5] = lastmagn_table_runsum2_total[n5] + targetgain;
            lastmagn_table_runsum2[i] = targetgain;
            double avggain = Math.sqrt(lastmagn_table_runsum2_total[i] / (double)runner_len);
            fftdata[a] = real * avggain;
            fftdata[b] = imag * avggain;
            ++i;
        }
        this.runner = (runner + 1) % runner_len;
    }
}

