/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.util;

import java.util.Arrays;

public class Comb {
    float feedback;
    double filterstore = 0.0;
    float damp1;
    float damp2;
    double[] buffer;
    int bufsize;
    int bufidx = 0;

    public Comb(int size) {
        this.buffer = new double[size];
        this.bufsize = size;
    }

    public boolean isSilent() {
        int i = 0;
        while (i < this.buffer.length) {
            if (this.buffer[i] != 0.0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void processMix(double[] inputs, double[] outputs, int from, int to, int channels) {
        int c = 0;
        while (c < channels) {
            int i = from + c;
            while (i < to) {
                double output = this.buffer[this.bufidx];
                if (output > 0.0 && output < 1.0E-10) {
                    output = 0.0;
                }
                if (output < 0.0 && output > -1.0E-10) {
                    output = 0.0;
                }
                this.filterstore = output * (double)this.damp2 + this.filterstore * (double)this.damp1;
                if (this.filterstore > 0.0 && this.filterstore < 1.0E-10) {
                    this.filterstore = 0.0;
                }
                if (this.filterstore < 0.0 && this.filterstore > -1.0E-10) {
                    this.filterstore = 0.0;
                }
                this.buffer[this.bufidx] = inputs[i] + this.filterstore * (double)this.feedback;
                if (++this.bufidx >= this.bufsize) {
                    this.bufidx = 0;
                }
                int n = i;
                outputs[n] = outputs[n] + output;
                i += channels;
            }
            ++c;
        }
    }

    public void processReplace(double[] inputs, double[] outputs, int from, int to, int channels) {
        int c = 0;
        while (c < channels) {
            int i = from + c;
            while (i < to) {
                double output = this.buffer[this.bufidx];
                if (output > 0.0 && output < 1.0E-10) {
                    output = 0.0;
                }
                if (output < 0.0 && output > -1.0E-10) {
                    output = 0.0;
                }
                this.filterstore = output * (double)this.damp2 + this.filterstore * (double)this.damp1;
                if (this.filterstore > 0.0 && this.filterstore < 1.0E-10) {
                    this.filterstore = 0.0;
                }
                if (this.filterstore < 0.0 && this.filterstore > -1.0E-10) {
                    this.filterstore = 0.0;
                }
                this.buffer[this.bufidx] = inputs[i] + this.filterstore * (double)this.feedback;
                if (++this.bufidx >= this.bufsize) {
                    this.bufidx = 0;
                }
                outputs[i] = output;
                i += channels;
            }
            ++c;
        }
    }

    public void setbuffer(double[] buf, int size) {
        this.buffer = buf;
        this.bufsize = size;
    }

    public void mute() {
        Arrays.fill(this.buffer, 0.0);
    }

    public void setdamp(float val) {
        this.damp1 = val;
        this.damp2 = 1.0f - val;
    }

    public float getdamp() {
        return this.damp1;
    }

    public void setfeedback(float val) {
        this.feedback = val;
    }

    public float getfeedback() {
        return this.feedback;
    }
}

