/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.util;

import java.util.Arrays;

public class Allpass {
    float feedback;
    double[] buffer;
    int bufsize;
    int bufidx = 0;

    public boolean isSilent() {
        int i = 0;
        while (i < this.buffer.length) {
            if (this.buffer[i] != 0.0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Allpass(int size) {
        this.buffer = new double[size];
        this.bufsize = size;
    }

    public void setbuffer(double[] buf, int size) {
        this.buffer = buf;
        this.bufsize = size;
    }

    public void mute() {
        Arrays.fill(this.buffer, 0.0);
    }

    public void setfeedback(float value) {
        this.feedback = value;
    }

    public float getfeedback() {
        return this.feedback;
    }

    public void processReplace(double[] inputs, double[] outputs, int from, int to, int channels) {
        int c = 0;
        while (c < channels) {
            int i = from;
            while (i < to) {
                double bufout = this.buffer[this.bufidx];
                if (bufout > 0.0 && bufout < 1.0E-10) {
                    bufout = 0.0;
                }
                if (bufout < 0.0 && bufout > -1.0E-10) {
                    bufout = 0.0;
                }
                double input = inputs[i];
                outputs[i] = -input + bufout;
                this.buffer[this.bufidx] = input + bufout * (double)this.feedback;
                if (++this.bufidx >= this.bufsize) {
                    this.bufidx = 0;
                }
                i += channels;
            }
            ++c;
        }
    }

    public void processMix(double[] inputs, double[] outputs, int from, int to, int channels) {
        int c = 0;
        while (c < channels) {
            int i = from + c;
            while (i < to) {
                double bufout = this.buffer[this.bufidx];
                if (bufout > 0.0 && bufout < 1.0E-10) {
                    bufout = 0.0;
                }
                if (bufout < 0.0 && bufout > -1.0E-10) {
                    bufout = 0.0;
                }
                double input = inputs[i];
                int n = i;
                outputs[n] = outputs[n] + (-input + bufout);
                this.buffer[this.bufidx] = input + bufout * (double)this.feedback;
                if (++this.bufidx >= this.bufsize) {
                    this.bufidx = 0;
                }
                i += channels;
            }
            ++c;
        }
    }
}

