/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.modifiers;

import java.util.Arrays;
import rasmus.interpreter.Variable;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.sampled.AudioCache;
import rasmus.interpreter.sampled.AudioEvent;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.AudioFallBackStream;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;
import rasmus.interpreter.sampled.AudioStreamable;
import rasmus.interpreter.sampled.util.Freeverb;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class AudioReverbInstance
extends UnitInstanceAdapter
implements AudioStreamable {
    public Variable output;
    public Variable input;
    Variable answer = new Variable();
    Variable dry = null;
    Variable wet = null;
    Variable width = null;
    Variable roomsize = null;
    Variable damp = null;
    Variable scale = null;

    public void calc() {
    }

    public AudioReverbInstance(Parameters parameters) {
        this.output = parameters.getParameterWithDefault("output");
        this.input = parameters.getParameterWithDefault("input");
        this.dry = parameters.getParameter(1, "dry");
        this.wet = parameters.getParameter(2, "wet");
        this.width = parameters.getParameter(3, "width");
        this.roomsize = parameters.getParameter(4, "roomsize");
        this.damp = parameters.getParameter(5, "damp");
        this.scale = parameters.getParameter(6, "scale");
        this.answer = AudioEvents.asVariable(new AudioEvent(0.0, this));
        this.output.add(this.answer);
    }

    public void close() {
        this.output.remove(this.answer);
    }

    public AudioStream openStream(AudioSession session) {
        return new FilterStreamInstance(AudioEvents.openStream(this.input, session), session);
    }

    class FilterStreamInstance
    implements AudioStream {
        AudioFallBackStream inputstream;
        Freeverb freeverb;
        int channels;
        AudioCache audiocache;

        public FilterStreamInstance(AudioStream inputstream, AudioSession session) {
            this.audiocache = session.getAudioCache();
            this.channels = session.getChannels();
            float scale = 1.0f;
            if (AudioReverbInstance.this.scale != null) {
                scale = (float)DoublePart.asDouble(AudioReverbInstance.this.scale);
            }
            this.freeverb = new Freeverb(session.getRate(), scale);
            this.freeverb.setdry(0.0f);
            this.freeverb.setroomsize(0.9f);
            this.freeverb.setdamp(0.9f);
            if (AudioReverbInstance.this.dry != null) {
                this.freeverb.setdry((float)DoublePart.asDouble(AudioReverbInstance.this.dry));
            }
            if (AudioReverbInstance.this.wet != null) {
                this.freeverb.setwet((float)DoublePart.asDouble(AudioReverbInstance.this.wet));
            }
            if (AudioReverbInstance.this.width != null) {
                this.freeverb.setwidth((float)DoublePart.asDouble(AudioReverbInstance.this.width));
            }
            if (AudioReverbInstance.this.roomsize != null) {
                this.freeverb.setroomsize((float)DoublePart.asDouble(AudioReverbInstance.this.roomsize));
            }
            if (AudioReverbInstance.this.damp != null) {
                this.freeverb.setdamp((float)DoublePart.asDouble(AudioReverbInstance.this.damp));
            }
            this.inputstream = new AudioFallBackStream(inputstream);
        }

        public int mix(double[] buffer, int start, int end) {
            double[] stockbuffer = this.audiocache.getBuffer(end);
            int ret = this.replace(stockbuffer, start, end);
            int cret = ret;
            if (cret == -1) {
                cret = 0;
            }
            int i = start;
            while (i < start + cret) {
                int n = i;
                buffer[n] = buffer[n] + stockbuffer[i];
                ++i;
            }
            this.audiocache.returnBuffer(stockbuffer);
            return ret;
        }

        public int skip(int len) {
            int ret = this.inputstream.skip(len);
            return ret;
        }

        public int replace(double[] buffer, int start, int end) {
            int ret = this.inputstream.replace(buffer, start, end);
            int cret = ret;
            if (cret == -1) {
                cret = 0;
            }
            Arrays.fill(buffer, start + cret, end, 0.0);
            this.freeverb.processReplace(buffer, buffer, start, end, this.channels);
            if (ret == -1) {
                int i = start;
                while (i < end) {
                    if (buffer[i] > 1.0E-10) {
                        return end - start;
                    }
                    ++i;
                }
                return -1;
            }
            return end - start;
        }

        public int isStatic(double[] buffer, int len) {
            int ret = this.inputstream.isStatic(buffer, len);
            if (ret != -1) {
                if (this.freeverb.isSilent()) {
                    return ret;
                }
                this.inputstream.fallBack();
            }
            return -1;
        }

        public void close() {
            this.inputstream.close();
        }
    }
}

