/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.modifiers;

import java.util.Arrays;
import rasmus.interpreter.Variable;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.sampled.AudioEvent;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;
import rasmus.interpreter.sampled.AudioStreamable;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class AudioResampleIInstance
extends UnitInstanceAdapter
implements AudioStreamable {
    public Variable output;
    public Variable input;
    Variable answer = new Variable();
    Variable amount;

    public void calc() {
    }

    public AudioResampleIInstance(Parameters parameters) {
        this.output = parameters.getParameterWithDefault("output");
        this.input = parameters.getParameterWithDefault("input");
        this.amount = parameters.getParameterWithDefault(1, "amount");
        this.answer = AudioEvents.asVariable(new AudioEvent(0.0, this));
        this.output.add(this.answer);
    }

    public void close() {
        this.output.remove(this.answer);
    }

    public AudioStream openStream(AudioSession session) {
        return new FilterStreamInstance(session);
    }

    class FilterStreamInstance
    implements AudioStream {
        double f_amount;
        AudioStream inputstream;
        AudioStream finputstream;
        int channels;
        double[] lastvalues;
        double ix;
        double[] stockbuffer;
        double[] freqbuffer;
        boolean finputstream_eof;

        public FilterStreamInstance(AudioSession session) {
            this.f_amount = DoublePart.asDouble(AudioResampleIInstance.this.amount);
            this.ix = 0.0;
            this.stockbuffer = null;
            this.freqbuffer = null;
            this.finputstream_eof = false;
            this.channels = session.getChannels();
            this.lastvalues = new double[this.channels];
            this.inputstream = AudioEvents.openStream(AudioResampleIInstance.this.input, session.newSession());
            this.finputstream = AudioEvents.openStream(AudioResampleIInstance.this.amount, session);
        }

        public int mix(double[] buffer, int start, int end) {
            if (this.freqbuffer == null) {
                this.freqbuffer = new double[buffer.length / this.channels];
            } else if (this.freqbuffer.length * this.channels < buffer.length) {
                this.freqbuffer = new double[buffer.length / this.channels];
                if (this.finputstream_eof) {
                    Arrays.fill(this.freqbuffer, this.f_amount);
                }
            }
            int cend = end / this.channels;
            int cstart = start / this.channels;
            if (!this.finputstream_eof) {
                int ret2 = this.finputstream.replace(this.freqbuffer, cstart, cend);
                if (ret2 == -1) {
                    Arrays.fill(this.freqbuffer, this.f_amount);
                    this.finputstream_eof = true;
                } else {
                    int cendret = cstart + ret2;
                    int i = cstart;
                    while (i < cendret) {
                        this.freqbuffer[i] = this.freqbuffer[i];
                        ++i;
                    }
                    Arrays.fill(this.freqbuffer, cstart + ret2, cend, this.f_amount);
                }
            }
            int skorun = 2;
            int sbuffsize = 2048;
            int xloopbuffsize = sbuffsize - skorun;
            int loopbuffsize = xloopbuffsize * this.channels;
            int ret = 0;
            if (this.stockbuffer == null) {
                this.stockbuffer = new double[sbuffsize * this.channels];
                ret = this.inputstream.replace(this.stockbuffer, 0, sbuffsize * this.channels);
                if (ret == -1) {
                    Arrays.fill(this.stockbuffer, this.channels, sbuffsize * this.channels, 0.0);
                } else {
                    Arrays.fill(this.stockbuffer, ret, sbuffsize * this.channels, 0.0);
                }
            }
            int ixx = 0;
            int i = start;
            while (i < end) {
                int j = (int)this.ix * this.channels;
                double interp = this.ix % 1.0;
                int c = 0;
                while (c < this.channels) {
                    int n = i + c;
                    buffer[n] = buffer[n] + (this.stockbuffer[j] * (1.0 - interp) + this.stockbuffer[j + this.channels] * interp);
                    ++j;
                    ++c;
                }
                if (this.freqbuffer[ixx] > 0.0) {
                    this.ix += this.freqbuffer[ixx];
                }
                ++ixx;
                if (this.ix > (double)xloopbuffsize) {
                    this.ix -= (double)xloopbuffsize;
                    c = 0;
                    while (c < skorun * this.channels) {
                        this.stockbuffer[c] = this.stockbuffer[loopbuffsize + c];
                        ++c;
                    }
                    ret = this.inputstream.replace(this.stockbuffer, this.channels * skorun, sbuffsize * this.channels);
                    if (ret == -1) {
                        Arrays.fill(this.stockbuffer, this.channels * skorun, 2048 * this.channels, 0.0);
                    } else {
                        Arrays.fill(this.stockbuffer, this.channels * skorun + ret, 2048 * this.channels, 0.0);
                    }
                }
                i += this.channels;
            }
            if (ret == -1) {
                return -1;
            }
            return end - start;
        }

        public int replace(double[] buffer, int start, int end) {
            Arrays.fill(buffer, start, end, 0.0);
            return this.mix(buffer, start, end);
        }

        public int isStatic(double[] buffer, int len) {
            return -1;
        }

        public int skip(int len) {
            return this.mix(new double[len], 0, len);
        }

        public void close() {
            this.inputstream.close();
            this.finputstream.close();
        }
    }
}

