/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.modifiers;

import java.util.Arrays;
import rasmus.interpreter.Variable;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.sampled.AudioEvent;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;
import rasmus.interpreter.sampled.AudioStreamable;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class AudioResampleHInstance
extends UnitInstanceAdapter
implements AudioStreamable {
    public Variable output;
    public Variable input;
    public Variable bias;
    public Variable tension;
    Variable answer = new Variable();
    Variable amount;

    public void calc() {
    }

    public AudioResampleHInstance(Parameters parameters) {
        this.output = parameters.getParameterWithDefault("output");
        this.input = parameters.getParameterWithDefault("input");
        this.amount = parameters.getParameterWithDefault(1, "amount");
        this.bias = parameters.getParameterWithDefault(2, "bias");
        this.tension = parameters.getParameterWithDefault(3, "tension");
        this.answer = AudioEvents.asVariable(new AudioEvent(0.0, this));
        this.output.add(this.answer);
    }

    public void close() {
        this.output.remove(this.answer);
    }

    public AudioStream openStream(AudioSession session) {
        return new FilterStreamInstance(session);
    }

    class FilterStreamInstance
    implements AudioStream {
        double f_amount;
        AudioStream inputstream;
        AudioStream finputstream;
        int channels;
        double[] lastvalues;
        double ix;
        double[] stockbuffer;
        double[] freqbuffer;
        boolean finputstream_eof;

        public FilterStreamInstance(AudioSession session) {
            this.f_amount = DoublePart.asDouble(AudioResampleHInstance.this.amount);
            this.ix = 0.0;
            this.stockbuffer = null;
            this.freqbuffer = null;
            this.finputstream_eof = false;
            this.channels = session.getChannels();
            this.lastvalues = new double[this.channels];
            this.inputstream = AudioEvents.openStream(AudioResampleHInstance.this.input, session.newSession());
            this.finputstream = AudioEvents.openStream(AudioResampleHInstance.this.amount, session);
        }

        public int mix(double[] buffer, int start, int end) {
            if (this.freqbuffer == null) {
                this.freqbuffer = new double[buffer.length / this.channels];
            } else if (this.freqbuffer.length * this.channels < buffer.length) {
                this.freqbuffer = new double[buffer.length / this.channels];
                if (this.finputstream_eof) {
                    Arrays.fill(this.freqbuffer, this.f_amount);
                }
            }
            int cend = end / this.channels;
            int cstart = start / this.channels;
            if (!this.finputstream_eof) {
                int ret2 = this.finputstream.replace(this.freqbuffer, cstart, cend);
                if (ret2 == -1) {
                    Arrays.fill(this.freqbuffer, this.f_amount);
                    this.finputstream_eof = true;
                } else {
                    int cendret = cstart + ret2;
                    int i = cstart;
                    while (i < cendret) {
                        this.freqbuffer[i] = this.freqbuffer[i];
                        ++i;
                    }
                    Arrays.fill(this.freqbuffer, cstart + ret2, cend, this.f_amount);
                }
            }
            int skorun = 4;
            int sbuffsize = 2048;
            int xloopbuffsize = sbuffsize - skorun;
            int loopbuffsize = xloopbuffsize * this.channels;
            int ret = 0;
            if (this.stockbuffer == null) {
                this.stockbuffer = new double[sbuffsize * this.channels];
                ret = this.inputstream.replace(this.stockbuffer, 0, sbuffsize * this.channels);
                if (ret == -1) {
                    Arrays.fill(this.stockbuffer, this.channels, sbuffsize * this.channels, 0.0);
                } else {
                    Arrays.fill(this.stockbuffer, ret, sbuffsize * this.channels, 0.0);
                }
            }
            int channels1 = this.channels * 1;
            int channels2 = this.channels * 2;
            int channels3 = this.channels * 3;
            double bias = DoublePart.asDouble(AudioResampleHInstance.this.bias);
            double tension = DoublePart.asDouble(AudioResampleHInstance.this.tension);
            int ixx = 0;
            int i = start;
            while (i < end) {
                int j = (int)this.ix * this.channels;
                double interp = this.ix % 1.0;
                double interp2 = interp * interp;
                double interp3 = interp2 * interp;
                int c = 0;
                while (c < this.channels) {
                    double y0 = this.stockbuffer[j];
                    double y1 = this.stockbuffer[j + channels1];
                    double y2 = this.stockbuffer[j + channels2];
                    double y3 = this.stockbuffer[j + channels3];
                    double m0 = (y1 - y0) * (1.0 + bias) * (1.0 - tension) / 2.0 + (y2 - y1) * (1.0 - bias) * (1.0 - tension) / 2.0;
                    double m1 = (y2 - y1) * (1.0 + bias) * (1.0 - tension) / 2.0 + (y3 - y2) * (1.0 - bias) * (1.0 - tension) / 2.0;
                    double a0 = 2.0 * interp3 - 3.0 * interp2 + 1.0;
                    double a1 = interp3 - 2.0 * interp2 + interp;
                    double a2 = interp3 - interp2;
                    double a3 = -2.0 * interp3 + 3.0 * interp2;
                    int n = i + c;
                    buffer[n] = buffer[n] + (a0 * y1 + a1 * m0 + a2 * m1 + a3 * y2);
                    ++j;
                    ++c;
                }
                if (this.freqbuffer[ixx] > 0.0) {
                    this.ix += this.freqbuffer[ixx];
                }
                ++ixx;
                if (this.ix > (double)xloopbuffsize) {
                    this.ix -= (double)xloopbuffsize;
                    c = 0;
                    while (c < skorun * this.channels) {
                        this.stockbuffer[c] = this.stockbuffer[loopbuffsize + c];
                        ++c;
                    }
                    ret = this.inputstream.replace(this.stockbuffer, this.channels * skorun, sbuffsize * this.channels);
                    if (ret == -1) {
                        Arrays.fill(this.stockbuffer, this.channels * skorun, 2048 * this.channels, 0.0);
                    } else {
                        Arrays.fill(this.stockbuffer, this.channels * skorun + ret, 2048 * this.channels, 0.0);
                    }
                }
                i += this.channels;
            }
            if (ret == -1) {
                return -1;
            }
            return end - start;
        }

        public int replace(double[] buffer, int start, int end) {
            Arrays.fill(buffer, start, end, 0.0);
            return this.mix(buffer, start, end);
        }

        public int isStatic(double[] buffer, int len) {
            return -1;
        }

        public int skip(int len) {
            return this.mix(new double[len], 0, len);
        }

        public void close() {
            this.inputstream.close();
            this.finputstream.close();
        }
    }
}

