/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.modifiers;

import java.util.Arrays;
import rasmus.interpreter.Variable;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.sampled.AudioCache;
import rasmus.interpreter.sampled.AudioEvent;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.AudioFallBackStream;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;
import rasmus.interpreter.sampled.AudioStreamable;
import rasmus.interpreter.sampled.util.FFTConvolution;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class AudioFFTConvolutionInstance
extends UnitInstanceAdapter
implements AudioStreamable {
    public Variable output;
    public Variable input;
    public Variable input2;
    Variable answer = new Variable();
    Variable fftFrameSize;
    Variable osamp;

    public void calc() {
    }

    public AudioFFTConvolutionInstance(Parameters parameters) {
        this.output = parameters.getParameterWithDefault("output");
        this.input = parameters.getParameterWithDefault("input");
        this.input2 = parameters.getParameterWithDefault(1, "input2");
        this.fftFrameSize = parameters.getParameterWithDefault(2, "fftFrameSize");
        this.answer = AudioEvents.asVariable(new AudioEvent(0.0, this));
        this.output.add(this.answer);
    }

    public void close() {
        this.output.remove(this.answer);
    }

    public AudioStream openStream(AudioSession session) {
        return new FilterStreamInstance(AudioEvents.openStream(this.input, session), session);
    }

    class FilterStreamInstance
    implements AudioStream {
        AudioFallBackStream inputstream;
        FFTConvolution[] workers;
        int channels;
        AudioCache audiocache;
        AudioSession session;

        public FilterStreamInstance(AudioStream inputstream, AudioSession session) {
            this.session = session;
            this.audiocache = session.getAudioCache();
            this.channels = session.getChannels();
            int i_fftFrameSize = (int)DoublePart.asDouble(AudioFFTConvolutionInstance.this.fftFrameSize);
            if (i_fftFrameSize == 0) {
                i_fftFrameSize = 4096;
            }
            AudioSession audiosession = new AudioSession(session.getRate(), session.getChannels());
            double[] convbuffer = audiosession.asDoubleArray(AudioFFTConvolutionInstance.this.input2);
            int chs = this.channels;
            this.workers = new FFTConvolution[this.channels];
            int i = 0;
            while (i < this.channels) {
                double[] cbuffer = new double[convbuffer.length / this.channels];
                int p = i;
                int j = 0;
                while (j < cbuffer.length) {
                    cbuffer[j] = convbuffer[p];
                    p += chs;
                    ++j;
                }
                this.workers[i] = new FFTConvolution(cbuffer, i_fftFrameSize);
                ++i;
            }
            this.inputstream = new AudioFallBackStream(inputstream);
        }

        public int mix(double[] buffer, int start, int end) {
            double[] stockbuffer = this.audiocache.getBuffer(end);
            int ret = this.replace(stockbuffer, start, end);
            int cret = ret;
            if (cret == -1) {
                cret = 0;
            }
            int i = start;
            while (i < start + cret) {
                int n = i;
                buffer[n] = buffer[n] + stockbuffer[i];
                ++i;
            }
            this.audiocache.returnBuffer(stockbuffer);
            return ret;
        }

        public int skip(int len) {
            int ret = this.inputstream.skip(len);
            return ret;
        }

        public int replace(double[] buffer, int start, int end) {
            int ret = this.inputstream.replace(buffer, start, end);
            if (ret != -1) {
                Arrays.fill(buffer, start + ret, end, 0.0);
            } else {
                Arrays.fill(buffer, start, end, 0.0);
            }
            int i = 0;
            while (i < this.channels) {
                this.workers[i].process(start + i, end, this.channels, buffer, buffer);
                ++i;
            }
            if (ret == -1) {
                i = start;
                while (i < end) {
                    if (buffer[i] > 1.0E-10) {
                        return end - start;
                    }
                    ++i;
                }
                return -1;
            }
            return ret;
        }

        public int isStatic(double[] buffer, int len) {
            return -1;
        }

        public void close() {
            this.inputstream.close();
        }
    }
}

