/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.modifiers;

import java.util.Arrays;
import rasmus.interpreter.Variable;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.sampled.AudioCache;
import rasmus.interpreter.sampled.AudioEvent;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.AudioFallBackStream;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;
import rasmus.interpreter.sampled.AudioStreamable;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class AudioEnvelopeFollowerInstance
extends UnitInstanceAdapter
implements AudioStreamable {
    public static final int PNUM = 6;
    public Variable output;
    Variable answer = new Variable();
    Variable input;
    Variable window;

    public void calc() {
    }

    public AudioEnvelopeFollowerInstance(Parameters parameters) {
        this.output = parameters.getParameterWithDefault("output");
        this.input = parameters.getParameterWithDefault("input");
        this.window = parameters.getParameter(1, "window");
        if (this.window == null) {
            this.window = DoublePart.asVariable(0.01);
        }
        this.answer = AudioEvents.asVariable(new AudioEvent(0.0, this));
        this.output.add(this.answer);
    }

    public void close() {
        this.output.remove(this.answer);
    }

    public AudioStream openStream(AudioSession session) {
        return new FilterStreamInstance(session);
    }

    class FilterStreamInstance
    implements AudioStream {
        AudioFallBackStream input_stream = null;
        boolean both_attack_release = true;
        boolean input_stream_eof = false;
        int channels;
        double rate;
        AudioCache audiocache;
        int windowlen = 0;
        int windowpos = 0;
        double[][] window_runner;
        double[] window_total;
        double window_factor;

        public FilterStreamInstance(AudioSession session) {
            this.audiocache = session.getAudioCache();
            this.channels = session.getChannels();
            this.rate = session.getRate();
            boolean bl = this.input_stream_eof = AudioEvents.getInstance((Variable)AudioEnvelopeFollowerInstance.this.input).track.size() == 0;
            if (!this.input_stream_eof) {
                this.input_stream = new AudioFallBackStream(AudioEvents.openStream(AudioEnvelopeFollowerInstance.this.input, session));
            }
            this.windowlen = (int)(DoublePart.asDouble(AudioEnvelopeFollowerInstance.this.window) * this.rate);
            this.window_runner = new double[this.channels][];
            this.window_total = new double[this.channels];
            int i = 0;
            while (i < this.channels) {
                this.window_runner[i] = new double[this.windowlen];
                this.window_total[i] = 0.0;
                ++i;
            }
            this.window_factor = 1.0 / (double)this.windowlen;
        }

        public int skip(int len) {
            if (this.input_stream_eof) {
                return -1;
            }
            int ret = this.input_stream.skip(len);
            return ret;
        }

        public int mix(double[] buffer, int start, int end) {
            if (this.input_stream_eof) {
                return -1;
            }
            double[] stockbuffer = this.audiocache.getBuffer(end);
            int ret = this.input_stream.replace(stockbuffer, start, end);
            if (ret == -1) {
                this.input_stream_eof = true;
                this.audiocache.returnBuffer(stockbuffer);
                return -1;
            }
            end = start + ret;
            int cend = end / this.channels;
            int cstart = start / this.channels;
            int chs = this.channels;
            int c = 0;
            while (c < chs) {
                int ix = start + c;
                double[] window_runner = this.window_runner[c];
                double window_total = this.window_total[c];
                int windowpos = this.windowpos;
                int i = cstart;
                while (i < cend) {
                    double xn = Math.abs(stockbuffer[ix]);
                    double last = window_runner[windowpos];
                    window_runner[windowpos] = xn;
                    window_total = window_total - last + xn;
                    double window_avg = window_total * this.window_factor;
                    int n = ix;
                    buffer[n] = buffer[n] + window_avg;
                    ix += chs;
                    windowpos = (windowpos + 1) % this.windowlen;
                    ++i;
                }
                this.window_total[c] = window_total;
                ++c;
            }
            this.windowpos += cend - cstart;
            this.windowpos %= this.windowlen;
            this.audiocache.returnBuffer(stockbuffer);
            return ret;
        }

        public int isStatic(double[] buffer, int len) {
            int i = 0;
            while (i < this.channels) {
                if (this.window_total[i] != 0.0) {
                    return -1;
                }
                ++i;
            }
            if (this.input_stream_eof) {
                return -1;
            }
            int ret = this.input_stream.isStatic(buffer, len);
            if (ret == -1) {
                return -1;
            }
            if (buffer[0] != 0.0) {
                this.input_stream.fallBack();
                return -1;
            }
            return len;
        }

        public int replace(double[] buffer, int start, int end) {
            Arrays.fill(buffer, start, end, 0.0);
            return this.mix(buffer, start, end);
        }

        public void close() {
            if (this.input_stream != null) {
                this.input_stream.close();
            }
        }
    }
}

