/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.modifiers;

import java.util.Arrays;
import rasmus.interpreter.Variable;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.sampled.AudioCache;
import rasmus.interpreter.sampled.AudioEvent;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.AudioFallBackStream;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;
import rasmus.interpreter.sampled.AudioStreamable;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class AudioEnvelopeFollower2Instance
extends UnitInstanceAdapter
implements AudioStreamable {
    public static final int PNUM = 6;
    public Variable output;
    Variable answer = new Variable();
    Variable input;
    Variable attack;
    Variable release;

    public void calc() {
    }

    public AudioEnvelopeFollower2Instance(Parameters parameters) {
        this.output = parameters.getParameterWithDefault("output");
        this.input = parameters.getParameterWithDefault("input");
        this.attack = parameters.getParameter(1, "attack");
        this.release = parameters.getParameter(2, "release");
        if (this.attack == null) {
            this.attack = DoublePart.asVariable(0.01);
        }
        this.answer = AudioEvents.asVariable(new AudioEvent(0.0, this));
        this.output.add(this.answer);
    }

    public void close() {
        this.output.remove(this.answer);
    }

    public AudioStream openStream(AudioSession session) {
        return new FilterStreamInstance(session);
    }

    class FilterStreamInstance
    implements AudioStream {
        AudioFallBackStream input_stream = null;
        boolean both_attack_release = false;
        double f_attack = 0.0;
        double f_release = 0.0;
        boolean input_stream_eof = false;
        boolean a_attack_eof = false;
        boolean a_release_eof = false;
        AudioStream a_attack = null;
        AudioStream a_release = null;
        int channels;
        double rate;
        AudioCache audiocache;
        double[] xn_1;

        public FilterStreamInstance(AudioSession session) {
            this.audiocache = session.getAudioCache();
            this.channels = session.getChannels();
            this.rate = session.getRate();
            this.xn_1 = new double[this.channels];
            Arrays.fill(this.xn_1, 0.0);
            boolean bl = this.input_stream_eof = AudioEvents.getInstance((Variable)AudioEnvelopeFollower2Instance.this.input).track.size() == 0;
            if (!this.input_stream_eof) {
                this.input_stream = new AudioFallBackStream(AudioEvents.openStream(AudioEnvelopeFollower2Instance.this.input, session));
            }
            AudioSession monosession = session.getMonoSession();
            this.f_attack = DoublePart.asDouble(AudioEnvelopeFollower2Instance.this.attack);
            this.a_attack_eof = AudioEvents.getInstance((Variable)AudioEnvelopeFollower2Instance.this.attack).track.size() == 0;
            this.a_attack = !this.a_attack_eof ? AudioEvents.openStream(AudioEnvelopeFollower2Instance.this.attack, monosession) : null;
            if (AudioEnvelopeFollower2Instance.this.release != null) {
                this.both_attack_release = true;
                this.f_release = DoublePart.asDouble(AudioEnvelopeFollower2Instance.this.release);
                this.a_release_eof = AudioEvents.getInstance((Variable)AudioEnvelopeFollower2Instance.this.release).track.size() == 0;
                this.a_release = !this.a_release_eof ? AudioEvents.openStream(AudioEnvelopeFollower2Instance.this.release, monosession) : null;
            }
        }

        public int skip(int len) {
            int aret;
            if (this.input_stream_eof) {
                return -1;
            }
            int ret = this.input_stream.skip(len);
            int clen = len / this.channels;
            if (!this.a_attack_eof && (aret = this.a_attack.skip(clen)) == -1) {
                this.a_attack_eof = true;
            }
            if (this.both_attack_release && !this.a_release_eof && (aret = this.a_release.skip(clen)) == -1) {
                this.a_release_eof = true;
            }
            return ret;
        }

        public int mix(double[] buffer, int start, int end) {
            int aret;
            if (this.input_stream_eof) {
                return -1;
            }
            double[] stockbuffer = this.audiocache.getBuffer(end);
            int ret = this.input_stream.replace(stockbuffer, start, end);
            if (ret == -1) {
                this.input_stream_eof = true;
                this.audiocache.returnBuffer(stockbuffer);
                return -1;
            }
            end = start + ret;
            int cend = end / this.channels;
            int cstart = start / this.channels;
            double[] cbuffer_attack = null;
            double[] cbuffer_release = null;
            boolean variablebuffers = false;
            if (!this.a_attack_eof) {
                cbuffer_attack = this.audiocache.getBuffer(cend);
                aret = this.a_attack.replace(cbuffer_attack, cstart, cend);
                if (aret == -1) {
                    this.a_attack_eof = true;
                } else {
                    variablebuffers = true;
                    Arrays.fill(cbuffer_attack, cstart + aret, cend, this.f_attack);
                }
            } else {
                cbuffer_attack = null;
            }
            if (this.both_attack_release) {
                if (!this.a_release_eof) {
                    cbuffer_release = this.audiocache.getBuffer(cend);
                    aret = this.a_release.replace(cbuffer_release, cstart, cend);
                    if (aret == -1) {
                        this.a_release_eof = true;
                    } else {
                        variablebuffers = true;
                        Arrays.fill(cbuffer_release, cstart + aret, cend, this.f_release);
                    }
                } else {
                    cbuffer_release = null;
                }
            }
            if (variablebuffers) {
                if (cbuffer_attack == null) {
                    cbuffer_attack = this.audiocache.getBuffer(cend);
                    Arrays.fill(cbuffer_attack, cstart, cend, this.f_attack);
                }
                if (this.both_attack_release && cbuffer_release == null) {
                    cbuffer_release = this.audiocache.getBuffer(cend);
                    Arrays.fill(cbuffer_release, cstart, cend, this.f_release);
                }
            }
            if (this.both_attack_release) {
                if (variablebuffers) {
                    double[] xbb_attack = cbuffer_attack;
                    double[] xbb_release = cbuffer_release;
                    int chs = this.channels;
                    int c = 0;
                    while (c < chs) {
                        int ix = start + c;
                        double xn_1 = this.xn_1[c];
                        int i = cstart;
                        while (i < cend) {
                            double bb_attack = Math.exp(Math.log(0.001) / (xbb_attack[i] * this.rate));
                            double bb_release = Math.exp(Math.log(0.001) / (xbb_release[i] * this.rate));
                            double xn = Math.abs(stockbuffer[ix]);
                            xn_1 = xn_1 < xn ? xn + bb_attack * (xn_1 - xn) : xn + bb_release * (xn_1 - xn);
                            int n = ix;
                            buffer[n] = buffer[n] + xn_1;
                            ix += chs;
                            ++i;
                        }
                        if (xn_1 > 0.0 && xn_1 < 1.0E-10) {
                            xn_1 = 0.0;
                        }
                        this.xn_1[c] = xn_1;
                        ++c;
                    }
                } else {
                    double bb_attack = Math.exp(Math.log(0.001) / (this.f_attack * this.rate));
                    double bb_release = Math.exp(Math.log(0.001) / (this.f_release * this.rate));
                    int chs = this.channels;
                    int c = 0;
                    while (c < chs) {
                        int ix = start + c;
                        double xn_1 = this.xn_1[c];
                        int i = cstart;
                        while (i < cend) {
                            double xn = Math.abs(stockbuffer[ix]);
                            xn_1 = xn_1 < xn ? xn + bb_attack * (xn_1 - xn) : xn + bb_release * (xn_1 - xn);
                            int n = ix;
                            buffer[n] = buffer[n] + xn_1;
                            ix += chs;
                            ++i;
                        }
                        if (xn_1 < 0.0 && xn_1 > -1.0E-10) {
                            xn_1 = 0.0;
                        }
                        this.xn_1[c] = xn_1;
                        ++c;
                    }
                }
            } else if (variablebuffers) {
                double[] xbb_attack = cbuffer_attack;
                int chs = this.channels;
                int c = 0;
                while (c < chs) {
                    int ix = start + c;
                    double xn_1 = this.xn_1[c];
                    int i = cstart;
                    while (i < cend) {
                        double bb_attack = Math.exp(Math.log(0.001) / (xbb_attack[i] * this.rate));
                        double xn = Math.abs(stockbuffer[ix]);
                        xn_1 = xn + bb_attack * (xn_1 - xn);
                        int n = ix;
                        buffer[n] = buffer[n] + xn_1;
                        ix += chs;
                        ++i;
                    }
                    if (xn_1 > 0.0 && xn_1 < 1.0E-10) {
                        xn_1 = 0.0;
                    }
                    this.xn_1[c] = xn_1;
                    ++c;
                }
            } else {
                double bb_attack = Math.exp(Math.log(0.001) / (this.f_attack * this.rate));
                int chs = this.channels;
                int c = 0;
                while (c < chs) {
                    int ix = start + c;
                    double xn_1 = this.xn_1[c];
                    int i = cstart;
                    while (i < cend) {
                        double xn = Math.abs(stockbuffer[ix]);
                        xn_1 = xn + bb_attack * (xn_1 - xn);
                        int n = ix;
                        buffer[n] = buffer[n] + xn_1;
                        ix += chs;
                        ++i;
                    }
                    if (xn_1 < 0.0 && xn_1 > -1.0E-10) {
                        xn_1 = 0.0;
                    }
                    this.xn_1[c] = xn_1;
                    ++c;
                }
            }
            this.audiocache.returnBuffer(stockbuffer);
            if (cbuffer_attack != null) {
                this.audiocache.returnBuffer(cbuffer_attack);
            }
            if (cbuffer_release != null) {
                this.audiocache.returnBuffer(cbuffer_release);
            }
            return ret;
        }

        public int isStatic(double[] buffer, int len) {
            int aret;
            int i = 0;
            while (i < this.channels) {
                if (this.xn_1[i] != 0.0) {
                    return -1;
                }
                ++i;
            }
            if (this.input_stream_eof) {
                return -1;
            }
            int ret = this.input_stream.isStatic(buffer, len);
            if (ret == -1) {
                return -1;
            }
            if (buffer[0] != 0.0) {
                this.input_stream.fallBack();
                return -1;
            }
            int cend = len / this.channels;
            int cstart = 0 / this.channels;
            double[] cbuffer = this.audiocache.getBuffer(cend);
            if (!this.a_attack_eof && (aret = this.a_attack.replace(cbuffer, cstart, cend)) == -1) {
                this.a_attack_eof = true;
            }
            if (this.both_attack_release && !this.a_release_eof && (aret = this.a_release.replace(cbuffer, cstart, cend)) == -1) {
                this.a_release_eof = true;
            }
            this.audiocache.returnBuffer(cbuffer);
            return len;
        }

        public int replace(double[] buffer, int start, int end) {
            Arrays.fill(buffer, start, end, 0.0);
            return this.mix(buffer, start, end);
        }

        public void close() {
            if (this.input_stream != null) {
                this.input_stream.close();
            }
            if (this.a_attack != null) {
                this.a_attack.close();
                this.a_attack = null;
            }
            if (this.both_attack_release && this.a_release != null) {
                this.a_release.close();
                this.a_release = null;
            }
        }
    }
}

