/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.modifiers;

import java.util.Arrays;
import rasmus.interpreter.Variable;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.sampled.AudioCache;
import rasmus.interpreter.sampled.AudioEvent;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;
import rasmus.interpreter.sampled.AudioStreamable;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class AudioDelayLineInstance
extends UnitInstanceAdapter
implements AudioStreamable {
    public Variable output;
    public Variable input;
    Variable answer = new Variable();
    public Variable delay;
    public Variable feedback;
    public Variable maxdelay;
    public Variable damp;

    public void calc() {
    }

    public AudioDelayLineInstance(Parameters parameters) {
        this.output = parameters.getParameterWithDefault("output");
        this.input = parameters.getParameterWithDefault("input");
        this.delay = parameters.getParameterWithDefault(1, "delay");
        this.feedback = parameters.getParameterWithDefault(2, "feedback");
        this.maxdelay = parameters.getParameter(3, "maxdelay");
        this.damp = parameters.getParameter(4, "damp");
        if (this.maxdelay == null) {
            this.maxdelay = this.delay;
        }
        this.answer = AudioEvents.asVariable(new AudioEvent(0.0, this));
        this.output.add(this.answer);
    }

    public void close() {
        this.output.remove(this.answer);
    }

    public AudioStream openStream(AudioSession session) {
        return new FilterStreamInstance(session);
    }

    class FilterStreamInstance
    implements AudioStream {
        AudioStream inputstream;
        boolean inputstream_eof = false;
        double[] stockbuffer = null;
        int channels;
        double[][] delaybuffer;
        int delaybuffer_rover = 0;
        int delaybuffer_len = 0;
        double d_maxdelay = 0.0;
        double rate;
        double[] filterstore;
        boolean inputstream2_eof = false;
        AudioStream inputstream2;
        AudioCache audiocache;
        boolean damp_active = false;
        double damp1 = 0.0;
        double damp2 = 0.0;

        public FilterStreamInstance(AudioSession session) {
            double cutoff;
            this.audiocache = session.getAudioCache();
            this.channels = session.getChannels();
            this.inputstream = AudioEvents.openStream(AudioDelayLineInstance.this.input, session);
            this.rate = session.getRate();
            this.d_maxdelay = DoublePart.asDouble(AudioDelayLineInstance.this.maxdelay);
            if (this.d_maxdelay < DoublePart.asDouble(AudioDelayLineInstance.this.delay)) {
                this.d_maxdelay = DoublePart.asDouble(AudioDelayLineInstance.this.delay);
            }
            this.delaybuffer_len = (int)(this.d_maxdelay * this.rate) + 1;
            this.d_maxdelay = (double)this.delaybuffer_len / this.rate;
            this.delaybuffer = new double[this.channels][];
            int c = 0;
            while (c < this.channels) {
                this.delaybuffer[c] = this.audiocache.getBuffer(this.delaybuffer_len + 1);
                Arrays.fill(this.delaybuffer[c], 0, this.delaybuffer_len + 1, 0.0);
                ++c;
            }
            if (AudioEvents.getInstance((Variable)AudioDelayLineInstance.this.delay).track.size() == 0) {
                this.inputstream2_eof = true;
            } else {
                this.inputstream2 = AudioEvents.openStream(AudioDelayLineInstance.this.delay, session.getMonoSession());
            }
            if (AudioDelayLineInstance.this.damp != null && (cutoff = DoublePart.asDouble(AudioDelayLineInstance.this.damp)) > 0.0) {
                double p;
                double x = Math.PI * 2 * cutoff / session.getRate();
                this.damp1 = p = 2.0 - Math.cos(x) - Math.sqrt(Math.pow(2.0 - Math.cos(x), 2.0) - 1.0);
                this.damp2 = 1.0 - p;
                this.damp_active = true;
            }
            this.filterstore = new double[this.channels];
        }

        public int skip(int len) {
            int ret = this.inputstream.skip(len);
            return ret;
        }

        public int mix(double[] buffer, int start, int end) {
            if (this.damp_active) {
                int i = 0;
                while (i < this.filterstore.length) {
                    if (this.filterstore[i] > 0.0 && this.filterstore[i] < 1.0E-10) {
                        this.filterstore[i] = 0.0;
                    }
                    if (this.filterstore[i] < 0.0 && this.filterstore[i] > -1.0E-10) {
                        this.filterstore[i] = 0.0;
                    }
                    ++i;
                }
            }
            if (this.stockbuffer == null) {
                this.stockbuffer = this.audiocache.getBuffer(buffer.length);
            } else if (this.stockbuffer.length < buffer.length) {
                this.audiocache.returnBuffer(this.stockbuffer);
                this.stockbuffer = this.audiocache.getBuffer(buffer.length);
            }
            if (!this.inputstream_eof) {
                int ret = this.inputstream.replace(this.stockbuffer, start, end);
                if (ret == -1) {
                    this.inputstream_eof = true;
                    ret = 0;
                }
                int i = start + ret;
                while (i < end) {
                    this.stockbuffer[i] = 0.0;
                    ++i;
                }
            }
            double d_delay = DoublePart.asDouble(AudioDelayLineInstance.this.delay);
            double[] stockbuffer2 = null;
            int cstart = start / this.channels;
            int cend = end / this.channels;
            if (!this.inputstream2_eof) {
                stockbuffer2 = new double[1];
                if (this.inputstream2.isStatic(stockbuffer2, cend - cstart) == -1) {
                    stockbuffer2 = this.audiocache.getBuffer(cend);
                    int ret2 = this.inputstream2.replace(stockbuffer2, cstart, cend);
                    if (ret2 == -1) {
                        this.inputstream2_eof = true;
                        this.audiocache.returnBuffer(stockbuffer2);
                        stockbuffer2 = null;
                    } else {
                        Arrays.fill(stockbuffer2, cstart + ret2, cend, DoublePart.asDouble(AudioDelayLineInstance.this.delay));
                    }
                } else {
                    d_delay = stockbuffer2[0];
                    stockbuffer2 = null;
                }
            }
            double d_feedback = DoublePart.asDouble(AudioDelayLineInstance.this.feedback);
            int delaybuffer_rover = 0;
            int chs = this.channels;
            if (stockbuffer2 != null) {
                delaybuffer_rover = this.delaybuffer_rover;
                double bufflen = this.d_maxdelay * this.rate;
                int i = cstart;
                while (i < cend) {
                    stockbuffer2[i] = ((double)delaybuffer_rover + bufflen - stockbuffer2[i] * this.rate + (double)this.delaybuffer_len) % (double)this.delaybuffer_len;
                    delaybuffer_rover = (delaybuffer_rover + 1) % this.delaybuffer_len;
                    ++i;
                }
            }
            double damp1 = this.damp1;
            double damp2 = this.damp2;
            int c = 0;
            while (c < this.channels) {
                int ix;
                delaybuffer_rover = this.delaybuffer_rover;
                double filterstore = this.filterstore[c];
                double[] delaybuffer = this.delaybuffer[c];
                if (stockbuffer2 != null) {
                    int cx = cstart;
                    try {
                        double b;
                        double curb;
                        double delaybuffer_readrover;
                        if (this.damp_active) {
                            int i = start + c;
                            while (i < end) {
                                delaybuffer_readrover = stockbuffer2[cx];
                                ix = (int)delaybuffer_readrover;
                                double s = delaybuffer_readrover - (double)ix;
                                double lastb = delaybuffer[ix %= this.delaybuffer_len];
                                ix = (ix + 1) % this.delaybuffer_len;
                                curb = delaybuffer[ix];
                                b = lastb * (1.0 - s) + curb * s;
                                int n = i;
                                buffer[n] = buffer[n] + b;
                                b = filterstore = b * damp2 + filterstore * damp1;
                                delaybuffer[delaybuffer_rover] = this.stockbuffer[i] + b * d_feedback;
                                delaybuffer_rover = (delaybuffer_rover + 1) % this.delaybuffer_len;
                                ++cx;
                                i += chs;
                            }
                        } else {
                            int i = start + c;
                            while (i < end) {
                                delaybuffer_readrover = stockbuffer2[cx];
                                ix = (int)delaybuffer_readrover;
                                double s = delaybuffer_readrover - (double)ix;
                                double lastb = delaybuffer[ix %= this.delaybuffer_len];
                                ix = (ix + 1) % this.delaybuffer_len;
                                curb = delaybuffer[ix];
                                b = lastb * (1.0 - s) + curb * s;
                                int n = i;
                                buffer[n] = buffer[n] + b;
                                delaybuffer[delaybuffer_rover] = this.stockbuffer[i] + b * d_feedback;
                                delaybuffer_rover = (delaybuffer_rover + 1) % this.delaybuffer_len;
                                ++cx;
                                i += chs;
                            }
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        e.printStackTrace();
                    }
                } else {
                    double delaybuffer_readrover = (double)this.delaybuffer_rover + (this.d_maxdelay - d_delay) * this.rate;
                    double s = delaybuffer_readrover - Math.floor(delaybuffer_readrover);
                    ix = (int)delaybuffer_readrover;
                    while (ix < 0) {
                        ix += this.delaybuffer_len;
                    }
                    while (ix >= this.delaybuffer_len) {
                        ix -= this.delaybuffer_len;
                    }
                    if (s < 1.0E-10) {
                        double b;
                        if (this.damp_active) {
                            int i = start + c;
                            while (i < end) {
                                b = delaybuffer[ix];
                                int n = i;
                                buffer[n] = buffer[n] + b;
                                b = filterstore = b * damp2 + filterstore * damp1;
                                delaybuffer[delaybuffer_rover] = this.stockbuffer[i] + b * d_feedback;
                                delaybuffer_rover = (delaybuffer_rover + 1) % this.delaybuffer_len;
                                ix = (ix + 1) % this.delaybuffer_len;
                                i += chs;
                            }
                        } else {
                            int i = start + c;
                            while (i < end) {
                                b = delaybuffer[ix];
                                int n = i;
                                buffer[n] = buffer[n] + b;
                                delaybuffer[delaybuffer_rover] = this.stockbuffer[i] + b * d_feedback;
                                delaybuffer_rover = (delaybuffer_rover + 1) % this.delaybuffer_len;
                                ix = (ix + 1) % this.delaybuffer_len;
                                i += chs;
                            }
                        }
                    } else {
                        double b;
                        double curb;
                        double lastb = delaybuffer[ix];
                        if (++ix == this.delaybuffer_len) {
                            ix = 0;
                        }
                        if (this.damp_active) {
                            int i = start + c;
                            while (i < end) {
                                curb = delaybuffer[ix];
                                b = lastb * (1.0 - s) + curb * s;
                                lastb = curb;
                                int n = i;
                                buffer[n] = buffer[n] + b;
                                b = filterstore = b * damp2 + filterstore * damp1;
                                delaybuffer[delaybuffer_rover] = this.stockbuffer[i] + b * d_feedback;
                                delaybuffer_rover = (delaybuffer_rover + 1) % this.delaybuffer_len;
                                ix = (ix + 1) % this.delaybuffer_len;
                                i += chs;
                            }
                        } else {
                            int i = start + c;
                            while (i < end) {
                                curb = delaybuffer[ix];
                                b = lastb * (1.0 - s) + curb * s;
                                lastb = curb;
                                int n = i;
                                buffer[n] = buffer[n] + b;
                                delaybuffer[delaybuffer_rover] = this.stockbuffer[i] + b * d_feedback;
                                delaybuffer_rover = (delaybuffer_rover + 1) % this.delaybuffer_len;
                                ix = (ix + 1) % this.delaybuffer_len;
                                i += chs;
                            }
                        }
                    }
                }
                this.filterstore[c] = filterstore;
                ++c;
            }
            this.delaybuffer_rover = delaybuffer_rover;
            if (stockbuffer2 != null) {
                this.audiocache.returnBuffer(stockbuffer2);
            }
            if (this.inputstream_eof) {
                c = 0;
                while (c < this.channels) {
                    int i = 0;
                    while (i < this.delaybuffer_len) {
                        if (this.delaybuffer[c][i] > 1.0E-10 || this.delaybuffer[c][i] < -1.0E-10) {
                            return end - start;
                        }
                        ++i;
                    }
                    ++c;
                }
                return -1;
            }
            return end - start;
        }

        public int replace(double[] buffer, int start, int end) {
            if (this.damp_active) {
                int i = 0;
                while (i < this.filterstore.length) {
                    if (this.filterstore[i] > 0.0 && this.filterstore[i] < 1.0E-10) {
                        this.filterstore[i] = 0.0;
                    }
                    if (this.filterstore[i] < 0.0 && this.filterstore[i] > -1.0E-10) {
                        this.filterstore[i] = 0.0;
                    }
                    ++i;
                }
            }
            if (this.stockbuffer == null) {
                this.stockbuffer = this.audiocache.getBuffer(buffer.length);
            } else if (this.stockbuffer.length < buffer.length) {
                this.audiocache.returnBuffer(this.stockbuffer);
                this.stockbuffer = this.audiocache.getBuffer(buffer.length);
            }
            if (!this.inputstream_eof) {
                int ret = this.inputstream.replace(this.stockbuffer, start, end);
                if (ret == -1) {
                    this.inputstream_eof = true;
                    ret = 0;
                }
                int i = start + ret;
                while (i < end) {
                    this.stockbuffer[i] = 0.0;
                    ++i;
                }
            }
            double d_delay = DoublePart.asDouble(AudioDelayLineInstance.this.delay);
            double[] stockbuffer2 = null;
            int cstart = start / this.channels;
            int cend = end / this.channels;
            if (!this.inputstream2_eof) {
                stockbuffer2 = new double[1];
                if (this.inputstream2.isStatic(stockbuffer2, cend - cstart) == -1) {
                    stockbuffer2 = this.audiocache.getBuffer(cend);
                    int ret2 = this.inputstream2.replace(stockbuffer2, cstart, cend);
                    if (ret2 == -1) {
                        this.inputstream2_eof = true;
                        this.audiocache.returnBuffer(stockbuffer2);
                        stockbuffer2 = null;
                    } else {
                        Arrays.fill(stockbuffer2, cstart + ret2, cend, DoublePart.asDouble(AudioDelayLineInstance.this.delay));
                    }
                } else {
                    d_delay = stockbuffer2[0];
                    stockbuffer2 = null;
                }
            }
            double d_feedback = DoublePart.asDouble(AudioDelayLineInstance.this.feedback);
            int delaybuffer_rover = 0;
            int chs = this.channels;
            if (stockbuffer2 != null) {
                delaybuffer_rover = this.delaybuffer_rover;
                double bufflen = this.d_maxdelay * this.rate;
                int i = cstart;
                while (i < cend) {
                    stockbuffer2[i] = ((double)delaybuffer_rover + bufflen - stockbuffer2[i] * this.rate + (double)this.delaybuffer_len) % (double)this.delaybuffer_len;
                    delaybuffer_rover = (delaybuffer_rover + 1) % this.delaybuffer_len;
                    ++i;
                }
            }
            double damp1 = this.damp1;
            double damp2 = this.damp2;
            int c = 0;
            while (c < this.channels) {
                int ix;
                delaybuffer_rover = this.delaybuffer_rover;
                double filterstore = this.filterstore[c];
                double[] delaybuffer = this.delaybuffer[c];
                if (stockbuffer2 != null) {
                    int cx = cstart;
                    try {
                        double b;
                        double curb;
                        double delaybuffer_readrover;
                        if (this.damp_active) {
                            int i = start + c;
                            while (i < end) {
                                delaybuffer_readrover = stockbuffer2[cx];
                                ix = (int)delaybuffer_readrover;
                                double s = delaybuffer_readrover - (double)ix;
                                double lastb = delaybuffer[ix];
                                ix = (ix + 1) % this.delaybuffer_len;
                                curb = delaybuffer[ix];
                                buffer[i] = b = lastb * (1.0 - s) + curb * s;
                                b = filterstore = b * damp2 + filterstore * damp1;
                                delaybuffer[delaybuffer_rover] = this.stockbuffer[i] + b * d_feedback;
                                delaybuffer_rover = (delaybuffer_rover + 1) % this.delaybuffer_len;
                                ++cx;
                                i += chs;
                            }
                        } else {
                            int i = start + c;
                            while (i < end) {
                                delaybuffer_readrover = stockbuffer2[cx];
                                ix = (int)delaybuffer_readrover;
                                double s = delaybuffer_readrover - (double)ix;
                                double lastb = delaybuffer[ix];
                                ix = (ix + 1) % this.delaybuffer_len;
                                curb = delaybuffer[ix];
                                buffer[i] = b = lastb * (1.0 - s) + curb * s;
                                delaybuffer[delaybuffer_rover] = this.stockbuffer[i] + b * d_feedback;
                                delaybuffer_rover = (delaybuffer_rover + 1) % this.delaybuffer_len;
                                ++cx;
                                i += chs;
                            }
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        e.printStackTrace();
                    }
                } else {
                    double delaybuffer_readrover = (double)this.delaybuffer_rover + (this.d_maxdelay - d_delay) * this.rate;
                    double s = delaybuffer_readrover - Math.floor(delaybuffer_readrover);
                    ix = (int)delaybuffer_readrover;
                    while (ix < 0) {
                        ix += this.delaybuffer_len;
                    }
                    while (ix >= this.delaybuffer_len) {
                        ix -= this.delaybuffer_len;
                    }
                    if (s < 1.0E-10) {
                        double b;
                        if (this.damp_active) {
                            int i = start + c;
                            while (i < end) {
                                buffer[i] = b = delaybuffer[ix];
                                b = filterstore = b * damp2 + filterstore * damp1;
                                delaybuffer[delaybuffer_rover] = this.stockbuffer[i] + b * d_feedback;
                                delaybuffer_rover = (delaybuffer_rover + 1) % this.delaybuffer_len;
                                ix = (ix + 1) % this.delaybuffer_len;
                                i += chs;
                            }
                        } else {
                            int i = start + c;
                            while (i < end) {
                                buffer[i] = b = delaybuffer[ix];
                                delaybuffer[delaybuffer_rover] = this.stockbuffer[i] + b * d_feedback;
                                delaybuffer_rover = (delaybuffer_rover + 1) % this.delaybuffer_len;
                                ix = (ix + 1) % this.delaybuffer_len;
                                i += chs;
                            }
                        }
                    } else {
                        double b;
                        double curb;
                        double lastb = delaybuffer[ix];
                        if (++ix == this.delaybuffer_len) {
                            ix = 0;
                        }
                        if (this.damp_active) {
                            int i = start + c;
                            while (i < end) {
                                curb = delaybuffer[ix];
                                b = lastb * (1.0 - s) + curb * s;
                                lastb = curb;
                                buffer[i] = b;
                                b = filterstore = b * damp2 + filterstore * damp1;
                                delaybuffer[delaybuffer_rover] = this.stockbuffer[i] + b * d_feedback;
                                delaybuffer_rover = (delaybuffer_rover + 1) % this.delaybuffer_len;
                                ix = (ix + 1) % this.delaybuffer_len;
                                i += chs;
                            }
                        } else {
                            int i = start + c;
                            while (i < end) {
                                curb = delaybuffer[ix];
                                b = lastb * (1.0 - s) + curb * s;
                                lastb = curb;
                                buffer[i] = b;
                                delaybuffer[delaybuffer_rover] = this.stockbuffer[i] + b * d_feedback;
                                delaybuffer_rover = (delaybuffer_rover + 1) % this.delaybuffer_len;
                                ix = (ix + 1) % this.delaybuffer_len;
                                i += chs;
                            }
                        }
                    }
                }
                this.filterstore[c] = filterstore;
                ++c;
            }
            this.delaybuffer_rover = delaybuffer_rover;
            if (stockbuffer2 != null) {
                this.audiocache.returnBuffer(stockbuffer2);
            }
            if (this.inputstream_eof) {
                c = 0;
                while (c < this.channels) {
                    int i = 0;
                    while (i < this.delaybuffer_len) {
                        if (this.delaybuffer[c][i] > 1.0E-10 || this.delaybuffer[c][i] < -1.0E-10) {
                            return end - start;
                        }
                        ++i;
                    }
                    ++c;
                }
                return -1;
            }
            return end - start;
        }

        public int isStatic(double[] buffer, int len) {
            return -1;
        }

        public void close() {
            if (this.stockbuffer != null) {
                this.audiocache.returnBuffer(this.stockbuffer);
                this.stockbuffer = null;
            }
            int c = 0;
            while (c < this.channels) {
                this.audiocache.returnBuffer(this.delaybuffer[c]);
                ++c;
            }
            this.inputstream.close();
            if (this.inputstream2 != null) {
                this.inputstream2.close();
            }
        }
    }
}

