/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.modifiers;

import java.util.Arrays;
import rasmus.interpreter.Variable;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.sampled.AudioCache;
import rasmus.interpreter.sampled.AudioEvent;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.AudioFallBackStream;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;
import rasmus.interpreter.sampled.AudioStreamable;
import rasmus.interpreter.sampled.util.DeReverb;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class AudioDeReverbInstance
extends UnitInstanceAdapter
implements AudioStreamable {
    public Variable output;
    public Variable input;
    Variable answer = new Variable();
    Variable fftFrameSize;
    Variable osamp;
    Variable amount;
    Variable feedback;
    Variable release;
    Variable attack;
    Variable thresold;
    Variable sumsmooth;

    public void calc() {
    }

    public AudioDeReverbInstance(Parameters parameters) {
        this.output = parameters.getParameterWithDefault("output");
        this.input = parameters.getParameterWithDefault("input");
        this.amount = parameters.getParameter(1, "amount");
        this.feedback = parameters.getParameter(2, "feedback");
        this.attack = parameters.getParameter(3, "attack");
        this.release = parameters.getParameter(4, "release");
        if (this.release == null) {
            this.release = this.attack;
        }
        this.thresold = parameters.getParameter(5, "thresold");
        this.sumsmooth = parameters.getParameter(6, "window");
        this.fftFrameSize = parameters.getParameterWithDefault(7, "fftFrameSize");
        this.osamp = parameters.getParameterWithDefault(8, "osamp");
        this.answer = AudioEvents.asVariable(new AudioEvent(0.0, this));
        this.output.add(this.answer);
    }

    public void close() {
        this.output.remove(this.answer);
    }

    public AudioStream openStream(AudioSession session) {
        return new FilterStreamInstance(AudioEvents.openStream(this.input, session), session);
    }

    class FilterStreamInstance
    implements AudioStream {
        AudioFallBackStream inputstream;
        DeReverb[] pitchshift;
        int channels;
        AudioCache audiocache;
        AudioSession session;

        public FilterStreamInstance(AudioStream inputstream, AudioSession session) {
            this.session = session;
            this.audiocache = session.getAudioCache();
            this.channels = session.getChannels();
            int i_fftFrameSize = (int)DoublePart.asDouble(AudioDeReverbInstance.this.fftFrameSize);
            int i_osamp = (int)DoublePart.asDouble(AudioDeReverbInstance.this.osamp);
            if (i_fftFrameSize == 0) {
                i_fftFrameSize = 4096;
            }
            if (i_osamp == 0) {
                i_osamp = 4;
            }
            int sumsmooth = 1;
            if (AudioDeReverbInstance.this.sumsmooth != null) {
                sumsmooth = (int)DoublePart.asDouble(AudioDeReverbInstance.this.sumsmooth);
            }
            this.pitchshift = new DeReverb[this.channels];
            int i = 0;
            while (i < this.channels) {
                this.pitchshift[i] = new DeReverb(i_fftFrameSize, i_osamp, session.getRate(), sumsmooth);
                if (AudioDeReverbInstance.this.amount != null) {
                    this.pitchshift[i].amount = DoublePart.asDouble(AudioDeReverbInstance.this.amount);
                }
                if (AudioDeReverbInstance.this.feedback != null) {
                    this.pitchshift[i].feedback = DoublePart.asDouble(AudioDeReverbInstance.this.feedback);
                }
                if (AudioDeReverbInstance.this.attack != null) {
                    this.pitchshift[i].attack = DoublePart.asDouble(AudioDeReverbInstance.this.attack);
                }
                if (AudioDeReverbInstance.this.release != null) {
                    this.pitchshift[i].release = DoublePart.asDouble(AudioDeReverbInstance.this.release);
                }
                if (AudioDeReverbInstance.this.thresold != null) {
                    this.pitchshift[i].thresold = DoublePart.asDouble(AudioDeReverbInstance.this.thresold);
                }
                ++i;
            }
            this.inputstream = new AudioFallBackStream(inputstream);
        }

        public int mix(double[] buffer, int start, int end) {
            double[] stockbuffer = this.audiocache.getBuffer(end);
            int ret = this.replace(stockbuffer, start, end);
            int cret = ret;
            if (cret == -1) {
                cret = 0;
            }
            int i = start;
            while (i < start + cret) {
                int n = i;
                buffer[n] = buffer[n] + stockbuffer[i];
                ++i;
            }
            this.audiocache.returnBuffer(stockbuffer);
            return ret;
        }

        public int skip(int len) {
            int ret = this.inputstream.skip(len);
            return ret;
        }

        public int replace(double[] buffer, int start, int end) {
            double[] stockbuffer2 = null;
            double[] stockbuffer3 = null;
            int ret = this.inputstream.replace(buffer, start, end);
            int cret = ret;
            if (cret == -1) {
                cret = 0;
            }
            Arrays.fill(buffer, start + cret, end, 0.0);
            int i = 0;
            while (i < this.channels) {
                this.pitchshift[i].process(start + i, end, this.channels, buffer, buffer);
                ++i;
            }
            if (stockbuffer2 != null) {
                this.audiocache.returnBuffer(stockbuffer2);
            }
            if (stockbuffer3 != null) {
                this.audiocache.returnBuffer(stockbuffer3);
            }
            if (ret == -1) {
                i = start;
                while (i < end) {
                    if (buffer[i] > 1.0E-10) {
                        return end - start;
                    }
                    ++i;
                }
                return -1;
            }
            return ret;
        }

        public int isStatic(double[] buffer, int len) {
            return -1;
        }

        public void close() {
            this.inputstream.close();
        }
    }
}

