/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.modifiers;

import java.util.ArrayList;
import java.util.Arrays;
import rasmus.interpreter.Variable;
import rasmus.interpreter.sampled.AudioCache;
import rasmus.interpreter.sampled.AudioEvent;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.AudioFallBackStream;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;
import rasmus.interpreter.sampled.AudioStreamable;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class AudioChannelMuxInstance
extends UnitInstanceAdapter
implements AudioStreamable {
    public Variable output;
    Variable answer = new Variable();
    Variable[] channels;

    public void calc() {
    }

    public AudioChannelMuxInstance(Parameters parameters) {
        this.output = parameters.getParameterWithDefault("output");
        ArrayList<Variable> vars = new ArrayList<Variable>();
        int ii = 1;
        Variable var = parameters.getParameter(ii);
        while (var != null) {
            vars.add(var);
            var = parameters.getParameter(++ii);
        }
        this.channels = new Variable[vars.size()];
        int i = 0;
        while (i < this.channels.length) {
            this.channels[i] = (Variable)vars.get(i);
            ++i;
        }
        this.answer = AudioEvents.asVariable(new AudioEvent(0.0, this));
        this.output.add(this.answer);
    }

    public void close() {
        this.output.remove(this.answer);
    }

    public AudioStream openStream(AudioSession session) {
        return new FilterStreamInstance(session);
    }

    class FilterStreamInstance
    implements AudioStream {
        AudioFallBackStream[] inputstreams;
        boolean[] inputstreams_eof;
        int totalchannels;
        int chs;
        AudioCache audiocache;
        double[] sbuffer = new double[1];

        public FilterStreamInstance(AudioSession session) {
            this.audiocache = session.getAudioCache();
            this.totalchannels = this.chs = session.getChannels();
            if (this.totalchannels > AudioChannelMuxInstance.this.channels.length) {
                this.totalchannels = AudioChannelMuxInstance.this.channels.length;
            }
            this.inputstreams = new AudioFallBackStream[this.totalchannels];
            this.inputstreams_eof = new boolean[this.totalchannels];
            if (this.totalchannels > 0) {
                AudioSession monosession = session.getMonoSession();
                int i = 0;
                while (i < this.totalchannels) {
                    this.inputstreams_eof[i] = false;
                    this.inputstreams[i] = new AudioFallBackStream(AudioEvents.openStream(AudioChannelMuxInstance.this.channels[i], monosession));
                    ++i;
                }
            }
        }

        public int mix(double[] buffer, int start, int end) {
            boolean anyact = false;
            int cstart = start / this.chs;
            int cend = end / this.chs;
            double[] stockbuffer = this.audiocache.getBuffer(cend);
            int c = 0;
            while (c < this.totalchannels) {
                if (!this.inputstreams_eof[c]) {
                    int retc = this.inputstreams[c].replace(stockbuffer, cstart, cend);
                    if (retc == -1) {
                        this.inputstreams_eof[c] = true;
                    } else {
                        anyact = true;
                        Arrays.fill(stockbuffer, cstart + retc, cend, 0.0);
                        int ix = cstart;
                        int i = start + c;
                        while (i < end) {
                            int n = i;
                            buffer[n] = buffer[n] + stockbuffer[ix];
                            ++ix;
                            i += this.chs;
                        }
                    }
                }
                ++c;
            }
            this.audiocache.returnBuffer(stockbuffer);
            if (!anyact) {
                return -1;
            }
            return end - start;
        }

        public int replace(double[] buffer, int start, int end) {
            boolean anyact = false;
            int cstart = start / this.chs;
            int cend = end / this.chs;
            double[] stockbuffer = this.audiocache.getBuffer(cend);
            int c = 0;
            while (c < this.totalchannels) {
                if (!this.inputstreams_eof[c]) {
                    int retc = this.inputstreams[c].replace(stockbuffer, cstart, cend);
                    if (retc == -1) {
                        this.inputstreams_eof[c] = true;
                    } else {
                        anyact = true;
                        Arrays.fill(stockbuffer, cstart + retc, cend, 0.0);
                        int ix = cstart;
                        int i = start + c;
                        while (i < end) {
                            buffer[i] = stockbuffer[ix];
                            ++ix;
                            i += this.chs;
                        }
                    }
                }
                ++c;
            }
            this.audiocache.returnBuffer(stockbuffer);
            if (!anyact) {
                return -1;
            }
            return end - start;
        }

        public int skip(int len) {
            boolean anyact = false;
            int c = 0;
            while (c < this.totalchannels) {
                if (!this.inputstreams_eof[c]) {
                    anyact = true;
                    int retc = this.inputstreams[c].skip(len / this.chs);
                    if (retc == -1) {
                        this.inputstreams_eof[c] = true;
                    }
                }
                ++c;
            }
            if (!anyact) {
                return -1;
            }
            return len;
        }

        public int isStatic(double[] buffer, int len) {
            boolean anyact = false;
            int clen = len / this.chs;
            int c = 0;
            while (c < this.totalchannels) {
                if (!this.inputstreams_eof[c]) {
                    int retc = this.inputstreams[c].isStatic(this.sbuffer, clen);
                    if (retc == -1) {
                        int i = 0;
                        while (i < c) {
                            this.inputstreams[c].fallBack();
                            ++c;
                        }
                        return -1;
                    }
                    if (this.sbuffer[0] != 0.0) {
                        int i = 0;
                        while (i <= c) {
                            this.inputstreams[c].fallBack();
                            ++c;
                        }
                        return -1;
                    }
                    anyact = true;
                }
                ++c;
            }
            if (!anyact) {
                return -1;
            }
            this.sbuffer[0] = 0.0;
            return len;
        }

        public void close() {
            int i = 0;
            while (i < this.inputstreams.length) {
                this.inputstreams[i].close();
                ++i;
            }
        }
    }
}

