/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.modifiers;

import java.util.Arrays;
import rasmus.interpreter.Variable;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.sampled.AudioCache;
import rasmus.interpreter.sampled.AudioEvent;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.AudioFallBackStream;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;
import rasmus.interpreter.sampled.AudioStreamable;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class AudioBiquadInstance
extends UnitInstanceAdapter
implements AudioStreamable {
    public static final int PNUM = 6;
    public Variable output;
    Variable answer = new Variable();
    Variable input;
    Variable[] a = new Variable[6];

    public void calc() {
    }

    public AudioBiquadInstance(Parameters parameters) {
        this.output = parameters.getParameterWithDefault("output");
        this.input = parameters.getParameterWithDefault("input");
        this.a[0] = parameters.getParameterWithDefault(1, "b0");
        this.a[1] = parameters.getParameterWithDefault(2, "b1");
        this.a[2] = parameters.getParameterWithDefault(3, "b2");
        this.a[3] = parameters.getParameterWithDefault(4, "a0");
        this.a[4] = parameters.getParameterWithDefault(5, "a1");
        this.a[5] = parameters.getParameterWithDefault(6, "a2");
        this.answer = AudioEvents.asVariable(new AudioEvent(0.0, this));
        this.output.add(this.answer);
    }

    public void close() {
        this.output.remove(this.answer);
    }

    public AudioStream openStream(AudioSession session) {
        return new FilterStreamInstance(session);
    }

    class FilterStreamInstance
    implements AudioStream {
        AudioFallBackStream input_stream = null;
        double[] f_a = new double[6];
        boolean input_stream_eof = false;
        boolean[] a_stream_eof = new boolean[6];
        AudioStream[] a_stream = new AudioStream[6];
        int channels;
        double rate;
        AudioCache audiocache;
        double[] xn_1;
        double[] xn_2;
        double[] yn_1;
        double[] yn_2;

        public FilterStreamInstance(AudioSession session) {
            this.audiocache = session.getAudioCache();
            this.channels = session.getChannels();
            this.rate = session.getRate();
            this.xn_1 = new double[this.channels];
            this.xn_2 = new double[this.channels];
            this.yn_1 = new double[this.channels];
            this.yn_2 = new double[this.channels];
            Arrays.fill(this.xn_1, 0.0);
            Arrays.fill(this.xn_2, 0.0);
            Arrays.fill(this.yn_1, 0.0);
            Arrays.fill(this.yn_2, 0.0);
            boolean bl = this.input_stream_eof = AudioEvents.getInstance((Variable)AudioBiquadInstance.this.input).track.size() == 0;
            if (!this.input_stream_eof) {
                this.input_stream = new AudioFallBackStream(AudioEvents.openStream(AudioBiquadInstance.this.input, session));
            }
            AudioSession monosession = session.getMonoSession();
            int i = 0;
            while (i < 6) {
                this.f_a[i] = DoublePart.asDouble(AudioBiquadInstance.this.a[i]);
                this.a_stream_eof[i] = AudioEvents.getInstance((Variable)AudioBiquadInstance.this.a[i]).track.size() == 0;
                this.a_stream[i] = !this.a_stream_eof[i] ? AudioEvents.openStream(AudioBiquadInstance.this.a[i], monosession) : null;
                ++i;
            }
        }

        public int skip(int len) {
            if (this.input_stream_eof) {
                return -1;
            }
            int ret = this.input_stream.skip(len);
            int clen = len / this.channels;
            int i = 0;
            while (i < 6) {
                int aret;
                if (!this.a_stream_eof[i] && (aret = this.a_stream[i].skip(clen)) == -1) {
                    this.a_stream_eof[i] = true;
                }
                ++i;
            }
            return ret;
        }

        public int mix(double[] buffer, int start, int end) {
            if (this.input_stream_eof) {
                return -1;
            }
            double[] stockbuffer = this.audiocache.getBuffer(end);
            int ret = this.input_stream.replace(stockbuffer, start, end);
            if (ret == -1) {
                this.input_stream_eof = true;
                this.audiocache.returnBuffer(stockbuffer);
                return -1;
            }
            end = start + ret;
            int cend = end / this.channels;
            int cstart = start / this.channels;
            double[][] cbuffer = new double[6][];
            boolean variablebuffers = false;
            int i = 0;
            while (i < 6) {
                if (!this.a_stream_eof[i]) {
                    cbuffer[i] = this.audiocache.getBuffer(cend);
                    int aret = this.a_stream[i].replace(cbuffer[i], cstart, cend);
                    if (aret == -1) {
                        this.a_stream_eof[i] = true;
                    } else {
                        variablebuffers = true;
                        Arrays.fill(cbuffer[i], cstart + aret, cend, this.f_a[i]);
                    }
                } else {
                    cbuffer[i] = null;
                }
                ++i;
            }
            if (variablebuffers) {
                i = 0;
                while (i < 6) {
                    if (cbuffer[i] == null) {
                        cbuffer[i] = this.audiocache.getBuffer(cend);
                        Arrays.fill(cbuffer[i], cstart, cend, this.f_a[i]);
                    }
                    ++i;
                }
            }
            if (variablebuffers) {
                double[] xbb0 = cbuffer[0];
                double[] xbb1 = cbuffer[1];
                double[] xbb2 = cbuffer[2];
                double[] xaa0 = cbuffer[3];
                double[] xaa1 = cbuffer[4];
                double[] xaa2 = cbuffer[5];
                int chs = this.channels;
                int c = 0;
                while (c < chs) {
                    int ix = start + c;
                    double xn_1 = this.xn_1[c];
                    double xn_2 = this.xn_2[c];
                    double yn_1 = this.yn_1[c];
                    double yn_2 = this.yn_2[c];
                    int i2 = cstart;
                    while (i2 < cend) {
                        double aa0 = 1.0 / xaa0[i2];
                        double bb0 = xbb0[i2];
                        double xn = stockbuffer[ix];
                        double bb1 = xbb1[i2];
                        double bb2 = xbb2[i2];
                        double aa1 = xaa1[i2];
                        double aa2 = xaa2[i2];
                        double yn = aa0 * (bb0 * xn + bb1 * xn_1 + bb2 * xn_2 - aa1 * yn_1 - aa2 * yn_2);
                        if (yn > 0.0 && yn < 1.0E-10) {
                            yn = 0.0;
                        }
                        if (yn < 0.0 && yn > -1.0E-10) {
                            yn = 0.0;
                        }
                        xn_2 = xn_1;
                        xn_1 = xn;
                        yn_2 = yn_1;
                        yn_1 = yn;
                        int n = ix;
                        buffer[n] = buffer[n] + yn;
                        ix += chs;
                        ++i2;
                    }
                    if (xn_1 > 0.0 && xn_1 < 1.0E-10) {
                        xn_1 = 0.0;
                    }
                    if (xn_2 < 0.0 && xn_2 > -1.0E-10) {
                        xn_2 = 0.0;
                    }
                    if (yn_1 > 0.0 && yn_1 < 1.0E-10) {
                        yn_1 = 0.0;
                    }
                    if (yn_2 < 0.0 && yn_2 > -1.0E-10) {
                        yn_2 = 0.0;
                    }
                    this.xn_1[c] = xn_1;
                    this.xn_2[c] = xn_2;
                    this.yn_1[c] = yn_1;
                    this.yn_2[c] = yn_2;
                    ++c;
                }
            } else {
                double aa0 = 1.0 / this.f_a[3];
                double bb0 = this.f_a[0];
                double bb1 = this.f_a[1];
                double bb2 = this.f_a[2];
                double aa1 = this.f_a[4];
                double aa2 = this.f_a[5];
                int chs = this.channels;
                int c = 0;
                while (c < chs) {
                    int ix = start + c;
                    double xn_1 = this.xn_1[c];
                    double xn_2 = this.xn_2[c];
                    double yn_1 = this.yn_1[c];
                    double yn_2 = this.yn_2[c];
                    int i3 = cstart;
                    while (i3 < cend) {
                        double xn = stockbuffer[ix];
                        double yn = aa0 * (bb0 * xn + bb1 * xn_1 + bb2 * xn_2 - aa1 * yn_1 - aa2 * yn_2);
                        if (yn > 0.0 && yn < 1.0E-10) {
                            yn = 0.0;
                        }
                        if (yn < 0.0 && yn > -1.0E-10) {
                            yn = 0.0;
                        }
                        xn_2 = xn_1;
                        xn_1 = xn;
                        yn_2 = yn_1;
                        yn_1 = yn;
                        int n = ix;
                        buffer[n] = buffer[n] + yn;
                        ix += chs;
                        ++i3;
                    }
                    if (xn_2 < 0.0 && xn_2 > -1.0E-10) {
                        xn_2 = 0.0;
                    }
                    if (yn_1 > 0.0 && yn_1 < 1.0E-10) {
                        yn_1 = 0.0;
                    }
                    if (yn_2 < 0.0 && yn_2 > -1.0E-10) {
                        yn_2 = 0.0;
                    }
                    this.xn_1[c] = xn_1;
                    this.xn_2[c] = xn_2;
                    this.yn_1[c] = yn_1;
                    this.yn_2[c] = yn_2;
                    ++c;
                }
            }
            this.audiocache.returnBuffer(stockbuffer);
            i = 0;
            while (i < 6) {
                if (cbuffer[i] != null) {
                    this.audiocache.returnBuffer(cbuffer[i]);
                }
                ++i;
            }
            return ret;
        }

        public int isStatic(double[] buffer, int len) {
            int i = 0;
            while (i < this.channels) {
                if (this.xn_1[i] != 0.0) {
                    return -1;
                }
                if (this.xn_2[i] != 0.0) {
                    return -1;
                }
                if (this.yn_1[i] != 0.0) {
                    return -1;
                }
                if (this.yn_2[i] != 0.0) {
                    return -1;
                }
                ++i;
            }
            if (this.input_stream_eof) {
                return -1;
            }
            int ret = this.input_stream.isStatic(buffer, len);
            if (ret == -1) {
                return -1;
            }
            if (buffer[0] != 0.0) {
                this.input_stream.fallBack();
                return -1;
            }
            int cend = len / this.channels;
            int cstart = 0 / this.channels;
            double[] cbuffer = this.audiocache.getBuffer(cend);
            int i2 = 0;
            while (i2 < 6) {
                int aret;
                if (!this.a_stream_eof[i2] && (aret = this.a_stream[i2].replace(cbuffer, cstart, cend)) == -1) {
                    this.a_stream_eof[i2] = true;
                }
                ++i2;
            }
            this.audiocache.returnBuffer(cbuffer);
            return len;
        }

        public int replace(double[] buffer, int start, int end) {
            Arrays.fill(buffer, start, end, 0.0);
            return this.mix(buffer, start, end);
        }

        public void close() {
            if (this.input_stream != null) {
                this.input_stream.close();
            }
            int i = 0;
            while (i < 6) {
                if (this.a_stream[i] != null) {
                    this.a_stream[i].close();
                    this.a_stream[i] = null;
                }
                ++i;
            }
        }
    }
}

