/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.modifiers;

import rasmus.interpreter.Variable;
import rasmus.interpreter.sampled.AudioEvent;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;
import rasmus.interpreter.sampled.AudioStreamable;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class AudioAGCInstance
extends UnitInstanceAdapter
implements AudioStreamable {
    public Variable output;
    public Variable input;
    Variable answer = new Variable();

    public void calc() {
    }

    public AudioAGCInstance(Parameters parameters) {
        this.output = parameters.getParameterWithDefault("output");
        this.input = parameters.getParameterWithDefault(1, "input");
        this.answer = AudioEvents.asVariable(new AudioEvent(0.0, this));
        this.output.add(this.answer);
    }

    public void close() {
        this.output.remove(this.answer);
    }

    public AudioStream openStream(AudioSession session) {
        return new FilterStreamInstance(session);
    }

    class FilterStreamInstance
    implements AudioStream {
        AudioStream inputstream;
        double[] stockbuffer = null;
        int channels;
        int aheadbuffer_len = 0;
        int aheadbuffer_rover = 0;
        int aheadbuffer_scaninterval = 0;
        double aheadbuffer_releasetime = 0.0;
        double[] aheadbuffer;
        double currentamp = 1.0;
        double plannedamp = 1.0;
        double amp_stepping = 0.0;

        public FilterStreamInstance(AudioSession session) {
            this.channels = session.getChannels();
            this.inputstream = AudioEvents.openStream(AudioAGCInstance.this.input, session);
            double agc_buffer_len = 0.016;
            this.aheadbuffer_len = session.getChannels() * (int)(agc_buffer_len * session.getRate());
            this.aheadbuffer_scaninterval = session.getChannels() * (int)(agc_buffer_len * 0.5 * session.getRate());
            this.aheadbuffer_releasetime = (double)(session.getChannels() * 25) * session.getRate();
            this.aheadbuffer_releasetime = Math.pow(2.0, 100.0 / this.aheadbuffer_releasetime);
            this.aheadbuffer = new double[this.aheadbuffer_len];
        }

        public int skip(int len) {
            int ret = this.inputstream.skip(len);
            return ret;
        }

        public int mix(double[] buffer, int start, int end) {
            if (this.stockbuffer == null) {
                this.stockbuffer = new double[buffer.length];
            } else if (this.stockbuffer.length < buffer.length) {
                this.stockbuffer = new double[buffer.length];
            }
            int ret = this.inputstream.replace(this.stockbuffer, start, end);
            double currentamp = this.currentamp;
            end = start + ret;
            double aheadbuffer_releasetime = this.aheadbuffer_releasetime;
            int i = start;
            while (i < end) {
                if (this.aheadbuffer_rover % this.aheadbuffer_scaninterval == 0) {
                    double agc_max = 0.0;
                    int j = 0;
                    while (j < this.aheadbuffer_len) {
                        double s = Math.abs(this.aheadbuffer[j]);
                        if (s > agc_max) {
                            agc_max = s;
                        }
                        ++j;
                    }
                    if (1.0 / (agc_max *= 1.1) - this.plannedamp < 0.0) {
                        this.plannedamp = 1.0 / agc_max;
                        double ampcorrection = this.plannedamp - currentamp;
                        this.amp_stepping = ampcorrection / (double)this.aheadbuffer_scaninterval;
                    }
                    if (agc_max < 1.0) {
                        agc_max = 1.0;
                    }
                    if (1.0 / agc_max - this.plannedamp > 0.2) {
                        this.plannedamp = 1.0 / agc_max;
                        this.amp_stepping = 1.0;
                    }
                }
                if (this.amp_stepping != 0.0) {
                    if (this.amp_stepping > 0.0) {
                        if ((currentamp *= aheadbuffer_releasetime) > this.plannedamp) {
                            currentamp = this.plannedamp;
                            this.amp_stepping = 0.0;
                        }
                    } else if ((currentamp += this.amp_stepping) < this.plannedamp) {
                        currentamp = this.plannedamp;
                        this.amp_stepping = 0.0;
                    }
                }
                if (this.aheadbuffer_rover == this.aheadbuffer_len) {
                    this.aheadbuffer_rover = 0;
                }
                double b = this.aheadbuffer[this.aheadbuffer_rover] * currentamp;
                this.aheadbuffer[this.aheadbuffer_rover] = this.stockbuffer[i];
                ++this.aheadbuffer_rover;
                if (b > 1.0) {
                    b = 1.0;
                } else if (b < -1.0) {
                    b = -1.0;
                }
                int n = i++;
                buffer[n] = buffer[n] + b;
            }
            this.currentamp = currentamp;
            return ret;
        }

        public int replace(double[] buffer, int start, int end) {
            if (this.stockbuffer == null) {
                this.stockbuffer = new double[buffer.length];
            } else if (this.stockbuffer.length < buffer.length) {
                this.stockbuffer = new double[buffer.length];
            }
            int ret = this.inputstream.replace(this.stockbuffer, start, end);
            double currentamp = this.currentamp;
            end = start + ret;
            double aheadbuffer_releasetime = this.aheadbuffer_releasetime;
            int i = start;
            while (i < end) {
                if (this.aheadbuffer_rover % this.aheadbuffer_scaninterval == 0) {
                    double agc_max = 0.0;
                    int j = 0;
                    while (j < this.aheadbuffer_len) {
                        double s = Math.abs(this.aheadbuffer[j]);
                        if (s > agc_max) {
                            agc_max = s;
                        }
                        ++j;
                    }
                    if (1.0 / (agc_max *= 1.1) - this.plannedamp < 0.0) {
                        this.plannedamp = 1.0 / agc_max;
                        double ampcorrection = this.plannedamp - currentamp;
                        this.amp_stepping = ampcorrection / (double)this.aheadbuffer_scaninterval;
                    }
                    if (agc_max < 1.0) {
                        agc_max = 1.0;
                    }
                    if (1.0 / agc_max - this.plannedamp > 0.2) {
                        this.plannedamp = 1.0 / agc_max;
                        this.amp_stepping = 1.0;
                    }
                }
                if (this.amp_stepping != 0.0) {
                    if (this.amp_stepping > 0.0) {
                        if ((currentamp *= aheadbuffer_releasetime) > this.plannedamp) {
                            currentamp = this.plannedamp;
                            this.amp_stepping = 0.0;
                        }
                    } else if ((currentamp += this.amp_stepping) < this.plannedamp) {
                        currentamp = this.plannedamp;
                        this.amp_stepping = 0.0;
                    }
                }
                if (this.aheadbuffer_rover == this.aheadbuffer_len) {
                    this.aheadbuffer_rover = 0;
                }
                double b = this.aheadbuffer[this.aheadbuffer_rover] * currentamp;
                this.aheadbuffer[this.aheadbuffer_rover] = this.stockbuffer[i];
                ++this.aheadbuffer_rover;
                if (b > 1.0) {
                    b = 1.0;
                } else if (b < -1.0) {
                    b = -1.0;
                }
                buffer[i] = b;
                ++i;
            }
            this.currentamp = currentamp;
            return ret;
        }

        public int isStatic(double[] buffer, int len) {
            return -1;
        }

        public void close() {
            this.inputstream.close();
        }
    }
}

