/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.midi;

import java.util.Arrays;
import rasmus.interpreter.NameSpace;
import rasmus.interpreter.Variable;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.sampled.AudioCache;
import rasmus.interpreter.sampled.AudioEvent;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;
import rasmus.interpreter.sampled.AudioStreamable;
import rasmus.interpreter.sampled.midi.AudioVoiceFactoryInstance;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.Unit;
import rasmus.interpreter.unit.UnitInstance;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class AudioVoiceInstance
extends UnitInstanceAdapter
implements AudioStreamable {
    Variable output;
    Variable note;
    Variable velocity;
    Variable active;
    Variable answer;
    Variable tuning;
    AudioVoiceFactoryInstance factory;
    Variable tuning_out = null;
    UnitInstance tuning_instance = null;
    Variable pitch;
    NameSpace namespace;

    public AudioStream openStream(AudioSession session) {
        return new AudioVoiceStream(session);
    }

    public AudioVoiceInstance(AudioVoiceFactoryInstance factory, Parameters parameters) {
        this.factory = factory;
        this.namespace = parameters.getNameSpace();
        this.pitch = parameters.getParameter("pitch");
        this.output = parameters.getParameterWithDefault("output");
        this.note = parameters.getParameterWithDefault(1, "note");
        this.velocity = parameters.getParameterWithDefault(2, "velocity");
        this.active = parameters.getParameterWithDefault(3, "active");
        this.tuning = parameters.getParameter(4, "tuning");
        if (this.tuning != null) {
            this.tuning_out = new Variable();
            Parameters p = new Parameters(this.namespace);
            p.setParameter("output", this.tuning_out);
            p.setParameter(1, this.note);
            this.tuning_instance = Unit.newInstance(this.tuning, p);
        }
        this.answer = AudioEvents.asVariable(new AudioEvent(0.0, this));
        this.output.add(this.answer);
    }

    public void calc() {
    }

    public void close() {
        this.output.remove(this.answer);
        if (this.tuning_instance != null) {
            this.tuning_instance.close();
        }
    }

    class AudioVoiceStream
    implements AudioStream {
        static final double MINUS40DB = 0.01;
        static final double MINUS60DB = 0.001;
        static final double MINUS70DB = 3.16228E-4;
        static final double MINUS80DB = 1.0E-4;
        static final double MINUS100DB = 1.0E-5;
        static final double MOD_CONVEX_START_FACTOR = 1.0E-4;
        AudioSession session;
        AudioStream samplestream = null;
        AudioCache audiocache;
        int channels;
        boolean eof = false;
        double streamfactor = 0.0;
        double velocity;
        double rate;
        int volEnvMode = 0;
        double volEnvAttackStep = 0.0;
        double volEnvDecayStep = 0.0;
        double volEnvReleaseStep = 0.0;
        double volEnvSustain = 0.0;
        double volEnvCurrentValue = 0.0;
        long volHoldCounter = 0L;
        long volDelayCounter = 0L;
        int modEnvMode_Pitch = 0;
        int modEnvMode_Freq = 0;
        boolean modEnvActive = false;
        double modEnvAttackOffset_Freq = 0.0;
        double modEnvAttackStep_Freq = 0.0;
        double modEnvDecayStep_Freq = 0.0;
        double modEnvReleaseStep_Freq = 0.0;
        double modEnvAttackOffset_Pitch = 0.0;
        double modEnvAttackStep_Pitch = 0.0;
        double modEnvDecayStep_Pitch = 0.0;
        double modEnvReleaseStep_Pitch = 0.0;
        long modEnvAttackCounter = 0L;
        double modEnvReleaseTime = 0.0;
        boolean modEnvReleaseCalculated_Pitch = false;
        boolean modEnvReleaseCalculated_Freq = false;
        double modEnvSustain = 1.0;
        double modEnvCurrentValue_Freq = 1.0;
        double modEnvCurrentValue_Pitch = 1.0;
        long modHoldCounter_Freq = 0L;
        long modDelayCounter_Freq = 0L;
        long modHoldCounter_Pitch = 0L;
        long modDelayCounter_Pitch = 0L;
        boolean modEnvEof_Pitch = false;
        boolean modEnvEof_Freq = false;
        double modEnvToFilterFc = 0.0;
        double modEnvToPitch = 0.0;
        double initialFilterFc = 0.0;
        double initialFilterQ = 0.0;
        double currentFilterFc = 0.0;
        double[] channelsVols;
        double a0;
        double a1;
        double a2;
        double b1;
        double b2;
        double q;
        double xn_2 = 0.0;
        double xn_1 = 0.0;
        double yn_2 = 0.0;
        double yn_1 = 0.0;
        boolean vibActive = false;
        boolean modActive = false;
        double vibCounter = 0.0;
        double modCounter = 0.0;
        double freqModLFO_step;
        double freqVibLFO_step;
        int delayModLFO_counter = 0;
        int delayVibLFO_counter = 0;
        double[] lfoTable_vibToPitch = null;
        double[] lfoTable_modToPitch = null;
        double[] lfoTable_modToFilterFc = null;
        double[] lfoTable_modToVolume = null;
        double v0 = 0.0;
        double v1 = 0.0;
        double s = 0.0;
        double dc = 0.0;
        double currentfreq = 0.0;
        double currentfreqmod = 1.0;
        boolean b_lowpass;
        AudioStream pitchstream = null;
        AudioStream activestream = null;
        boolean activestream_eof = false;
        double[] rbuffer = new double[2048];
        double rbuffer_pos = 2046.0;
        double[] sbuff = new double[1];

        public void initLP(double cutoff, double resonancedB) {
            double c;
            this.currentfreq = cutoff;
            if (cutoff < 120.0) {
                cutoff = 120.0;
            }
            if ((c = 7.3303828583761845 * cutoff / this.rate) > 1.382300767579509) {
                c = 1.382300767579509;
            }
            this.a0 = Math.sqrt(1.0 - Math.cos(c)) * Math.sqrt(1.5707963267948966);
            if (resonancedB < 0.0) {
                resonancedB = 0.0;
            }
            if (resonancedB > 20.0) {
                resonancedB = 20.0;
            }
            this.q = Math.sqrt(0.5) * Math.pow(10.0, -(resonancedB / 20.0));
        }

        public void calcLP(double[] buffer, int start, int end) {
            double c = this.a0;
            double r = this.q;
            double v1 = this.v1;
            double v0 = this.v0;
            int recalcrate = (int)(this.rate / 100.0);
            int i = start;
            while (i < end) {
                int len = i + recalcrate;
                if (len > end) {
                    len = end;
                }
                if (v1 > 0.0) {
                    if (v1 < 1.0E-10) {
                        v1 = 0.0;
                    }
                } else if (v1 > -1.0E-10) {
                    v1 = 0.0;
                }
                while (i < len) {
                    v0 = (1.0 - r * c) * v0 - c * v1 + c * buffer[i];
                    buffer[i] = v1 = (1.0 - r * c) * v1 + c * v0;
                    ++i;
                }
            }
            this.v1 = v1;
            this.v0 = v0;
        }

        public void calcLP(double[] buffer, double[] freq, int start, int end) {
            double a0 = this.a0;
            double r = this.q;
            double v1 = this.v1;
            double v0 = this.v0;
            double a0_delta = 0.0;
            int recalcrate = (int)(this.rate / 250.0);
            int i = start;
            while (i < end) {
                int len = i + recalcrate;
                if (len > end) {
                    len = end;
                }
                if (this.currentfreqmod != freq[len - 1]) {
                    double c;
                    this.currentfreqmod = freq[len - 1];
                    double cutoff = this.initialFilterFc * freq[len - 1];
                    if (cutoff < 120.0) {
                        cutoff = 120.0;
                    }
                    if ((c = 7.3303828583761845 * cutoff / this.rate) > 1.382300767579509) {
                        c = 1.382300767579509;
                    }
                    double a0_new = Math.sqrt(1.0 - Math.cos(c)) * Math.sqrt(1.5707963267948966);
                    double fixlen = len - i;
                    a0_delta = (a0_new - a0) / fixlen;
                }
                if (v1 > 0.0) {
                    if (v1 < 1.0E-10) {
                        v1 = 0.0;
                    }
                } else if (v1 > -1.0E-10) {
                    v1 = 0.0;
                }
                while (i < len) {
                    v0 = (1.0 - r * (a0 += a0_delta)) * v0 - a0 * v1 + a0 * buffer[i];
                    buffer[i] = v1 = (1.0 - r * a0) * v1 + a0 * v0;
                    ++i;
                }
                a0_delta = 0.0;
            }
            if (end - start > 0) {
                double c;
                this.currentfreqmod = freq[end - 1];
                double cutoff = this.initialFilterFc * freq[end - 1];
                if (cutoff < 120.0) {
                    cutoff = 120.0;
                }
                if ((c = 7.3303828583761845 * cutoff / this.rate) > 1.382300767579509) {
                    c = 1.382300767579509;
                }
                a0 = Math.sqrt(1.0 - Math.cos(c)) * Math.sqrt(1.5707963267948966);
            }
            this.v1 = v1;
            this.v0 = v0;
            this.a0 = a0;
        }

        public void initLP2(double cutoff, double resonancedB) {
            this.currentfreq = cutoff;
            double c = 1.0 / Math.tan(Math.PI * (cutoff / this.rate));
            double csq = c * c;
            double resonance = Math.pow(10.0, -(resonancedB / 20.0));
            this.q = Math.sqrt(2.0) * resonance;
            this.a0 = 1.0 / (1.0 + this.q * c + csq);
            this.a1 = 2.0 * this.a0;
            this.a2 = this.a0;
            this.b1 = 2.0 * this.a0 * (1.0 - csq);
            this.b2 = this.a0 * (1.0 - this.q * c + csq);
        }

        public void calcLP2(double[] buffer, int start, int end) {
            double a0 = this.a0;
            double a1 = this.a1;
            double a2 = this.a2;
            double b1 = this.b1;
            double b2 = this.b2;
            double xn_1 = this.xn_1;
            double xn_2 = this.xn_2;
            double yn_1 = this.yn_1;
            double yn_2 = this.yn_2;
            int recalcrate = (int)(this.rate / 100.0);
            int i = start;
            while (i < end) {
                int len = i + recalcrate;
                if (len > end) {
                    len = end;
                }
                while (i < len) {
                    double yn;
                    double xn = buffer[i];
                    buffer[i] = yn = a0 * xn + a1 * xn_1 + a2 * xn_2 - b1 * yn_1 - b2 * yn_2;
                    xn_2 = xn_1;
                    xn_1 = xn;
                    yn_2 = yn_1;
                    yn_1 = yn;
                    ++i;
                }
                if (yn_1 > 0.0) {
                    if (yn_1 < 1.0E-10) {
                        yn_1 = 0.0;
                    }
                } else if (yn_1 > -1.0E-10) {
                    yn_1 = 0.0;
                }
                if (yn_2 > 0.0) {
                    if (!(yn_2 < 1.0E-10)) continue;
                    yn_2 = 0.0;
                    continue;
                }
                if (!(yn_2 > -1.0E-10)) continue;
                yn_2 = 0.0;
            }
            this.xn_1 = xn_1;
            this.xn_2 = xn_2;
            this.yn_1 = yn_1;
            this.yn_2 = yn_2;
        }

        public void calcLP2(double[] buffer, double[] freq, int start, int end) {
            double initialFilterFc = this.initialFilterFc;
            double a0 = this.a0;
            double a1 = this.a1;
            double a2 = this.a2;
            double b1 = this.b1;
            double b2 = this.b2;
            double q = this.q;
            double rate = this.rate;
            double xn_1 = this.xn_1;
            double xn_2 = this.xn_2;
            double yn_1 = this.yn_1;
            double yn_2 = this.yn_2;
            double currentfreqmod = this.currentfreqmod;
            int recalcrate = (int)(rate / 100.0);
            int i = start;
            while (i < end) {
                int len = i + recalcrate;
                if (len > end) {
                    len = end;
                }
                if (currentfreqmod != freq[i]) {
                    currentfreqmod = freq[i];
                    double calcfreq = initialFilterFc * freq[i];
                    if (calcfreq < 200.0) {
                        calcfreq = 200.0;
                    }
                    if (calcfreq > rate * 0.45) {
                        calcfreq = rate * 0.45;
                    }
                    double c = 1.0 / Math.tan(Math.PI * (calcfreq / rate));
                    double csq = c * c;
                    a0 = 1.0 / (1.0 + q * c + csq);
                    a1 = 2.0 * a0;
                    a2 = a0;
                    b1 = 2.0 * a0 * (1.0 - csq);
                    b2 = a0 * (1.0 - q * c + csq);
                }
                if (yn_1 > 0.0) {
                    if (yn_1 < 1.0E-10) {
                        yn_1 = 0.0;
                    }
                } else if (yn_1 > -1.0E-10) {
                    yn_1 = 0.0;
                }
                if (yn_2 > 0.0) {
                    if (yn_2 < 1.0E-10) {
                        yn_2 = 0.0;
                    }
                } else if (yn_2 > -1.0E-10) {
                    yn_2 = 0.0;
                }
                while (i < len) {
                    double yn;
                    double xn = buffer[i];
                    buffer[i] = yn = a0 * xn + a1 * xn_1 + a2 * xn_2 - b1 * yn_1 - b2 * yn_2;
                    xn_2 = xn_1;
                    xn_1 = xn;
                    yn_2 = yn_1;
                    yn_1 = yn;
                    ++i;
                }
            }
            this.currentfreqmod = currentfreqmod;
            this.a0 = a0;
            this.a1 = a1;
            this.a2 = a2;
            this.b1 = b1;
            this.b2 = b2;
            this.xn_1 = xn_1;
            this.xn_2 = xn_2;
            this.yn_1 = yn_1;
            this.yn_2 = yn_2;
        }

        public AudioVoiceStream(AudioSession session) {
            long l_decay;
            long l_attack;
            double holdKeyNumModifier;
            if (AudioVoiceInstance.this.pitch != null) {
                this.pitchstream = AudioEvents.openStream(AudioVoiceInstance.this.pitch, session.getMonoSession());
            }
            this.activestream = AudioEvents.openStream(AudioVoiceInstance.this.active, session.getMonoSession());
            this.session = session;
            this.b_lowpass = AudioVoiceInstance.this.factory.b_lowpass;
            if (AudioVoiceInstance.this.factory.d_initialFilterFc >= 19900.0) {
                this.b_lowpass = false;
            }
            this.audiocache = session.getAudioCache();
            this.rate = session.getRate();
            this.channels = session.getChannels();
            this.delayModLFO_counter = (int)(this.rate * AudioVoiceInstance.this.factory.d_delayModLFO);
            this.delayVibLFO_counter = (int)(this.rate * AudioVoiceInstance.this.factory.d_delayVibLFO);
            this.freqModLFO_step = AudioVoiceInstance.this.factory.d_freqModLFO / this.rate * 512.0;
            this.freqVibLFO_step = AudioVoiceInstance.this.factory.d_freqVibLFO / this.rate * 512.0;
            this.lfoTable_vibToPitch = AudioVoiceInstance.this.factory.lfoTable_vibToPitch;
            this.lfoTable_modToPitch = AudioVoiceInstance.this.factory.lfoTable_modToPitch;
            this.lfoTable_modToFilterFc = AudioVoiceInstance.this.factory.lfoTable_modToFilterFc;
            this.lfoTable_modToVolume = AudioVoiceInstance.this.factory.lfoTable_modToVolume;
            if (this.lfoTable_vibToPitch != null) {
                this.vibActive = true;
            }
            if (this.lfoTable_modToPitch != null) {
                this.modActive = true;
            }
            if (this.lfoTable_modToFilterFc != null) {
                this.modActive = true;
            }
            if (this.lfoTable_modToVolume != null) {
                this.modActive = true;
            }
            int i_note = (int)DoublePart.asDouble(AudioVoiceInstance.this.note);
            double i_velocity = DoublePart.asDouble(AudioVoiceInstance.this.velocity);
            if (AudioVoiceInstance.this.factory.i_keynum != -1) {
                i_note = AudioVoiceInstance.this.factory.i_keynum;
            }
            if (AudioVoiceInstance.this.factory.i_velocity != -1) {
                i_velocity = (double)AudioVoiceInstance.this.factory.i_velocity / 127.0;
            }
            AudioEvents audioevents = AudioEvents.getInstance(AudioVoiceInstance.this.factory.sample);
            if (audioevents.track.size() == 1) {
                AudioEvent aevent = (AudioEvent)audioevents.track.get(0);
                if (aevent.start == 0.0) {
                    this.samplestream = aevent.streamable.openStream(session.getMonoSession());
                }
            }
            if (this.samplestream == null) {
                this.samplestream = AudioEvents.openStream(AudioVoiceInstance.this.factory.sample, session.getMonoSession());
            }
            this.streamfactor = AudioVoiceInstance.this.factory.d_scaleTune == 0.0 ? AudioVoiceInstance.this.factory.d_sampleRate / this.rate : (AudioVoiceInstance.this.tuning_out != null ? AudioVoiceInstance.this.factory.d_sampleRate / this.rate * Math.pow(AudioVoiceInstance.this.factory.d_scaleTune, AudioVoiceInstance.this.factory.d_coarseTune / 12.0) * DoublePart.asDouble(AudioVoiceInstance.this.tuning_out) : AudioVoiceInstance.this.factory.d_sampleRate / this.rate * Math.pow(AudioVoiceInstance.this.factory.d_scaleTune, (AudioVoiceInstance.this.factory.d_coarseTune + (double)i_note) / 12.0));
            this.velocity = AudioVoiceInstance.this.factory.d_initialAttenuation * i_velocity;
            if (this.velocity == 0.0) {
                this.eof = true;
            }
            this.channelsVols = AudioVoiceInstance.this.factory.d_channelsVols;
            this.initialFilterFc = this.velocity < 0.5 ? AudioVoiceInstance.this.factory.d_initialFilterFc * (this.velocity * 2.0 * 0.75 + 0.25) : AudioVoiceInstance.this.factory.d_initialFilterFc;
            if (this.initialFilterFc > 20000.0) {
                this.initialFilterFc = 20000.0;
            }
            this.initialFilterQ = AudioVoiceInstance.this.factory.d_initialFilterQ;
            if (this.b_lowpass) {
                if (this.initialFilterQ < 0.0) {
                    this.initialFilterQ = 0.0;
                }
                if (this.initialFilterQ != 0.0) {
                    this.velocity *= Math.pow(10.0, -this.initialFilterQ / 40.0);
                }
                this.initLP(this.initialFilterFc, this.initialFilterQ);
            }
            if (AudioVoiceInstance.this.factory.d_modEnvToFilterFc != 0.0 || AudioVoiceInstance.this.factory.d_modEnvToPitch != 0.0) {
                this.modEnvToFilterFc = AudioVoiceInstance.this.factory.d_modEnvToFilterFc;
                this.modEnvToPitch = AudioVoiceInstance.this.factory.d_modEnvToPitch;
                this.modEnvActive = true;
                double decayKeyNumModifier = AudioVoiceInstance.this.factory.d_keynumToModEnvDecay != 0.0 ? Math.pow(2.0, (double)(-((i_note - 60) / 12)) * AudioVoiceInstance.this.factory.d_keynumToModEnvDecay) : 1.0;
                holdKeyNumModifier = AudioVoiceInstance.this.factory.d_keynumToModEnvHold != 0.0 ? Math.pow(2.0, (double)(-((i_note - 60) / 12)) * AudioVoiceInstance.this.factory.d_keynumToModEnvHold) : 1.0;
                l_attack = (long)(AudioVoiceInstance.this.factory.d_attackModEnv * this.rate * 0.5);
                l_decay = (long)(decayKeyNumModifier * AudioVoiceInstance.this.factory.d_decayModEnv * this.rate * 0.5);
                long l_release = (long)(AudioVoiceInstance.this.factory.d_releaseModEnv * this.rate * 0.5);
                this.modEnvSustain = AudioVoiceInstance.this.factory.d_sustainModEnv;
                this.modHoldCounter_Freq = (long)(holdKeyNumModifier * AudioVoiceInstance.this.factory.d_holdModEnv * this.rate);
                this.modDelayCounter_Freq = (long)(AudioVoiceInstance.this.factory.d_delayVolEnv * this.rate);
                this.modHoldCounter_Pitch = (long)(holdKeyNumModifier * AudioVoiceInstance.this.factory.d_holdModEnv * this.rate);
                this.modDelayCounter_Pitch = (long)(AudioVoiceInstance.this.factory.d_delayVolEnv * this.rate);
                this.modEnvCurrentValue_Freq = 1.0;
                this.modEnvCurrentValue_Pitch = 1.0;
                if (l_attack == 0L) {
                    this.modEnvMode_Pitch = 1;
                    this.modEnvMode_Freq = 1;
                    this.modEnvCurrentValue_Freq = Math.pow(2.0, this.modEnvToFilterFc);
                    this.modEnvCurrentValue_Pitch = Math.pow(2.0, this.modEnvToPitch);
                } else {
                    this.modEnvAttackOffset_Pitch = Math.pow(2.0, this.modEnvToPitch);
                    this.modEnvAttackOffset_Freq = Math.pow(2.0, this.modEnvToFilterFc);
                    this.modEnvAttackCounter = l_attack;
                    this.modEnvAttackStep_Pitch = Math.pow(1.0E-4, 1.0 / (double)l_attack);
                    this.modEnvAttackStep_Freq = Math.pow(1.0E-4, 1.0 / (double)l_attack);
                }
                if (l_decay != 0L) {
                    this.modEnvDecayStep_Pitch = Math.pow(Math.pow(2.0, this.modEnvSustain * this.modEnvToPitch) / Math.pow(2.0, this.modEnvToPitch), 1.0 / (double)l_decay);
                    this.modEnvDecayStep_Freq = Math.pow(Math.pow(2.0, this.modEnvSustain * this.modEnvToFilterFc) / Math.pow(2.0, this.modEnvToFilterFc), 1.0 / (double)l_decay);
                }
                if (l_release != 0L) {
                    this.modEnvReleaseTime = l_release;
                    this.modEnvReleaseCalculated_Pitch = false;
                    this.modEnvReleaseCalculated_Freq = false;
                }
            }
            double decayKeyNumModifier = AudioVoiceInstance.this.factory.d_keynumToVolEnvDecay != 0.0 ? Math.pow(2.0, (double)(-((i_note - 60) / 12)) * AudioVoiceInstance.this.factory.d_keynumToVolEnvDecay) : 1.0;
            holdKeyNumModifier = AudioVoiceInstance.this.factory.d_keynumToVolEnvHold != 0.0 ? Math.pow(2.0, (double)(-((i_note - 60) / 12)) * AudioVoiceInstance.this.factory.d_keynumToVolEnvHold) : 1.0;
            l_attack = (long)(AudioVoiceInstance.this.factory.d_attackVolEnv * this.rate);
            l_decay = (long)(decayKeyNumModifier * AudioVoiceInstance.this.factory.d_decayVolEnv * this.rate);
            double f_sustain = AudioVoiceInstance.this.factory.d_sustainVolEnv * this.velocity;
            long l_release = (long)(AudioVoiceInstance.this.factory.d_releaseVolEnv * this.rate);
            this.volHoldCounter = (long)(holdKeyNumModifier * AudioVoiceInstance.this.factory.d_holdVolEnv * this.rate);
            this.volDelayCounter = (long)(AudioVoiceInstance.this.factory.d_delayVolEnv * this.rate);
            this.volEnvSustain = f_sustain;
            if (l_attack == 0L) {
                this.volEnvMode = 1;
                this.volEnvCurrentValue = this.velocity;
            } else {
                this.volEnvAttackStep = this.velocity / (double)l_attack;
            }
            if (l_decay != 0L) {
                this.volEnvDecayStep = Math.pow(f_sustain / this.velocity, 1.0 / (double)l_decay);
            }
            if (l_release != 0L) {
                this.volEnvReleaseStep = Math.pow(1.0E-5 / this.velocity, 1.0 / (double)l_release);
            }
        }

        public void readNextInputBuffer() {
            int i = 0;
            while (i < 2) {
                this.rbuffer[i] = this.rbuffer[i + 2048 - 2];
                ++i;
            }
            int ret = this.samplestream.replace(this.rbuffer, 2, 2048);
            if (ret == -1) {
                Arrays.fill(this.rbuffer, 2, 2048, 0.0);
                this.eof = true;
            } else if (ret != 2046) {
                Arrays.fill(this.rbuffer, ret + 2, 2048, 0.0);
            }
        }

        public int readActiveStream(int len) {
            if (this.activestream_eof) {
                return 0;
            }
            int clen = len / this.channels;
            int ret = this.activestream.isStatic(this.sbuff, clen);
            if (ret != -1) {
                if (this.sbuff[0] < 0.5) {
                    this.activestream_eof = true;
                    return 0;
                }
                if (ret != clen) {
                    this.activestream_eof = true;
                }
                return ret * this.channels;
            }
            double[] cbuffer = this.audiocache.getBuffer(clen);
            ret = this.activestream.replace(cbuffer, 0, clen);
            if (ret == -1) {
                this.audiocache.returnBuffer(cbuffer);
                this.activestream_eof = true;
                return 0;
            }
            int i = 0;
            while (i < clen) {
                if (cbuffer[i] < 0.5) {
                    this.audiocache.returnBuffer(cbuffer);
                    this.activestream_eof = true;
                    return i * this.channels;
                }
                ++i;
            }
            this.audiocache.returnBuffer(cbuffer);
            if (ret != clen) {
                this.activestream_eof = true;
            }
            return ret * this.channels;
        }

        public int mix(double[] buffer, int start, int end) {
            int activelen = this.readActiveStream(end - start);
            if (activelen == 0) {
                return this.mix(buffer, start, end, false);
            }
            if (activelen == end - start) {
                return this.mix(buffer, start, end, true);
            }
            int bend = start + activelen;
            int ret = this.mix(buffer, start, bend, true);
            if (ret < bend - start) {
                return ret;
            }
            int ret2 = this.mix(buffer, bend, end, false);
            if (ret == -1) {
                return ret;
            }
            return ret + ret2;
        }

        /*
         * Unable to fully structure code
         */
        public int mix(double[] buffer, int start, int end, boolean active) {
            block165: {
                block166: {
                    block160: {
                        block169: {
                            block167: {
                                block159: {
                                    block168: {
                                        block164: {
                                            block161: {
                                                block157: {
                                                    block162: {
                                                        block156: {
                                                            block163: {
                                                                if (this.eof) {
                                                                    return -1;
                                                                }
                                                                noteActive = active;
                                                                channels = this.channels;
                                                                cstart = start / channels;
                                                                cend = end / channels;
                                                                cbuffer = this.audiocache.getBuffer(cend);
                                                                dynamic_pitch = false;
                                                                constantPitch = false;
                                                                vibStart = cend;
                                                                modStart = cend;
                                                                if (this.vibActive) {
                                                                    if (this.delayVibLFO_counter != 0) {
                                                                        this.delayVibLFO_counter -= cend - cstart;
                                                                        if (this.delayVibLFO_counter < 0) {
                                                                            vibStart += this.delayVibLFO_counter;
                                                                            this.delayVibLFO_counter = 0;
                                                                        }
                                                                    } else {
                                                                        vibStart = cstart;
                                                                    }
                                                                }
                                                                if (this.modActive) {
                                                                    if (this.delayModLFO_counter != 0) {
                                                                        this.delayModLFO_counter -= cend - cstart;
                                                                        if (this.delayModLFO_counter < 0) {
                                                                            modStart += this.delayModLFO_counter;
                                                                            this.delayModLFO_counter = 0;
                                                                        }
                                                                    } else {
                                                                        modStart = cstart;
                                                                    }
                                                                }
                                                                if (!this.modEnvActive || this.modEnvToPitch == 0.0 || this.modEnvEof_Pitch) break block161;
                                                                dynamic_pitch = true;
                                                                modEnvCurrentValue_Pitch = this.modEnvCurrentValue_Pitch;
                                                                ix = cstart;
                                                                if (!noteActive) break block162;
                                                                if (this.modDelayCounter_Pitch != 0L) {
                                                                    if (this.modDelayCounter_Pitch > (long)(cend - ix)) {
                                                                        i = ix;
                                                                        while (i < cend) {
                                                                            cbuffer[i] = modEnvCurrentValue_Pitch;
                                                                            ++i;
                                                                        }
                                                                        this.modDelayCounter_Pitch -= (long)(cend - ix);
                                                                    } else {
                                                                        i = ix;
                                                                        while ((long)i < (long)ix + this.modDelayCounter_Pitch) {
                                                                            cbuffer[i] = modEnvCurrentValue_Pitch;
                                                                            ++i;
                                                                        }
                                                                        ix = (int)((long)ix + this.modDelayCounter_Pitch);
                                                                        this.modDelayCounter_Pitch = 0L;
                                                                    }
                                                                }
                                                                if (this.modEnvMode_Pitch == 0) {
                                                                    modEnvToPitch = Math.pow(2.0, this.modEnvToPitch);
                                                                    modEnvAttackStep_Pitch = this.modEnvAttackStep_Pitch;
                                                                    while (ix < cend) {
                                                                        modEnvCurrentValue_Pitch = (modEnvCurrentValue_Pitch - this.modEnvAttackOffset_Pitch) * modEnvAttackStep_Pitch + this.modEnvAttackOffset_Pitch;
                                                                        if (this.modEnvAttackCounter == 0L) {
                                                                            modEnvCurrentValue_Pitch = modEnvToPitch;
                                                                            this.modEnvMode_Pitch = 1;
                                                                            break;
                                                                        }
                                                                        --this.modEnvAttackCounter;
                                                                        cbuffer[ix] = modEnvCurrentValue_Pitch;
                                                                        ++ix;
                                                                    }
                                                                }
                                                                if (this.modEnvMode_Pitch == 1) {
                                                                    if (this.modHoldCounter_Pitch == 0L) {
                                                                        this.modEnvMode_Pitch = 2;
                                                                    }
                                                                    if (this.modHoldCounter_Pitch > (long)(cend - ix)) {
                                                                        i = ix;
                                                                        while (i < cend) {
                                                                            cbuffer[i] = modEnvCurrentValue_Pitch;
                                                                            ++i;
                                                                        }
                                                                        this.modHoldCounter_Pitch -= (long)(cend - ix);
                                                                    } else {
                                                                        this.modEnvMode_Pitch = 2;
                                                                        i = ix;
                                                                        while ((long)i < (long)ix + this.modHoldCounter_Pitch) {
                                                                            cbuffer[i] = modEnvCurrentValue_Pitch;
                                                                            ++i;
                                                                        }
                                                                        ix = (int)((long)ix + this.modHoldCounter_Pitch);
                                                                    }
                                                                }
                                                                if (this.modEnvMode_Pitch != 2) break block156;
                                                                if (this.modEnvDecayStep_Pitch != 0.0) break block163;
                                                                this.modEnvMode_Pitch = 3;
                                                                break block156;
                                                            }
                                                            sustain = Math.pow(2.0, this.modEnvSustain * this.modEnvToPitch);
                                                            envStep = this.modEnvDecayStep_Pitch;
                                                            if (!(envStep >= 1.0)) ** GOTO lbl103
                                                            while (ix < cend) {
                                                                if ((modEnvCurrentValue_Pitch *= envStep) >= sustain) {
                                                                    modEnvCurrentValue_Pitch = sustain;
                                                                    this.modEnvMode_Pitch = 3;
                                                                    break block156;
                                                                }
                                                                cbuffer[ix] = modEnvCurrentValue_Pitch;
                                                                ++ix;
                                                            }
                                                            break block156;
lbl-1000:
                                                            // 1 sources

                                                            {
                                                                if ((modEnvCurrentValue_Pitch *= envStep) <= sustain) {
                                                                    modEnvCurrentValue_Pitch = sustain;
                                                                    this.modEnvMode_Pitch = 3;
                                                                    break;
                                                                }
                                                                cbuffer[ix] = modEnvCurrentValue_Pitch;
                                                                ++ix;
lbl103:
                                                                // 2 sources

                                                                ** while (ix < cend)
                                                            }
                                                        }
                                                        if (this.modEnvMode_Pitch == 3) {
                                                            if (ix == 0) {
                                                                constantPitch = true;
                                                            } else {
                                                                i = ix;
                                                                while (i < cend) {
                                                                    cbuffer[i] = modEnvCurrentValue_Pitch;
                                                                    ++i;
                                                                }
                                                            }
                                                            ix = cend;
                                                        }
                                                        break block157;
                                                    }
                                                    if (!this.modEnvReleaseCalculated_Pitch) {
                                                        this.modEnvReleaseCalculated_Pitch = true;
                                                        this.modEnvReleaseStep_Pitch = this.modEnvReleaseTime != 0.0 ? Math.pow(1.0 / modEnvCurrentValue_Pitch, 1.0 / this.modEnvReleaseTime) : 1.0;
                                                    }
                                                    if (!((envStep = this.modEnvReleaseStep_Pitch) >= 1.0)) ** GOTO lbl134
                                                    while (ix < cend) {
                                                        if ((modEnvCurrentValue_Pitch *= envStep) >= 1.0) {
                                                            this.modEnvEof_Pitch = true;
                                                            break block157;
                                                        }
                                                        cbuffer[ix] = modEnvCurrentValue_Pitch;
                                                        ++ix;
                                                    }
                                                    break block157;
lbl-1000:
                                                    // 1 sources

                                                    {
                                                        if ((modEnvCurrentValue_Pitch *= envStep) <= 1.0) {
                                                            this.modEnvEof_Pitch = true;
                                                            break;
                                                        }
                                                        cbuffer[ix] = modEnvCurrentValue_Pitch;
                                                        ++ix;
lbl134:
                                                        // 2 sources

                                                        ** while (ix < cend)
                                                    }
                                                }
                                                Arrays.fill(cbuffer, ix, cend, modEnvCurrentValue_Pitch);
                                                this.modEnvCurrentValue_Pitch = modEnvCurrentValue_Pitch;
                                            }
                                            if (this.vibActive && vibStart != -1 && this.lfoTable_vibToPitch != null) {
                                                ix = this.vibCounter;
                                                ix_step = this.freqVibLFO_step;
                                                ix_len = 512.0;
                                                ix_table = this.lfoTable_vibToPitch;
                                                if (dynamic_pitch) {
                                                    if (!constantPitch) {
                                                        i = vibStart;
                                                        while (i < cend) {
                                                            v0 = i;
                                                            cbuffer[v0] = cbuffer[v0] * ix_table[(int)ix];
                                                            if ((ix += ix_step) > ix_len) {
                                                                ix %= ix_len;
                                                            }
                                                            ++i;
                                                        }
                                                    } else {
                                                        constantPitch = false;
                                                        Arrays.fill(cbuffer, cstart, vibStart, this.modEnvCurrentValue_Pitch);
                                                        i = vibStart;
                                                        while (i < cend) {
                                                            cbuffer[i] = this.modEnvCurrentValue_Pitch * ix_table[(int)ix];
                                                            if ((ix += ix_step) > ix_len) {
                                                                ix %= ix_len;
                                                            }
                                                            ++i;
                                                        }
                                                    }
                                                } else {
                                                    i = cstart;
                                                    while (i < vibStart) {
                                                        cbuffer[i] = 1.0;
                                                        ++i;
                                                    }
                                                    i = vibStart;
                                                    while (i < cend) {
                                                        cbuffer[i] = ix_table[(int)ix];
                                                        if ((ix += ix_step) > ix_len) {
                                                            ix %= ix_len;
                                                        }
                                                        ++i;
                                                    }
                                                    dynamic_pitch = true;
                                                }
                                            }
                                            if (this.modActive && modStart != -1 && this.lfoTable_modToPitch != null) {
                                                ix = this.modCounter;
                                                ix_step = this.freqModLFO_step;
                                                ix_len = 512.0;
                                                ix_table = this.lfoTable_modToPitch;
                                                if (dynamic_pitch) {
                                                    if (!constantPitch) {
                                                        i = modStart;
                                                        while (i < cend) {
                                                            v1 = i;
                                                            cbuffer[v1] = cbuffer[v1] * ix_table[(int)ix];
                                                            if ((ix += ix_step) > ix_len) {
                                                                ix %= ix_len;
                                                            }
                                                            ++i;
                                                        }
                                                    } else {
                                                        constantPitch = false;
                                                        Arrays.fill(cbuffer, cstart, modStart, this.modEnvCurrentValue_Pitch);
                                                        i = modStart;
                                                        while (i < cend) {
                                                            cbuffer[i] = this.modEnvCurrentValue_Pitch * ix_table[(int)ix];
                                                            if ((ix += ix_step) > ix_len) {
                                                                ix %= ix_len;
                                                            }
                                                            ++i;
                                                        }
                                                    }
                                                } else {
                                                    i = cstart;
                                                    while (i < modStart) {
                                                        cbuffer[i] = 1.0;
                                                        ++i;
                                                    }
                                                    i = modStart;
                                                    while (i < cend) {
                                                        cbuffer[i] = ix_table[(int)ix];
                                                        if ((ix += ix_step) > ix_len) {
                                                            ix %= ix_len;
                                                        }
                                                        ++i;
                                                    }
                                                    dynamic_pitch = true;
                                                }
                                            }
                                            pitch = 1.0;
                                            if (this.pitchstream != null) {
                                                sbuffer = new double[1];
                                                ret = this.pitchstream.isStatic(sbuffer, cend - cstart);
                                                if (ret != -1) {
                                                    pitch = sbuffer[0];
                                                } else {
                                                    pbuffer = this.audiocache.getBuffer(cend);
                                                    ret = this.pitchstream.replace(pbuffer, cstart, cend);
                                                    if (ret == -1) {
                                                        ret = 0;
                                                        this.pitchstream.close();
                                                        this.pitchstream = null;
                                                    }
                                                    Arrays.fill(pbuffer, cstart + ret, cend, 1.0);
                                                    if (dynamic_pitch) {
                                                        if (!constantPitch) {
                                                            i = cstart;
                                                            while (i < cend) {
                                                                v2 = i;
                                                                cbuffer[v2] = cbuffer[v2] * pbuffer[i];
                                                                ++i;
                                                            }
                                                        } else {
                                                            constantPitch = false;
                                                            i = cstart;
                                                            while (i < cend) {
                                                                cbuffer[i] = pbuffer[i];
                                                                ++i;
                                                            }
                                                        }
                                                    } else {
                                                        i = cstart;
                                                        while (i < cend) {
                                                            cbuffer[i] = pbuffer[i];
                                                            ++i;
                                                        }
                                                        dynamic_pitch = true;
                                                    }
                                                    this.audiocache.returnBuffer(pbuffer);
                                                }
                                            }
                                            streamfactor = this.streamfactor * pitch;
                                            rbuffer = this.rbuffer;
                                            ix = cstart;
                                            rbuffer_pos = this.rbuffer_pos;
                                            if (!dynamic_pitch) ** GOTO lbl293
                                            if (!constantPitch) ** GOTO lbl282
                                            streamfactor *= this.modEnvCurrentValue_Pitch;
                                            while (ix < cend) {
                                                rbuffer_pos += streamfactor;
                                                while (rbuffer_pos >= 2046.0) {
                                                    rbuffer_pos -= 2046.0;
                                                    this.readNextInputBuffer();
                                                }
                                                interp = rbuffer_pos % 1.0;
                                                i_rbuffer_pos = (int)rbuffer_pos;
                                                cbuffer[ix] = rbuffer[i_rbuffer_pos] * (1.0 - interp) + rbuffer[i_rbuffer_pos + 1] * interp;
                                                ++ix;
                                            }
                                            break block164;
lbl-1000:
                                            // 1 sources

                                            {
                                                rbuffer_pos += streamfactor * cbuffer[ix];
                                                while (rbuffer_pos >= 2046.0) {
                                                    rbuffer_pos -= 2046.0;
                                                    this.readNextInputBuffer();
                                                }
                                                interp = rbuffer_pos % 1.0;
                                                i_rbuffer_pos = (int)rbuffer_pos;
                                                cbuffer[ix] = rbuffer[i_rbuffer_pos] * (1.0 - interp) + rbuffer[i_rbuffer_pos + 1] * interp;
                                                ++ix;
lbl282:
                                                // 2 sources

                                                ** while (ix < cend)
                                            }
lbl283:
                                            // 1 sources

                                            break block164;
lbl-1000:
                                            // 1 sources

                                            {
                                                rbuffer_pos += streamfactor;
                                                while (rbuffer_pos >= 2046.0) {
                                                    rbuffer_pos -= 2046.0;
                                                    this.readNextInputBuffer();
                                                }
                                                interp = rbuffer_pos % 1.0;
                                                i_rbuffer_pos = (int)rbuffer_pos;
                                                cbuffer[ix] = rbuffer[i_rbuffer_pos] * (1.0 - interp) + rbuffer[i_rbuffer_pos + 1] * interp;
                                                ++ix;
lbl293:
                                                // 2 sources

                                                ** while (ix < cend)
                                            }
                                        }
                                        this.rbuffer_pos = rbuffer_pos;
                                        volEnvCurrentValue = this.volEnvCurrentValue;
                                        ix = cstart;
                                        if (noteActive) {
                                            if (this.volDelayCounter != 0L) {
                                                if (this.volDelayCounter > (long)(cend - ix)) {
                                                    i = ix;
                                                    while (i < cend) {
                                                        v3 = i++;
                                                        cbuffer[v3] = cbuffer[v3] * volEnvCurrentValue;
                                                    }
                                                    this.volDelayCounter -= (long)(cend - ix);
                                                } else {
                                                    i = ix;
                                                    while ((long)i < (long)ix + this.volDelayCounter) {
                                                        v4 = i++;
                                                        cbuffer[v4] = cbuffer[v4] * volEnvCurrentValue;
                                                    }
                                                    ix = (int)((long)ix + this.volDelayCounter);
                                                    this.volDelayCounter = 0L;
                                                }
                                            }
                                            if (this.volEnvMode == 0) {
                                                velocity = this.velocity;
                                                volEnvAttackStep = this.volEnvAttackStep;
                                                while (ix < cend) {
                                                    if ((volEnvCurrentValue += volEnvAttackStep) > velocity) {
                                                        volEnvCurrentValue = velocity;
                                                        this.volEnvMode = 1;
                                                        break;
                                                    }
                                                    v5 = ix++;
                                                    cbuffer[v5] = cbuffer[v5] * volEnvCurrentValue;
                                                }
                                            }
                                            if (this.volEnvMode == 1) {
                                                if (this.volHoldCounter == 0L) {
                                                    this.volEnvMode = 2;
                                                }
                                                if (this.volHoldCounter > (long)(cend - ix)) {
                                                    i = ix;
                                                    while (i < cend) {
                                                        v6 = i++;
                                                        cbuffer[v6] = cbuffer[v6] * volEnvCurrentValue;
                                                    }
                                                    this.volHoldCounter -= (long)(cend - ix);
                                                } else {
                                                    this.volEnvMode = 2;
                                                    i = ix;
                                                    while ((long)i < (long)ix + this.volHoldCounter) {
                                                        v7 = i++;
                                                        cbuffer[v7] = cbuffer[v7] * volEnvCurrentValue;
                                                    }
                                                    ix = (int)((long)ix + this.volHoldCounter);
                                                }
                                            }
                                            if (this.volEnvMode == 2) {
                                                if (this.volEnvDecayStep == 0.0) {
                                                    this.volEnvMode = 3;
                                                } else {
                                                    sustain = this.volEnvSustain;
                                                    envStep = this.volEnvDecayStep;
                                                    while (ix < cend) {
                                                        if ((volEnvCurrentValue *= envStep) <= sustain) {
                                                            volEnvCurrentValue = sustain;
                                                            this.volEnvMode = 3;
                                                            if (!(volEnvCurrentValue <= 0.001)) break;
                                                            this.eof = true;
                                                            break;
                                                        }
                                                        v8 = ix++;
                                                        cbuffer[v8] = cbuffer[v8] * volEnvCurrentValue;
                                                    }
                                                }
                                            }
                                            if (this.volEnvMode == 3) {
                                                i = ix;
                                                while (i < cend) {
                                                    v9 = i++;
                                                    cbuffer[v9] = cbuffer[v9] * volEnvCurrentValue;
                                                }
                                            }
                                        } else {
                                            envStep = this.volEnvReleaseStep;
                                            while (ix < cend) {
                                                if ((volEnvCurrentValue *= envStep) <= 0.001) {
                                                    cend = ix;
                                                    this.eof = true;
                                                    break;
                                                }
                                                v10 = ix++;
                                                cbuffer[v10] = cbuffer[v10] * volEnvCurrentValue;
                                            }
                                        }
                                        end = cend * channels;
                                        this.volEnvCurrentValue = volEnvCurrentValue;
                                        if (modStart > cend) {
                                            modStart = cend;
                                        }
                                        if (vibStart > cend) {
                                            vibStart = cend;
                                        }
                                        if (this.modActive && modStart != -1 && this.lfoTable_modToVolume != null) {
                                            ix = this.modCounter;
                                            ix_step = this.freqModLFO_step;
                                            ix_len = 512.0;
                                            ix_table = this.lfoTable_modToVolume;
                                            i = modStart;
                                            while (i < cend) {
                                                v11 = i;
                                                cbuffer[v11] = cbuffer[v11] * ix_table[(int)ix];
                                                if ((ix += ix_step) > ix_len) {
                                                    ix %= ix_len;
                                                }
                                                ++i;
                                            }
                                        }
                                        fbuffer = null;
                                        if (!this.b_lowpass) break block165;
                                        if (!this.modEnvActive || this.modEnvToFilterFc == 0.0 || this.modEnvEof_Freq) break block166;
                                        fbuffer = this.audiocache.getBuffer(cbuffer.length);
                                        modEnvCurrentValue_Freq = this.modEnvCurrentValue_Freq;
                                        ix = cstart;
                                        if (!noteActive) break block167;
                                        if (this.modDelayCounter_Freq != 0L) {
                                            if (this.modDelayCounter_Freq > (long)(cend - ix)) {
                                                i = ix;
                                                while (i < cend) {
                                                    fbuffer[i] = modEnvCurrentValue_Freq;
                                                    ++i;
                                                }
                                                this.modDelayCounter_Freq -= (long)(cend - ix);
                                            } else {
                                                i = ix;
                                                while ((long)i < (long)ix + this.modDelayCounter_Freq) {
                                                    fbuffer[i] = modEnvCurrentValue_Freq;
                                                    ++i;
                                                }
                                                ix = (int)((long)ix + this.modDelayCounter_Freq);
                                                this.modDelayCounter_Freq = 0L;
                                            }
                                        }
                                        if (this.modEnvMode_Freq == 0) {
                                            modEnvToPitch = Math.pow(2.0, this.modEnvToFilterFc);
                                            modEnvAttackStep_Freq = this.modEnvAttackStep_Freq;
                                            while (ix < cend) {
                                                modEnvCurrentValue_Freq = (modEnvCurrentValue_Freq - this.modEnvAttackOffset_Freq) * modEnvAttackStep_Freq + this.modEnvAttackOffset_Freq;
                                                if (this.modEnvAttackCounter == 0L) {
                                                    modEnvCurrentValue_Freq = modEnvToPitch;
                                                    this.modEnvMode_Freq = 1;
                                                    break;
                                                }
                                                --this.modEnvAttackCounter;
                                                fbuffer[ix] = modEnvCurrentValue_Freq;
                                                ++ix;
                                            }
                                        }
                                        if (this.modEnvMode_Freq == 1) {
                                            if (this.modHoldCounter_Freq == 0L) {
                                                this.modEnvMode_Freq = 2;
                                            }
                                            if (this.modHoldCounter_Freq > (long)(cend - ix)) {
                                                i = ix;
                                                while (i < cend) {
                                                    fbuffer[i] = modEnvCurrentValue_Freq;
                                                    ++i;
                                                }
                                                this.modHoldCounter_Freq -= (long)(cend - ix);
                                            } else {
                                                this.modEnvMode_Freq = 2;
                                                i = ix;
                                                while ((long)i < (long)ix + this.modHoldCounter_Freq) {
                                                    fbuffer[i] = modEnvCurrentValue_Freq;
                                                    ++i;
                                                }
                                                ix = (int)((long)ix + this.modHoldCounter_Freq);
                                            }
                                        }
                                        if (this.modEnvMode_Freq != 2) break block159;
                                        if (this.modEnvDecayStep_Freq != 0.0) break block168;
                                        this.modEnvMode_Freq = 3;
                                        break block159;
                                    }
                                    sustain = Math.pow(2.0, this.modEnvSustain * this.modEnvToFilterFc);
                                    envStep = this.modEnvDecayStep_Freq;
                                    if (!(envStep >= 1.0)) ** GOTO lbl474
                                    while (ix < cend) {
                                        if ((modEnvCurrentValue_Freq *= envStep) >= sustain) {
                                            modEnvCurrentValue_Freq = sustain;
                                            this.modEnvMode_Freq = 3;
                                            break block159;
                                        }
                                        fbuffer[ix] = modEnvCurrentValue_Freq;
                                        ++ix;
                                    }
                                    break block159;
lbl-1000:
                                    // 1 sources

                                    {
                                        if ((modEnvCurrentValue_Freq *= envStep) <= sustain) {
                                            modEnvCurrentValue_Freq = sustain;
                                            this.modEnvMode_Freq = 3;
                                            break;
                                        }
                                        fbuffer[ix] = modEnvCurrentValue_Freq;
                                        ++ix;
lbl474:
                                        // 2 sources

                                        ** while (ix < cend)
                                    }
                                }
                                if (this.modEnvMode_Freq == 3) {
                                    if (ix == cstart) {
                                        if (fbuffer != null) {
                                            this.audiocache.returnBuffer(fbuffer);
                                        }
                                        fbuffer = null;
                                    } else {
                                        i = ix;
                                        while (i < cend) {
                                            fbuffer[i] = modEnvCurrentValue_Freq;
                                            ++i;
                                        }
                                    }
                                    ix = cend;
                                }
                                break block160;
                            }
                            if (!this.modEnvReleaseCalculated_Freq) {
                                this.modEnvReleaseCalculated_Freq = true;
                                this.modEnvReleaseStep_Freq = this.modEnvReleaseTime != 0.0 ? Math.pow(1.0 / modEnvCurrentValue_Freq, 1.0 / this.modEnvReleaseTime) : 1.0;
                            }
                            if ((envStep = this.modEnvReleaseStep_Freq) != 1.0) break block169;
                            if (ix == cstart) {
                                this.modEnvEof_Freq = true;
                                if (fbuffer != null) {
                                    this.audiocache.returnBuffer(fbuffer);
                                }
                                fbuffer = null;
                            }
                            break block160;
                        }
                        if (!(envStep >= 1.0)) ** GOTO lbl516
                        while (ix > cend) {
                            if ((modEnvCurrentValue_Freq *= envStep) >= 1.0) {
                                this.modEnvEof_Freq = true;
                                break block160;
                            }
                            fbuffer[ix] = modEnvCurrentValue_Freq;
                            ++ix;
                        }
                        break block160;
lbl-1000:
                        // 1 sources

                        {
                            modEnvCurrentValue_Freq *= envStep;
                            if (envStep <= 1.0 && modEnvCurrentValue_Freq <= 1.0 || envStep > 1.0 && modEnvCurrentValue_Freq >= 1.0) {
                                this.modEnvEof_Freq = true;
                                break;
                            }
                            fbuffer[ix] = modEnvCurrentValue_Freq;
                            ++ix;
lbl516:
                            // 2 sources

                            ** while (ix < cend)
                        }
                    }
                    if (fbuffer != null) {
                        Arrays.fill(fbuffer, ix, cend, modEnvCurrentValue_Freq);
                    }
                    this.modEnvCurrentValue_Freq = modEnvCurrentValue_Freq;
                }
                if (this.modActive && modStart != -1 && this.lfoTable_modToFilterFc != null) {
                    ix = this.modCounter;
                    ix_step = this.freqModLFO_step;
                    ix_len = 512.0;
                    ix_table = this.lfoTable_modToFilterFc;
                    if (fbuffer == null) {
                        fbuffer = this.audiocache.getBuffer(cbuffer.length);
                        i = cstart;
                        while (i < modStart) {
                            fbuffer[i] = this.modEnvCurrentValue_Freq;
                            ++i;
                        }
                        i = modStart;
                        while (i < cend) {
                            fbuffer[i] = this.modEnvCurrentValue_Freq * ix_table[(int)ix];
                            if ((ix += ix_step) > ix_len) {
                                ix %= ix_len;
                            }
                            ++i;
                        }
                    } else {
                        i = modStart;
                        while (i < cend) {
                            v12 = i;
                            fbuffer[v12] = fbuffer[v12] * ix_table[(int)ix];
                            if ((ix += ix_step) > ix_len) {
                                ix %= ix_len;
                            }
                            ++i;
                        }
                    }
                }
                if (fbuffer != null) {
                    this.calcLP(cbuffer, fbuffer, cstart, cend);
                } else if (this.modEnvCurrentValue_Freq != 1.0 || !(this.initialFilterFc > 19000.0) || !(this.initialFilterQ < 0.01)) {
                    this.calcLP(cbuffer, cstart, cend);
                }
            }
            c = 0;
            while (c < channels) {
                ix = cstart;
                ch_vol = 0.0;
                if (c < this.channelsVols.length) {
                    ch_vol = this.channelsVols[c];
                }
                if (ch_vol > 3.16228E-4) {
                    i = start + c;
                    while (i < end) {
                        v13 = i;
                        buffer[v13] = buffer[v13] + cbuffer[ix] * ch_vol;
                        ++ix;
                        i += channels;
                    }
                }
                ++c;
            }
            this.audiocache.returnBuffer(cbuffer);
            if (fbuffer != null) {
                this.audiocache.returnBuffer(fbuffer);
            }
            if (this.vibActive && vibStart != -1) {
                this.vibCounter += this.freqVibLFO_step * (double)(cend - vibStart);
                this.vibCounter %= 512.0;
            }
            if (this.modActive && modStart != -1) {
                this.modCounter += this.freqModLFO_step * (double)(cend - modStart);
                this.modCounter %= 512.0;
            }
            return (end - start) * channels;
        }

        public int replace(double[] buffer, int start, int end) {
            Arrays.fill(buffer, start, end, 0.0);
            return this.mix(buffer, start, end);
        }

        public int skip(int len) {
            return -1;
        }

        public int isStatic(double[] buffer, int len) {
            return -1;
        }

        public void close() {
            this.samplestream.close();
            this.activestream.close();
            if (this.pitchstream != null) {
                this.pitchstream.close();
                this.pitchstream = null;
            }
        }
    }
}

