/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.midi;

import java.util.ArrayList;
import rasmus.interpreter.Commitable;
import rasmus.interpreter.NameSpace;
import rasmus.interpreter.Variable;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.sampled.midi.AudioVoice;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.Unit;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class AudioVoiceFactoryInstance
extends UnitInstanceAdapter
implements Commitable {
    Variable velocity;
    Variable keynum;
    Variable[] channelsVols;
    Variable initialAttenuation;
    Variable delayVolEnv;
    Variable attackVolEnv;
    Variable holdVolEnv;
    Variable decayVolEnv;
    Variable sustainVolEnv;
    Variable releaseVolEnv;
    Variable delayModEnv;
    Variable attackModEnv;
    Variable holdModEnv;
    Variable decayModEnv;
    Variable sustainModEnv;
    Variable releaseModEnv;
    Variable modEnvToPitch;
    Variable modEnvToFilterFc;
    Variable sample;
    Variable sampleRate;
    Variable scaleTune;
    Variable coarseTune;
    Variable initialFilterFc;
    Variable initialFilterQ;
    Variable delayModLFO;
    Variable freqModLFO;
    Variable modLfoToPitch;
    Variable modLfoToFilterFc;
    Variable modLfoToVolume;
    Variable delayVibLFO;
    Variable freqVibLFO;
    Variable vibLfoToPitch;
    Variable keynumToModEnvHold;
    Variable keynumToModEnvDecay;
    Variable keynumToVolEnvHold;
    Variable keynumToVolEnvDecay;
    Variable lowpass;
    int i_velocity = -1;
    int i_keynum = -1;
    boolean b_lowpass = true;
    double[] d_channelsVols = new double[]{0.5, 0.5};
    double d_initialAttenuation = 1.0;
    double d_delayVolEnv = 0.0;
    double d_attackVolEnv = 0.0;
    double d_holdVolEnv = 0.0;
    double d_decayVolEnv = 0.0;
    double d_sustainVolEnv = 1.0;
    double d_releaseVolEnv = 0.001;
    double d_delayModEnv = 0.0;
    double d_attackModEnv = 0.0;
    double d_holdModEnv = 0.0;
    double d_decayModEnv = 0.0;
    double d_sustainModEnv = 1.0;
    double d_releaseModEnv = 0.001;
    double d_modEnvToPitch = 0.0;
    double d_modEnvToFilterFc = 0.0;
    double d_sample;
    double d_sampleRate = 44100.0;
    double d_scaleTune = 2.0;
    double d_coarseTune = -60.0;
    double d_initialFilterFc = 20000.0;
    double d_initialFilterQ = 0.0;
    double d_keynumToModEnvHold = 0.0;
    double d_keynumToModEnvDecay = 0.0;
    double d_keynumToVolEnvHold = 0.0;
    double d_keynumToVolEnvDecay = 0.0;
    double d_delayModLFO = 0.0;
    double d_freqModLFO = 8.176;
    double d_modLfoToPitch = 0.0;
    double d_modLfoToFilterFc = 0.0;
    double d_modLfoToVolume = 0.0;
    double d_delayVibLFO = 0.0;
    double d_freqVibLFO = 8.176;
    double d_vibLfoToPitch = 0.0;
    public static final int lfoTable_size = 512;
    public static final int lfoTable_size_overlap = 520;
    double[] lfoTable_vibToPitch = null;
    double[] lfoTable_modToPitch = null;
    double[] lfoTable_modToFilterFc = null;
    double[] lfoTable_modToVolume = null;
    Variable output;
    Variable answer;
    private NameSpace namespace;

    public AudioVoiceFactoryInstance(Parameters parameters) {
        Variable value;
        this.namespace = parameters.getNameSpace();
        this.output = parameters.getParameterWithDefault(0, "output");
        this.answer = Unit.asVariable(new AudioVoice(this));
        this.output.add(this.answer);
        this.velocity = parameters.getParameter("velocity");
        this.keynum = parameters.getParameter("keynum");
        ArrayList<Variable> chlist = new ArrayList<Variable>();
        int c = 1;
        while ((value = parameters.getParameter("ch" + c + "Vol")) != null) {
            chlist.add(value);
            ++c;
        }
        this.channelsVols = chlist.toArray(new Variable[c]);
        this.initialAttenuation = parameters.getParameter("initialAttenuation");
        this.delayVolEnv = parameters.getParameter("delayVolEnv");
        this.attackVolEnv = parameters.getParameter("attackVolEnv");
        this.holdVolEnv = parameters.getParameter("holdVolEnv");
        this.decayVolEnv = parameters.getParameter("decayVolEnv");
        this.sustainVolEnv = parameters.getParameter("sustainVolEnv");
        this.releaseVolEnv = parameters.getParameter("releaseVolEnv");
        this.delayModEnv = parameters.getParameter("delayModEnv");
        this.attackModEnv = parameters.getParameter("attackModEnv");
        this.holdModEnv = parameters.getParameter("holdModEnv");
        this.decayModEnv = parameters.getParameter("decayModEnv");
        this.sustainModEnv = parameters.getParameter("sustainModEnv");
        this.releaseModEnv = parameters.getParameter("releaseModEnv");
        this.modEnvToPitch = parameters.getParameter("modEnvToPitch");
        this.modEnvToFilterFc = parameters.getParameter("modEnvToFilterFc");
        this.sample = parameters.getParameter("sample");
        this.sampleRate = parameters.getParameter("sampleRate");
        this.scaleTune = parameters.getParameter("scaleTune");
        this.coarseTune = parameters.getParameter("coarseTune");
        this.initialFilterFc = parameters.getParameter("initialFilterFc");
        this.initialFilterQ = parameters.getParameter("initialFilterQ");
        this.delayModLFO = parameters.getParameter("delayModLFO");
        this.freqModLFO = parameters.getParameter("freqModLFO");
        this.modLfoToPitch = parameters.getParameter("modLfoToPitch");
        this.modLfoToFilterFc = parameters.getParameter("modLfoToFilterFc");
        this.modLfoToVolume = parameters.getParameter("modLfoToVolume");
        this.delayVibLFO = parameters.getParameter("delayVibLFO");
        this.freqVibLFO = parameters.getParameter("freqVibLFO");
        this.vibLfoToPitch = parameters.getParameter("vibLfoToPitch");
        this.keynumToModEnvHold = parameters.getParameter("keynumToModEnvHold");
        this.keynumToModEnvDecay = parameters.getParameter("keynumToModEnvDecay");
        this.keynumToVolEnvHold = parameters.getParameter("keynumToVolEnvHold");
        this.keynumToVolEnvDecay = parameters.getParameter("keynumToVolEnvDecay");
        this.lowpass = parameters.getParameter("lowpass");
        if (this.lowpass != null) {
            DoublePart.getInstance(this.lowpass).addListener(this);
        }
        if (this.velocity != null) {
            DoublePart.getInstance(this.velocity).addListener(this);
        }
        if (this.keynum != null) {
            DoublePart.getInstance(this.keynum).addListener(this);
        }
        int j = 0;
        while (j < this.channelsVols.length) {
            if (this.channelsVols[j] != null) {
                DoublePart.getInstance(this.channelsVols[j]).addListener(this);
            }
            ++j;
        }
        if (this.initialAttenuation != null) {
            DoublePart.getInstance(this.initialAttenuation).addListener(this);
        }
        if (this.delayVolEnv != null) {
            DoublePart.getInstance(this.delayVolEnv).addListener(this);
        }
        if (this.attackVolEnv != null) {
            DoublePart.getInstance(this.attackVolEnv).addListener(this);
        }
        if (this.holdVolEnv != null) {
            DoublePart.getInstance(this.holdVolEnv).addListener(this);
        }
        if (this.decayVolEnv != null) {
            DoublePart.getInstance(this.decayVolEnv).addListener(this);
        }
        if (this.sustainVolEnv != null) {
            DoublePart.getInstance(this.sustainVolEnv).addListener(this);
        }
        if (this.releaseVolEnv != null) {
            DoublePart.getInstance(this.releaseVolEnv).addListener(this);
        }
        if (this.delayModEnv != null) {
            DoublePart.getInstance(this.delayModEnv).addListener(this);
        }
        if (this.attackModEnv != null) {
            DoublePart.getInstance(this.attackModEnv).addListener(this);
        }
        if (this.holdModEnv != null) {
            DoublePart.getInstance(this.holdModEnv).addListener(this);
        }
        if (this.decayModEnv != null) {
            DoublePart.getInstance(this.decayModEnv).addListener(this);
        }
        if (this.sustainModEnv != null) {
            DoublePart.getInstance(this.sustainModEnv).addListener(this);
        }
        if (this.releaseModEnv != null) {
            DoublePart.getInstance(this.releaseModEnv).addListener(this);
        }
        if (this.modEnvToPitch != null) {
            DoublePart.getInstance(this.modEnvToPitch).addListener(this);
        }
        if (this.modEnvToFilterFc != null) {
            DoublePart.getInstance(this.modEnvToFilterFc).addListener(this);
        }
        if (this.sampleRate != null) {
            DoublePart.getInstance(this.sampleRate).addListener(this);
        }
        if (this.scaleTune != null) {
            DoublePart.getInstance(this.scaleTune).addListener(this);
        }
        if (this.coarseTune != null) {
            DoublePart.getInstance(this.coarseTune).addListener(this);
        }
        if (this.initialFilterFc != null) {
            DoublePart.getInstance(this.initialFilterFc).addListener(this);
        }
        if (this.initialFilterQ != null) {
            DoublePart.getInstance(this.initialFilterQ).addListener(this);
        }
        if (this.delayModLFO != null) {
            DoublePart.getInstance(this.delayModLFO).addListener(this);
        }
        if (this.freqModLFO != null) {
            DoublePart.getInstance(this.freqModLFO).addListener(this);
        }
        if (this.modLfoToPitch != null) {
            DoublePart.getInstance(this.modLfoToPitch).addListener(this);
        }
        if (this.modLfoToFilterFc != null) {
            DoublePart.getInstance(this.modLfoToFilterFc).addListener(this);
        }
        if (this.modLfoToVolume != null) {
            DoublePart.getInstance(this.modLfoToVolume).addListener(this);
        }
        if (this.delayVibLFO != null) {
            DoublePart.getInstance(this.delayVibLFO).addListener(this);
        }
        if (this.freqVibLFO != null) {
            DoublePart.getInstance(this.freqVibLFO).addListener(this);
        }
        if (this.vibLfoToPitch != null) {
            DoublePart.getInstance(this.vibLfoToPitch).addListener(this);
        }
        if (this.keynumToModEnvHold != null) {
            DoublePart.getInstance(this.keynumToModEnvHold).addListener(this);
        }
        if (this.keynumToModEnvDecay != null) {
            DoublePart.getInstance(this.keynumToModEnvDecay).addListener(this);
        }
        if (this.keynumToVolEnvHold != null) {
            DoublePart.getInstance(this.keynumToVolEnvHold).addListener(this);
        }
        if (this.keynumToVolEnvDecay != null) {
            DoublePart.getInstance(this.keynumToVolEnvDecay).addListener(this);
        }
        this.calc();
    }

    public int getRunLevel() {
        return 0;
    }

    public void commit() {
        int i;
        if (this.lowpass != null) {
            boolean bl = this.b_lowpass = DoublePart.asDouble(this.lowpass) > 0.5;
        }
        if (this.velocity != null) {
            this.i_velocity = (int)DoublePart.asDouble(this.velocity);
        }
        if (this.keynum != null) {
            this.i_keynum = (int)DoublePart.asDouble(this.keynum);
        }
        if (this.channelsVols.length != 0) {
            this.d_channelsVols = new double[this.channelsVols.length];
        }
        int j = 0;
        while (j < this.channelsVols.length) {
            if (this.channelsVols[j] != null) {
                this.d_channelsVols[j] = DoublePart.asDouble(this.channelsVols[j]);
            }
            ++j;
        }
        if (this.initialAttenuation != null) {
            this.d_initialAttenuation = DoublePart.asDouble(this.initialAttenuation);
        }
        if (this.delayVolEnv != null) {
            this.d_delayVolEnv = DoublePart.asDouble(this.delayVolEnv);
        }
        if (this.attackVolEnv != null) {
            this.d_attackVolEnv = DoublePart.asDouble(this.attackVolEnv);
        }
        if (this.holdVolEnv != null) {
            this.d_holdVolEnv = DoublePart.asDouble(this.holdVolEnv);
        }
        if (this.decayVolEnv != null) {
            this.d_decayVolEnv = DoublePart.asDouble(this.decayVolEnv);
        }
        if (this.sustainVolEnv != null) {
            this.d_sustainVolEnv = DoublePart.asDouble(this.sustainVolEnv);
        }
        if (this.releaseVolEnv != null) {
            this.d_releaseVolEnv = DoublePart.asDouble(this.releaseVolEnv);
        }
        if (this.delayModEnv != null) {
            this.d_delayModEnv = DoublePart.asDouble(this.delayModEnv);
        }
        if (this.attackModEnv != null) {
            this.d_attackModEnv = DoublePart.asDouble(this.attackModEnv);
        }
        if (this.holdModEnv != null) {
            this.d_holdModEnv = DoublePart.asDouble(this.holdModEnv);
        }
        if (this.decayModEnv != null) {
            this.d_decayModEnv = DoublePart.asDouble(this.decayModEnv);
        }
        if (this.sustainModEnv != null) {
            this.d_sustainModEnv = DoublePart.asDouble(this.sustainModEnv);
        }
        if (this.releaseModEnv != null) {
            this.d_releaseModEnv = DoublePart.asDouble(this.releaseModEnv);
        }
        if (this.modEnvToPitch != null) {
            this.d_modEnvToPitch = DoublePart.asDouble(this.modEnvToPitch);
        }
        if (this.modEnvToFilterFc != null) {
            this.d_modEnvToFilterFc = DoublePart.asDouble(this.modEnvToFilterFc);
        }
        if (this.sampleRate != null) {
            this.d_sampleRate = DoublePart.asDouble(this.sampleRate);
        }
        if (this.scaleTune != null) {
            this.d_scaleTune = DoublePart.asDouble(this.scaleTune);
        }
        if (this.coarseTune != null) {
            this.d_coarseTune = DoublePart.asDouble(this.coarseTune);
        }
        if (this.initialFilterFc != null) {
            this.d_initialFilterFc = DoublePart.asDouble(this.initialFilterFc);
        }
        if (this.initialFilterQ != null) {
            this.d_initialFilterQ = DoublePart.asDouble(this.initialFilterQ);
        }
        if (this.delayModLFO != null) {
            this.d_delayModLFO = DoublePart.asDouble(this.delayModLFO);
        }
        if (this.freqModLFO != null) {
            this.d_freqModLFO = DoublePart.asDouble(this.freqModLFO);
        }
        if (this.modLfoToPitch != null) {
            this.d_modLfoToPitch = DoublePart.asDouble(this.modLfoToPitch);
        }
        if (this.modLfoToFilterFc != null) {
            this.d_modLfoToFilterFc = DoublePart.asDouble(this.modLfoToFilterFc);
        }
        if (this.modLfoToVolume != null) {
            this.d_modLfoToVolume = DoublePart.asDouble(this.modLfoToVolume);
        }
        if (this.delayVibLFO != null) {
            this.d_delayVibLFO = DoublePart.asDouble(this.delayVibLFO);
        }
        if (this.freqVibLFO != null) {
            this.d_freqVibLFO = DoublePart.asDouble(this.freqVibLFO);
        }
        if (this.vibLfoToPitch != null) {
            this.d_vibLfoToPitch = DoublePart.asDouble(this.vibLfoToPitch);
        }
        if (this.keynumToModEnvHold != null) {
            this.d_keynumToModEnvHold = DoublePart.asDouble(this.keynumToModEnvHold);
        }
        if (this.keynumToModEnvDecay != null) {
            this.d_keynumToModEnvDecay = DoublePart.asDouble(this.keynumToModEnvDecay);
        }
        if (this.keynumToVolEnvHold != null) {
            this.d_keynumToVolEnvHold = DoublePart.asDouble(this.keynumToVolEnvHold);
        }
        if (this.keynumToVolEnvDecay != null) {
            this.d_keynumToVolEnvDecay = DoublePart.asDouble(this.keynumToVolEnvDecay);
        }
        if (this.d_vibLfoToPitch != 0.0) {
            this.lfoTable_vibToPitch = new double[520];
            i = 0;
            while (i < 520) {
                this.lfoTable_vibToPitch[i] = Math.pow(2.0, this.d_vibLfoToPitch * Math.sin((double)i * 2.0 * Math.PI / 512.0));
                ++i;
            }
        }
        if (this.d_modLfoToPitch != 0.0) {
            this.lfoTable_modToPitch = new double[520];
            i = 0;
            while (i < 520) {
                this.lfoTable_modToPitch[i] = Math.pow(2.0, this.d_modLfoToPitch * Math.sin((double)i * 2.0 * Math.PI / 512.0));
                ++i;
            }
        }
        if (this.d_modLfoToFilterFc != 0.0) {
            this.lfoTable_modToFilterFc = new double[520];
            i = 0;
            while (i < 520) {
                this.lfoTable_modToFilterFc[i] = Math.pow(2.0, this.d_modLfoToFilterFc * Math.cos((double)i * 2.0 * Math.PI / 512.0));
                ++i;
            }
        }
        if (this.d_modLfoToVolume != 1.0) {
            this.lfoTable_modToVolume = new double[520];
            i = 0;
            while (i < 520) {
                this.lfoTable_modToVolume[i] = Math.pow(this.d_modLfoToVolume, Math.sin((double)i * 2.0 * Math.PI / 512.0));
                ++i;
            }
        }
        if (!this.b_lowpass) {
            this.d_modLfoToFilterFc = 0.0;
            this.d_modEnvToFilterFc = 0.0;
            this.d_initialFilterFc = 20000.0;
            this.d_initialFilterQ = 0.0;
        }
        if (this.isImmutable(this.initialAttenuation)) {
            this.initialAttenuation = null;
        }
        if (this.isImmutable(this.delayVolEnv)) {
            this.delayVolEnv = null;
        }
        if (this.isImmutable(this.attackVolEnv)) {
            this.attackVolEnv = null;
        }
        if (this.isImmutable(this.holdVolEnv)) {
            this.holdVolEnv = null;
        }
        if (this.isImmutable(this.decayVolEnv)) {
            this.decayVolEnv = null;
        }
        if (this.isImmutable(this.sustainVolEnv)) {
            this.sustainVolEnv = null;
        }
        if (this.isImmutable(this.releaseVolEnv)) {
            this.releaseVolEnv = null;
        }
        if (this.isImmutable(this.delayModEnv)) {
            this.delayModEnv = null;
        }
        if (this.isImmutable(this.attackModEnv)) {
            this.attackModEnv = null;
        }
        if (this.isImmutable(this.holdModEnv)) {
            this.holdModEnv = null;
        }
        if (this.isImmutable(this.decayModEnv)) {
            this.decayModEnv = null;
        }
        if (this.isImmutable(this.sustainModEnv)) {
            this.sustainModEnv = null;
        }
        if (this.isImmutable(this.releaseModEnv)) {
            this.releaseModEnv = null;
        }
        if (this.isImmutable(this.modEnvToPitch)) {
            this.modEnvToPitch = null;
        }
        if (this.isImmutable(this.modEnvToFilterFc)) {
            this.modEnvToFilterFc = null;
        }
        if (this.isImmutable(this.sampleRate)) {
            this.sampleRate = null;
        }
        if (this.isImmutable(this.scaleTune)) {
            this.scaleTune = null;
        }
        if (this.isImmutable(this.coarseTune)) {
            this.coarseTune = null;
        }
        if (this.isImmutable(this.coarseTune)) {
            this.initialFilterFc = null;
        }
        if (this.isImmutable(this.initialFilterQ)) {
            this.initialFilterQ = null;
        }
        if (this.isImmutable(this.delayModLFO)) {
            this.delayModLFO = null;
        }
        if (this.isImmutable(this.freqModLFO)) {
            this.freqModLFO = null;
        }
        if (this.isImmutable(this.modLfoToPitch)) {
            this.modLfoToPitch = null;
        }
        if (this.isImmutable(this.modLfoToFilterFc)) {
            this.modLfoToFilterFc = null;
        }
        if (this.isImmutable(this.modLfoToVolume)) {
            this.modLfoToVolume = null;
        }
        if (this.isImmutable(this.delayVibLFO)) {
            this.delayVibLFO = null;
        }
        if (this.isImmutable(this.freqVibLFO)) {
            this.freqVibLFO = null;
        }
        if (this.isImmutable(this.vibLfoToPitch)) {
            this.vibLfoToPitch = null;
        }
        if (this.isImmutable(this.keynumToModEnvHold)) {
            this.keynumToModEnvHold = null;
        }
        if (this.isImmutable(this.keynumToModEnvDecay)) {
            this.keynumToModEnvDecay = null;
        }
        if (this.isImmutable(this.keynumToVolEnvHold)) {
            this.keynumToVolEnvHold = null;
        }
        if (this.isImmutable(this.keynumToVolEnvDecay)) {
            this.keynumToVolEnvDecay = null;
        }
        if (this.isImmutable(this.lowpass)) {
            this.lowpass = null;
        }
    }

    public boolean isImmutable(Variable variable) {
        if (variable == null) {
            return false;
        }
        return DoublePart.getInstance(variable).isImmutable();
    }

    public void calc() {
        this.namespace.addToCommitStack(this);
    }

    public void close() {
        if (this.lowpass != null) {
            DoublePart.getInstance(this.lowpass).removeListener(this);
        }
        if (this.velocity != null) {
            DoublePart.getInstance(this.velocity).removeListener(this);
        }
        if (this.keynum != null) {
            DoublePart.getInstance(this.keynum).removeListener(this);
        }
        int j = 0;
        while (j < this.channelsVols.length) {
            if (this.channelsVols[j] != null) {
                DoublePart.getInstance(this.channelsVols[j]).removeListener(this);
            }
            ++j;
        }
        if (this.initialAttenuation != null) {
            DoublePart.getInstance(this.initialAttenuation).removeListener(this);
        }
        if (this.delayVolEnv != null) {
            DoublePart.getInstance(this.delayVolEnv).removeListener(this);
        }
        if (this.attackVolEnv != null) {
            DoublePart.getInstance(this.attackVolEnv).removeListener(this);
        }
        if (this.holdVolEnv != null) {
            DoublePart.getInstance(this.holdVolEnv).removeListener(this);
        }
        if (this.decayVolEnv != null) {
            DoublePart.getInstance(this.decayVolEnv).removeListener(this);
        }
        if (this.sustainVolEnv != null) {
            DoublePart.getInstance(this.sustainVolEnv).removeListener(this);
        }
        if (this.releaseVolEnv != null) {
            DoublePart.getInstance(this.releaseVolEnv).removeListener(this);
        }
        if (this.delayModEnv != null) {
            DoublePart.getInstance(this.delayModEnv).removeListener(this);
        }
        if (this.attackModEnv != null) {
            DoublePart.getInstance(this.attackModEnv).removeListener(this);
        }
        if (this.holdModEnv != null) {
            DoublePart.getInstance(this.holdModEnv).removeListener(this);
        }
        if (this.decayModEnv != null) {
            DoublePart.getInstance(this.decayModEnv).removeListener(this);
        }
        if (this.sustainModEnv != null) {
            DoublePart.getInstance(this.sustainModEnv).removeListener(this);
        }
        if (this.releaseModEnv != null) {
            DoublePart.getInstance(this.releaseModEnv).removeListener(this);
        }
        if (this.modEnvToPitch != null) {
            DoublePart.getInstance(this.modEnvToPitch).removeListener(this);
        }
        if (this.modEnvToFilterFc != null) {
            DoublePart.getInstance(this.modEnvToFilterFc).removeListener(this);
        }
        if (this.sampleRate != null) {
            DoublePart.getInstance(this.sampleRate).removeListener(this);
        }
        if (this.scaleTune != null) {
            DoublePart.getInstance(this.scaleTune).removeListener(this);
        }
        if (this.coarseTune != null) {
            DoublePart.getInstance(this.coarseTune).removeListener(this);
        }
        if (this.initialFilterFc != null) {
            DoublePart.getInstance(this.initialFilterFc).removeListener(this);
        }
        if (this.initialFilterQ != null) {
            DoublePart.getInstance(this.initialFilterQ).removeListener(this);
        }
        if (this.delayModLFO != null) {
            DoublePart.getInstance(this.delayModLFO).removeListener(this);
        }
        if (this.freqModLFO != null) {
            DoublePart.getInstance(this.freqModLFO).removeListener(this);
        }
        if (this.modLfoToPitch != null) {
            DoublePart.getInstance(this.modLfoToPitch).removeListener(this);
        }
        if (this.modLfoToFilterFc != null) {
            DoublePart.getInstance(this.modLfoToFilterFc).removeListener(this);
        }
        if (this.modLfoToVolume != null) {
            DoublePart.getInstance(this.modLfoToVolume).removeListener(this);
        }
        if (this.delayVibLFO != null) {
            DoublePart.getInstance(this.delayVibLFO).removeListener(this);
        }
        if (this.freqVibLFO != null) {
            DoublePart.getInstance(this.freqVibLFO).removeListener(this);
        }
        if (this.vibLfoToPitch != null) {
            DoublePart.getInstance(this.vibLfoToPitch).removeListener(this);
        }
        if (this.keynumToModEnvHold != null) {
            DoublePart.getInstance(this.keynumToModEnvHold).removeListener(this);
        }
        if (this.keynumToModEnvDecay != null) {
            DoublePart.getInstance(this.keynumToModEnvDecay).removeListener(this);
        }
        if (this.keynumToVolEnvHold != null) {
            DoublePart.getInstance(this.keynumToVolEnvHold).removeListener(this);
        }
        if (this.keynumToVolEnvDecay != null) {
            DoublePart.getInstance(this.keynumToVolEnvDecay).removeListener(this);
        }
        this.output.remove(this.answer);
    }
}

