/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.midi;

import rasmus.interpreter.Commitable;
import rasmus.interpreter.NameSpace;
import rasmus.interpreter.Variable;
import rasmus.interpreter.list.ObjectsPart;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.sampled.midi.VoiceRecord;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class AudioRegisterVoiceInstance
extends UnitInstanceAdapter
implements Commitable {
    Variable output;
    Variable answer = null;
    Variable voice;
    Variable keyfrom;
    Variable keyto;
    Variable velfrom;
    Variable velto;
    Variable exclusiveClass;
    Variable name;
    private NameSpace namespace;

    public AudioRegisterVoiceInstance(Parameters parameters) {
        this.namespace = parameters.getNameSpace();
        this.output = parameters.getParameterWithDefault("output");
        this.voice = parameters.getParameterWithDefault("input");
        this.keyfrom = parameters.getParameterWithDefault(1, "keyfrom");
        this.keyto = parameters.getParameterWithDefault(2, "keyto");
        this.velfrom = parameters.getParameterWithDefault(3, "velfrom");
        this.velto = parameters.getParameterWithDefault(4, "velto");
        this.exclusiveClass = parameters.getParameter("exclusiveClass");
        this.name = parameters.getParameter("name");
        if (this.keyfrom != null) {
            DoublePart.getInstance(this.keyfrom).addListener(this);
        }
        if (this.keyto != null) {
            DoublePart.getInstance(this.keyto).addListener(this);
        }
        if (this.velfrom != null) {
            DoublePart.getInstance(this.velfrom).addListener(this);
        }
        if (this.velto != null) {
            DoublePart.getInstance(this.velto).addListener(this);
        }
        if (this.exclusiveClass != null) {
            DoublePart.getInstance(this.exclusiveClass).addListener(this);
        }
        if (this.name != null) {
            ObjectsPart.getInstance(this.name).addListener(this);
        }
        this.calc();
    }

    public void close() {
        if (this.keyfrom != null) {
            DoublePart.getInstance(this.keyfrom).removeListener(this);
        }
        if (this.keyto != null) {
            DoublePart.getInstance(this.keyto).removeListener(this);
        }
        if (this.velfrom != null) {
            DoublePart.getInstance(this.velfrom).removeListener(this);
        }
        if (this.velto != null) {
            DoublePart.getInstance(this.velto).removeListener(this);
        }
        if (this.exclusiveClass != null) {
            DoublePart.getInstance(this.exclusiveClass).removeListener(this);
        }
        if (this.name != null) {
            ObjectsPart.getInstance(this.name).removeListener(this);
        }
    }

    public void calc() {
        this.namespace.addToCommitStack(this);
    }

    public int getRunLevel() {
        return 0;
    }

    public void commit() {
        if (this.answer != null) {
            this.output.remove(this.answer);
        }
        VoiceRecord voicedata = new VoiceRecord();
        voicedata.voice = this.voice;
        if (this.keyfrom != null) {
            voicedata.keyfrom = (int)DoublePart.asDouble(this.keyfrom);
        }
        if (this.keyto != null) {
            voicedata.keyto = (int)DoublePart.asDouble(this.keyto);
        }
        if (this.velfrom != null) {
            voicedata.velfrom = (int)DoublePart.asDouble(this.velfrom);
        }
        if (this.velto != null) {
            voicedata.velto = (int)DoublePart.asDouble(this.velto);
        }
        if (this.exclusiveClass != null) {
            voicedata.exclusiveClass = (int)DoublePart.asDouble(this.exclusiveClass);
        }
        if (this.name != null) {
            voicedata.name = ObjectsPart.toString(this.name);
        }
        this.answer = ObjectsPart.asVariable(voicedata);
        this.output.add(this.answer);
    }
}

