/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.midi;

import java.util.ArrayList;
import rasmus.interpreter.Commitable;
import rasmus.interpreter.NameSpace;
import rasmus.interpreter.Variable;
import rasmus.interpreter.list.ObjectsPart;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.sampled.midi.InstrumentRecord;
import rasmus.interpreter.sampled.midi.VoiceRecord;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class AudioRegisterInstrumentInstance
extends UnitInstanceAdapter
implements Commitable {
    Variable output;
    Variable answer = null;
    Variable voices;
    Variable program;
    Variable bank;
    Variable description;
    Variable[] channels = new Variable[16];
    private NameSpace namespace;

    public AudioRegisterInstrumentInstance(Parameters parameters) {
        this.namespace = parameters.getNameSpace();
        this.output = parameters.getParameterWithDefault("output");
        this.voices = parameters.getParameterWithDefault("input");
        this.program = parameters.getParameterWithDefault(1, "program");
        this.bank = parameters.getParameterWithDefault(2, "bank");
        this.description = parameters.getParameterWithDefault(3, "description");
        int i = 0;
        while (i < this.channels.length) {
            this.channels[i] = parameters.getParameter("ch" + (i + 1));
            if (this.channels[i] != null) {
                DoublePart.getInstance(this.channels[i]).addListener(this);
            }
            ++i;
        }
        DoublePart.getInstance(this.program).addListener(this);
        DoublePart.getInstance(this.bank).addListener(this);
        ObjectsPart.getInstance(this.description).addListener(this);
        ObjectsPart.getInstance(this.voices).addListener(this);
        this.calc();
    }

    public void close() {
        int i = 0;
        while (i < this.channels.length) {
            if (this.channels[i] != null) {
                DoublePart.getInstance(this.channels[i]).removeListener(this);
            }
            ++i;
        }
        DoublePart.getInstance(this.program).removeListener(this);
        DoublePart.getInstance(this.bank).removeListener(this);
        ObjectsPart.getInstance(this.description).removeListener(this);
        ObjectsPart.getInstance(this.voices).removeListener(this);
        if (this.answer != null) {
            this.output.remove(this.answer);
        }
    }

    public void calc() {
        this.namespace.addToCommitStack(this);
    }

    public int getRunLevel() {
        return 0;
    }

    public void commit() {
        if (this.answer != null) {
            this.output.remove(this.answer);
        }
        InstrumentRecord voicedata = new InstrumentRecord();
        voicedata.voices = new ArrayList<VoiceRecord>();
        for (Object obj : ObjectsPart.asList(this.voices)) {
            if (!(obj instanceof VoiceRecord)) continue;
            voicedata.voices.add((VoiceRecord)obj);
        }
        if (voicedata.voices.size() == 0) {
            VoiceRecord rvoice = new VoiceRecord();
            rvoice.voice = this.voices;
            voicedata.voices.add(rvoice);
        }
        boolean[] b_channels = new boolean[16];
        boolean defaultval = false;
        boolean allnull = true;
        int i = 0;
        while (i < this.channels.length) {
            if (this.channels[i] != null) {
                boolean val;
                boolean bl = val = (int)DoublePart.asDouble(this.channels[i]) != 0;
                if (!val) {
                    defaultval = true;
                }
                b_channels[i] = val;
                allnull = false;
            }
            ++i;
        }
        if (allnull) {
            defaultval = true;
        }
        i = 0;
        while (i < this.channels.length) {
            if (this.channels[i] == null) {
                b_channels[i] = defaultval;
            }
            ++i;
        }
        voicedata.program = (int)DoublePart.asDouble(this.program);
        voicedata.bank = (int)DoublePart.asDouble(this.bank);
        voicedata.description = ObjectsPart.toString(this.description);
        voicedata.channels = b_channels;
        this.answer = ObjectsPart.asVariable(voicedata);
        this.output.add(this.answer);
    }
}

