/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.midi;

import java.util.ArrayList;
import java.util.Arrays;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import rasmus.interpreter.Variable;
import rasmus.interpreter.midi.MidiSequence;
import rasmus.interpreter.sampled.AudioEvent;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;
import rasmus.interpreter.sampled.AudioStreamable;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class AudioMidiTrapInstance
extends UnitInstanceAdapter
implements AudioStreamable {
    public Variable output;
    public Variable input;
    Variable answer = new Variable();
    Variable midi;
    Variable midiout;

    public void calc() {
    }

    public AudioMidiTrapInstance(Parameters parameters) {
        this.output = parameters.getParameterWithDefault("output");
        this.input = parameters.getParameterWithDefault("input");
        this.midi = parameters.getParameterWithDefault(1, "midiin");
        this.midiout = parameters.getParameterWithDefault(2, "midiout");
        this.answer = AudioEvents.asVariable(new AudioEvent(0.0, this));
        this.output.add(this.answer);
    }

    public void close() {
        this.output.remove(this.answer);
    }

    public AudioStream openStream(AudioSession session) {
        return new FilterStreamInstance(session);
    }

    class FilterStreamInstance
    implements AudioStream,
    Receiver {
        volatile boolean trapped = true;
        boolean a_trapped = true;
        volatile boolean m_trapped = true;
        AudioStream inputstream;
        AudioSession session;
        MidiSequence mout;
        ArrayList<MidiMessage> midiqueue = new ArrayList();

        public FilterStreamInstance(AudioSession session) {
            if (!session.isRealTime()) {
                this.inputstream = AudioEvents.openStream(AudioMidiTrapInstance.this.input, session);
                this.a_trapped = false;
                this.trapped = false;
                return;
            }
            this.session = session;
            this.mout = MidiSequence.getInstance(AudioMidiTrapInstance.this.midiout);
            MidiSequence.getInstance(AudioMidiTrapInstance.this.midi).addReceiver(this);
        }

        public int skip(int len) {
            return len;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isTrapped() {
            if (this.a_trapped) {
                this.a_trapped = this.trapped;
                if (!this.a_trapped) {
                    ArrayList<MidiMessage> arrayList = this.midiqueue;
                    synchronized (arrayList) {
                        AudioSession new_session = this.session.newSession();
                        this.inputstream = AudioEvents.openStream(AudioMidiTrapInstance.this.input, new_session);
                        this.m_trapped = false;
                        for (MidiMessage item : this.midiqueue) {
                            this.mout.send(item, -1L);
                        }
                        this.midiqueue.clear();
                    }
                }
            }
            return this.a_trapped;
        }

        public int mix(double[] buffer, int start, int end) {
            if (this.isTrapped()) {
                return end - start;
            }
            return this.inputstream.mix(buffer, start, end);
        }

        public int replace(double[] buffer, int start, int end) {
            if (this.isTrapped()) {
                Arrays.fill(buffer, start, end, 0.0);
                return end - start;
            }
            return this.inputstream.replace(buffer, start, end);
        }

        public int isStatic(double[] buffer, int len) {
            if (this.isTrapped()) {
                buffer[0] = 0.0;
                return len;
            }
            return this.inputstream.isStatic(buffer, len);
        }

        public void close() {
            if (this.inputstream != null) {
                this.inputstream.close();
            }
            MidiSequence.getInstance(AudioMidiTrapInstance.this.midi).removeReceiver(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void send(MidiMessage arg0, long arg1) {
            if (this.m_trapped) {
                ArrayList<MidiMessage> arrayList = this.midiqueue;
                synchronized (arrayList) {
                    this.midiqueue.add(arg0);
                    if (arg0 instanceof ShortMessage && ((ShortMessage)arg0).getCommand() == 144 && ((ShortMessage)arg0).getData2() > 0) {
                        this.trapped = false;
                    }
                }
            } else {
                this.mout.send(arg0, arg1);
            }
        }
    }
}

