/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.midi;

import java.util.Arrays;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;
import rasmus.interpreter.Variable;
import rasmus.interpreter.midi.MidiSequence;
import rasmus.interpreter.sampled.AudioCache;
import rasmus.interpreter.sampled.AudioEvent;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;
import rasmus.interpreter.sampled.AudioStreamable;
import rasmus.interpreter.sampled.BeatToTimeMapper;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class AudioGainInstance
extends UnitInstanceAdapter
implements AudioStreamable {
    public Variable output;
    public Variable input;
    Variable answer = new Variable();

    public void calc() {
    }

    public AudioGainInstance(Parameters parameters) {
        this.output = parameters.getParameterWithDefault("output");
        this.input = parameters.getParameterWithDefault("input");
        this.answer = AudioEvents.asVariable(new AudioEvent(0.0, this));
        this.output.add(this.answer);
    }

    public void close() {
        this.output.remove(this.answer);
    }

    public AudioStream openStream(AudioSession session) {
        return new FilterStreamInstance(session);
    }

    class FilterStreamInstance
    implements AudioStream,
    Receiver {
        Sequence iseq;
        long position = 0L;
        Track track;
        MidiEvent midievent = null;
        int trackpos = 0;
        double beatfactor = 1.0 / (double)MidiSequence.DEFAULT_RES;
        BeatToTimeMapper bmap;
        long nexttime = 0L;
        double rate;
        int channels;
        boolean realtime;
        double max_step_size = 1.0;
        double pan = 0.5;
        double balance = 0.5;
        double volume = 1.0;
        double expression = 1.0;
        double reverb = 0.5;
        double chorus = 0.0;
        double[] current_value;
        double[] target_value;
        MidiSequence midiseq = null;
        AudioSession session;
        AudioCache audiocache;
        boolean firstbuffer = true;

        public void calcValues() {
            double balanceR;
            double balanceL;
            int chs = this.current_value.length;
            if (this.balance > 0.5) {
                balanceL = 1.0 - 2.0 * (this.balance - 0.5);
                balanceR = 1.0;
            } else {
                balanceL = 1.0;
                balanceR = 2.0 * this.balance;
            }
            if (chs > 0) {
                this.target_value[0] = this.volume * this.expression * Math.cos(this.pan * Math.PI * 0.5) * balanceL;
            }
            if (chs > 1) {
                this.target_value[1] = this.volume * this.expression * Math.sin(this.pan * Math.PI * 0.5) * balanceR;
            }
            if (chs > 2) {
                this.target_value[2] = this.reverb;
            }
            if (chs > 3) {
                this.target_value[2] = this.chorus;
            }
        }

        public FilterStreamInstance(AudioSession session) {
            this.audiocache = session.getAudioCache();
            this.session = session;
            this.bmap = session.getBeatToTimeMap();
            this.rate = session.getRate();
            this.channels = session.getChannels();
            this.realtime = session.isRealTime();
            this.current_value = new double[session.getChannels()];
            this.target_value = new double[session.getChannels()];
            int i = 0;
            while (i < this.current_value.length) {
                this.current_value[i] = 0.0;
                this.target_value[i] = 0.0;
                ++i;
            }
            this.calcValues();
            this.max_step_size = 200.0 / ((double)this.channels * this.rate);
            if (this.realtime) {
                this.midiseq = MidiSequence.getInstance(AudioGainInstance.this.input);
                this.midiseq.addReceiver(this);
            } else {
                this.iseq = MidiSequence.asSequence(AudioGainInstance.this.input);
                this.track = this.iseq.getTracks()[0];
                if (this.track.size() != 0) {
                    this.midievent = this.track.get(0);
                    this.nexttime = AudioEvents.TimeToStreamTime(this.bmap.getTime((double)this.midievent.getTick() * this.beatfactor), this.rate, this.channels);
                    if (this.nexttime < 0L) {
                        this.nexttime = 0L;
                    }
                }
                this.trackpos = 0;
            }
        }

        public void processMidiMessage(MidiMessage mmsg) {
            ShortMessage smmsg;
            if (mmsg instanceof ShortMessage && (smmsg = (ShortMessage)mmsg).getCommand() == 176) {
                int data1 = smmsg.getData1();
                if (data1 == 7) {
                    this.volume = (double)smmsg.getData2() / 127.0;
                    this.calcValues();
                    return;
                }
                if (data1 == 8) {
                    this.balance = (double)(smmsg.getData2() - 1) / 126.0;
                    if (this.balance < 0.0) {
                        this.balance = 0.0;
                    }
                    this.calcValues();
                    return;
                }
                if (data1 == 10) {
                    this.pan = (double)(smmsg.getData2() - 1) / 126.0;
                    if (this.pan < 0.0) {
                        this.pan = 0.0;
                    }
                    this.calcValues();
                    return;
                }
                if (data1 == 11) {
                    this.expression = (double)smmsg.getData1() / 127.0;
                    this.calcValues();
                    return;
                }
                if (data1 == 91) {
                    this.reverb = (double)smmsg.getData1() / 127.0;
                    this.calcValues();
                    return;
                }
                if (data1 == 93) {
                    this.chorus = (double)smmsg.getData1() / 127.0;
                    this.calcValues();
                    return;
                }
                if (data1 == 121) {
                    this.pan = 0.5;
                    this.balance = 0.5;
                    this.volume = 1.0;
                    this.expression = 1.0;
                    this.reverb = 0.5;
                    this.chorus = 0.0;
                    this.calcValues();
                    return;
                }
            }
        }

        public void processSkip(int len) {
            int m = 0;
            while (m < this.current_value.length) {
                this.processSkip(len, m);
                ++m;
            }
        }

        public void processSkip(int len, int m) {
            double step_value;
            int ix = 0;
            double cur = this.current_value[m];
            double tar = this.target_value[m];
            if (this.firstbuffer) {
                this.firstbuffer = false;
                cur = tar;
            }
            if (cur > tar) {
                step_value = -this.max_step_size;
                while (cur != tar) {
                    if ((cur += step_value) < tar) {
                        cur = tar;
                        break;
                    }
                    if (++ix != len) continue;
                    this.current_value[m] = cur;
                    return;
                }
            }
            if (cur < tar) {
                step_value = this.max_step_size;
                while (cur != tar) {
                    if ((cur += step_value) > tar) {
                        cur = tar;
                        break;
                    }
                    if (++ix != len) continue;
                    this.current_value[m] = cur;
                    return;
                }
            }
            this.current_value[m] = cur;
        }

        public void processAudio(double[] buffer, int start, int end) {
            int m = 0;
            while (m < this.current_value.length) {
                this.processAudio(buffer, start, end, m);
                ++m;
            }
        }

        public void processAudio(double[] buffer, int start, int end, int m) {
            double step_value;
            int chs = this.session.getChannels();
            int ix = start + m;
            double cur = this.current_value[m];
            double tar = this.target_value[m];
            if (this.firstbuffer) {
                this.firstbuffer = false;
                cur = tar;
            }
            if (cur > tar) {
                step_value = -this.max_step_size;
                while (cur != tar) {
                    if ((cur += step_value) < tar) {
                        cur = tar;
                        break;
                    }
                    int n = ix;
                    buffer[n] = buffer[n] + cur;
                    if ((ix += chs) < end) continue;
                    this.current_value[m] = cur;
                    return;
                }
            }
            if (cur < tar) {
                step_value = this.max_step_size;
                while (cur != tar) {
                    if ((cur += step_value) > tar) {
                        cur = tar;
                        break;
                    }
                    int n = ix;
                    buffer[n] = buffer[n] + cur;
                    if ((ix += chs) < end) continue;
                    this.current_value[m] = cur;
                    return;
                }
            }
            this.current_value[m] = cur;
            while (ix < end) {
                int n = ix;
                buffer[n] = buffer[n] + cur;
                ix += chs;
            }
        }

        public int skip(int len) {
            if (this.realtime) {
                this.processSkip(len);
                return len;
            }
            long endposition = this.position + (long)len;
            int writepos = 0;
            while (this.nexttime <= endposition && this.midievent != null) {
                MidiMessage mmsg = this.midievent.getMessage();
                this.processMidiMessage(mmsg);
                long deltatime = this.nexttime - this.position;
                if (deltatime != 0L) {
                    this.processSkip((int)deltatime);
                }
                this.position = this.nexttime;
                writepos = (int)((long)writepos + deltatime);
                ++this.trackpos;
                if (this.trackpos < this.track.size()) {
                    this.midievent = this.track.get(this.trackpos);
                    this.nexttime = AudioEvents.TimeToStreamTime(this.bmap.getTime((double)this.midievent.getTick() * this.beatfactor), this.rate, this.channels);
                    if (this.nexttime >= 0L) continue;
                    this.nexttime = 0L;
                    continue;
                }
                this.midievent = null;
            }
            long deltatime = endposition - this.position;
            if (deltatime != 0L) {
                this.processSkip((int)deltatime);
            }
            this.position = endposition;
            return len;
        }

        public int mix(double[] buffer, int start, int end) {
            if (this.realtime) {
                this.processAudio(buffer, start, end);
                return end - start;
            }
            long endposition = this.position + (long)end - (long)start;
            int writepos = 0;
            while (this.nexttime <= endposition && this.midievent != null) {
                MidiMessage mmsg = this.midievent.getMessage();
                this.processMidiMessage(mmsg);
                long deltatime = this.nexttime - this.position;
                if (deltatime != 0L) {
                    this.processAudio(buffer, writepos, (int)((long)writepos + deltatime));
                }
                this.position = this.nexttime;
                writepos = (int)((long)writepos + deltatime);
                ++this.trackpos;
                if (this.trackpos < this.track.size()) {
                    this.midievent = this.track.get(this.trackpos);
                    this.nexttime = AudioEvents.TimeToStreamTime(this.bmap.getTime((double)this.midievent.getTick() * this.beatfactor), this.rate, this.channels);
                    if (this.nexttime >= 0L) continue;
                    this.nexttime = 0L;
                    continue;
                }
                this.midievent = null;
            }
            long deltatime = endposition - this.position;
            if (deltatime != 0L) {
                this.processAudio(buffer, writepos, (int)((long)writepos + deltatime));
            }
            this.position = endposition;
            return end - start;
        }

        public int replace(double[] buffer, int start, int end) {
            Arrays.fill(buffer, start, end, 0.0);
            return this.mix(buffer, start, end);
        }

        public int isStatic(double[] buffer, int len) {
            double cur = this.current_value[0];
            int m = 0;
            while (m < this.current_value.length) {
                if (Math.abs(this.current_value[m] - cur) > 1.0E-9) {
                    return -1;
                }
                if (Math.abs(this.target_value[m] - cur) > 1.0E-9) {
                    return -1;
                }
                ++m;
            }
            buffer[0] = this.current_value[0];
            if (!this.realtime) {
                if (this.midievent == null) {
                    return len;
                }
                long endposition = this.position + (long)len;
                if (this.nexttime <= endposition && this.midievent != null) {
                    return -1;
                }
                this.position = endposition;
            }
            return len;
        }

        public void close() {
            if (this.midiseq != null) {
                this.midiseq.removeReceiver(this);
            }
        }

        public void send(MidiMessage arg0, long arg1) {
            this.processMidiMessage(arg0);
        }
    }
}

