/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.math;

import java.util.Arrays;
import rasmus.interpreter.Variable;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.sampled.AudioCache;
import rasmus.interpreter.sampled.AudioEvent;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.AudioFallBackStream;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;
import rasmus.interpreter.sampled.AudioStreamable;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class AudioOperatorInstance
extends UnitInstanceAdapter
implements AudioStreamable {
    Variable output;
    Variable input;
    Variable answer = null;
    Variable input2;
    int opr = 0;
    int oopr = 0;
    Variable oinput;
    Variable oinput2;

    public static void fastSin_MIX(double[] outbuffer, double[] buffer, int start, int end) {
        double piD2 = 1.5707963267948966;
        double NpiD2 = -1.5707963267948966;
        double pi = Math.PI;
        double pi2 = Math.PI * 2;
        double pi3 = Math.PI * 3;
        int i = start;
        while (i < end) {
            double x = buffer[i];
            if ((x = (x + Math.PI * 3) % (Math.PI * 2) - Math.PI) > 1.5707963267948966) {
                x = Math.PI - x;
            } else if (x < -1.5707963267948966) {
                x = -Math.PI - x;
            }
            double x2 = x * x;
            int n = i++;
            outbuffer[n] = outbuffer[n] + x * (x2 * (x2 * (x2 * (x2 * 2.7557319223985893E-6 - 1.984126984126984E-4) + 0.008333333333333333) - 0.16666666666666666) + 1.0);
        }
    }

    public static void fastSin_REPLACE(double[] outbuffer, double[] buffer, int start, int end) {
        double piD2 = 1.5707963267948966;
        double NpiD2 = -1.5707963267948966;
        double pi = Math.PI;
        double pi2 = Math.PI * 2;
        double pi3 = Math.PI * 3;
        int i = start;
        while (i < end) {
            double x = buffer[i];
            if ((x = (x + Math.PI * 3) % (Math.PI * 2) - Math.PI) > 1.5707963267948966) {
                x = Math.PI - x;
            } else if (x < -1.5707963267948966) {
                x = -Math.PI - x;
            }
            double x2 = x * x;
            outbuffer[i] = x * (x2 * (x2 * (x2 * (x2 * 2.7557319223985893E-6 - 1.984126984126984E-4) + 0.008333333333333333) - 0.16666666666666666) + 1.0);
            ++i;
        }
    }

    public static void fastCos_MIX(double[] outbuffer, double[] buffer, int start, int end) {
        double piD2 = 1.5707963267948966;
        double NpiD2 = -1.5707963267948966;
        double pi = Math.PI;
        double pi2 = Math.PI * 2;
        double pi3 = 10.995574287564276;
        int i = start;
        while (i < end) {
            double x = buffer[i];
            if ((x = (x + 10.995574287564276) % (Math.PI * 2) - Math.PI) > 1.5707963267948966) {
                x = Math.PI - x;
            } else if (x < -1.5707963267948966) {
                x = -Math.PI - x;
            }
            double x2 = x * x;
            int n = i++;
            outbuffer[n] = outbuffer[n] + x * (x2 * (x2 * (x2 * (x2 * 2.7557319223985893E-6 - 1.984126984126984E-4) + 0.008333333333333333) - 0.16666666666666666) + 1.0);
        }
    }

    public static void fastCos_REPLACE(double[] outbuffer, double[] buffer, int start, int end) {
        double piD2 = 1.5707963267948966;
        double NpiD2 = -1.5707963267948966;
        double pi = Math.PI;
        double pi2 = Math.PI * 2;
        double pi3 = 10.995574287564276;
        int i = start;
        while (i < end) {
            double x = buffer[i];
            if ((x = (x + 10.995574287564276) % (Math.PI * 2) - Math.PI) > 1.5707963267948966) {
                x = Math.PI - x;
            } else if (x < -1.5707963267948966) {
                x = -Math.PI - x;
            }
            double x2 = x * x;
            outbuffer[i] = x * (x2 * (x2 * (x2 * (x2 * 2.7557319223985893E-6 - 1.984126984126984E-4) + 0.008333333333333333) - 0.16666666666666666) + 1.0);
            ++i;
        }
    }

    public static void fastTan_REPLACE(double[] outbuffer, double[] buffer, int start, int end) {
        double PI_d2 = 1.5707963267948966;
        double PI_d4 = 0.7853981633974483;
        int i = start;
        while (i < end) {
            double x16;
            double x8;
            double x4;
            double x2;
            double x = buffer[i];
            if (x > PI_d4) {
                x = PI_d2 - x;
                x2 = x * x;
                x4 = x2 * x2;
                x8 = x4 * x4;
                x16 = x8 * x8;
                outbuffer[i] = 1.0 / (x * (x2 / 13.0 + 2.0 * x4 / 15.0 + 2.0 * x16 / 315.0));
            } else {
                x2 = x * x;
                x4 = x2 * x2;
                x8 = x4 * x4;
                x16 = x8 * x8;
                outbuffer[i] = x * (x2 / 13.0 + 2.0 * x4 / 15.0 + 2.0 * x16 / 315.0);
            }
            ++i;
        }
    }

    public static void fastTan_MIX(double[] outbuffer, double[] buffer, int start, int end) {
        double PI_d2 = 1.5707963267948966;
        double PI_d4 = 0.7853981633974483;
        int i = start;
        while (i < end) {
            double x16;
            double x8;
            double x4;
            double x2;
            double x = buffer[i];
            if (x > PI_d4) {
                x = PI_d2 - x;
                x2 = x * x;
                x4 = x2 * x2;
                x8 = x4 * x4;
                x16 = x8 * x8;
                int n = i;
                outbuffer[n] = outbuffer[n] + 1.0 / (x * (x2 / 13.0 + 2.0 * x4 / 15.0 + 2.0 * x16 / 315.0));
            } else {
                x2 = x * x;
                x4 = x2 * x2;
                x8 = x4 * x4;
                x16 = x8 * x8;
                int n = i;
                outbuffer[n] = outbuffer[n] + x * (x2 / 13.0 + 2.0 * x4 / 15.0 + 2.0 * x16 / 315.0);
            }
            ++i;
        }
    }

    public void recalc() {
        this.input2 = this.oinput;
        this.input = this.oinput2;
        if (this.opr == 1) {
            this.opr = 11;
        } else if (this.opr == 5) {
            this.opr = 6;
        } else if (this.opr == 7) {
            this.opr = 8;
        } else if (this.opr == 204) {
            this.opr = 205;
        } else if (this.opr == 200) {
            this.opr = 206;
        } else if (this.opr == 201) {
            this.opr = 207;
        } else if (this.opr == 11) {
            this.opr = 1;
        } else if (this.opr == 6) {
            this.opr = 5;
        } else if (this.opr == 8) {
            this.opr = 7;
        } else if (this.opr == 205) {
            this.opr = 204;
        } else if (this.opr == 206) {
            this.opr = 200;
        } else if (this.opr == 207) {
            this.opr = 201;
        }
        if (this.answer == null) {
            this.answer = AudioEvents.asVariable(new AudioEvent(0.0, this));
            this.output.add(this.answer);
        }
    }

    public void calc() {
        this.input = this.oinput;
        this.input2 = this.oinput2;
        this.opr = this.oopr;
        if (AudioEvents.getInstance((Variable)this.input).track.size() == 0) {
            if (this.input2 != null && AudioEvents.getInstance((Variable)this.input2).track.size() != 0 && (this.opr >= 0 && this.opr < 100 || this.opr >= 200 && this.opr < 300)) {
                this.recalc();
                return;
            }
            if (this.answer != null) {
                this.output.remove(this.answer);
                this.answer = null;
            }
        } else if (this.answer == null) {
            this.answer = AudioEvents.asVariable(new AudioEvent(0.0, this));
            this.output.add(this.answer);
        }
    }

    public AudioOperatorInstance(Parameters parameters, int opr) {
        this.opr = opr;
        this.output = parameters.getParameterWithDefault("output");
        this.input = parameters.getParameter("input");
        if (this.input != null) {
            this.input2 = parameters.getParameterWithDefault(1, "input2");
        } else {
            this.input = parameters.getParameterWithDefault(1, "input");
            this.input2 = parameters.getParameterWithDefault(2, "input2");
        }
        this.oinput = this.input;
        this.oinput2 = this.input2;
        this.oopr = opr;
        AudioEvents.getInstance(this.input).addListener(this);
        if (this.input2 != null) {
            AudioEvents.getInstance(this.input2).addListener(this);
        }
        this.calc();
    }

    public void close() {
        if (this.answer != null) {
            this.output.remove(this.answer);
        }
    }

    public AudioStream openStream(AudioSession session) {
        return new FilterStreamInstance(session);
    }

    class FilterStreamInstance
    implements AudioStream {
        double ff_2;
        AudioFallBackStream inputstream;
        AudioFallBackStream inputstream2;
        int lopr;
        boolean inputstream2_eof;
        AudioCache audiocache;

        public FilterStreamInstance(AudioSession session) {
            this.ff_2 = DoublePart.asDouble(AudioOperatorInstance.this.input2);
            this.lopr = AudioOperatorInstance.this.opr;
            this.inputstream2_eof = false;
            this.audiocache = session.getAudioCache();
            this.inputstream = new AudioFallBackStream(AudioEvents.openStream(AudioOperatorInstance.this.input, session));
            if (AudioOperatorInstance.this.opr != 2 && (AudioOperatorInstance.this.opr < 100 || AudioOperatorInstance.this.opr >= 200)) {
                if (AudioEvents.getInstance((Variable)AudioOperatorInstance.this.input2).track.size() == 0) {
                    this.inputstream2_eof = true;
                } else {
                    this.inputstream2 = new AudioFallBackStream(AudioEvents.openStream(AudioOperatorInstance.this.input2, session));
                }
            } else {
                this.inputstream2_eof = true;
            }
        }

        public int isStatic(double[] buffer, int len) {
            int ret;
            block59: {
                int i;
                int end;
                int start;
                double[] stockbuffer2;
                double[] stockbuffer;
                block87: {
                    block86: {
                        block85: {
                            block84: {
                                block83: {
                                    block82: {
                                        block81: {
                                            block80: {
                                                block79: {
                                                    block78: {
                                                        block77: {
                                                            block76: {
                                                                block75: {
                                                                    block74: {
                                                                        block73: {
                                                                            block72: {
                                                                                block71: {
                                                                                    block70: {
                                                                                        block69: {
                                                                                            block68: {
                                                                                                block67: {
                                                                                                    block66: {
                                                                                                        block65: {
                                                                                                            block64: {
                                                                                                                block63: {
                                                                                                                    block62: {
                                                                                                                        block61: {
                                                                                                                            block60: {
                                                                                                                                block58: {
                                                                                                                                    double d;
                                                                                                                                    stockbuffer = new double[1];
                                                                                                                                    stockbuffer2 = new double[1];
                                                                                                                                    ret = this.inputstream.isStatic(stockbuffer, len);
                                                                                                                                    if (ret == -1) {
                                                                                                                                        return -1;
                                                                                                                                    }
                                                                                                                                    if (this.inputstream2_eof) {
                                                                                                                                        stockbuffer2[0] = this.ff_2;
                                                                                                                                    } else if (this.inputstream2 != null) {
                                                                                                                                        int ret2 = this.inputstream2.isStatic(stockbuffer2, len);
                                                                                                                                        if (ret2 == -1) {
                                                                                                                                            this.inputstream.fallBack();
                                                                                                                                            return -1;
                                                                                                                                        }
                                                                                                                                        if (ret2 != ret) {
                                                                                                                                            this.inputstream.fallBack();
                                                                                                                                            this.inputstream2.fallBack();
                                                                                                                                            return -1;
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                    start = 0;
                                                                                                                                    end = 1;
                                                                                                                                    if (this.lopr == 0) {
                                                                                                                                        i = start;
                                                                                                                                        while (i < end) {
                                                                                                                                            buffer[i] = stockbuffer[i] * stockbuffer2[i];
                                                                                                                                            ++i;
                                                                                                                                        }
                                                                                                                                    } else if (this.lopr == 1) {
                                                                                                                                        i = start;
                                                                                                                                        while (i < end) {
                                                                                                                                            buffer[i] = stockbuffer[i] / stockbuffer2[i];
                                                                                                                                            ++i;
                                                                                                                                        }
                                                                                                                                    } else if (this.lopr == 2) {
                                                                                                                                        i = start;
                                                                                                                                        while (i < end) {
                                                                                                                                            buffer[i] = -stockbuffer[i];
                                                                                                                                            ++i;
                                                                                                                                        }
                                                                                                                                    } else if (this.lopr == 3) {
                                                                                                                                        i = start;
                                                                                                                                        while (i < end) {
                                                                                                                                            buffer[i] = stockbuffer[i] + stockbuffer2[i];
                                                                                                                                            ++i;
                                                                                                                                        }
                                                                                                                                    } else if (this.lopr == 4) {
                                                                                                                                        i = start;
                                                                                                                                        while (i < end) {
                                                                                                                                            buffer[i] = stockbuffer[i] % stockbuffer2[i];
                                                                                                                                            ++i;
                                                                                                                                        }
                                                                                                                                    } else if (this.lopr == 5) {
                                                                                                                                        i = start;
                                                                                                                                        while (i < end) {
                                                                                                                                            buffer[i] = stockbuffer[i] > stockbuffer2[i] ? 1.0 : 0.0;
                                                                                                                                            ++i;
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                    if (this.lopr == 6) {
                                                                                                                                        i = start;
                                                                                                                                        while (i < end) {
                                                                                                                                            buffer[i] = stockbuffer[i] < stockbuffer2[i] ? 1.0 : 0.0;
                                                                                                                                            ++i;
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                    if (this.lopr == 7) {
                                                                                                                                        i = start;
                                                                                                                                        while (i < end) {
                                                                                                                                            buffer[i] = stockbuffer[i] >= stockbuffer2[i] ? 1.0 : 0.0;
                                                                                                                                            ++i;
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                    if (this.lopr == 8) {
                                                                                                                                        i = start;
                                                                                                                                        while (i < end) {
                                                                                                                                            buffer[i] = stockbuffer[i] <= stockbuffer2[i] ? 1.0 : 0.0;
                                                                                                                                            ++i;
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                    if (this.lopr == 9) {
                                                                                                                                        i = start;
                                                                                                                                        while (i < end) {
                                                                                                                                            d = stockbuffer[i] - stockbuffer2[i];
                                                                                                                                            buffer[i] = d > 1.0E-5 || d < -1.0E-5 ? 1.0 : 0.0;
                                                                                                                                            ++i;
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                    if (this.lopr != 10) break block58;
                                                                                                                                    i = start;
                                                                                                                                    while (i < end) {
                                                                                                                                        d = stockbuffer[i] - stockbuffer2[i];
                                                                                                                                        buffer[i] = d < 1.0E-5 && d > -1.0E-5 ? 1.0 : 0.0;
                                                                                                                                        ++i;
                                                                                                                                    }
                                                                                                                                    break block59;
                                                                                                                                }
                                                                                                                                if (this.lopr != 11) break block60;
                                                                                                                                i = start;
                                                                                                                                while (i < end) {
                                                                                                                                    buffer[i] = stockbuffer2[i] / stockbuffer[i];
                                                                                                                                    ++i;
                                                                                                                                }
                                                                                                                                break block59;
                                                                                                                            }
                                                                                                                            if (this.lopr != 100) break block61;
                                                                                                                            i = start;
                                                                                                                            while (i < end) {
                                                                                                                                buffer[i] = Math.abs(stockbuffer[i]);
                                                                                                                                ++i;
                                                                                                                            }
                                                                                                                            break block59;
                                                                                                                        }
                                                                                                                        if (this.lopr != 101) break block62;
                                                                                                                        i = start;
                                                                                                                        while (i < end) {
                                                                                                                            buffer[i] = Math.acos(stockbuffer[i]);
                                                                                                                            ++i;
                                                                                                                        }
                                                                                                                        break block59;
                                                                                                                    }
                                                                                                                    if (this.lopr != 102) break block63;
                                                                                                                    i = start;
                                                                                                                    while (i < end) {
                                                                                                                        buffer[i] = Math.asin(stockbuffer[i]);
                                                                                                                        ++i;
                                                                                                                    }
                                                                                                                    break block59;
                                                                                                                }
                                                                                                                if (this.lopr != 103) break block64;
                                                                                                                i = start;
                                                                                                                while (i < end) {
                                                                                                                    buffer[i] = Math.atan(stockbuffer[i]);
                                                                                                                    ++i;
                                                                                                                }
                                                                                                                break block59;
                                                                                                            }
                                                                                                            if (this.lopr != 104) break block65;
                                                                                                            i = start;
                                                                                                            while (i < end) {
                                                                                                                buffer[i] = Math.ceil(stockbuffer[i]);
                                                                                                                ++i;
                                                                                                            }
                                                                                                            break block59;
                                                                                                        }
                                                                                                        if (this.lopr != 105) break block66;
                                                                                                        i = start;
                                                                                                        while (i < end) {
                                                                                                            buffer[i] = Math.cos(stockbuffer[i]);
                                                                                                            ++i;
                                                                                                        }
                                                                                                        break block59;
                                                                                                    }
                                                                                                    if (this.lopr != 106) break block67;
                                                                                                    i = start;
                                                                                                    while (i < end) {
                                                                                                        buffer[i] = Math.exp(stockbuffer[i]);
                                                                                                        ++i;
                                                                                                    }
                                                                                                    break block59;
                                                                                                }
                                                                                                if (this.lopr != 107) break block68;
                                                                                                i = start;
                                                                                                while (i < end) {
                                                                                                    buffer[i] = Math.floor(stockbuffer[i]);
                                                                                                    ++i;
                                                                                                }
                                                                                                break block59;
                                                                                            }
                                                                                            if (this.lopr != 108) break block69;
                                                                                            i = start;
                                                                                            while (i < end) {
                                                                                                buffer[i] = Math.log(stockbuffer[i]);
                                                                                                ++i;
                                                                                            }
                                                                                            break block59;
                                                                                        }
                                                                                        if (this.lopr != 109) break block70;
                                                                                        i = start;
                                                                                        while (i < end) {
                                                                                            buffer[i] = Math.rint(stockbuffer[i]);
                                                                                            ++i;
                                                                                        }
                                                                                        break block59;
                                                                                    }
                                                                                    if (this.lopr != 110) break block71;
                                                                                    i = start;
                                                                                    while (i < end) {
                                                                                        buffer[i] = Math.round(stockbuffer[i]);
                                                                                        ++i;
                                                                                    }
                                                                                    break block59;
                                                                                }
                                                                                if (this.lopr != 111) break block72;
                                                                                i = start;
                                                                                while (i < end) {
                                                                                    buffer[i] = Math.sin(stockbuffer[i]);
                                                                                    ++i;
                                                                                }
                                                                                break block59;
                                                                            }
                                                                            if (this.lopr != 112) break block73;
                                                                            i = start;
                                                                            while (i < end) {
                                                                                buffer[i] = Math.sqrt(stockbuffer[i]);
                                                                                ++i;
                                                                            }
                                                                            break block59;
                                                                        }
                                                                        if (this.lopr != 113) break block74;
                                                                        i = start;
                                                                        while (i < end) {
                                                                            buffer[i] = Math.tan(stockbuffer[i]);
                                                                            ++i;
                                                                        }
                                                                        break block59;
                                                                    }
                                                                    if (this.lopr != 114) break block75;
                                                                    i = start;
                                                                    while (i < end) {
                                                                        buffer[i] = Math.toDegrees(stockbuffer[i]);
                                                                        ++i;
                                                                    }
                                                                    break block59;
                                                                }
                                                                if (this.lopr != 115) break block76;
                                                                i = start;
                                                                while (i < end) {
                                                                    buffer[i] = Math.toRadians(stockbuffer[i]);
                                                                    ++i;
                                                                }
                                                                break block59;
                                                            }
                                                            if (this.lopr != 116) break block77;
                                                            i = start;
                                                            while (i < end) {
                                                                double calc = stockbuffer[i];
                                                                calc = calc > 0.0 ? 1.0 : (calc < 0.0 ? -1.0 : 0.0);
                                                                buffer[i] = calc;
                                                                ++i;
                                                            }
                                                            break block59;
                                                        }
                                                        if (this.lopr != 151) break block78;
                                                        AudioOperatorInstance.fastSin_REPLACE(buffer, stockbuffer, start, end);
                                                        break block59;
                                                    }
                                                    if (this.lopr != 152) break block79;
                                                    AudioOperatorInstance.fastCos_REPLACE(buffer, stockbuffer, start, end);
                                                    break block59;
                                                }
                                                if (this.lopr != 153) break block80;
                                                AudioOperatorInstance.fastTan_REPLACE(buffer, stockbuffer, start, end);
                                                break block59;
                                            }
                                            if (this.lopr != 200) break block81;
                                            i = start;
                                            while (i < end) {
                                                buffer[i] = Math.IEEEremainder(stockbuffer[i], stockbuffer2[i]);
                                                ++i;
                                            }
                                            break block59;
                                        }
                                        if (this.lopr != 201) break block82;
                                        i = start;
                                        while (i < end) {
                                            buffer[i] = Math.atan2(stockbuffer[i], stockbuffer2[i]);
                                            ++i;
                                        }
                                        break block59;
                                    }
                                    if (this.lopr != 202) break block83;
                                    i = start;
                                    while (i < end) {
                                        buffer[i] = Math.min(stockbuffer[i], stockbuffer2[i]);
                                        ++i;
                                    }
                                    break block59;
                                }
                                if (this.lopr != 203) break block84;
                                i = start;
                                while (i < end) {
                                    buffer[i] = Math.max(stockbuffer[i], stockbuffer2[i]);
                                    ++i;
                                }
                                break block59;
                            }
                            if (this.lopr != 204) break block85;
                            i = start;
                            while (i < end) {
                                buffer[i] = Math.pow(stockbuffer[i], stockbuffer2[i]);
                                ++i;
                            }
                            break block59;
                        }
                        if (this.lopr != 205) break block86;
                        i = start;
                        while (i < end) {
                            buffer[i] = Math.pow(stockbuffer2[i], stockbuffer[i]);
                            ++i;
                        }
                        break block59;
                    }
                    if (this.lopr != 206) break block87;
                    i = start;
                    while (i < end) {
                        buffer[i] = Math.IEEEremainder(stockbuffer2[i], stockbuffer[i]);
                        ++i;
                    }
                    break block59;
                }
                if (this.lopr != 207) break block59;
                i = start;
                while (i < end) {
                    buffer[i] = Math.atan2(stockbuffer2[i], stockbuffer[i]);
                    ++i;
                }
            }
            return ret;
        }

        public int skip(int len) {
            int ret2;
            int ret = this.inputstream.skip(len);
            if (this.inputstream2 != null && !this.inputstream2_eof && (ret2 = this.inputstream2.skip(len)) == -1) {
                this.inputstream2_eof = true;
            }
            return ret;
        }

        public int mix(double[] buffer, int start, int end) {
            int i;
            double f_2 = this.ff_2;
            double[] stockbuffer = this.audiocache.getBuffer(end);
            int ret = this.inputstream.replace(stockbuffer, start, end);
            if (ret == -1) {
                if (stockbuffer != null) {
                    this.audiocache.returnBuffer(stockbuffer);
                }
                return -1;
            }
            boolean onlyvar = false;
            double[] stockbuffer2 = null;
            if (this.inputstream2_eof) {
                onlyvar = true;
            } else if (this.inputstream2 != null && !this.inputstream2_eof) {
                stockbuffer2 = this.audiocache.getBuffer(end);
                int ret2 = this.inputstream2.replace(stockbuffer2, start, end);
                if (ret2 == -1) {
                    this.inputstream2_eof = true;
                    onlyvar = true;
                } else {
                    Arrays.fill(stockbuffer2, start + ret2, end, f_2);
                }
            }
            end = start + ret;
            if (onlyvar) {
                double d;
                if (this.lopr == 0) {
                    if (f_2 == 0.0) {
                        if (stockbuffer != null) {
                            this.audiocache.returnBuffer(stockbuffer);
                        }
                        return -1;
                    }
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + stockbuffer[i] * f_2;
                        ++i;
                    }
                } else if (this.lopr == 1) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + stockbuffer[i] / f_2;
                        ++i;
                    }
                } else if (this.lopr == 2) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] - stockbuffer[i];
                        ++i;
                    }
                } else if (this.lopr == 3) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + (stockbuffer[i] + f_2);
                        ++i;
                    }
                } else if (this.lopr == 4) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + stockbuffer[i] % f_2;
                        ++i;
                    }
                } else if (this.lopr == 5) {
                    i = start;
                    while (i < end) {
                        if (stockbuffer[i] > f_2) {
                            int n = i;
                            buffer[n] = buffer[n] + 1.0;
                        }
                        ++i;
                    }
                }
                if (this.lopr == 6) {
                    i = start;
                    while (i < end) {
                        if (stockbuffer[i] < f_2) {
                            int n = i;
                            buffer[n] = buffer[n] + 1.0;
                        }
                        ++i;
                    }
                }
                if (this.lopr == 7) {
                    i = start;
                    while (i < end) {
                        if (stockbuffer[i] >= f_2) {
                            int n = i;
                            buffer[n] = buffer[n] + 1.0;
                        }
                        ++i;
                    }
                }
                if (this.lopr == 8) {
                    i = start;
                    while (i < end) {
                        if (stockbuffer[i] <= f_2) {
                            int n = i;
                            buffer[n] = buffer[n] + 1.0;
                        }
                        ++i;
                    }
                }
                if (this.lopr == 9) {
                    i = start;
                    while (i < end) {
                        d = stockbuffer[i] - f_2;
                        if (d > 1.0E-5 || d < -1.0E-5) {
                            int n = i;
                            buffer[n] = buffer[n] + 1.0;
                        }
                        ++i;
                    }
                }
                if (this.lopr == 10) {
                    i = start;
                    while (i < end) {
                        d = stockbuffer[i] - f_2;
                        if (d < 1.0E-5 && d > -1.0E-5) {
                            int n = i;
                            buffer[n] = buffer[n] + 1.0;
                        }
                        ++i;
                    }
                } else if (this.lopr == 11) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + f_2 / stockbuffer[i];
                        ++i;
                    }
                } else if (this.lopr == 100) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + Math.abs(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 101) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + Math.acos(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 102) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + Math.asin(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 103) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + Math.atan(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 104) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + Math.ceil(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 105) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + Math.cos(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 106) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + Math.exp(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 107) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + Math.floor(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 108) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + Math.log(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 109) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + Math.rint(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 110) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + (double)Math.round(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 111) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + Math.sin(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 112) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + Math.sqrt(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 113) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + Math.tan(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 114) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + Math.toDegrees(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 115) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + Math.toRadians(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 116) {
                    i = start;
                    while (i < end) {
                        double calc = stockbuffer[i];
                        calc = calc > 0.0 ? 1.0 : (calc < 0.0 ? -1.0 : 0.0);
                        int n = i++;
                        buffer[n] = buffer[n] + calc;
                    }
                } else if (this.lopr == 151) {
                    AudioOperatorInstance.fastSin_MIX(buffer, stockbuffer, start, end);
                } else if (this.lopr == 151) {
                    AudioOperatorInstance.fastCos_MIX(buffer, stockbuffer, start, end);
                } else if (this.lopr == 151) {
                    AudioOperatorInstance.fastTan_MIX(buffer, stockbuffer, start, end);
                } else if (this.lopr == 200) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + Math.IEEEremainder(stockbuffer[i], f_2);
                        ++i;
                    }
                } else if (this.lopr == 201) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + Math.atan2(stockbuffer[i], f_2);
                        ++i;
                    }
                } else if (this.lopr == 202) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + Math.min(stockbuffer[i], f_2);
                        ++i;
                    }
                } else if (this.lopr == 203) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + Math.max(stockbuffer[i], f_2);
                        ++i;
                    }
                } else if (this.lopr == 204) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + Math.pow(stockbuffer[i], f_2);
                        ++i;
                    }
                } else if (this.lopr == 205) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + Math.pow(f_2, stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 206) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + Math.IEEEremainder(f_2, stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 207) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + Math.atan2(f_2, stockbuffer[i]);
                        ++i;
                    }
                }
            } else {
                double d;
                if (this.lopr == 0) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + stockbuffer[i] * stockbuffer2[i];
                        ++i;
                    }
                } else if (this.lopr == 1) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + stockbuffer[i] / stockbuffer2[i];
                        ++i;
                    }
                } else if (this.lopr == 2) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] - stockbuffer[i];
                        ++i;
                    }
                } else if (this.lopr == 3) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + (stockbuffer[i] + stockbuffer2[i]);
                        ++i;
                    }
                } else if (this.lopr == 4) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + stockbuffer[i] % stockbuffer2[i];
                        ++i;
                    }
                } else if (this.lopr == 5) {
                    i = start;
                    while (i < end) {
                        if (stockbuffer[i] > stockbuffer2[i]) {
                            int n = i;
                            buffer[n] = buffer[n] + 1.0;
                        }
                        ++i;
                    }
                }
                if (this.lopr == 6) {
                    i = start;
                    while (i < end) {
                        if (stockbuffer[i] < stockbuffer2[i]) {
                            int n = i;
                            buffer[n] = buffer[n] + 1.0;
                        }
                        ++i;
                    }
                }
                if (this.lopr == 7) {
                    i = start;
                    while (i < end) {
                        if (stockbuffer[i] >= stockbuffer2[i]) {
                            int n = i;
                            buffer[n] = buffer[n] + 1.0;
                        }
                        ++i;
                    }
                }
                if (this.lopr == 8) {
                    i = start;
                    while (i < end) {
                        if (stockbuffer[i] <= stockbuffer2[i]) {
                            int n = i;
                            buffer[n] = buffer[n] + 1.0;
                        }
                        ++i;
                    }
                }
                if (this.lopr == 9) {
                    i = start;
                    while (i < end) {
                        d = stockbuffer[i] - stockbuffer2[i];
                        if (d > 1.0E-5 || d < -1.0E-5) {
                            int n = i;
                            buffer[n] = buffer[n] + 1.0;
                        }
                        ++i;
                    }
                }
                if (this.lopr == 10) {
                    i = start;
                    while (i < end) {
                        d = stockbuffer[i] - stockbuffer2[i];
                        if (d < 1.0E-5 && d > -1.0E-5) {
                            int n = i;
                            buffer[n] = buffer[n] + 1.0;
                        }
                        ++i;
                    }
                } else if (this.lopr == 11) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + stockbuffer2[i] / stockbuffer[i];
                        ++i;
                    }
                } else if (this.lopr == 100) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + Math.abs(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 101) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + Math.acos(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 102) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + Math.asin(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 103) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + Math.atan(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 104) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + Math.ceil(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 105) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + Math.cos(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 106) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + Math.exp(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 107) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + Math.floor(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 108) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + Math.log(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 109) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + Math.rint(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 110) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + (double)Math.round(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 111) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + Math.sin(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 112) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + Math.sqrt(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 113) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + Math.tan(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 114) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + Math.toDegrees(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 115) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + Math.toRadians(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 116) {
                    i = start;
                    while (i < end) {
                        double calc = stockbuffer[i];
                        calc = calc > 0.0 ? 1.0 : (calc < 0.0 ? -1.0 : 0.0);
                        int n = i++;
                        buffer[n] = buffer[n] + calc;
                    }
                } else if (this.lopr == 151) {
                    AudioOperatorInstance.fastSin_MIX(buffer, stockbuffer, start, end);
                } else if (this.lopr == 151) {
                    AudioOperatorInstance.fastCos_MIX(buffer, stockbuffer, start, end);
                } else if (this.lopr == 151) {
                    AudioOperatorInstance.fastTan_MIX(buffer, stockbuffer, start, end);
                } else if (this.lopr == 200) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + Math.IEEEremainder(stockbuffer[i], stockbuffer2[i]);
                        ++i;
                    }
                } else if (this.lopr == 201) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + Math.atan2(stockbuffer[i], stockbuffer2[i]);
                        ++i;
                    }
                } else if (this.lopr == 202) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + Math.min(stockbuffer[i], stockbuffer2[i]);
                        ++i;
                    }
                } else if (this.lopr == 203) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + Math.max(stockbuffer[i], stockbuffer2[i]);
                        ++i;
                    }
                } else if (this.lopr == 204) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + Math.pow(stockbuffer[i], stockbuffer2[i]);
                        ++i;
                    }
                } else if (this.lopr == 205) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + Math.pow(stockbuffer2[i], stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 206) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + Math.IEEEremainder(stockbuffer2[i], stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 207) {
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + Math.atan2(stockbuffer2[i], stockbuffer[i]);
                        ++i;
                    }
                }
            }
            if (stockbuffer != null) {
                this.audiocache.returnBuffer(stockbuffer);
            }
            if (stockbuffer2 != null) {
                this.audiocache.returnBuffer(stockbuffer2);
            }
            return ret;
        }

        public int replace(double[] buffer, int start, int end) {
            int i;
            double f_2 = this.ff_2;
            double[] stockbuffer = buffer;
            int ret = this.inputstream.replace(stockbuffer, start, end);
            if (ret == -1) {
                return ret;
            }
            boolean onlyvar = false;
            double[] stockbuffer2 = null;
            if (this.inputstream2_eof) {
                onlyvar = true;
            } else if (this.inputstream2 != null && !this.inputstream2_eof) {
                stockbuffer2 = this.audiocache.getBuffer(end);
                int ret2 = this.inputstream2.replace(stockbuffer2, start, end);
                if (ret2 == -1) {
                    this.inputstream2_eof = true;
                    onlyvar = true;
                } else {
                    Arrays.fill(stockbuffer2, start + ret2, end, f_2);
                }
            }
            end = start + ret;
            if (onlyvar) {
                double d;
                if (this.lopr == 0) {
                    if (f_2 == 0.0) {
                        if (stockbuffer2 != null) {
                            this.audiocache.returnBuffer(stockbuffer2);
                        }
                        return -1;
                    }
                    i = start;
                    while (i < end) {
                        buffer[i] = stockbuffer[i] * f_2;
                        ++i;
                    }
                } else if (this.lopr == 1) {
                    i = start;
                    while (i < end) {
                        buffer[i] = stockbuffer[i] / f_2;
                        ++i;
                    }
                } else if (this.lopr == 2) {
                    i = start;
                    while (i < end) {
                        buffer[i] = -stockbuffer[i];
                        ++i;
                    }
                } else if (this.lopr == 3) {
                    i = start;
                    while (i < end) {
                        buffer[i] = stockbuffer[i] + f_2;
                        ++i;
                    }
                } else if (this.lopr == 4) {
                    i = start;
                    while (i < end) {
                        buffer[i] = stockbuffer[i] % f_2;
                        ++i;
                    }
                } else if (this.lopr == 5) {
                    i = start;
                    while (i < end) {
                        buffer[i] = stockbuffer[i] > f_2 ? 1.0 : 0.0;
                        ++i;
                    }
                }
                if (this.lopr == 6) {
                    i = start;
                    while (i < end) {
                        buffer[i] = stockbuffer[i] < f_2 ? 1.0 : 0.0;
                        ++i;
                    }
                }
                if (this.lopr == 7) {
                    i = start;
                    while (i < end) {
                        buffer[i] = stockbuffer[i] >= f_2 ? 1.0 : 0.0;
                        ++i;
                    }
                }
                if (this.lopr == 8) {
                    i = start;
                    while (i < end) {
                        buffer[i] = stockbuffer[i] <= f_2 ? 1.0 : 0.0;
                        ++i;
                    }
                }
                if (this.lopr == 9) {
                    i = start;
                    while (i < end) {
                        d = stockbuffer[i] - f_2;
                        buffer[i] = d > 1.0E-5 || d < -1.0E-5 ? 1.0 : 0.0;
                        ++i;
                    }
                }
                if (this.lopr == 10) {
                    i = start;
                    while (i < end) {
                        d = stockbuffer[i] - f_2;
                        buffer[i] = d < 1.0E-5 && d > -1.0E-5 ? 1.0 : 0.0;
                        ++i;
                    }
                } else if (this.lopr == 11) {
                    i = start;
                    while (i < end) {
                        buffer[i] = f_2 / stockbuffer[i];
                        ++i;
                    }
                } else if (this.lopr == 100) {
                    i = start;
                    while (i < end) {
                        buffer[i] = Math.abs(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 101) {
                    i = start;
                    while (i < end) {
                        buffer[i] = Math.acos(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 102) {
                    i = start;
                    while (i < end) {
                        buffer[i] = Math.asin(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 103) {
                    i = start;
                    while (i < end) {
                        buffer[i] = Math.atan(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 104) {
                    i = start;
                    while (i < end) {
                        buffer[i] = Math.ceil(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 105) {
                    i = start;
                    while (i < end) {
                        buffer[i] = Math.cos(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 106) {
                    i = start;
                    while (i < end) {
                        buffer[i] = Math.exp(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 107) {
                    i = start;
                    while (i < end) {
                        buffer[i] = Math.floor(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 108) {
                    i = start;
                    while (i < end) {
                        buffer[i] = Math.log(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 109) {
                    i = start;
                    while (i < end) {
                        buffer[i] = Math.rint(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 110) {
                    i = start;
                    while (i < end) {
                        buffer[i] = Math.round(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 111) {
                    i = start;
                    while (i < end) {
                        buffer[i] = Math.sin(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 112) {
                    i = start;
                    while (i < end) {
                        buffer[i] = Math.sqrt(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 113) {
                    i = start;
                    while (i < end) {
                        buffer[i] = Math.tan(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 114) {
                    i = start;
                    while (i < end) {
                        buffer[i] = Math.toDegrees(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 115) {
                    i = start;
                    while (i < end) {
                        buffer[i] = Math.toRadians(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 116) {
                    i = start;
                    while (i < end) {
                        double calc = stockbuffer[i];
                        calc = calc > 0.0 ? 1.0 : (calc < 0.0 ? -1.0 : 0.0);
                        buffer[i] = calc;
                        ++i;
                    }
                } else if (this.lopr == 151) {
                    AudioOperatorInstance.fastSin_REPLACE(buffer, stockbuffer, start, end);
                } else if (this.lopr == 152) {
                    AudioOperatorInstance.fastCos_REPLACE(buffer, stockbuffer, start, end);
                } else if (this.lopr == 153) {
                    AudioOperatorInstance.fastTan_REPLACE(buffer, stockbuffer, start, end);
                } else if (this.lopr == 200) {
                    i = start;
                    while (i < end) {
                        buffer[i] = Math.IEEEremainder(stockbuffer[i], f_2);
                        ++i;
                    }
                } else if (this.lopr == 201) {
                    i = start;
                    while (i < end) {
                        buffer[i] = Math.atan2(stockbuffer[i], f_2);
                        ++i;
                    }
                } else if (this.lopr == 202) {
                    i = start;
                    while (i < end) {
                        buffer[i] = Math.min(stockbuffer[i], f_2);
                        ++i;
                    }
                } else if (this.lopr == 203) {
                    i = start;
                    while (i < end) {
                        buffer[i] = Math.max(stockbuffer[i], f_2);
                        ++i;
                    }
                } else if (this.lopr == 204) {
                    i = start;
                    while (i < end) {
                        buffer[i] = Math.pow(stockbuffer[i], f_2);
                        ++i;
                    }
                } else if (this.lopr == 205) {
                    i = start;
                    while (i < end) {
                        buffer[i] = Math.pow(f_2, stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 206) {
                    i = start;
                    while (i < end) {
                        buffer[i] = Math.IEEEremainder(f_2, stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 207) {
                    i = start;
                    while (i < end) {
                        buffer[i] = Math.atan2(f_2, stockbuffer[i]);
                        ++i;
                    }
                }
            } else {
                double d;
                if (this.lopr == 0) {
                    i = start;
                    while (i < end) {
                        buffer[i] = stockbuffer[i] * stockbuffer2[i];
                        ++i;
                    }
                } else if (this.lopr == 1) {
                    i = start;
                    while (i < end) {
                        buffer[i] = stockbuffer[i] / stockbuffer2[i];
                        ++i;
                    }
                } else if (this.lopr == 2) {
                    i = start;
                    while (i < end) {
                        buffer[i] = -stockbuffer[i];
                        ++i;
                    }
                } else if (this.lopr == 3) {
                    i = start;
                    while (i < end) {
                        buffer[i] = stockbuffer[i] + stockbuffer2[i];
                        ++i;
                    }
                } else if (this.lopr == 4) {
                    i = start;
                    while (i < end) {
                        buffer[i] = stockbuffer[i] % stockbuffer2[i];
                        ++i;
                    }
                } else if (this.lopr == 5) {
                    i = start;
                    while (i < end) {
                        buffer[i] = stockbuffer[i] > stockbuffer2[i] ? 1.0 : 0.0;
                        ++i;
                    }
                }
                if (this.lopr == 6) {
                    i = start;
                    while (i < end) {
                        buffer[i] = stockbuffer[i] < stockbuffer2[i] ? 1.0 : 0.0;
                        ++i;
                    }
                }
                if (this.lopr == 7) {
                    i = start;
                    while (i < end) {
                        buffer[i] = stockbuffer[i] >= stockbuffer2[i] ? 1.0 : 0.0;
                        ++i;
                    }
                }
                if (this.lopr == 8) {
                    i = start;
                    while (i < end) {
                        buffer[i] = stockbuffer[i] <= stockbuffer2[i] ? 1.0 : 0.0;
                        ++i;
                    }
                }
                if (this.lopr == 9) {
                    i = start;
                    while (i < end) {
                        d = stockbuffer[i] - stockbuffer2[i];
                        buffer[i] = d > 1.0E-5 || d < -1.0E-5 ? 1.0 : 0.0;
                        ++i;
                    }
                }
                if (this.lopr == 10) {
                    i = start;
                    while (i < end) {
                        d = stockbuffer[i] - stockbuffer2[i];
                        buffer[i] = d < 1.0E-5 && d > -1.0E-5 ? 1.0 : 0.0;
                        ++i;
                    }
                } else if (this.lopr == 11) {
                    i = start;
                    while (i < end) {
                        buffer[i] = stockbuffer2[i] / stockbuffer[i];
                        ++i;
                    }
                } else if (this.lopr == 100) {
                    i = start;
                    while (i < end) {
                        buffer[i] = Math.abs(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 101) {
                    i = start;
                    while (i < end) {
                        buffer[i] = Math.acos(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 102) {
                    i = start;
                    while (i < end) {
                        buffer[i] = Math.asin(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 103) {
                    i = start;
                    while (i < end) {
                        buffer[i] = Math.atan(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 104) {
                    i = start;
                    while (i < end) {
                        buffer[i] = Math.ceil(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 105) {
                    i = start;
                    while (i < end) {
                        buffer[i] = Math.cos(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 106) {
                    i = start;
                    while (i < end) {
                        buffer[i] = Math.exp(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 107) {
                    i = start;
                    while (i < end) {
                        buffer[i] = Math.floor(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 108) {
                    i = start;
                    while (i < end) {
                        buffer[i] = Math.log(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 109) {
                    i = start;
                    while (i < end) {
                        buffer[i] = Math.rint(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 110) {
                    i = start;
                    while (i < end) {
                        buffer[i] = Math.round(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 111) {
                    i = start;
                    while (i < end) {
                        buffer[i] = Math.sin(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 112) {
                    i = start;
                    while (i < end) {
                        buffer[i] = Math.sqrt(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 113) {
                    i = start;
                    while (i < end) {
                        buffer[i] = Math.tan(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 114) {
                    i = start;
                    while (i < end) {
                        buffer[i] = Math.toDegrees(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 115) {
                    i = start;
                    while (i < end) {
                        buffer[i] = Math.toRadians(stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 116) {
                    i = start;
                    while (i < end) {
                        double calc = stockbuffer[i];
                        calc = calc > 0.0 ? 1.0 : (calc < 0.0 ? -1.0 : 0.0);
                        buffer[i] = calc;
                        ++i;
                    }
                } else if (this.lopr == 151) {
                    AudioOperatorInstance.fastSin_REPLACE(buffer, stockbuffer, start, end);
                } else if (this.lopr == 151) {
                    AudioOperatorInstance.fastCos_REPLACE(buffer, stockbuffer, start, end);
                } else if (this.lopr == 152) {
                    AudioOperatorInstance.fastTan_REPLACE(buffer, stockbuffer, start, end);
                } else if (this.lopr == 200) {
                    i = start;
                    while (i < end) {
                        buffer[i] = Math.IEEEremainder(stockbuffer[i], stockbuffer2[i]);
                        ++i;
                    }
                } else if (this.lopr == 201) {
                    i = start;
                    while (i < end) {
                        buffer[i] = Math.atan2(stockbuffer[i], stockbuffer2[i]);
                        ++i;
                    }
                } else if (this.lopr == 202) {
                    i = start;
                    while (i < end) {
                        buffer[i] = Math.min(stockbuffer[i], stockbuffer2[i]);
                        ++i;
                    }
                } else if (this.lopr == 203) {
                    i = start;
                    while (i < end) {
                        buffer[i] = Math.max(stockbuffer[i], stockbuffer2[i]);
                        ++i;
                    }
                } else if (this.lopr == 204) {
                    i = start;
                    while (i < end) {
                        buffer[i] = Math.pow(stockbuffer[i], stockbuffer2[i]);
                        ++i;
                    }
                } else if (this.lopr == 205) {
                    i = start;
                    while (i < end) {
                        buffer[i] = Math.pow(stockbuffer2[i], stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 206) {
                    i = start;
                    while (i < end) {
                        buffer[i] = Math.IEEEremainder(stockbuffer2[i], stockbuffer[i]);
                        ++i;
                    }
                } else if (this.lopr == 207) {
                    i = start;
                    while (i < end) {
                        buffer[i] = Math.atan2(stockbuffer2[i], stockbuffer[i]);
                        ++i;
                    }
                }
            }
            if (stockbuffer2 != null) {
                this.audiocache.returnBuffer(stockbuffer2);
            }
            return ret;
        }

        public void close() {
            this.inputstream.close();
            if (this.inputstream2 != null) {
                this.inputstream2.close();
                this.inputstream2 = null;
            }
            this.inputstream = null;
        }
    }
}

