/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.io;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import rasmus.interpreter.sampled.AudioCache;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;
import rasmus.interpreter.sampled.io.AudioFileInstance;

class AudioFileWriteStream
implements AudioStream {
    AudioStream peerstream;
    AudioSession session;
    AudioCache cache;
    OutputStream pcm_outputstream;
    File file;
    AudioInputStream audio_inputstream;
    AudioFileFormat.Type file_type = null;
    byte[] data = null;

    public AudioFileWriteStream(AudioFileInstance afi, AudioStream peerstream, AudioSession session) throws IOException {
        this.session = session;
        this.cache = session.getAudioCache();
        this.peerstream = peerstream;
        this.file = afi.file;
        PipedOutputStream pcm_outputstream = new PipedOutputStream();
        this.pcm_outputstream = pcm_outputstream;
        PipedInputStream pipe_inputstream = new PipedInputStream(pcm_outputstream);
        int channels = session.getChannels();
        AudioFormat audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, (float)this.session.getRate(), 16, channels, 2 * channels, (float)this.session.getRate(), false);
        this.audio_inputstream = new AudioInputStream(pipe_inputstream, audioFormat, -1L);
        AudioFileFormat.Type[] types = AudioSystem.getAudioFileTypes(this.audio_inputstream);
        int i = 0;
        while (i < types.length) {
            if (this.file.getName().toLowerCase().endsWith("." + types[i].getExtension().toLowerCase())) {
                this.file_type = types[i];
                break;
            }
            ++i;
        }
        if (this.file_type == null) {
            pcm_outputstream = null;
            return;
        }
        new Thread(){

            public void run() {
                try {
                    AudioSystem.write(AudioFileWriteStream.this.audio_inputstream, AudioFileWriteStream.this.file_type, AudioFileWriteStream.this.file);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    AudioFileWriteStream.this.pcm_outputstream = null;
                }
            }
        }.start();
    }

    public int mix(double[] buffer, int start, int end) {
        double[] readbuffer = this.cache.getBuffer(end);
        int ret = this.replace(readbuffer, start, end);
        if (ret != -1) {
            int i = start;
            while (i < start + ret) {
                int n = i;
                buffer[n] = buffer[n] + readbuffer[i];
                ++i;
            }
        }
        this.cache.returnBuffer(readbuffer);
        return 0;
    }

    public int replace(double[] buffer, int start, int end) {
        int ret = this.peerstream.replace(buffer, start, end);
        int clen = (end - start) * 2;
        if (this.data == null) {
            this.data = new byte[clen];
        } else if (this.data.length < clen) {
            this.data = new byte[clen];
        }
        if (ret == -1) {
            return -1;
        }
        end = start + ret;
        int j = 0;
        int i = start;
        while (i < end) {
            double b = buffer[i];
            int valueL = (int)(b * 32768.0);
            this.data[j++] = (byte)valueL;
            this.data[j++] = (byte)(valueL >>> 8);
            ++i;
        }
        try {
            OutputStream pcm_outputstream = this.pcm_outputstream;
            if (pcm_outputstream != null) {
                pcm_outputstream.write(this.data);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public int isStatic(double[] buffer, int len) {
        return -1;
    }

    public int skip(int len) {
        return this.peerstream.skip(len);
    }

    public void close() {
        this.peerstream.close();
        try {
            this.pcm_outputstream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

