/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.io;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.channels.Channels;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import rasmus.interpreter.sampled.AudioStream;
import rasmus.interpreter.sampled.io.AudioFileInstance;
import rasmus.util.NonBlockingReadableByteChannel;

class AudioFileStream
implements AudioStream {
    AudioInputStream audiostream;
    float file_framrate;
    int file_channels;
    float samplesize;
    boolean float_format = false;
    boolean big_endian = true;
    AudioFormat format;
    int samplebits;
    double rate;
    int channels;
    InputStream fis = null;
    long loopend = 0L;
    long loopstart = 0L;
    long offset = 0L;
    AudioFormat iformat;
    File file;
    AudioFileInstance afi;
    byte[] datacache = null;
    byte[] loopcache = null;
    byte[] bytesample = null;
    ByteBuffer bytebuffer = null;
    FloatBuffer floatbuffer = null;
    float[] fbuffer = null;
    DoubleBuffer doublebuffer = null;
    double[] dbuffer = null;
    boolean eof = false;
    byte[] externalbuffer = null;
    int externalbufferloc = -1;
    int externalbuffersize = -1;
    int externalbufferleft = 0;

    public void close() {
        if (this.audiostream != null) {
            try {
                this.audiostream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.audiostream = null;
        }
        if (this.fis != null) {
            try {
                this.fis.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.fis = null;
        }
    }

    public static AudioFormat getFormat(File file) {
        try {
            AudioFormat readformat = AudioSystem.getAudioFileFormat(file).getFormat();
            return readformat;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void restartLoop() {
        if (this.datacache != null) {
            try {
                this.audiostream.reset();
                this.audiostream.skip(this.loopstart);
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
        try {
            this.close();
            this.fis = Channels.newInputStream(new NonBlockingReadableByteChannel(this.afi.channel_loop));
            this.audiostream = new AudioInputStream(this.fis, this.iformat, (this.loopend - this.loopstart) / (long)this.iformat.getFrameSize());
            this.initStream();
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public AudioFileStream(AudioFileInstance afi, File file, double rate, int channels, long offset, long length, long loopstart, long loopend, AudioFormat format) throws Exception {
        this.loopcache = afi.loopcache;
        this.afi = afi;
        this.rate = rate;
        this.channels = channels;
        this.offset = offset;
        this.file = file;
        this.iformat = format;
        this.loopend = loopend;
        this.loopstart = loopstart;
        this.datacache = afi.datacache;
        if (loopend != 0L) {
            length = loopend;
        }
        this.fis = this.datacache != null ? new ByteArrayInputStream(this.datacache) : Channels.newInputStream(new NonBlockingReadableByteChannel(afi.channel));
        if (format != null && length != 0L) {
            this.audiostream = new AudioInputStream(this.fis, format, length / (long)format.getFrameSize());
        } else {
            try {
                this.audiostream = afi.audioreader != null ? afi.audioreader.getAudioInputStream(this.fis) : AudioSystem.getAudioInputStream(this.fis);
            }
            catch (Exception e) {
                this.audiostream = AudioSystem.getAudioInputStream(file);
            }
        }
        this.initStream();
    }

    public void initStream() {
        AudioFormat readformat = this.audiostream.getFormat();
        if (readformat.getEncoding() == AudioFormat.Encoding.ULAW || readformat.getEncoding() == AudioFormat.Encoding.ALAW || readformat.getSampleSizeInBits() == -1) {
            this.samplebits = readformat.getSampleSizeInBits() == -1 ? 16 : readformat.getSampleSizeInBits() * 2;
            float framerate = readformat.getFrameRate();
            int framesize = readformat.getFrameSize();
            if (framesize == -1) {
                framesize = readformat.getChannels() * 2;
                framerate = readformat.getSampleRate();
            } else {
                framesize *= 2;
            }
            AudioFormat newFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, readformat.getSampleRate(), this.samplebits, readformat.getChannels(), framesize, framerate, false);
            this.audiostream = AudioSystem.getAudioInputStream(newFormat, this.audiostream);
            this.format = newFormat;
        } else {
            this.file_framrate = readformat.getFrameRate();
            this.file_channels = readformat.getChannels();
            this.samplebits = readformat.getSampleSizeInBits();
            this.samplesize = readformat.getSampleRate();
            this.big_endian = readformat.isBigEndian();
            if (readformat.getEncoding() == AudioFormat.Encoding.PCM_SIGNED && !readformat.isBigEndian()) {
                return;
            }
            if (readformat.getEncoding().toString().equals("PCM_FLOAT")) {
                this.float_format = true;
                return;
            }
            this.format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, this.file_framrate, this.samplebits, this.file_channels, readformat.getFrameSize(), readformat.getFrameRate(), false);
            this.audiostream = AudioSystem.getAudioInputStream(this.format, this.audiostream);
        }
        this.file_framrate = this.format.getFrameRate();
        this.file_channels = this.format.getChannels();
        this.samplebits = this.format.getSampleSizeInBits();
        this.samplesize = this.format.getSampleRate();
    }

    public int isStatic(double[] buffer, int len) {
        return -1;
    }

    private byte[] getByteBuffer(int len) {
        if (this.bytesample != null && len > this.bytesample.length) {
            this.bytesample = null;
        }
        if (this.bytesample == null) {
            this.bytesample = new byte[len];
        }
        return this.bytesample;
    }

    public int mix(double[] buffer, int start, int end) {
        if (this.eof) {
            return -1;
        }
        int length = (end - start) / this.channels;
        try {
            int i_offset = start;
            if (this.float_format) {
                if (this.samplebits == 32) {
                    int size = length;
                    int dsize = size * 4 * this.file_channels;
                    if (this.bytebuffer == null || this.bytebuffer.capacity() < dsize) {
                        this.bytebuffer = ByteBuffer.allocate(dsize);
                        if (!this.big_endian) {
                            this.bytebuffer = this.bytebuffer.order(ByteOrder.LITTLE_ENDIAN);
                        }
                        this.floatbuffer = this.bytebuffer.asFloatBuffer();
                        this.fbuffer = new float[this.file_channels * size];
                    }
                    this.bytebuffer.position(0);
                    int ret = this.read(this.bytebuffer.array(), size * 4 * this.file_channels);
                    if (ret == -1) {
                        return -1;
                    }
                    int bsize = size = ret / (4 * this.file_channels);
                    this.floatbuffer.position(0);
                    this.floatbuffer.get(this.fbuffer);
                    int z = 0;
                    if (this.file_channels == this.channels) {
                        bsize *= this.file_channels;
                        int i = 0;
                        while (i < bsize) {
                            int n = i_offset++;
                            buffer[n] = buffer[n] + (double)this.fbuffer[z];
                            ++z;
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while (i < bsize) {
                            int c = 0;
                            while (c < this.file_channels) {
                                if (c < this.channels) {
                                    int n = i_offset + c;
                                    buffer[n] = buffer[n] + (double)this.fbuffer[z];
                                }
                                ++z;
                                ++c;
                            }
                            i_offset += this.channels;
                            ++i;
                        }
                    }
                } else if (this.samplebits == 64) {
                    int size = length;
                    int dsize = size * 8 * this.file_channels;
                    if (this.bytebuffer == null || this.bytebuffer.capacity() < dsize) {
                        this.bytebuffer = ByteBuffer.allocate(dsize);
                        if (!this.big_endian) {
                            this.bytebuffer = this.bytebuffer.order(ByteOrder.LITTLE_ENDIAN);
                        }
                        this.doublebuffer = this.bytebuffer.asDoubleBuffer();
                        this.dbuffer = new double[this.file_channels * size];
                    }
                    this.bytebuffer.position(0);
                    int ret = this.read(this.bytebuffer.array(), size * 8 * this.file_channels);
                    if (ret == -1) {
                        return -1;
                    }
                    int bsize = size = ret / (8 * this.file_channels);
                    this.doublebuffer.position(0);
                    this.doublebuffer.get(this.dbuffer);
                    int z = 0;
                    if (this.file_channels == this.channels) {
                        bsize *= this.file_channels;
                        int i = 0;
                        while (i < bsize) {
                            int n = i_offset++;
                            buffer[n] = buffer[n] + this.dbuffer[z];
                            ++z;
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while (i < bsize) {
                            int c = 0;
                            while (c < this.file_channels) {
                                if (c < this.channels) {
                                    int n = i_offset + c;
                                    buffer[n] = buffer[n] + this.dbuffer[z];
                                }
                                ++z;
                                ++c;
                            }
                            i_offset += this.channels;
                            ++i;
                        }
                    }
                }
            } else if (this.samplebits == 32) {
                int size = length;
                byte[] bytesample = this.getByteBuffer(size * 4 * this.file_channels);
                int ret = this.read(bytesample, size * 4 * this.file_channels);
                if (ret == -1) {
                    return -1;
                }
                int bsize = size = ret / (4 * this.file_channels);
                int z = 0;
                if (this.file_channels == this.channels) {
                    bsize *= this.file_channels;
                    int i = 0;
                    while (i < bsize) {
                        int n = i_offset++;
                        buffer[n] = buffer[n] + (double)((float)((bytesample[z + 3] & 0xFF) << 24 | (bytesample[z + 2] & 0xFF) << 16 | ((bytesample[z + 1] & 0xFF) << 8) + (bytesample[z] & 0xFF)) / 2.1474836E9f);
                        z += 4;
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < bsize) {
                        int c = 0;
                        while (c < this.file_channels) {
                            if (c < this.channels) {
                                int n = i_offset + c;
                                buffer[n] = buffer[n] + (double)((float)(bytesample[z + 3] << 24 | (bytesample[z + 2] & 0xFF) << 16 | (bytesample[z + 1] & 0xFF) << 8 | bytesample[z] & 0xFF) / 2.1474836E9f);
                            }
                            z += 4;
                            ++c;
                        }
                        i_offset += this.channels;
                        ++i;
                    }
                }
            } else if (this.samplebits == 24 || this.samplebits == 20) {
                int size = length;
                byte[] bytesample = this.getByteBuffer(size * 3 * this.file_channels);
                int ret = this.read(bytesample, size * 3 * this.file_channels);
                if (ret == -1) {
                    return -1;
                }
                int bsize = size = ret / (3 * this.file_channels);
                int z = 0;
                if (this.file_channels == this.channels) {
                    bsize *= this.file_channels;
                    int i = 0;
                    while (i < bsize) {
                        int n = i_offset;
                        buffer[n] = buffer[n] + (double)((float)(((bytesample[z + 2] & 0xFF) << 16) + ((bytesample[z + 1] & 0xFF) << 8) + (bytesample[z] & 0xFF)) / 8388608.0f);
                        if (buffer[i_offset] > 1.0) {
                            buffer[i_offset] = buffer[i_offset] - 2.0;
                        }
                        z += 3;
                        ++i_offset;
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < bsize) {
                        int c = 0;
                        while (c < this.file_channels) {
                            if (c < this.channels) {
                                int n = i_offset + c;
                                buffer[n] = buffer[n] + (double)((float)(((bytesample[z + 2] & 0xFF) << 16) + ((bytesample[z + 1] & 0xFF) << 8) + (bytesample[z] & 0xFF)) / 8388608.0f);
                                if (buffer[i_offset + c] > 1.0) {
                                    buffer[i_offset + c] = buffer[i_offset + c] - 2.0;
                                }
                            }
                            z += 3;
                            ++c;
                        }
                        i_offset += this.channels;
                        ++i;
                    }
                }
            } else if (this.samplebits == 16) {
                int size = length;
                byte[] bytesample = this.getByteBuffer(size * 2 * this.file_channels);
                int ret = this.read(bytesample, size * 2 * this.file_channels);
                if (ret == -1) {
                    return -1;
                }
                int bsize = size = ret / (2 * this.file_channels);
                int z = 0;
                if (this.file_channels == this.channels) {
                    bsize *= this.file_channels;
                    int i = 0;
                    while (i < bsize) {
                        int n = i_offset++;
                        buffer[n] = buffer[n] + (double)((float)((short)((bytesample[z + 1] << 8) + (bytesample[z] & 0xFF))) / 32768.0f);
                        z += 2;
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < bsize) {
                        int c = 0;
                        while (c < this.file_channels) {
                            if (c < this.channels) {
                                int n = i_offset + c;
                                buffer[n] = buffer[n] + (double)((float)((short)((bytesample[z + 1] << 8) + (bytesample[z] & 0xFF))) / 32768.0f);
                            }
                            z += 2;
                            ++c;
                        }
                        i_offset += this.channels;
                        ++i;
                    }
                }
            } else if (this.samplebits == 8) {
                int size = length;
                byte[] bytesample = new byte[size * this.file_channels];
                int ret = this.audiostream.read(bytesample);
                if (ret == -1) {
                    this.eof = true;
                    return -1;
                }
                int bsize = size = ret / this.file_channels;
                int z = 0;
                int i = 0;
                while (i < bsize) {
                    int c = 0;
                    while (c < this.file_channels) {
                        if (c < this.channels) {
                            int n = i_offset + c;
                            buffer[n] = buffer[n] + (double)((float)bytesample[z] / 128.0f);
                        }
                        ++z;
                        ++c;
                    }
                    i_offset += this.channels;
                    ++i;
                }
            }
            return i_offset - start;
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return -1;
        }
    }

    public int read(byte[] bytesample, int len) throws IOException {
        if (this.eof) {
            return -1;
        }
        int ret = 0;
        if (this.externalbuffer == null && (ret = this.audiostream.read(bytesample, 0, len)) == -1) {
            if (this.loopend != 0L) {
                this.restartLoop();
                ret = this.audiostream.read(bytesample, 0, len);
            } else {
                this.eof = true;
                return -1;
            }
        }
        if (ret != len) {
            int leftover = len - ret;
            if (this.externalbuffer == null) {
                this.externalbuffer = new byte[4096 * this.file_channels];
            }
            int ix = ret;
            while (!this.eof && leftover != 0) {
                int i;
                if (this.externalbufferleft == 0) {
                    this.externalbuffersize = this.audiostream.read(this.externalbuffer);
                    if (this.externalbuffersize == -1) {
                        if (this.loopend != 0L) {
                            this.restartLoop();
                            this.externalbuffersize = this.audiostream.read(this.externalbuffer);
                        } else {
                            this.eof = true;
                            return ret;
                        }
                    }
                    this.externalbufferloc = 0;
                    this.externalbufferleft = this.externalbuffersize;
                }
                if (this.externalbufferleft > leftover) {
                    i = 0;
                    while (i < leftover) {
                        bytesample[ix] = this.externalbuffer[this.externalbufferloc];
                        ++ix;
                        ++this.externalbufferloc;
                        ++i;
                    }
                    ret += leftover;
                    this.externalbufferleft -= leftover;
                    leftover = 0;
                    continue;
                }
                i = 0;
                while (i < this.externalbufferleft) {
                    bytesample[ix] = this.externalbuffer[this.externalbufferloc];
                    ++ix;
                    ++this.externalbufferloc;
                    ++i;
                }
                ret += this.externalbufferleft;
                leftover -= this.externalbufferleft;
                this.externalbufferleft = 0;
            }
        }
        return ret;
    }

    public int replace(double[] buffer, int start, int end) {
        if (this.eof) {
            return -1;
        }
        int length = (end - start) / this.channels;
        try {
            int i_offset = start;
            if (this.float_format) {
                if (this.samplebits == 32) {
                    int size = length;
                    int dsize = size * 4 * this.file_channels;
                    if (this.bytebuffer == null || this.bytebuffer.capacity() < dsize) {
                        this.bytebuffer = ByteBuffer.allocate(dsize);
                        if (!this.big_endian) {
                            this.bytebuffer = this.bytebuffer.order(ByteOrder.LITTLE_ENDIAN);
                        }
                        this.floatbuffer = this.bytebuffer.asFloatBuffer();
                        this.fbuffer = new float[size * this.file_channels];
                    }
                    this.bytebuffer.position(0);
                    int ret = this.read(this.bytebuffer.array(), size * 4 * this.file_channels);
                    if (ret == -1) {
                        return -1;
                    }
                    int bsize = size = ret / (4 * this.file_channels);
                    this.floatbuffer.position(0);
                    this.floatbuffer.get(this.fbuffer);
                    int z = 0;
                    if (this.file_channels == this.channels) {
                        bsize *= this.file_channels;
                        int i = 0;
                        while (i < bsize) {
                            buffer[i_offset] = this.fbuffer[z];
                            ++z;
                            ++i_offset;
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while (i < bsize) {
                            int c = 0;
                            while (c < this.file_channels) {
                                if (c < this.channels) {
                                    buffer[i_offset + c] = this.fbuffer[z];
                                }
                                ++z;
                                ++c;
                            }
                            i_offset += this.channels;
                            ++i;
                        }
                    }
                } else if (this.samplebits == 64) {
                    int size = length;
                    int dsize = size * 8 * this.file_channels;
                    if (this.bytebuffer == null || this.bytebuffer.capacity() < dsize) {
                        this.bytebuffer = ByteBuffer.allocate(dsize);
                        if (!this.big_endian) {
                            this.bytebuffer = this.bytebuffer.order(ByteOrder.LITTLE_ENDIAN);
                        }
                        this.doublebuffer = this.bytebuffer.asDoubleBuffer();
                        this.dbuffer = new double[size * this.file_channels];
                    }
                    this.bytebuffer.position(0);
                    int ret = this.read(this.bytebuffer.array(), size * 8 * this.file_channels);
                    if (ret == -1) {
                        return -1;
                    }
                    int bsize = size = ret / (8 * this.file_channels);
                    this.doublebuffer.position(0);
                    this.doublebuffer.get(this.dbuffer);
                    int z = 0;
                    if (this.file_channels == this.channels) {
                        bsize *= this.file_channels;
                        int i = 0;
                        while (i < bsize) {
                            buffer[i_offset] = this.dbuffer[z];
                            ++z;
                            ++i_offset;
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while (i < bsize) {
                            int c = 0;
                            while (c < this.file_channels) {
                                if (c < this.channels) {
                                    buffer[i_offset + c] = this.dbuffer[z];
                                }
                                ++z;
                                ++c;
                            }
                            i_offset += this.channels;
                            ++i;
                        }
                    }
                }
            } else if (this.samplebits == 32) {
                int size = length;
                byte[] bytesample = this.getByteBuffer(size * 4 * this.file_channels);
                int ret = this.read(bytesample, size * 4 * this.file_channels);
                if (ret == -1) {
                    return -1;
                }
                int bsize = size = ret / (4 * this.file_channels);
                int z = 0;
                if (this.file_channels == this.channels) {
                    bsize *= this.file_channels;
                    int i = 0;
                    while (i < bsize) {
                        buffer[i_offset] = (float)((bytesample[z + 3] & 0xFF) << 24 | (bytesample[z + 2] & 0xFF) << 16 | ((bytesample[z + 1] & 0xFF) << 8) + (bytesample[z] & 0xFF)) / 2.1474836E9f;
                        z += 4;
                        ++i_offset;
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < bsize) {
                        int c = 0;
                        while (c < this.file_channels) {
                            if (c < this.channels) {
                                buffer[i_offset + c] = (float)(bytesample[z + 3] << 24 | (bytesample[z + 2] & 0xFF) << 16 | (bytesample[z + 1] & 0xFF) << 8 | bytesample[z] & 0xFF) / 2.1474836E9f;
                            }
                            z += 4;
                            ++c;
                        }
                        i_offset += this.channels;
                        ++i;
                    }
                }
            } else if (this.samplebits == 24 || this.samplebits == 20) {
                int size = length;
                byte[] bytesample = this.getByteBuffer(size * 3 * this.file_channels);
                int ret = this.read(bytesample, size * 3 * this.file_channels);
                if (ret == -1) {
                    return -1;
                }
                int bsize = size = ret / (3 * this.file_channels);
                int z = 0;
                if (this.file_channels == this.channels) {
                    bsize *= this.file_channels;
                    int i = 0;
                    while (i < bsize) {
                        buffer[i_offset] = (float)(((bytesample[z + 2] & 0xFF) << 16) + ((bytesample[z + 1] & 0xFF) << 8) + (bytesample[z] & 0xFF)) / 8388608.0f;
                        if (buffer[i_offset] > 1.0) {
                            buffer[i_offset] = buffer[i_offset] - 2.0;
                        }
                        z += 3;
                        ++i_offset;
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < bsize) {
                        int c = 0;
                        while (c < this.file_channels) {
                            if (c < this.channels) {
                                buffer[i_offset + c] = (float)(((bytesample[z + 2] & 0xFF) << 16) + ((bytesample[z + 1] & 0xFF) << 8) + (bytesample[z] & 0xFF)) / 8388608.0f;
                                if (buffer[i_offset + c] > 1.0) {
                                    buffer[i_offset + c] = buffer[i_offset + c] - 2.0;
                                }
                            }
                            z += 3;
                            ++c;
                        }
                        i_offset += this.channels;
                        ++i;
                    }
                }
            } else if (this.samplebits == 16) {
                int size = length;
                byte[] bytesample = this.getByteBuffer(size * 2 * this.file_channels);
                int ret = this.read(bytesample, size * 2 * this.file_channels);
                if (ret == -1) {
                    return -1;
                }
                int bsize = size = ret / (2 * this.file_channels);
                int z = 0;
                if (this.file_channels == this.channels) {
                    bsize *= this.file_channels;
                    int i = 0;
                    while (i < bsize) {
                        buffer[i_offset] = (float)((short)((bytesample[z + 1] << 8) + (bytesample[z] & 0xFF))) / 32768.0f;
                        z += 2;
                        ++i_offset;
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < bsize) {
                        int c = 0;
                        while (c < this.file_channels) {
                            if (c < this.channels) {
                                buffer[i_offset + c] = (float)((short)((bytesample[z + 1] << 8) + (bytesample[z] & 0xFF))) / 32768.0f;
                            }
                            z += 2;
                            ++c;
                        }
                        i_offset += this.channels;
                        ++i;
                    }
                }
            } else if (this.samplebits == 8) {
                int size = length;
                byte[] bytesample = new byte[size * this.file_channels];
                int ret = this.audiostream.read(bytesample);
                if (ret == -1) {
                    this.eof = true;
                    return -1;
                }
                int bsize = size = ret / this.file_channels;
                int z = 0;
                int i = 0;
                while (i < bsize) {
                    int c = 0;
                    while (c < this.file_channels) {
                        if (c < this.channels) {
                            buffer[i_offset + c] = (float)bytesample[z] / 128.0f;
                        }
                        ++z;
                        ++c;
                    }
                    i_offset += this.channels;
                    ++i;
                }
            }
            return i_offset - start;
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return -1;
        }
    }

    public int skip(int len) {
        if (this.eof) {
            return -1;
        }
        int length = len / this.channels;
        try {
            byte[] bytesample;
            int size;
            if (this.samplebits == 32) {
                size = length;
                bytesample = this.getByteBuffer(size * 4 * this.file_channels);
                this.read(bytesample, size * 4 * this.file_channels);
            }
            if (this.samplebits == 24 || this.samplebits == 20) {
                size = length;
                bytesample = this.getByteBuffer(size * 3 * this.file_channels);
                this.read(bytesample, size * 3 * this.file_channels);
            }
            if (this.samplebits == 16) {
                size = length;
                bytesample = this.getByteBuffer(size * 2 * this.file_channels);
                this.read(bytesample, size * 2 * this.file_channels);
            }
            if (this.samplebits == 8) {
                size = length;
                bytesample = this.getByteBuffer(size * this.file_channels);
                this.read(bytesample, size * this.file_channels);
            }
            return length * this.channels;
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return -1;
        }
    }
}

