/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;
import rasmus.interpreter.Commitable;
import rasmus.interpreter.NameSpace;
import rasmus.interpreter.Variable;
import rasmus.interpreter.io.Resource;
import rasmus.interpreter.io.ResourceManager;
import rasmus.interpreter.list.ObjectsPart;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.sampled.AudioEvent;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;
import rasmus.interpreter.sampled.AudioStreamable;
import rasmus.interpreter.sampled.io.AudioFileStream;
import rasmus.interpreter.sampled.io.AudioFileWriteStream;
import rasmus.interpreter.sampled.util.WaveUtils;
import rasmus.interpreter.status.GlobalStatus;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;
import rasmus.util.NonBlockingReadableByteChannel;
import rasmus.util.RasmusUtil;

class AudioFileInstance
extends UnitInstanceAdapter
implements Commitable {
    public static final int FILE_BUFFER_SIZE = 8192;
    public byte[] loopcache;
    boolean noresample = false;
    Variable returnvar;
    Variable inputvar;
    Variable filename;
    Variable wrkdir;
    Variable offset = null;
    Variable length = null;
    Variable format = null;
    Variable loopstart = null;
    Variable loopend = null;
    Variable answer;
    Variable streammode;
    AudioFormat audioformat;
    byte[] datacache = null;
    File file;
    NonBlockingReadableByteChannel channel = null;
    NonBlockingReadableByteChannel channel_loop = null;
    NameSpace namespace;
    ResourceManager manager;
    boolean commitmode = false;
    Resource resource = null;
    AudioFileReader audioreader = null;
    AudioFormat cformat = null;
    String s_filename = null;
    String c_filename = null;
    byte[] partialcache = null;
    static /* synthetic */ Class class$0;

    public AudioFormat getFormat(File file) {
        if (this.cformat != null) {
            return this.cformat;
        }
        if (this.length != null) {
            float sampleRate = 48000.0f;
            int sampleSizeInBits = 16;
            int channels = 1;
            boolean signed = true;
            boolean bigEndian = false;
            if (this.format != null) {
                Object[] s_formatstrings = ObjectsPart.asObjects(this.format);
                int i = 0;
                while (i < s_formatstrings.length) {
                    String formatstring = s_formatstrings[i].toString();
                    StringTokenizer st = new StringTokenizer(formatstring, " ");
                    while (st.hasMoreTokens()) {
                        String formattoken = st.nextToken();
                        if (formattoken.endsWith("khz")) {
                            sampleRate = Float.parseFloat(formattoken.substring(0, formattoken.length() - 3)) * 1000.0f;
                            continue;
                        }
                        if (formattoken.endsWith("hz")) {
                            sampleRate = Float.parseFloat(formattoken.substring(0, formattoken.length() - 2));
                            continue;
                        }
                        if (formattoken.endsWith("bit")) {
                            sampleSizeInBits = Integer.parseInt(formattoken.substring(0, formattoken.length() - 3));
                            continue;
                        }
                        if (formattoken.endsWith("ch")) {
                            channels = Integer.parseInt(formattoken.substring(0, formattoken.length() - 2));
                            continue;
                        }
                        if (formattoken.equalsIgnoreCase("stereo")) {
                            channels = 2;
                            continue;
                        }
                        if (formattoken.equalsIgnoreCase("bigEndian")) {
                            bigEndian = true;
                            continue;
                        }
                        if (!formattoken.equalsIgnoreCase("signed")) continue;
                        signed = true;
                    }
                    ++i;
                }
            }
            return new AudioFormat(sampleRate, sampleSizeInBits, channels, signed, bigEndian);
        }
        AudioFormat audioformat = AudioFileStream.getFormat(file);
        return audioformat;
    }

    public AudioFileInstance(boolean noresample, Parameters parameters) {
        this.noresample = noresample;
        this.namespace = parameters.getNameSpace();
        this.manager = ResourceManager.getInstance(this.namespace);
        this.returnvar = parameters.getParameterWithDefault("output");
        this.inputvar = parameters.getParameter("input");
        this.filename = parameters.getParameterWithDefault(1, "filename");
        this.offset = parameters.getParameterWithDefault(2, "offset");
        this.length = parameters.getParameter(3, "length");
        this.format = parameters.getParameter(4, "format");
        this.loopstart = parameters.getParameter(5, "loopstart");
        this.loopend = parameters.getParameter(6, "loopend");
        this.streammode = parameters.getParameter(7, "streammode");
        this.wrkdir = parameters.get("wrkdir");
        AudioFileStreamable afs = new AudioFileStreamable();
        this.answer = AudioEvents.asVariable(new AudioEvent(0.0, afs));
        this.returnvar.add(this.answer);
        ObjectsPart.getInstance(this.filename).addListener(this);
        ObjectsPart.getInstance(this.wrkdir).addListener(this);
        if (this.offset != null) {
            DoublePart.getInstance(this.offset).addListener(this);
        }
        if (this.length != null) {
            DoublePart.getInstance(this.length).addListener(this);
        }
        if (this.loopstart != null) {
            DoublePart.getInstance(this.loopstart).addListener(this);
        }
        if (this.streammode != null) {
            DoublePart.getInstance(this.streammode).addListener(this);
        }
        this.calc();
    }

    public void close() {
        if (this.channel != null) {
            try {
                this.channel.close();
                this.channel = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.returnvar.remove(this.answer);
        if (this.resource != null) {
            this.resource.close();
            this.resource = null;
        }
        ObjectsPart.getInstance(this.filename).removeListener(this);
        ObjectsPart.getInstance(this.wrkdir).removeListener(this);
        if (this.offset != null) {
            DoublePart.getInstance(this.offset).removeListener(this);
        }
        if (this.length != null) {
            DoublePart.getInstance(this.length).removeListener(this);
        }
        if (this.loopstart != null) {
            DoublePart.getInstance(this.loopstart).removeListener(this);
        }
        if (this.streammode != null) {
            DoublePart.getInstance(this.streammode).addListener(this);
        }
    }

    public void calc() {
        if (!this.commitmode) {
            this.commitmode = true;
            this.namespace.addToCommitStack(this);
        }
    }

    public String expandPath(String path) {
        if ((path = path.trim()).length() == 0) {
            return path;
        }
        if (path.startsWith(File.separator)) {
            return path;
        }
        if (path.length() > 2 && Character.isLetter(path.charAt(0)) && path.charAt(1) == ':' && path.charAt(2) == File.separatorChar) {
            return path;
        }
        String wrkdir = ObjectsPart.toString(this.wrkdir);
        if (wrkdir.trim().length() == 0) {
            return path;
        }
        if (wrkdir.endsWith(File.separator)) {
            return String.valueOf(wrkdir) + path;
        }
        return String.valueOf(wrkdir) + File.separator + path;
    }

    public int getRunLevel() {
        return 0;
    }

    public void commit() {
        if (this.commitmode) {
            String id_filename;
            this.commitmode = false;
            Object[] s_filenames = ObjectsPart.asObjects(this.filename);
            if (s_filenames.length == 0) {
                this.s_filename = null;
                this.c_filename = null;
                return;
            }
            this.s_filename = this.expandPath(s_filenames[0].toString());
            if (this.s_filename.toLowerCase().endsWith(".mid")) {
                this.s_filename = null;
                this.c_filename = null;
                return;
            }
            if (this.s_filename.toLowerCase().endsWith(".rlm")) {
                this.s_filename = null;
                this.c_filename = null;
                return;
            }
            if (this.inputvar != null) {
                this.s_filename = null;
                this.c_filename = null;
                return;
            }
            if (this.resource != null) {
                this.resource.close();
            }
            this.resource = this.manager.getResource(this.s_filename);
            if (this.resource == null) {
                this.s_filename = null;
                this.c_filename = null;
                return;
            }
            this.file = this.resource.getFile();
            this.s_filename = this.file.getPath();
            long i_length = 0L;
            long i_offset = 0L;
            int i_streammode = 0;
            if (this.streammode != null) {
                i_streammode = (int)DoublePart.asDouble(this.streammode);
            }
            if (this.offset == null || this.length == null) {
                id_filename = this.s_filename;
            } else {
                i_offset = (int)DoublePart.asDouble(this.offset);
                i_length = (long)DoublePart.asDouble(this.length);
                id_filename = String.valueOf(this.s_filename) + ":" + i_offset + ":" + i_length;
            }
            if (this.c_filename != null && this.c_filename.equals(id_filename)) {
                return;
            }
            this.c_filename = id_filename;
            this.file = new File(this.s_filename);
            if (this.inputvar != null) {
                return;
            }
            if (i_length == 0L) {
                i_length = this.file.length();
            }
            if (i_offset != 0L) {
                GlobalStatus.setStatus("loading " + this.s_filename + " " + i_offset + "-" + (i_length + i_offset));
            } else {
                GlobalStatus.setStatus("loading " + this.s_filename);
            }
            if (i_streammode == 1 || i_length < 8192L) {
                this.datacache = new byte[(int)i_length];
                try {
                    FileInputStream fis = new FileInputStream(this.file);
                    fis.skip(i_offset);
                    fis.read(this.datacache);
                    fis.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.loopcache = null;
                this.partialcache = null;
            } else {
                try {
                    if (this.channel != null) {
                        this.channel.close();
                    }
                    this.channel = new NonBlockingReadableByteChannel(this.file, i_offset, 8192);
                    int i_loopstart = (int)DoublePart.asDouble(this.loopstart);
                    this.channel_loop = i_loopstart == 0 ? this.channel : new NonBlockingReadableByteChannel(this.file, i_offset + (long)i_loopstart, 8192);
                }
                catch (Exception e) {
                    this.channel = null;
                    e.printStackTrace();
                }
            }
            this.cformat = null;
            this.audioreader = null;
            if (this.length == null) {
                boolean audioreaderfound = false;
                for (AudioFileReader reader : RasmusUtil.getProviders(AudioFileReader.class)) {
                    try {
                        AudioInputStream stream = reader.getAudioInputStream(this.file);
                        AudioFormat format = stream.getFormat();
                        if (format != null) {
                            this.cformat = format;
                        }
                        stream.close();
                        this.audioreader = reader;
                        audioreaderfound = true;
                        break;
                    }
                    catch (UnsupportedAudioFileException e) {
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (!audioreaderfound) {
                    this.audioreader = null;
                    this.cformat = this.getFormat(this.file);
                }
            } else {
                this.cformat = this.getFormat(this.file);
            }
            GlobalStatus.setStatus("");
        }
    }

    class AudioFileStreamable
    implements AudioStreamable {
        AudioFileStreamable() {
        }

        public AudioStream openStream(AudioSession session) {
            try {
                if (AudioFileInstance.this.s_filename == null) {
                    return null;
                }
                if (AudioFileInstance.this.inputvar != null) {
                    AudioStream audiostream = session.openStream(AudioFileInstance.this.inputvar);
                    try {
                        audiostream = new AudioFileWriteStream(AudioFileInstance.this, audiostream, session);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return audiostream;
                }
                AudioFormat audioformat = AudioFileInstance.this.getFormat(AudioFileInstance.this.file);
                if (audioformat == null) {
                    return null;
                }
                double samplerate = audioformat.getSampleRate();
                if (AudioFileInstance.this.noresample || Math.abs(samplerate - session.getRate()) < 0.001) {
                    return new AudioFileStream(AudioFileInstance.this, AudioFileInstance.this.file, session.getRate(), session.getChannels(), (long)DoublePart.asDouble(AudioFileInstance.this.offset), (long)DoublePart.asDouble(AudioFileInstance.this.length), (long)DoublePart.asDouble(AudioFileInstance.this.loopstart), (long)DoublePart.asDouble(AudioFileInstance.this.loopend), audioformat);
                }
                return new WaveUtils.ResampleStream(new AudioFileStream(AudioFileInstance.this, AudioFileInstance.this.file, session.getRate(), session.getChannels(), (long)DoublePart.asDouble(AudioFileInstance.this.offset), (long)DoublePart.asDouble(AudioFileInstance.this.length), (long)DoublePart.asDouble(AudioFileInstance.this.loopstart), (long)DoublePart.asDouble(AudioFileInstance.this.loopend), audioformat), samplerate / session.getRate(), session.getChannels());
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

