/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.generators;

import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;
import rasmus.interpreter.sampled.generators.AudioTableInstance;

class TableData {
    int table_length;
    double[] table;
    int channels;
    double rate;
    double from;
    double to;
    double dur;
    int datadur;

    public TableData(AudioTableInstance ati) {
        this.channels = (int)DoublePart.asDouble(ati.channels);
        this.rate = (int)DoublePart.asDouble(ati.rate);
        this.from = DoublePart.asDouble(ati.from);
        this.to = DoublePart.asDouble(ati.to);
        this.dur = this.to - this.from;
        if (this.channels == 0) {
            this.channels = 1;
        }
        if (this.rate == 0.0) {
            this.rate = 48000.0;
        }
        this.datadur = (int)(this.dur * this.rate) * this.channels;
        this.table = new double[this.datadur + this.channels];
        int fromdur = (int)(this.from * this.rate) * this.channels;
        AudioSession audiosession = new AudioSession(this.rate, this.channels);
        AudioStream audiostream = AudioEvents.openStream(ati.input, audiosession);
        if (fromdur != 0) {
            double[] tempbuffer = new double[512 * this.channels];
            while (fromdur > tempbuffer.length) {
                audiostream.replace(tempbuffer, 0, tempbuffer.length);
                fromdur -= tempbuffer.length;
            }
            double[] garbagebuffer = new double[fromdur];
            audiostream.replace(garbagebuffer, 0, garbagebuffer.length);
        }
        audiostream.replace(this.table, 0, this.table.length - this.channels);
        int i = 0;
        while (i < this.channels) {
            this.table[this.table.length - this.channels + i] = this.table[i];
            ++i;
        }
        this.table_length = this.table.length - this.channels;
        audiostream.close();
        audiosession.close();
    }
}

