/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.generators;

import rasmus.interpreter.Variable;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.sampled.AudioEvent;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;
import rasmus.interpreter.sampled.AudioStreamable;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class AudioSignalInstance
extends UnitInstanceAdapter
implements AudioStreamable {
    public Variable output;
    Variable answer = new Variable();
    Variable value;
    double fvalue;

    public void calc() {
        this.fvalue = DoublePart.asDouble(this.value);
    }

    public AudioSignalInstance(Parameters parameters) {
        this.output = parameters.getParameterWithDefault("output");
        this.answer = AudioEvents.asVariable(new AudioEvent(0.0, this));
        this.output.add(this.answer);
        this.value = parameters.getParameterWithDefault(1, "input");
        DoublePart.getInstance(this.value).addListener(this);
    }

    public void close() {
        DoublePart.getInstance(this.value).removeListener(this);
        this.output.remove(this.answer);
    }

    public AudioStream openStream(AudioSession session) {
        return new FilterStreamInstance(session);
    }

    class FilterStreamInstance
    implements AudioStream {
        public FilterStreamInstance(AudioSession session) {
        }

        public int mix(double[] buffer, int start, int end) {
            double ffvalue = AudioSignalInstance.this.fvalue;
            int i = start;
            while (i < end) {
                int n = i++;
                buffer[n] = buffer[n] + ffvalue;
            }
            return end - start;
        }

        public int replace(double[] buffer, int start, int end) {
            double ffvalue = AudioSignalInstance.this.fvalue;
            int i = start;
            while (i < end) {
                buffer[i] = ffvalue;
                ++i;
            }
            return end - start;
        }

        public int skip(int len) {
            return len;
        }

        public int isStatic(double[] buffer, int len) {
            buffer[0] = AudioSignalInstance.this.fvalue;
            return len;
        }

        public void close() {
        }
    }
}

