/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.generators;

import rasmus.interpreter.Variable;
import rasmus.interpreter.sampled.AudioEvent;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;
import rasmus.interpreter.sampled.AudioStreamable;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class AudioSampleRateInstance
extends UnitInstanceAdapter
implements AudioStreamable {
    public Variable output;
    Variable answer = new Variable();

    public void calc() {
    }

    public AudioSampleRateInstance(Parameters parameters) {
        this.output = parameters.getParameterWithDefault("output");
        this.answer = AudioEvents.asVariable(new AudioEvent(0.0, this));
        this.output.add(this.answer);
    }

    public void close() {
        this.output.remove(this.answer);
    }

    public AudioStream openStream(AudioSession session) {
        return new FilterStreamInstance(session);
    }

    class FilterStreamInstance
    implements AudioStream {
        double rate;

        public FilterStreamInstance(AudioSession session) {
            this.rate = session.getRate();
        }

        public int mix(double[] buffer, int start, int end) {
            int i = start;
            while (i < end) {
                int n = i++;
                buffer[n] = buffer[n] + this.rate;
            }
            return end - start;
        }

        public int replace(double[] buffer, int start, int end) {
            int i = start;
            while (i < end) {
                buffer[i] = this.rate;
                ++i;
            }
            return end - start;
        }

        public int skip(int len) {
            return len;
        }

        public int isStatic(double[] buffer, int len) {
            buffer[0] = this.rate;
            return len;
        }

        public void close() {
        }
    }
}

