/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.generators;

import java.util.Random;
import rasmus.interpreter.Variable;
import rasmus.interpreter.sampled.AudioEvent;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;
import rasmus.interpreter.sampled.AudioStreamable;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class AudioRandomInstance
extends UnitInstanceAdapter
implements AudioStreamable {
    public Variable output;
    Variable answer = new Variable();

    public void calc() {
    }

    public AudioRandomInstance(Parameters parameters) {
        this.output = parameters.getParameterWithDefault("output");
        this.answer = AudioEvents.asVariable(new AudioEvent(0.0, this));
        this.output.add(this.answer);
    }

    public void close() {
        this.output.remove(this.answer);
    }

    public AudioStream openStream(AudioSession session) {
        return new FilterStreamInstance(session);
    }

    class FilterStreamInstance
    implements AudioStream {
        Random random = new Random();

        public FilterStreamInstance(AudioSession session) {
        }

        public int mix(double[] buffer, int start, int end) {
            int i = start;
            while (i < end) {
                int n = i++;
                buffer[n] = buffer[n] + this.random.nextDouble();
            }
            return end - start;
        }

        public int replace(double[] buffer, int start, int end) {
            int i = start;
            while (i < end) {
                buffer[i] = this.random.nextDouble();
                ++i;
            }
            return end - start;
        }

        public int skip(int len) {
            return len;
        }

        public int isStatic(double[] buffer, int len) {
            return -1;
        }

        public void close() {
        }
    }
}

