/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.generators;

import java.util.ArrayList;
import java.util.Iterator;
import rasmus.interpreter.Variable;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.sampled.AudioEvent;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;
import rasmus.interpreter.sampled.AudioStreamable;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class AudioExpSegInstance
extends UnitInstanceAdapter
implements AudioStreamable {
    public Variable output;
    Variable answer = new Variable();
    Variable lastvar = null;
    ArrayList elements = new ArrayList();
    double activevalue = 0.0;

    public void calc() {
    }

    public AudioExpSegInstance(Parameters parameters) {
        this.output = parameters.getParameterWithDefault("output");
        int ii = 1;
        Variable var = parameters.getParameter(ii);
        while (var != null) {
            this.elements.add(DoublePart.getInstance(var));
            this.lastvar = var = parameters.getParameter(++ii);
        }
        this.answer = AudioEvents.asVariable(new AudioEvent(0.0, this));
        if (this.lastvar != null) {
            this.output.add(this.lastvar);
        }
        this.output.add(this.answer);
    }

    public void close() {
        if (this.lastvar != null) {
            this.output.remove(this.lastvar);
        }
        this.output.remove(this.answer);
    }

    public AudioStream openStream(AudioSession session) {
        return new FilterStreamInstance(session);
    }

    class FilterStreamInstance
    implements AudioStream {
        double f_value = 0.0;
        int channels;
        double rate;
        double[] env_values;
        double[] env_step;
        long[] env_durs;
        boolean[] env_inc;
        int env_index = 0;
        int last_index = 0;
        long esteps = 0L;

        public FilterStreamInstance(AudioSession session) {
            this.rate = session.getRate();
            int l = AudioExpSegInstance.this.elements.size() - 1;
            if (l % 2 != 0) {
                ++l;
            }
            int fcount = l / 2;
            Iterator iterator = AudioExpSegInstance.this.elements.iterator();
            if (iterator.hasNext()) {
                this.f_value = ((DoublePart)iterator.next()).getDouble();
            }
            this.env_values = new double[fcount];
            this.env_step = new double[fcount];
            this.env_inc = new boolean[fcount];
            this.env_durs = new long[fcount];
            this.last_index = fcount;
            double lastvalue = this.f_value;
            int i = 0;
            while (i < fcount) {
                long durs = iterator.hasNext() ? (long)(this.rate * ((DoublePart)iterator.next()).getDouble()) : 0L;
                double nextvalue = iterator.hasNext() ? ((DoublePart)iterator.next()).getDouble() : 0.0;
                this.env_values[i] = nextvalue;
                this.env_inc[i] = nextvalue > lastvalue;
                this.env_durs[i] = durs;
                this.env_step[i] = durs == 0L ? 1.0 : Math.pow(nextvalue / lastvalue, 1.0 / (double)durs);
                lastvalue = nextvalue;
                ++i;
            }
            this.channels = session.getChannels();
            this.rate = session.getRate();
        }

        public int isStatic(double[] buffer, int len) {
            double cur_env_step;
            if (this.env_index == this.last_index) {
                return -1;
            }
            if (this.esteps == this.env_durs[this.env_index]) {
                this.f_value = this.env_values[this.env_index];
                ++this.env_index;
                this.esteps = 0L;
                if (this.env_index == this.last_index) {
                    return -1;
                }
            }
            if ((cur_env_step = this.env_step[this.env_index]) != 1.0) {
                return -1;
            }
            long dur = this.env_durs[this.env_index];
            if ((dur -= this.esteps) < (long)len) {
                return -1;
            }
            this.esteps += (long)len;
            buffer[0] = this.f_value;
            return len;
        }

        /*
         * Unable to fully structure code
         */
        public int mix(double[] buffer, int start, int end) {
            if (this.env_index == this.last_index) {
                return -1;
            }
            ff_value = this.f_value;
            ix = start;
            block0: while (ix < end) {
                if (this.env_index == this.last_index) {
                    return ix - start;
                }
                cur_env_step = this.env_step[this.env_index];
                cur_env_values = this.env_values[this.env_index];
                dur = this.env_durs[this.env_index];
                if (!((double)dur < 0.0)) ** GOTO lbl25
                while (ix < end) {
                    v0 = ix++;
                    buffer[v0] = buffer[v0] + ff_value;
                }
                continue;
lbl-1000:
                // 1 sources

                {
                    if (this.esteps == dur) {
                        ff_value = cur_env_values;
                        ++this.env_index;
                        this.esteps = 0L;
                        continue block0;
                    }
                    v1 = ix++;
                    buffer[v1] = buffer[v1] + (ff_value *= cur_env_step);
                    ++this.esteps;
lbl25:
                    // 2 sources

                    ** while (ix < end)
                }
lbl26:
                // 1 sources

            }
            this.f_value = ff_value;
            return end - start;
        }

        /*
         * Unable to fully structure code
         */
        public int replace(double[] buffer, int start, int end) {
            if (this.env_index == this.last_index) {
                return -1;
            }
            ff_value = this.f_value;
            ix = start;
            block0: while (ix < end) {
                if (this.env_index == this.last_index) {
                    return ix - start;
                }
                cur_env_step = this.env_step[this.env_index];
                cur_env_values = this.env_values[this.env_index];
                dur = this.env_durs[this.env_index];
                if (!((double)dur < 0.0)) ** GOTO lbl25
                while (ix < end) {
                    buffer[ix] = ff_value;
                    ++ix;
                }
                continue;
lbl-1000:
                // 1 sources

                {
                    if (this.esteps == dur) {
                        ff_value = cur_env_values;
                        ++this.env_index;
                        this.esteps = 0L;
                        continue block0;
                    }
                    buffer[ix] = ff_value *= cur_env_step;
                    ++this.esteps;
                    ++ix;
lbl25:
                    // 2 sources

                    ** while (ix < end)
                }
lbl26:
                // 1 sources

            }
            this.f_value = ff_value;
            return end - start;
        }

        public int skip(int len) {
            double[] buffer = new double[1];
            int ret = this.isStatic(buffer, len);
            if (ret != -1) {
                return len;
            }
            buffer = new double[len];
            return this.mix(buffer, 0, len);
        }

        public void close() {
        }
    }
}

