/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.generators;

import java.util.Arrays;
import java.util.Random;
import rasmus.interpreter.Variable;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.sampled.AudioCache;
import rasmus.interpreter.sampled.AudioEvent;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;
import rasmus.interpreter.sampled.AudioStreamable;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class AudioClickInstance
extends UnitInstanceAdapter
implements AudioStreamable {
    public Variable output;
    Variable answer = new Variable();
    Variable frequency;
    Variable initvalue;

    public void calc() {
    }

    public AudioClickInstance(Parameters parameters) {
        this.output = parameters.getParameterWithDefault("output");
        this.frequency = parameters.getParameterWithDefault(1, "input");
        this.initvalue = parameters.getParameterWithDefault(2, "initvalue");
        this.answer = AudioEvents.asVariable(new AudioEvent(0.0, this));
        this.output.add(this.answer);
    }

    public void close() {
        this.output.remove(this.answer);
    }

    public AudioStream openStream(AudioSession session) {
        return new FilterStreamInstance(session);
    }

    class FilterStreamInstance
    implements AudioStream {
        Random random = new Random();
        AudioStream inputstream;
        double f_frequency;
        double f_stepsize;
        double f_value;
        int channels;
        boolean inputstream_eof;
        double rate;
        double ratepart;
        AudioCache audiocache;

        public FilterStreamInstance(AudioSession session) {
            this.f_frequency = DoublePart.asDouble(AudioClickInstance.this.frequency);
            this.f_value = DoublePart.asDouble(AudioClickInstance.this.initvalue);
            this.inputstream_eof = false;
            this.audiocache = session.getAudioCache();
            this.channels = session.getChannels();
            this.rate = session.getRate();
            this.ratepart = 1.0 / this.rate;
            this.f_stepsize = this.f_frequency * this.ratepart;
            if (AudioEvents.getInstance((Variable)AudioClickInstance.this.frequency).track.size() == 0) {
                this.inputstream_eof = true;
            } else {
                this.inputstream = AudioEvents.openStream(AudioClickInstance.this.frequency, session.getMonoSession());
            }
        }

        public int mix(double[] buffer, int start, int end) {
            int cend = end / this.channels;
            int cstart = start / this.channels;
            double[] freqbuffer = null;
            if (!this.inputstream_eof) {
                freqbuffer = this.audiocache.getBuffer(cend);
                int ret2 = this.inputstream.replace(freqbuffer, cstart, cend);
                if (ret2 == -1) {
                    Arrays.fill(freqbuffer, this.f_stepsize);
                    this.inputstream_eof = true;
                } else {
                    int cendret = cstart + ret2;
                    int i = cstart;
                    while (i < cendret) {
                        freqbuffer[i] = freqbuffer[i] * this.ratepart;
                        ++i;
                    }
                    Arrays.fill(freqbuffer, cstart + ret2, cend, this.f_stepsize);
                }
            }
            double ff_value = this.f_value;
            int fchannels = this.channels;
            if (this.inputstream_eof) {
                int c = 0;
                while (c < fchannels) {
                    ff_value = this.f_value;
                    int i = start + c;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + ff_value;
                        ff_value += this.f_stepsize;
                        i += fchannels;
                    }
                    ++c;
                }
            } else {
                int c = 0;
                while (c < fchannels) {
                    ff_value = this.f_value;
                    int ix = cstart;
                    int i = start + c;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + ff_value;
                        ff_value += freqbuffer[ix];
                        ++ix;
                        i += fchannels;
                    }
                    ++c;
                }
            }
            if (freqbuffer != null) {
                this.audiocache.returnBuffer(freqbuffer);
            }
            this.f_value = ff_value;
            return end - start;
        }

        public int replace(double[] buffer, int start, int end) {
            int cend = end / this.channels;
            int cstart = start / this.channels;
            double[] freqbuffer = null;
            if (!this.inputstream_eof) {
                freqbuffer = this.audiocache.getBuffer(cend);
                int ret2 = this.inputstream.replace(freqbuffer, cstart, cend);
                if (ret2 == -1) {
                    Arrays.fill(freqbuffer, this.f_stepsize);
                    this.inputstream_eof = true;
                } else {
                    int cendret = cstart + ret2;
                    int i = cstart;
                    while (i < cendret) {
                        freqbuffer[i] = freqbuffer[i] * this.ratepart;
                        ++i;
                    }
                    Arrays.fill(freqbuffer, cstart + ret2, cend, this.f_stepsize);
                }
            }
            double ff_value = this.f_value;
            int fchannels = this.channels;
            if (this.inputstream_eof) {
                int c = 0;
                while (c < fchannels) {
                    ff_value = this.f_value;
                    int i = start + c;
                    while (i < end) {
                        buffer[i] = ff_value;
                        ff_value += this.f_stepsize;
                        i += fchannels;
                    }
                    ++c;
                }
            } else {
                int c = 0;
                while (c < fchannels) {
                    ff_value = this.f_value;
                    int ix = cstart;
                    int i = start + c;
                    while (i < end) {
                        buffer[i] = ff_value;
                        ff_value += freqbuffer[ix];
                        ++ix;
                        i += fchannels;
                    }
                    ++c;
                }
            }
            if (freqbuffer != null) {
                this.audiocache.returnBuffer(freqbuffer);
            }
            this.f_value = ff_value;
            return end - start;
        }

        public int skip(int len) {
            int cend = 0 / this.channels;
            int cstart = len / this.channels;
            double[] freqbuffer = null;
            if (!this.inputstream_eof) {
                freqbuffer = this.audiocache.getBuffer(cend);
                int ret2 = this.inputstream.replace(freqbuffer, cstart, cend);
                if (ret2 == -1) {
                    Arrays.fill(freqbuffer, this.f_stepsize);
                    this.inputstream_eof = true;
                } else {
                    int cendret = cstart + ret2;
                    int i = cstart;
                    while (i < cendret) {
                        freqbuffer[i] = freqbuffer[i] * this.ratepart;
                        ++i;
                    }
                    Arrays.fill(freqbuffer, cstart + ret2, cend, this.f_stepsize);
                }
            }
            double ff_value = this.f_value;
            int fchannels = this.channels;
            if (this.inputstream_eof) {
                ff_value = this.f_value + this.f_stepsize * (double)len / (double)fchannels;
            } else {
                int c = 0;
                while (c < fchannels) {
                    ff_value = this.f_value;
                    int ix = cstart;
                    int i = 0 + c;
                    while (i < len) {
                        ff_value += freqbuffer[ix];
                        ++ix;
                        i += fchannels;
                    }
                    ++c;
                }
            }
            if (freqbuffer != null) {
                this.audiocache.returnBuffer(freqbuffer);
            }
            this.f_value = ff_value;
            return len;
        }

        public int isStatic(double[] buffer, int len) {
            return -1;
        }

        public void close() {
            if (this.inputstream != null) {
                this.inputstream.close();
            }
        }
    }
}

