/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.generators;

import java.util.Arrays;
import rasmus.interpreter.Variable;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.sampled.AudioCache;
import rasmus.interpreter.sampled.AudioEvent;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;
import rasmus.interpreter.sampled.AudioStreamable;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstancePart;

class AudioAhdsrInstance
implements AudioStreamable,
UnitInstancePart {
    public Variable output;
    Variable answer = new Variable();
    Variable active;
    Variable attack;
    Variable hold;
    Variable decay;
    Variable sustain;
    Variable release;

    public AudioAhdsrInstance(Parameters parameters) {
        this.output = parameters.getParameterWithDefault("output");
        this.active = parameters.getParameterWithDefault(1, "gate");
        this.attack = parameters.getParameterWithDefault(2, "attack");
        this.hold = parameters.getParameterWithDefault(3, "hold");
        this.decay = parameters.getParameterWithDefault(4, "decay");
        this.sustain = parameters.getParameterWithDefault(5, "sustain");
        this.release = parameters.getParameterWithDefault(6, "release");
        this.answer = AudioEvents.asVariable(new AudioEvent(0.0, this));
        this.output.add(this.answer);
    }

    public void close() {
        this.output.remove(this.answer);
    }

    public AudioStream openStream(AudioSession session) {
        return new FilterStreamInstance(session);
    }

    class FilterStreamInstance
    implements AudioStream {
        long l_attack;
        long l_decay;
        double f_sustain;
        long l_release;
        double l_attack_step;
        double l_decay_step;
        double l_release_step;
        double f_value = 0.0;
        int channels;
        double rate;
        long hold_counter = 0L;
        static final double MINUS40DB = 0.01;
        static final double MINUS60DB = 0.001;
        static final double MINUS70DB = 3.16228E-4;
        static final double MINUS80DB = 1.0E-4;
        static final double MINUS100DB = 1.0E-5;
        double stopval = 0.001;
        double releaseval = 1.0E-5;
        int mode = 0;
        AudioCache audiocache;
        AudioStream activestream = null;
        boolean activestream_eof = false;
        double[] sbuff = new double[1];
        int fallback = -1;

        public FilterStreamInstance(AudioSession session) {
            this.activestream = AudioEvents.openStream(AudioAhdsrInstance.this.active, session.getMonoSession());
            this.audiocache = session.getAudioCache();
            this.rate = session.getRate();
            this.l_attack = (long)(DoublePart.asDouble(AudioAhdsrInstance.this.attack) * this.rate);
            this.l_decay = (long)(DoublePart.asDouble(AudioAhdsrInstance.this.decay) * this.rate);
            this.f_sustain = DoublePart.asDouble(AudioAhdsrInstance.this.sustain);
            this.l_release = (long)(DoublePart.asDouble(AudioAhdsrInstance.this.release) * this.rate);
            long l_hold = (long)(DoublePart.asDouble(AudioAhdsrInstance.this.release) * this.rate);
            if (this.f_sustain == 0.0) {
                this.f_sustain = this.releaseval;
            }
            this.l_attack_step = this.l_attack == 0L ? 1.0 : 1.0 / (double)this.l_attack;
            this.l_decay_step = this.l_decay == 0L ? 0.0 : Math.pow(this.f_sustain / 1.0, 1.0 / (double)this.l_decay);
            this.l_release_step = this.l_release == 0L ? 0.0 : Math.pow(this.releaseval / 1.0, 1.0 / (double)this.l_release);
            this.channels = session.getChannels();
            this.rate = session.getRate();
            this.hold_counter = l_hold;
            if (this.l_attack == 0L) {
                this.f_value = 1.0;
                this.mode = 2;
            }
        }

        public int readActiveStream(int len) {
            if (this.fallback != -1) {
                int r = this.fallback;
                this.fallback = -1;
                return r;
            }
            return this.readActiveStream2(len);
        }

        public int readActiveStream2(int len) {
            if (this.activestream_eof) {
                return 0;
            }
            int clen = len / this.channels;
            int ret = this.activestream.isStatic(this.sbuff, clen);
            if (ret != -1) {
                if (this.sbuff[0] < 0.5) {
                    this.activestream_eof = true;
                    return 0;
                }
                if (ret != clen) {
                    this.activestream_eof = true;
                }
                return ret * this.channels;
            }
            double[] cbuffer = this.audiocache.getBuffer(clen);
            ret = this.activestream.replace(cbuffer, 0, clen);
            if (ret == -1) {
                this.audiocache.returnBuffer(cbuffer);
                this.activestream_eof = true;
                return 0;
            }
            int i = 0;
            while (i < clen) {
                if (cbuffer[i] < 0.5) {
                    this.audiocache.returnBuffer(cbuffer);
                    this.activestream_eof = true;
                    return i * this.channels;
                }
                ++i;
            }
            this.audiocache.returnBuffer(cbuffer);
            if (ret != clen) {
                this.activestream_eof = true;
            }
            return ret * this.channels;
        }

        public int mix(double[] buffer, int start, int end) {
            int activelen = this.readActiveStream(end - start);
            if (activelen == 0) {
                return this.mix(buffer, start, end, false);
            }
            if (activelen == end - start) {
                return this.mix(buffer, start, end, true);
            }
            int bend = start + activelen;
            int ret = this.mix(buffer, start, bend, true);
            if (ret < bend - start) {
                return ret;
            }
            int ret2 = this.mix(buffer, bend, end, false);
            if (ret == -1) {
                return ret;
            }
            return ret + ret2;
        }

        public int replace(double[] buffer, int start, int end) {
            int activelen = this.readActiveStream(end - start);
            if (activelen == 0) {
                return this.replace(buffer, start, end, false);
            }
            if (activelen == end - start) {
                return this.replace(buffer, start, end, true);
            }
            int bend = start + activelen;
            int ret = this.replace(buffer, start, bend, true);
            if (ret < bend - start) {
                return ret;
            }
            int ret2 = this.replace(buffer, bend, end, false);
            if (ret == -1) {
                return ret;
            }
            return ret + ret2;
        }

        /*
         * Unable to fully structure code
         */
        public int mix(double[] buffer, int start, int end, boolean active) {
            block22: {
                block21: {
                    block20: {
                        block19: {
                            if (this.mode == 0 && !active) {
                                this.mode = 5;
                            }
                            if (this.mode == 5) {
                                return -1;
                            }
                            ff_value = this.f_value;
                            fchannels = this.channels;
                            ix = start;
                            if (this.mode == 0 && active) {
                                this.mode = 1;
                            }
                            if (this.mode != 1) break block19;
                            if (active) ** GOTO lbl24
                            this.mode = 4;
                            break block19;
lbl-1000:
                            // 1 sources

                            {
                                if ((ff_value += this.l_attack_step) >= 1.0) {
                                    ff_value = 1.0;
                                    this.mode = 2;
                                    break;
                                }
                                c = 0;
                                while (c < fchannels) {
                                    v0 = ix++;
                                    buffer[v0] = buffer[v0] + ff_value;
                                    ++c;
                                }
lbl24:
                                // 2 sources

                                ** while (ix < end)
                            }
                        }
                        if (this.mode != 2) break block20;
                        if (active) ** GOTO lbl40
                        this.mode = 4;
                        break block20;
lbl-1000:
                        // 1 sources

                        {
                            if (this.hold_counter <= 0L) {
                                this.mode = 12;
                                break;
                            }
                            --this.hold_counter;
                            c = 0;
                            while (c < fchannels) {
                                v1 = ix++;
                                buffer[v1] = buffer[v1] + ff_value;
                                ++c;
                            }
lbl40:
                            // 2 sources

                            ** while (ix < end)
                        }
                    }
                    if (this.mode != 12) break block21;
                    if (active) ** GOTO lbl59
                    this.mode = 4;
                    break block21;
lbl-1000:
                    // 1 sources

                    {
                        if ((ff_value *= this.l_decay_step) <= this.f_sustain) {
                            if (ff_value <= 0.0) {
                                this.mode = 5;
                                ff_value = 0.0;
                                break;
                            }
                            this.mode = 3;
                            break;
                        }
                        c = 0;
                        while (c < fchannels) {
                            v2 = ix++;
                            buffer[v2] = buffer[v2] + ff_value;
                            ++c;
                        }
lbl59:
                        // 2 sources

                        ** while (ix < end)
                    }
                }
                if (this.mode != 3) break block22;
                if (active) ** GOTO lbl71
                this.mode = 4;
                break block22;
lbl-1000:
                // 1 sources

                {
                    c = 0;
                    while (c < fchannels) {
                        v3 = ix++;
                        buffer[v3] = buffer[v3] + ff_value;
                        ++c;
                    }
lbl71:
                    // 2 sources

                    ** while (ix < end)
                }
            }
            if (this.mode == 4) {
                while (ix < end) {
                    if ((ff_value *= this.l_release_step) < this.releaseval) {
                        ff_value = 0.0;
                        this.mode = 5;
                        break;
                    }
                    c = 0;
                    while (c < fchannels) {
                        v4 = ix++;
                        buffer[v4] = buffer[v4] + ff_value;
                        ++c;
                    }
                }
            }
            this.f_value = ff_value;
            return end - start;
        }

        /*
         * Unable to fully structure code
         */
        public int replace(double[] buffer, int start, int end, boolean active) {
            block22: {
                block21: {
                    block20: {
                        if (this.mode == 0 && !active) {
                            this.mode = 5;
                        }
                        if (this.mode == 5) {
                            return -1;
                        }
                        ff_value = this.f_value;
                        fchannels = this.channels;
                        ix = start;
                        if (this.mode == 0 && active) {
                            this.mode = 1;
                        }
                        if (this.mode != 1) break block20;
                        if (active) ** GOTO lbl24
                        this.mode = 4;
                        break block20;
lbl-1000:
                        // 1 sources

                        {
                            if ((ff_value += this.l_attack_step) >= 1.0) {
                                ff_value = 1.0;
                                this.mode = 2;
                                break;
                            }
                            c = 0;
                            while (c < fchannels) {
                                buffer[ix] = ff_value;
                                ++ix;
                                ++c;
                            }
lbl24:
                            // 2 sources

                            ** while (ix < end)
                        }
                    }
                    if (this.mode != 2) break block21;
                    if (active) ** GOTO lbl40
                    this.mode = 4;
                    break block21;
lbl-1000:
                    // 1 sources

                    {
                        if (this.hold_counter <= 0L) {
                            this.mode = 12;
                            break;
                        }
                        --this.hold_counter;
                        c = 0;
                        while (c < fchannels) {
                            buffer[ix] = ff_value;
                            ++ix;
                            ++c;
                        }
lbl40:
                        // 2 sources

                        ** while (ix < end)
                    }
                }
                if (this.mode != 12) break block22;
                if (active) ** GOTO lbl59
                this.mode = 4;
                break block22;
lbl-1000:
                // 1 sources

                {
                    if ((ff_value *= this.l_decay_step) <= this.f_sustain) {
                        if (ff_value <= 0.0) {
                            this.mode = 5;
                            ff_value = 0.0;
                            break;
                        }
                        this.mode = 3;
                        break;
                    }
                    c = 0;
                    while (c < fchannels) {
                        buffer[ix] = ff_value;
                        ++ix;
                        ++c;
                    }
lbl59:
                    // 2 sources

                    ** while (ix < end)
                }
            }
            if (this.mode == 3) {
                if (!active) {
                    this.mode = 4;
                } else {
                    Arrays.fill(buffer, ix, end, ff_value);
                    ix = end;
                }
            }
            if (this.mode == 4) {
                while (ix < end) {
                    if ((ff_value *= this.l_release_step) < this.stopval) {
                        ff_value = 0.0;
                        this.mode = 5;
                        break;
                    }
                    c = 0;
                    while (c < fchannels) {
                        buffer[ix] = ff_value;
                        ++ix;
                        ++c;
                    }
                }
            }
            Arrays.fill(buffer, ix, end, 0.0);
            this.f_value = ff_value;
            return end - start;
        }

        public int isStatic(double[] buffer, int len) {
            if (this.mode != 3) {
                return -1;
            }
            int a = this.readActiveStream(len);
            if (a < len) {
                this.fallback = a;
                return -1;
            }
            buffer[0] = this.f_value;
            return len;
        }

        public int skip(int len) {
            double[] buffer = new double[1];
            int ret = this.isStatic(buffer, len);
            if (ret != -1) {
                return len;
            }
            buffer = new double[len];
            return this.mix(buffer, 0, len);
        }

        public void close() {
            this.activestream.close();
        }
    }
}

